/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2020
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer;

public class MPParameterValue {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    // runtime attributes
    private String _value;
    private String _description;

    /**
     * Constructor
     */
    public MPParameterValue(String value, String description) {
        _value = value;
        _description = description;
    }

    /**
     * Get the 'parameter value' value
     */
    public String getValue() {
        if (_value == null)
            _value = "";
        return _value;
    }

    /**
     * Get the 'parameter value' description
     */
    public String getDescription() {
        if (_description == null)
            _description = "";
        return _description;
    }

    public String toString() {
        return getValue();
    }
}