/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018, 2020
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer;

import java.util.ArrayList;
import java.util.List;

public class MPParameter {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    // runtime attributes
    private String _name;
    private String _description;
    private String _type;
    private String _designType;
    private boolean _isOptional;
    private boolean _isDefault;
    private String _defValue;
    private List<MPParameterValue> _parameterValues;

    /**
     * Constructor
     */
    public MPParameter(String name, String description, String type, String designType, boolean isOptional, boolean isDefault, String defValue) {
        _name = name;
        _description = description;
        _type = type;
        _designType = designType;
        _isOptional = isOptional;
        _isDefault = isDefault;
        _defValue = defValue;
    }

    /**
     * Get the parameter name
     */
    public String getName() {
        if (_name == null)
            _name = "";
        return _name;
    }

    /**
     * Get the description
     */
    public String getDescription() {
        if (_description == null)
            _description = "";
        return _description;
    }

    /**
     * Get the parameter type
     */
    public String getType() {
        if (_type == null)
            _type = "";
        return _type;
    }

    /**
     * Get the parameter design type
     */
    public String getDesignType() {
        if (_designType == null)
            _designType = "";
        return _designType;
    }

    /**
     * Get the parameter optional status
     */
    public boolean isOptional() {
        return _isOptional;
    }

    /**
     * Get the parameter default status
     */
    public boolean isDefault() {
        return _isDefault;
    }

    /**
     * Get the parameter defValue
     */
    public String getDefValue() {
        if (_defValue == null)
            _defValue = "";
        return _defValue;
    }

    /**
     * Get the declared list of parameter values this MP parameter.
     */
    public List<MPParameterValue> getParameterValues() {
        if (_parameterValues == null)
            _parameterValues = new ArrayList<MPParameterValue>();
        return _parameterValues;
    }

    public String toString() {
        return getName();
    }
}