/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018, 2019
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.ibm.pdp.engine.IAnalyzerResult;

public class MPAnalyzerResult implements IAnalyzerResult {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    // runtime attributes
    private String _identifier;
    private String _concreteIdentifier;
    private boolean _hasDot;
    private String _header;
    private boolean _needFormat;
    private Map<String, Object> _parameters;
    private List<String> _malFormedMessages;

    /**
     * Constructor
     */
    public MPAnalyzerResult(String identifier, String concreteIdentifier, boolean hasDot) {
        _identifier = identifier;
        _concreteIdentifier = concreteIdentifier;
        _hasDot = hasDot;
    }

    public String getIdentifier() {
        if (_identifier == null)
            return "";
        return _identifier;
    }

    public String getConcreteIdentifier() {
        if (_concreteIdentifier == null)
            return getIdentifier();
        return _concreteIdentifier;
    }

    public boolean hasDot() {
        return _hasDot;
    }

    public String getHeader() {
        if (_header == null) {
            return "";
        }
        return _header;
    }

    public void setHeader(String header) {
        _header = header;
    }

    public boolean getNeedFormat() {
        return _needFormat;
    }

    public void setNeedFormat(boolean needFormat) {
        _needFormat = needFormat;
    }

    /**
     * Return the map of parameters values (instance of String, Integer, Boolean or MPReference).
     * Key is the parameter's name.
     */
    public Map<String, Object> getParameters() {
        if (_parameters == null)
            _parameters = new LinkedHashMap<String, Object>();
        return _parameters;
    }

    public boolean isWellFormed() {
        return getMalformedMessages().size() == 0;
    }

    public List<String> getMalformedMessages() {
        if (_malFormedMessages == null)
            _malFormedMessages = new ArrayList<String>();
        return _malFormedMessages;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(getIdentifier());
        buffer.append(' ').append(getParameters().toString());

        return buffer.toString();
    }
}