/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018, 2020
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer;

import org.eclipse.osgi.util.NLS;

public class MPAnalyzerLabel {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    // New Location wizard label
    public static String _UNKNOWN_MICRO_PATTERN;
    public static String _MP_OLD_SYNTAX;
    public static String _INVALID_SEQUENCE;
    public static String _UNKNOWN_PARAMETER;
    public static String _NUMERIC_PARAMETER;
    public static String _BOOLEAN_PARAMETER;
    public static String _MISSING_PARAMETER;
    public static String _PARAM_MSG;

    // The class implementation start here. See:
    // http://dev.eclipse.org/viewcvs/index.cgi/~checkout~/platform-core-home/documents/3.1/message_bundles.html
    private static final String _BUNDLE_NAME = "com.ibm.pdp.micropattern.analyzer.MPAnalyzer"; //$NON-NLS-1$
    static {
        NLS.initializeMessages(_BUNDLE_NAME, MPAnalyzerLabel.class);
    }

    public static String getString(String key) {
        return NLS.bind(key, null);
    }

    public static String getString(String key, Object... array) {
        return NLS.bind(key, array);
    }
}