/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018, 2020
 * The source code for this program is not published or
 * otherwise divested of its trade secrets, irrespective of
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ibm.pdp.micropattern.analyzer.plugin.IMPAnalyzer;

public abstract class MPAbstractAnalyzer implements IMPAnalyzer {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    // runtime attributes
    private String _namespace;
    private String _identifier;
    private String _description;
    private String _area;
    private boolean _contentAssist;
    private List<MPParameter> _parameters;
    private Map<String, MPParameter> _keyedParameters;
    private Map<String, MPPattern> _keyedPatterns;

    /**
     * Constructor
     */
    public MPAbstractAnalyzer() {
        // default constructor invoked by the extension point instantiation
    }

    /**
     * Get/Set the declared namespace for this micro-pattern implementation.
     */
    public final String getNamespace() {
        if (_namespace == null)
            _namespace = "";
        return _namespace;
    }

    public final void setNamespace(String namespace) {
        _namespace = namespace;
    }

    /**
     * Get/Set the declared identifier for this micro-pattern implementation.
     */
    public final String getIdentifier() {
        if (_identifier == null)
            _identifier = "";
        return _identifier;
    }

    public final void setIdentifier(String identifier) {
        _identifier = identifier;
    }

    /**
     * Get/Set the declared description for this micro-pattern implementation.
     */
    public final String getDescription() {
        if (_description == null)
            _description = "";
        return _description;
    }

    public final void setDescription(String description) {
        _description = description;
    }

    /**
     * Get/Set the definition area for this micro-pattern implementation.
     */
    public final String getArea() {
        if (!IMPAnalyzer._AREA_PROCEDURE.equals(_area) && !IMPAnalyzer._AREA_WORKING.equals(_area))
            _area = IMPAnalyzer._AREA_ALL;
        return _area;
    }

    public final void setArea(String area) {
        _area = area;
    }

    /**
     * Get/Set the contentAssist status for this micro-pattern implementation.
     */
    public final boolean getContentAssist() {
        return _contentAssist;
    }

    public final void setContentAssist(boolean contentAssist) {
        _contentAssist = contentAssist;
    }

    /**
     * Get the declared list of parameters for this micro-pattern implementation.
     */
    public List<MPParameter> getParameters() {
        if (_parameters == null)
            _parameters = new ArrayList<MPParameter>();
        return _parameters;
    }

    /**
     * Get the declared map of parameters for this micro-pattern implementation.
     */
    public Map<String, MPParameter> getKeyedParameters() {
        if (_keyedParameters == null)
            _keyedParameters = new HashMap<String, MPParameter>();
        return _keyedParameters;
    }

    /**
     * Get the declared list of patterns for this micro-pattern implementation.
     */
    public Map<String, MPPattern> getKeyedPatterns() {
        if (_keyedPatterns == null)
            _keyedPatterns = new HashMap<String, MPPattern>();
        return _keyedPatterns;
    }

    /**
     * Indicates if the value is ckeckable.
     */
    public boolean isValueCheckable(String value) {
        return true;
    }

    /**
     * Indicates if the text given in parameter is recognized by the micro-pattern implementation.
     */
    public boolean accept(String text) {
    	// generic implementation for all micro-patterns
    	String id = getIdentifier();
    	int idLength = id.length();
    	return text.regionMatches( _PREFIX_END, id, 0, idLength )
    			&& text.regionMatches( _STAR_COLUMN, _MP_DECLARATION_TOKEN, 0, _MP_DECLARATION_TOKEN_LENGTH )
    			&& (text.length() == _PREFIX_END+idLength || text.charAt(_PREFIX_END+idLength) == ' ');


        /* Old content for the method (work item 34588)
	    String mpDecl = _MP_DECLARATION_TOKEN + getIdentifier();
	    if (text.indexOf(mpDecl) == _STAR_COLUMN) {
	        String endOfDecl = text.substring(_STAR_COLUMN + mpDecl.length());
	            if (endOfDecl.length() == 0 || endOfDecl.charAt(0) == ' ')
	                return true;
	    }
        return false;
        */
    }


    /**
     * Indicates if the 'parameters' describes a valid map of parameters, according to the micro-pattern implementation.
     * Return a boolean if the syntax is correct,
     * Return null, and feed the 'malformedMessages' list otherwise.
     */
    public boolean acceptParameters(Map<String, Object> parameters, List<String> malformedMessages) throws MPException {
        return true;
    }

    public String toString() {
        return getDescription();
    }
}