/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2012, 2014
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.mdl.link.design;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.service.MetadataService;

public class Util
{
	private static int MINI_PRIME_NUMBER = 37;
	private static final String EMPTY_STRING = "";		//$NON-NLS-1$
	
	/**
	 * 1) s == null => returns 0;<br>
	 * 2) s == "" => returns 0;<br>
	 * 3) if s.length = n then <br>
	 *    returns s.charAt(0) * 37^(n-1) + s.charAt(1) * 37^(n-2) + ... + s.charAt(n-1) <br>
	 * @param s
	 * @return
	 */
	public static int computeHashCode(String s)
	{
		if (s == null)
			return 0;
		int len = s.length();
		if (len == 0)
			return 0;
		int sum = 0;
		for (int i=0; i<len; i++)
		{
			sum = sum * MINI_PRIME_NUMBER + s.charAt(i);
		}
		return sum;
	}
	
	/**
	 * This method is used in the context of the server during the parsing of a CBL file.
	 * The fileName passed in parameter contains the full path, i.e. it contains
	 * the rpp folder (known as the designFolder). This is a problem 
	 * because the cblpdp parser renders a relative path, and both ID should be equal.<br>
	 * So this method removes the designFolder (generally "rpp") from the fileName.<br>  
	 * @deprecated
	 * @param fileName
	 * @return
	 */
	public static Document createADocument(String fileName)
	{
		String theGeneratedResourceId;
		Document result;
		
	    //Return an array of tokens [project,package,name,metaType,type] built from the documentId given in parameter.
		String[] tokens = MetadataService.getTokens(fileName);
		
		//************************************************
//		theGeneratedResourceId = 
//							MetadataService.getId(tokens[0], tokens[1], tokens[2], "", tokens[4]);				//$NON-NLS-1$

		//PFR : Bidouille pour dbloquer Xavier.
		String s = tokens[1];
		if (tokens[1].startsWith("rpp"))			//$NON-NLS-1$
		{
			s = tokens[1].substring("rpp".length());		//$NON-NLS-1$
		}
		else if (tokens[1].startsWith("rpp."))		//$NON-NLS-1$
		{
			s = tokens[1].substring("rpp.".length());		//$NON-NLS-1$
		}
			
		theGeneratedResourceId = 
					MetadataService.getId(tokens[0], s, tokens[2], "", tokens[4]);				//$NON-NLS-1$
		//************************************************
		result = MetaFactory.eINSTANCE.getDocument(theGeneratedResourceId, false);		//We do not create a new Document. We only retrieve the existing instance.
		if (result == null)
			result = MetaFactory.eINSTANCE.getDocument(theGeneratedResourceId, true);
		
		return result;
	}
	
	/**
	 * Returns the documentID (fileName without the RPP Folder) of a pacmacro file ONLY.
	 * In input, we have the physical fileName of the pacmacro file, and its RadicalEntity corresponding object.<br>
	 */
	public static String getMacroDocumentId(String fileName, RadicalEntity radicalEntity)
	{
		String documentId = null;
		String[] tokens = MetadataService.getTokens(fileName);
		String thePackage = EMPTY_STRING; 
		if (fileName.endsWith("macro"))			//$NON-NLS-1$
		{
			thePackage = radicalEntity.getPackage();
			documentId = MetadataService.getId(tokens[0], thePackage, tokens[2], "", tokens[4]);				//$NON-NLS-1$
		}
		return documentId;
	}

	public static InputStream getMacroSourceCodeAttribute(RadicalEntity radicalEntity)
	{
		if (radicalEntity == null)
			return null;
		
        if (radicalEntity.eClass().getName().equals("PacMacro"))				//$NON-NLS-1$ 
        {
            String source = null;
            for (EAttribute eAttribute : radicalEntity.eClass().getEAttributes()) 
            {
                if (eAttribute.getName().equals("source"))						//$NON-NLS-1$
                {
                    source = (String) radicalEntity.eGet(eAttribute);
                    break;
                }
            }
            return new ByteArrayInputStream(source.getBytes());
        }
		
		return null;
	}

	/**
	 * The parameter fileName is here only in case of problem, to tell on what file the problem occurred.
	 * @param fileName
	 * @param inputStream
	 * 
	 * NO LONGER USED. 
	 * 
	 * @deprecated
	 * @return
	 */
	public static RadicalEntity loadResource(String fileName, InputStream inputStream)
	{
        RadicalEntity radicalObject = null;

        URI uri = URI.createURI("foo");		//$NON-NLS-1$
        //Resource resource = getResourceSet().createResource(ContentHandler.UNSPECIFIED_CONTENT_TYPE);
        ResourceSet resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);

        try 
        {
            resource.load(inputStream, Collections.EMPTY_MAP);
            radicalObject = (RadicalEntity) resource.getContents().get(0);
        } catch (IOException e) {
	    	RuntimeException rt = new RuntimeException("IOException while trying to read the EMF instance of " + fileName, e);	//$NON-NLS-1$
	    	throw rt;
        }

        return radicalObject;
    }
		
	/**
	 * Returns the index of the last character of the line containing the
	 * character whose index is passed in parameter. The last character includes
	 * the CarriageReturn if it exists.<br>
	 * The index returned is the index of the char AFTER the '\n' char.<br>
	 * Example:<br>
	 * 012345678901234 5 67<br>
	 * abcdefgh\r\nefg<br>
	 * The result returned is : 7.<br>
	 * 
	 * @param offset
	 * @return
	 */
	public static int getLineEndOffset(CharSequence text, int offset)
	{
		int length = text.length();
		if (length == 0)
			return 0;
		
		if (offset == length)
			return offset;
		
		if (offset < 0 || offset > length)
		{
			throw new RuntimeException("PdpTool.getLineEndOffset : offset given is out of the limits of the text.");		//$NON-NLS-1$
		}
		
		int i = offset;
		char c = ' ';
		while (i < length)
		{
			c = text.charAt(i);
			if (c == '\n')
			{
				return (i + 1);
			}
			i++;
		}
		return i;
	}

	/**
	 * returns the index of the first character of the line containing the
	 * character whose index is passed in parameter.
	 * 
	 * @param offset
	 * @return
	 */
	public static int getLineStartOffset(CharSequence text, int offset)
	{
		int length = text.length();
		if (length == 0)
			return 0;

		if (offset == 0)
			return 0;
		
		if (offset < 0 || offset >= length)
		{
			throw new RuntimeException("PdpTool.getLineStartOffset : offset given is out of the limits of the text.");			//$NON-NLS-1$
		}
		if (text.charAt(offset) == '\n')
		{
			if (offset > 0 && text.charAt(offset - 1) == '\n')
			{
					return offset;
			}
		}
		
		int i = offset - 1;
		while (i >= 0)
		{
			char c = text.charAt(i);
			if (c == '\n')
			{
				return (i + 1);
			}
			i--;
		}
		return 0;
	}
	
	private static String lineSeparator;


	public static String getLineSeparator()
	{
		if ( lineSeparator == null )
		{
			lineSeparator = System.getProperty( "line.separator" );		//$NON-NLS-1$
			if ( lineSeparator == null )
				lineSeparator = "\n";		//$NON-NLS-1$
		}
		return lineSeparator;
	}

	public static String convertStreamToString(InputStream is) throws IOException
	{
		if (is != null)
		{
			Writer writer = new StringWriter();

			char[] buffer = new char[100000];
			try
			{
				Reader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));		//$NON-NLS-1$
				int n;
				while ((n = reader.read(buffer)) != -1)
				{
					writer.write(buffer, 0, n);
				}
			}
			finally
			{
				is.close();
			}
			return writer.toString();
		}
		else
		{
			return EMPTY_STRING;
		}
	}
	
	
	/**
	 * Reads about 5 times faster than readFileContents... 
	 * (Adapted from com.ibm.pdp.util.Strings.fileToString(String))
	 * 
	 * @param fileName
	 * @return
	 */
	public static String readFileContentsQuickly(String fileName)
	{
		try
		{
			RandomAccessFile raf = new RandomAccessFile(fileName, "r");		//$NON-NLS-1$

			long length = raf.length();
			if (length > Integer.MAX_VALUE)
				throw new RuntimeException("File too big: " + fileName);		//$NON-NLS-1$

			byte[] buffer = new byte[(int) length];
			raf.readFully(buffer);
			raf.close();
			return new String(buffer);
		}
		catch (Exception e)
		{
			throw new RuntimeException(e);
		}
	}

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{

	}

	public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";		//$NON-NLS-1$
}
