/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2013, 2014
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.mdl.link.design;

public class RubriqueToken 
{
    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";	//$NON-NLS-1$

    private String _name;
    private int _indexInLine;
    private String _shortName;
    
    public RubriqueToken(String name, int indexInLine) 
    {
        _name = name;
        _indexInLine = indexInLine;
        _shortName = null;
    }
    
    /**
     * Returns the full name of the Data Element (prefix + suffix)
     * @return
     */
    public String getName() 
    {
        return _name;
    }
    
    /**
     * Returns the name as known in the RPP repository (suffix part : after the last dash)
     * @return
     */
    public String getShortName()
    {
    	if (_shortName == null)
    	{
    		int size = _name.length();
    		boolean trouve = false;
    		int i = size - 1;
    		for (; i>=0; i--)
    		{
    			if (_name.charAt(i) == '-')
    			{
    				trouve = true;
    				break;
    			}
    		}
    		if (trouve)
    			_shortName = _name.substring(i+1);
    		else
    			_shortName = _name;
    	}
    	return _shortName;
    }
    
    public int getIndexInLine() {
        return _indexInLine;
    }
    
    @Override
    public String toString() 
    {
        return getName() + " @ " + getIndexInLine();	//$NON-NLS-1$
    }
}
