/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.mdl.link.design;


/**
 * From com.ibm.pdp.mdl.link.design.ReferencedEntity
 */
public class ReferencedEntity

{
    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private String _name;
    private String _metaType;
    private String _type;
    private String _mpIdentifier;
    private int _offset;

    public ReferencedEntity(String name, String metaType, String type, String mpIdentifier) {
        _name = name;
        _metaType = metaType;
        _type = type;
        _mpIdentifier = mpIdentifier;
    }

    public ReferencedEntity(String name, String metaType, String type, String mpIdentifier, int offset) {
        _name = name;
        _metaType = metaType;
        _type = type;
        _mpIdentifier = mpIdentifier;
        _offset = offset;
    }

    public String getName() {
        if (_name == null)
            return "";
        return _name;
    }

    public String getMetaType() {
        if (_metaType == null)
            return "";
        return _metaType;
    }

    public String getType() {
        if (_type == null)
            return "";
        return _type;
    }

    public String getMPIdentifier() {
        if (_mpIdentifier == null)
            return "";
        return _mpIdentifier;
    }

    public int getOffset() {
        return _offset;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(getName());
        if (getMetaType().length() > 0)
            buffer.append('.').append(getMetaType());
        buffer.append('.').append(getType());

        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReferencedEntity) {
            ReferencedEntity ref = (ReferencedEntity) obj;
            return (ref.getName().equals(getName()) && ref.getType().equals(getType()) && ref.getMetaType().equals(getMetaType()) && ref
                    .getMPIdentifier().equals(getMPIdentifier()));
        }
        else
            return false;
    }

    public int hashCode() {
        StringBuilder buffer = new StringBuilder(getName());
        buffer.append(getName()).append(getMetaType()).append(getType()).append(getMPIdentifier());

        return Util.computeHashCode(buffer.toString());
    }
}
