/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2013
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.mdl.link.design;



public class DichoSearchForArray 
{
    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private static String[] TEST_TAB = {"AAA", "BBB", "DDD", "EEE", "GGG", "III", "PPP", "QQQ", "RRR"};
	
    /**
     * Returns either a positive integer representing the index of elem in the tab if it exists;
     * or a negative integer representing the index that would take elem if it was inserted in tab. 
     * The order is the String class order (ASCII).
     * Both parameter must be not null.
     * @param elem
     * @param tab
     * @return
     */
    public static int search(String elem, String[] tab)
    {
        if (elem == null || tab == null)
            throw new RuntimeException("DichotomicSearch.search(elem, tab). At least one parameter is null !!!");
        
        int len = tab.length;
        if (len == 0)
            return ~0;
        if (elem.compareTo(tab[0]) < 0)
            return ~0;
        if (elem.compareTo(tab[len - 1]) > 0)
            return ~(len);
        
        int inf = 0; 
        int sup = len - 1;
        int pivot;
        while (inf <= sup)
        {
            pivot = (inf + sup)/2;
            if (elem.compareTo(tab[pivot]) == 0)
                return pivot;
            else if (elem.compareTo(tab[pivot]) < 0)
                sup = pivot - 1;
            else //elem.compareTo(tab[pivot]) > 0
                inf = pivot + 1;
        }
        return ~inf;
    }
    
	/**
	 * @param args
	 */
	public static void main(String[] args) 
	{
		System.out.println("Start of program");
		System.out.print("Input=[");
		for (String z : TEST_TAB)
		{
			System.out.print(z + ", ");
		}
		System.out.println("]");
		
		String s = "A";
		//---------------------------------------------
		int r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		s = "AAA";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
		s = "BBB";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
		s = "DDD";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
		s = "FFF";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
		s = "GGG";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
		s = "PPP";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
		s = "RRR";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
		s = "ZZZ";
		r0 = search(s, TEST_TAB);
		System.out.println("search for : " + s + " => found @ index : " + r0);
		//---------------------------------------------
        //SPECIAL CASE : search in an empty Tab.
        s = "ZZZ";
        r0 = search(s, new String[0]);
        System.out.println("Empty tab. search for : " + s + " => found @ index : " + r0);
        //---------------------------------------------
		System.out.println("End of program");
	}

}
