/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.volume.label.eobject;

import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.Keyword;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class VolumeEObjectLabelFactory {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String getClassLabel(EObject eObject) {
        return eObject.eClass().getName();
    }

    public String getShortLabel(EObject eObject) {
        String label = eObject instanceof RadicalEntity ? this.getLabel(eObject) : (eObject instanceof Keyword ? ((Keyword)eObject).getName() : this.getClassLabel(eObject));
        return label;
    }

    public String getLabel(EObject eObject) {
        StringBuilder buffer = new StringBuilder(this.getClassLabel(eObject));
        if (eObject instanceof RadicalEntity) {
            buffer.append(": ").append(this.getFullName((RadicalEntity)eObject));
        } else if (eObject instanceof Keyword) {
            buffer.append(" ").append(((Keyword)eObject).getName());
        }
        return buffer.toString();
    }

    public boolean accept(EObject eObject) {
        EObject ePackage = eObject.eClass().eContainer();
        return ePackage == KernelPackage.eINSTANCE;
    }

    protected String getFullName(RadicalEntity radicalObject) {
        URI uri = radicalObject.getDesignURI();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < uri.segmentCount()) {
            String segment = uri.segment(i);
            if (i < uri.segmentCount() - 1) {
                buffer.append(uri.segment(i));
                buffer.append("/");
            } else {
                buffer.append(segment.substring(0, segment.lastIndexOf(".")));
            }
            ++i;
        }
        return buffer.toString();
    }
}

