/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.skeleton.micropattern;

import com.ibm.pdp.engine.ICommonMicroPatternHandler;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternHandler;
import com.ibm.pdp.skeleton.framework.pattern.SkeletonMessage;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class MicroPatternRuntimeJarHandler
implements IMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, SoftReference<ClassLoader>> softReferences = null;

    public String getId() {
        return "RPPJAR";
    }

    public String getNamespace() {
        return null;
    }

    public void init() {
    }

    public void process(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        String className = microPattern.getAttribute("ClassName");
        String jarPath = microPattern.getAttribute("JarFileName");
        String jarProject = microPattern.getAttribute("JarProject");
        String forceReload = microPattern.getAttribute("JarReload");
        if (className == null || jarPath == null) {
            microPattern.getProcessingContext().setStatus(4, microPattern, SkeletonMessage._MPJAR_CLASSNAME_JARNAME_PARAMS_NOT_FOUND, SkeletonMessage._MP_REVIEW_DECLARATION);
            return;
        }
        if (jarProject != null) {
            jarPath = "/" + jarProject + "/" + jarPath.replace('\\', '/');
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember(jarPath);
            if (resource != null) {
                jarPath = resource.getLocation().toOSString();
            }
        }
        try {
            ClassLoader classLoader = this.getClassLoaderFor(jarPath, "true".equals(forceReload));
            Class<?> aClass = classLoader.loadClass(className);
            ICommonMicroPatternHandler pluginMicroPattern = (ICommonMicroPatternHandler)aClass.newInstance();
            pluginMicroPattern.process(microPattern, genInfoBuilder);
        }
        catch (Exception e) {
            e.printStackTrace();
            microPattern.getProcessingContext().setStatus(4, microPattern, e.getClass() + "\n" + e.getLocalizedMessage(), "Please, review check the jar file");
        }
    }

    private ClassLoader loadJar(String jarFileName, ClassLoader classLoader) throws Exception {
        String cp;
        File jar = new File(jarFileName);
        JarFile jf = new JarFile(jar);
        ArrayList<URL> urls = new ArrayList<URL>(5);
        urls.add(jar.toURI().toURL());
        Manifest mf = jf.getManifest();
        if (mf != null && (cp = mf.getMainAttributes().getValue("class-path")) != null) {
            String[] stringArray = cp.split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cpe = stringArray[n2];
                File lib = new File(jar.getParentFile(), cpe);
                urls.add(lib.toURI().toURL());
                ++n2;
            }
        }
        jf.close();
        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), classLoader);
        return cl;
    }

    private ClassLoader getClassLoaderFor(String jarPath, boolean forceReload) throws Exception {
        if (softReferences == null) {
            softReferences = new HashMap<String, SoftReference<ClassLoader>>();
        }
        SoftReference<ClassLoader> softReference = null;
        softReference = softReferences.get(jarPath);
        if (softReference != null && softReference.get() != null) {
            if (forceReload) {
                softReference.clear();
            } else {
                return softReference.get();
            }
        }
        ClassLoader classLoader = this.loadJar(jarPath, this.getClass().getClassLoader());
        softReferences.put(jarPath, new SoftReference<ClassLoader>(classLoader));
        return classLoader;
    }

    public List<Object> getReferencedEntities(IMicroPattern microPattern) {
        return null;
    }

    public String getDescription() {
        return SkeletonMessage._MPJAR_TEMPLATE;
    }

    public String getTemplate() {
        if ("true".equals(System.getProperty("rppSdkDemo"))) {
            return "\r\n*- ClassName=\"com.sample.demo.ServiceCallMicroPattern\"\r\n*- JarFileName=\"com.sample.demo_1.0.0.201706271637.jar\"\r\n*- JarProject=\"Jars\"\r\n*- Call=\"SUBPRG01\" Inputs=\"NUM_CLI\" Outputs=\"CONTRACT_ID\"";
        }
        return "PRIVATE";
    }
}

