/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.skeleton.micropattern;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IMicroPattern;
import com.ibm.pdp.engine.IMicroPatternHandler;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.framework.interfaces.IReference;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.mdl.skeleton.MicroPatternCode;
import com.ibm.pdp.mdl.skeleton.MicroPatternCodeFragment;
import com.ibm.pdp.mdl.skeleton.MicroPatternTagFragment;
import com.ibm.pdp.mdl.skeleton.SourceCode;
import com.ibm.pdp.mdl.skeleton.SourceProperty;
import com.ibm.pdp.references.service.ReferenceService;
import com.ibm.pdp.skeleton.framework.SkeletonPlugin;
import com.ibm.pdp.skeleton.framework.pattern.SkeletonMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MicroPatternFragmentHandler
implements IMicroPatternHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String EOF = System.getProperty("line.separator");
    private static final String ID = "RPPMPF";
    private static final String DESIGN_FILE = "DESIGN_FILE_IN_CONTEXT";
    private static final String ATTRIBUTE_ID = "id";

    public String getId() {
        return ID;
    }

    public String getNamespace() {
        return null;
    }

    public void init() {
    }

    public void process(IMicroPattern microPattern, IGenInfoBuilder genInfoBuilder) {
        String design;
        Object obj = microPattern.getProcessingContext().getData(DESIGN_FILE);
        if (obj == null && (design = microPattern.getProcessingContext().getGenerationProperties().getProperty("DESIGN_PATH")) != null) {
            int initialResolvingMode = PTEditorService.getResolvingMode();
            PTEditorService.setResolvingMode((int)3);
            obj = PTEditorService.getSharedResource((IPath)new Path(design));
            PTEditorService.setResolvingMode((int)initialResolvingMode);
        }
        if (obj instanceof RadicalEntity) {
            RadicalEntity radicalEntity = (RadicalEntity)obj;
            String projectName = null;
            String packageName = null;
            String name = null;
            String id = null;
            HashMap<String, String> otherAttributes = new HashMap<String, String>();
            for (String attrName : microPattern.getAttributes().keySet()) {
                if ("Project".equals(attrName)) {
                    projectName = microPattern.getAttribute(attrName);
                    continue;
                }
                if ("Name".equals(attrName)) {
                    name = microPattern.getAttribute(attrName);
                    continue;
                }
                if ("Package".equals(attrName)) {
                    packageName = microPattern.getAttribute(attrName);
                    continue;
                }
                if ("Id".equals(attrName)) {
                    id = microPattern.getAttribute(attrName);
                    continue;
                }
                otherAttributes.put(attrName, microPattern.getAttribute(attrName));
            }
            if (name == null || id == null) {
                microPattern.getProcessingContext().setStatus(4, microPattern, SkeletonMessage._MPCODE_NAME_ID_PARAMS_NOT_FOUND, SkeletonMessage._MP_REVIEW_DECLARATION);
                return;
            }
            if (projectName == null) {
                projectName = radicalEntity.getProject();
            }
            if (packageName == null) {
                packageName = radicalEntity.getPackage();
            }
            int initialResolvingMode = PTEditorService.getResolvingMode();
            PTEditorService.setResolvingMode((int)3);
            RadicalEntity mpEntity = PTEditorService.resolveSharedResource((String)projectName, (String)packageName, (String)name, (String)MicroPatternCode.class.getSimpleName().toLowerCase());
            PTEditorService.setResolvingMode((int)initialResolvingMode);
            if (mpEntity == null) {
                microPattern.getProcessingContext().setStatus(4, microPattern, SkeletonMessage.getString((String)SkeletonMessage._MPCODE_BLOCK_NOT_FOUND, (Object[])new String[]{name}), SkeletonMessage._MP_REVIEW_DECLARATION);
                return;
            }
            MicroPatternCode microPatternCode = (MicroPatternCode)mpEntity;
            String source = null;
            MicroPatternCodeFragment fragment = null;
            for (MicroPatternCodeFragment codeFragment : microPatternCode.getFragments()) {
                if (!codeFragment.getId().equals(id)) continue;
                source = codeFragment.getSource();
                fragment = codeFragment;
                break;
            }
            if (source != null && source.length() > 0) {
                String tagName = "RPPMPF_" + projectName + '_' + (packageName == null || packageName.length() == 0 ? "" : String.valueOf(packageName) + '_') + microPatternCode.getName() + '_' + id + '_' + this.findId(microPattern);
                IBuilderTag tag = genInfoBuilder.tagFromName(tagName);
                if (tag == null) {
                    tag = genInfoBuilder.addTag(microPattern.getLocation().getEndIndex(), microPattern.getLocation().getEndIndex(), tagName);
                }
                if (!(source = this.replaceProperties(microPattern, radicalEntity, otherAttributes, source)).endsWith(EOF)) {
                    source = String.valueOf(source) + EOF;
                }
                tag.setText((CharSequence)source);
                tag.setProperty("mp", "true");
            }
            if (fragment != null) {
                for (MicroPatternTagFragment tagFragment : fragment.getTagFragments()) {
                    IBuilderTag tag;
                    if (tagFragment.getSource() == null || tagFragment.getTagName() == null || genInfoBuilder.tagFromName(tagFragment.getTagName()) == null) continue;
                    source = tagFragment.getSource();
                    String tagName = "RPPMPF_" + projectName + '_' + (packageName == null || packageName.length() == 0 ? "" : String.valueOf(packageName) + '_') + microPatternCode.getName() + '_' + id + '_' + tagFragment.getTagName();
                    if (!tagFragment.isUnique()) {
                        tagName = String.valueOf(tagName) + '_' + this.findId(microPattern);
                    }
                    if ((tag = genInfoBuilder.tagFromName(tagName)) == null) {
                        IBuilderTag parentTag = genInfoBuilder.tagFromName(tagFragment.getTagName());
                        tag = genInfoBuilder.addTag(parentTag.getEndIndex(), parentTag.getEndIndex(), tagName, tagFragment.getTagName());
                    }
                    if (!(source = this.replaceProperties(microPattern, radicalEntity, otherAttributes, source)).endsWith(EOF)) {
                        source = String.valueOf(source) + EOF;
                    }
                    tag.setText((CharSequence)source);
                    tag.setProperty("mp", "true");
                }
            } else {
                microPattern.getProcessingContext().setStatus(4, microPattern, SkeletonMessage.getString((String)SkeletonMessage._MPCODE_BLOCK_NOT_FOUND, (Object[])new String[]{id}), SkeletonMessage._MP_REVIEW_DECLARATION);
                return;
            }
            IReference reference = ReferenceService.newReference((String)microPatternCode.getProject(), (String)microPatternCode.getPackage(), null, (String)microPatternCode.getName(), (String)microPatternCode.eClass().getName().toLowerCase(), (String)microPatternCode.getStateId(), (String)(String.valueOf(this.getClass().getCanonicalName()) + "_" + microPatternCode.getName()));
            microPattern.getProcessingContext().registerGenerationReference((Object)reference);
        }
    }

    private String replaceProperties(IMicroPattern microPattern, RadicalEntity radicalEntity, Map<String, String> otherAttributes, String sourceInput) {
        String source = sourceInput;
        HashSet<String> sourceProperties = new HashSet<String>();
        for (String attrName : otherAttributes.keySet()) {
            source = source.replace(String.valueOf('$') + attrName, otherAttributes.get(attrName));
            sourceProperties.add(attrName);
        }
        if (radicalEntity instanceof SourceCode) {
            String patternName;
            SourceCode sourceCode = (SourceCode)radicalEntity;
            for (SourceProperty property : sourceCode.getProperties()) {
                if (sourceProperties.contains(property.getName())) continue;
                source = source.replace(String.valueOf('$') + property.getName(), property.getValue());
                sourceProperties.add(property.getName());
            }
            if (sourceCode.getSkeleton() != null) {
                for (SourceProperty property : sourceCode.getSkeleton().getSkeletonProperties()) {
                    if (sourceProperties.contains(property.getName())) continue;
                    source = source.replace(String.valueOf('$') + property.getName(), property.getDefaultValue());
                    sourceProperties.add(property.getName());
                }
            }
            if (microPattern.getProcessingContext() != null && microPattern.getProcessingContext().getGeneratedInfo() != null && (patternName = microPattern.getProcessingContext().getGeneratedInfo().getProperty("pattern")) != null) {
                Map map = SkeletonPlugin.getSkeletonPredefinedPropertyExtension((String)patternName, (SourceCode)sourceCode);
                for (String key : map.keySet()) {
                    if (sourceProperties.contains(key)) continue;
                    source = source.replace(String.valueOf('$') + key, (CharSequence)map.get(key));
                }
            }
        }
        return source;
    }

    protected String findId(IMicroPattern microPattern) {
        String id = microPattern.getProcessingContext().getAttribute(ATTRIBUTE_ID);
        if (id != null) {
            int lastId = Integer.parseInt(id);
            id = String.valueOf(++lastId);
        } else {
            id = "1";
        }
        microPattern.getProcessingContext().setAttribute(ATTRIBUTE_ID, id);
        return id;
    }

    public static IBuilderTag getMPCurrentTag(IMicroPattern microPattern) {
        IGenInfoBuilder giBuilder = microPattern.getProcessingContext().getGeneratedInfo().toGeneratedInfoBuilder();
        int index = microPattern.getLocation().getBeginIndex() + microPattern.getOriginalHeaderDeclaration().length() - 1;
        IBuilderTag currentTag = giBuilder.includingTag(index, index);
        return currentTag;
    }

    public List<Object> getReferencedEntities(IMicroPattern microPattern) {
        if (ID.equals(microPattern.getId())) {
            String entityName = microPattern.getAttribute("Name");
            ArrayList<Object> refEntities = new ArrayList<Object>();
            ReferencedEntity re = new ReferencedEntity(entityName, null, "micropatterncode", microPattern.getId());
            refEntities.add(re);
            return refEntities;
        }
        return null;
    }

    public String getDescription() {
        return SkeletonMessage._MPCODE_TEMPLATE;
    }

    public String getTemplate() {
        if ("true".equals(System.getProperty("rppSdkDemo"))) {
            return "Project=\"P01\" Name=\"CALL\" Id=\"01\"\r\n*- Call=\"SUBPRG01\" Inputs=\"NUM_CLI\" Outputs=\"CONTRACT_ID\"";
        }
        return "PRIVATE";
    }
}

