/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;

public class ParseUserInfo {
    public static final String delim = ":";
    public static final char eq = '=';
    public static String _userInfo = "";
    public static String _type = "";
    public static final String PROP_TYPE = "DET";
    public static final String PROP_PAR = "P";
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String parse(String userinfo, String property) {
        if (userinfo != null && userinfo.trim().length() != 0) {
            String ui = userinfo.trim();
            StringTokenizer tokenizer = new StringTokenizer(ui, delim);
            while (tokenizer.hasMoreTokens()) {
                int ind;
                String token = tokenizer.nextToken();
                if (!token.substring(0, ind = token.indexOf(61)).equals(property)) continue;
                return token.substring(ind + 1);
            }
        }
        return "";
    }

    public static String replace(String originalText, String subStringToFind, String subStringToReplaceWith) {
        int s = 0;
        int e = 0;
        StringBuffer newText = new StringBuffer();
        while ((e = originalText.indexOf(subStringToFind, s)) >= 0) {
            newText.append(originalText.substring(s, e));
            newText.append(subStringToReplaceWith);
            s = e + subStringToFind.length();
        }
        newText.append(originalText.substring(s));
        _userInfo = newText.toString();
        return _userInfo;
    }

    public static String getUserInfoFor(String userinfo, String property) {
        if (userinfo != null && userinfo.trim().length() != 0) {
            String ui = userinfo.trim();
            StringTokenizer tokenizer = new StringTokenizer(ui, delim);
            while (tokenizer.hasMoreTokens()) {
                int ind;
                String token = tokenizer.nextToken();
                if (!token.substring(0, ind = token.indexOf(61)).equals(property)) continue;
                return token;
            }
        }
        return "";
    }

    public static String getUserInfo() {
        return _userInfo;
    }

    public static String getUserInfo(RadicalEntity re) {
        _userInfo = re.getUserInfo();
        return _userInfo;
    }

    public static String setType(DataElement de, DataElement dem, String newType) {
        _userInfo = de.getUserInfo();
        String typede = "";
        typede = newType.length() == 0 ? ParseUserInfo.getPacDataElementType(de) : newType;
        if (dem == null) {
            _type = typede;
        } else {
            String typedem = ParseUserInfo.getPacDataElementType(dem);
            _type = typede.equals("I") ? typedem : typede;
        }
        return _type;
    }

    public static void setUserInfo(RadicalEntity re, String property, String value) {
        String ui = re.getUserInfo();
        String uiForProperty = ParseUserInfo.getUserInfoFor(ui, property);
        String newValue = String.valueOf(property) + '=' + value;
        if (ui != null && ui.length() > 0 && uiForProperty.length() > 0 && !uiForProperty.equals(newValue)) {
            uiForProperty = ParseUserInfo.replace(ui, uiForProperty, newValue);
            re.setUserInfo(_userInfo);
            return;
        }
        if (ui != null && ui.length() == 0) {
            _userInfo = ParseUserInfo.setUserInfoUnique(property, value);
            re.setUserInfo(_userInfo);
            return;
        }
        if (ui != null && uiForProperty.length() == 0) {
            _userInfo = String.valueOf(ui) + delim + ParseUserInfo.setUserInfoUnique(property, value);
            re.setUserInfo(_userInfo);
            return;
        }
    }

    private static String setUserInfoUnique(String property, String value) {
        if (property.equals(PROP_PAR)) {
            return "P=" + value;
        }
        if (property.equals(PROP_TYPE)) {
            return "DET=" + value;
        }
        return "";
    }

    public static String getPacDataElementType(DataElement de) {
        return ParseUserInfo.getPacDataElementDescription(de).getType().getLiteral().substring(1, 2);
    }

    public static PacDataElementDescription getPacDataElementDescription(DataElement de) {
        EList ddExtensions = de.getDataDescription().getExtensions();
        int ind = 0;
        while (ind < ddExtensions.size()) {
            Object object = ddExtensions.get(ind);
            if (object instanceof PacDataElementDescription) {
                PacDataElementDescription ded = (PacDataElementDescription)object;
                return ded;
            }
            ++ind;
        }
        return null;
    }
}

