/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.PacAbstractDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCardinalityValues;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCommunicationTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacErrorMessageSentValues;
import com.ibm.pdp.mdl.pacbase.PacScreenSubSchemaValues;
import com.ibm.pdp.mdl.pacbase.PacTypeNodeValues;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacTransformationEbusinessValues {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _DIALOG_EB = 1;
    public static final int _EB = 2;

    public static List<PacErrorMessageSentValues> getErrorMessageSentTypes(PacAbstractDialogCommunicationMonitor absDialCM) {
        if (absDialCM instanceof PacCommunicationMonitor) {
            return PacTransformationEbusinessValues.getErrorMessageSentTypes(2);
        }
        if (absDialCM instanceof PacDialogCommunicationMonitor) {
            return PacTransformationEbusinessValues.getErrorMessageSentTypes(1);
        }
        return null;
    }

    private static List<PacErrorMessageSentValues> getErrorMessageSentTypes(int type) {
        ArrayList<PacErrorMessageSentValues> errorMessageSentTypes = new ArrayList<PacErrorMessageSentValues>();
        switch (type) {
            case 1: {
                errorMessageSentTypes.add(PacErrorMessageSentValues._N_LITERAL);
                errorMessageSentTypes.add(PacErrorMessageSentValues._Y_LITERAL);
                break;
            }
            case 2: {
                errorMessageSentTypes.add(PacErrorMessageSentValues._NONE_LITERAL);
                errorMessageSentTypes.add(PacErrorMessageSentValues._N_LITERAL);
                errorMessageSentTypes.add(PacErrorMessageSentValues._Y_LITERAL);
            }
        }
        return errorMessageSentTypes;
    }

    public static List<PacCommunicationTypeValues> getCommunicationTypes(PacAbstractDialogCommunicationMonitor absDialCM) {
        if (absDialCM instanceof PacCommunicationMonitor) {
            return PacTransformationEbusinessValues.getCommunicationTypes(2);
        }
        if (absDialCM instanceof PacDialogCommunicationMonitor) {
            return PacTransformationEbusinessValues.getCommunicationTypes(1);
        }
        return null;
    }

    private static List<PacCommunicationTypeValues> getCommunicationTypes(int type) {
        ArrayList<PacCommunicationTypeValues> commTypes = new ArrayList<PacCommunicationTypeValues>();
        switch (type) {
            case 1: {
                commTypes.add(PacCommunicationTypeValues._SOCKET_LITERAL);
                commTypes.add(PacCommunicationTypeValues._LOCAL_LITERAL);
                break;
            }
            case 2: {
                commTypes.add(PacCommunicationTypeValues._NONE_LITERAL);
                commTypes.add(PacCommunicationTypeValues._SOCKET_LITERAL);
                commTypes.add(PacCommunicationTypeValues._LOCAL_LITERAL);
            }
        }
        return commTypes;
    }

    public static String transformNodeType(PacTypeNodeValues value) {
        switch (value.getValue()) {
            case 0: {
                return "D";
            }
            case 1: {
                return "L";
            }
        }
        System.out.println("transformNodeType(...) - Unknown PacTypeNode value: " + value.toString());
        return "  ";
    }

    public static String transformCardinality(PacCardinalityValues value) {
        switch (value.getValue()) {
            case 0: {
                return "01";
            }
            case 2: {
                return "0N";
            }
            case 1: {
                return "11";
            }
            case 3: {
                return "1N";
            }
        }
        System.out.println("transformCardinality(...) - Unknown PacCardinality value: " + value.toString());
        return "  ";
    }

    public static String transformSubschema(PacScreenSubSchemaValues value) {
        switch (value.getValue()) {
            case 1: {
                return "10";
            }
            case 2: {
                return "1";
            }
            case 3: {
                return "2";
            }
            case 4: {
                return "3";
            }
            case 5: {
                return "4";
            }
            case 6: {
                return "5";
            }
            case 7: {
                return "6";
            }
            case 8: {
                return "7";
            }
            case 9: {
                return "8";
            }
            case 10: {
                return "9";
            }
            case 0: {
                return "";
            }
        }
        System.out.println("transformSubschema(...) - Unknown PacSuschema value: " + value.toString());
        return "  ";
    }

    public static List<PacCardinalityValues> getCardinalities(PacTypeNodeValues typeNode) {
        ArrayList<PacCardinalityValues> values = new ArrayList<PacCardinalityValues>();
        switch (typeNode.getValue()) {
            case 0: {
                values.add(PacCardinalityValues._01_LITERAL);
                values.add(PacCardinalityValues._11_LITERAL);
                values.add(PacCardinalityValues._0N_LITERAL);
                values.add(PacCardinalityValues._1N_LITERAL);
                break;
            }
            case 1: {
                values.add(PacCardinalityValues._01_LITERAL);
                values.add(PacCardinalityValues._11_LITERAL);
                break;
            }
        }
        return values;
    }
}

