/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.PacBlankWhenZeroValues;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.PacTimestampFractionValues;
import com.ibm.pdp.mdl.pacbase.PacTimezoneValues;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacTransformationDataElementType {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _CHILD = 1;
    public static final int _PARENT = 2;

    public static String transformDataElementType(PacDataElementTypeValues value) {
        switch (value.getValue()) {
            case 0: {
                return "R";
            }
            case 1: {
                return "P";
            }
            case 3: {
                return "L";
            }
            case 4: {
                return "U";
            }
            case 2: {
                return "A";
            }
            case 5: {
                return " ";
            }
        }
        System.out.println("transformDataElementType(...) - Unknown PacDataElementTypeValues Value: " + value.toString());
        return " ";
    }

    public static ArrayList<PacDataElementTypeValues> getPacDataElementTypes(PacDataElementDescription pded) {
        if (pded == null || pded.getParent() == null) {
            return PacTransformationDataElementType.getPacDataElementTypes(1);
        }
        return PacTransformationDataElementType.getPacDataElementTypes(2);
    }

    public static ArrayList<PacDataElementTypeValues> getPacDataElementTypes(int type) {
        ArrayList<PacDataElementTypeValues> dataElementTypes = new ArrayList<PacDataElementTypeValues>();
        switch (type) {
            case 1: {
                dataElementTypes.add(PacDataElementTypeValues._R_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._P_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._A_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._L_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._U_LITERAL);
                break;
            }
            case 2: {
                dataElementTypes.add(PacDataElementTypeValues._R_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._P_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._A_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._L_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._U_LITERAL);
                dataElementTypes.add(PacDataElementTypeValues._INHERITED_LITERAL);
            }
        }
        return dataElementTypes;
    }

    public static ArrayList<PacBlankWhenZeroValues> getPacDataElementBWZ(PacDataElementDescription pded) {
        if (pded == null || pded.getParent() == null) {
            return PacTransformationDataElementType.getPacDataElementBWZ(1);
        }
        return PacTransformationDataElementType.getPacDataElementBWZ(2);
    }

    public static ArrayList<PacBlankWhenZeroValues> getPacDataElementBWZ(int type) {
        ArrayList<PacBlankWhenZeroValues> dataElementBWZ = new ArrayList<PacBlankWhenZeroValues>();
        switch (type) {
            case 1: {
                dataElementBWZ.add(PacBlankWhenZeroValues._FALSE_LITERAL);
                dataElementBWZ.add(PacBlankWhenZeroValues._TRUE_LITERAL);
                break;
            }
            case 2: {
                dataElementBWZ.add(PacBlankWhenZeroValues._FALSE_LITERAL);
                dataElementBWZ.add(PacBlankWhenZeroValues._TRUE_LITERAL);
                dataElementBWZ.add(PacBlankWhenZeroValues._INHERITED_LITERAL);
            }
        }
        return dataElementBWZ;
    }

    public static ArrayList<PacTimezoneValues> getPacTimezone(PacDataElementDescription pded) {
        if (pded == null || pded.getParent() == null) {
            return PacTransformationDataElementType.getPacTimezone(1);
        }
        return PacTransformationDataElementType.getPacTimezone(2);
    }

    public static ArrayList<PacTimezoneValues> getPacTimezone(int type) {
        ArrayList<PacTimezoneValues> timezones = new ArrayList<PacTimezoneValues>();
        switch (type) {
            case 1: {
                timezones.add(PacTimezoneValues._FALSE_LITERAL);
                timezones.add(PacTimezoneValues._TRUE_LITERAL);
                break;
            }
            case 2: {
                timezones.add(PacTimezoneValues._FALSE_LITERAL);
                timezones.add(PacTimezoneValues._TRUE_LITERAL);
                timezones.add(PacTimezoneValues._INHERITED_LITERAL);
            }
        }
        return timezones;
    }

    public static ArrayList<PacTimestampFractionValues> getPacFraction(PacDataElementDescription pded) {
        if (pded == null || pded.getParent() == null) {
            return PacTransformationDataElementType.getPacFraction(1);
        }
        return PacTransformationDataElementType.getPacFraction(2);
    }

    public static ArrayList<PacTimestampFractionValues> getPacFraction(int type) {
        ArrayList<PacTimestampFractionValues> fractions = new ArrayList<PacTimestampFractionValues>();
        switch (type) {
            case 1: {
                fractions.add(PacTimestampFractionValues._6_LITERAL);
                fractions.add(PacTimestampFractionValues._0_LITERAL);
                fractions.add(PacTimestampFractionValues._1_LITERAL);
                fractions.add(PacTimestampFractionValues._2_LITERAL);
                fractions.add(PacTimestampFractionValues._3_LITERAL);
                fractions.add(PacTimestampFractionValues._4_LITERAL);
                fractions.add(PacTimestampFractionValues._5_LITERAL);
                fractions.add(PacTimestampFractionValues._7_LITERAL);
                fractions.add(PacTimestampFractionValues._8_LITERAL);
                fractions.add(PacTimestampFractionValues._9_LITERAL);
                fractions.add(PacTimestampFractionValues._10_LITERAL);
                fractions.add(PacTimestampFractionValues._11_LITERAL);
                fractions.add(PacTimestampFractionValues._12_LITERAL);
                break;
            }
            case 2: {
                fractions.add(PacTimestampFractionValues._6_LITERAL);
                fractions.add(PacTimestampFractionValues._0_LITERAL);
                fractions.add(PacTimestampFractionValues._1_LITERAL);
                fractions.add(PacTimestampFractionValues._2_LITERAL);
                fractions.add(PacTimestampFractionValues._3_LITERAL);
                fractions.add(PacTimestampFractionValues._4_LITERAL);
                fractions.add(PacTimestampFractionValues._5_LITERAL);
                fractions.add(PacTimestampFractionValues._7_LITERAL);
                fractions.add(PacTimestampFractionValues._8_LITERAL);
                fractions.add(PacTimestampFractionValues._9_LITERAL);
                fractions.add(PacTimestampFractionValues._10_LITERAL);
                fractions.add(PacTimestampFractionValues._11_LITERAL);
                fractions.add(PacTimestampFractionValues._12_LITERAL);
                fractions.add(PacTimestampFractionValues._INHERITED_LITERAL);
            }
        }
        return fractions;
    }

    public static int transformFraction(PacTimestampFractionValues value) {
        switch (value.getValue()) {
            case 0: {
                return 6;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
        }
        System.out.println("transformDataElementType(...) - Unknown PacDataElementTypeValues Value: " + value.toString());
        return 6;
    }
}

