/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.PacDataAggregateTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDataUnitTypeValues;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PacTransformationData {
    private static final PacDataUnitTypeValues[] VALUES_TABLE_ARRAY = new PacDataUnitTypeValues[]{PacDataUnitTypeValues._G_LITERAL, PacDataUnitTypeValues._T_LITERAL, PacDataUnitTypeValues._M_LITERAL, PacDataUnitTypeValues._N_LITERAL};
    private static final List<PacDataUnitTypeValues> TABLE_VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_TABLE_ARRAY));
    private static final PacDataUnitTypeValues[] VALUES_LVIEW_ARRAY = new PacDataUnitTypeValues[]{PacDataUnitTypeValues._V_LITERAL};
    private static final List<PacDataUnitTypeValues> LVIEW_VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_LVIEW_ARRAY));
    private static final PacDataUnitTypeValues[] VALUES_STANDARD_ARRAY = new PacDataUnitTypeValues[]{PacDataUnitTypeValues._Z_LITERAL};
    private static final List<PacDataUnitTypeValues> STANDARD_VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_STANDARD_ARRAY));
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String transformDataUnitType(PacDataUnitTypeValues value) {
        switch (value.getValue()) {
            case 0: {
                return "Z";
            }
            case 2: {
                return "G";
            }
            case 3: {
                return "T";
            }
            case 1: {
                return "V";
            }
            case 4: {
                return "M";
            }
            case 5: {
                return "N";
            }
        }
        System.out.println("transformDataUnitType(...) - Unknown PacDataUnitType Value: " + value.toString());
        return " ";
    }

    public static String transformDataAggregateType(PacDataAggregateTypeValues value) {
        switch (value.getValue()) {
            case 0: {
                return "Z";
            }
            case 2: {
                return "G";
            }
            case 1: {
                return "V";
            }
        }
        System.out.println("transformDataAggregateType(...) - Unknown PacDataAggregateType Value: " + value.toString());
        return " ";
    }

    public static List getPacDataUnitTableTypeValues() {
        return TABLE_VALUES;
    }

    public static List getPacDataUnitLogicalViewTypeValues() {
        return LVIEW_VALUES;
    }

    public static List getPacDataUnitStandardTypeValues() {
        return STANDARD_VALUES;
    }

    public static boolean isTablePacDataUnit(PacDataUnitTypeValues value) {
        return PacTransformationData.arrayContainsElement(VALUES_TABLE_ARRAY, value);
    }

    public static boolean isStandardPacDataUnit(PacDataUnitTypeValues value) {
        return PacTransformationData.arrayContainsElement(VALUES_STANDARD_ARRAY, value);
    }

    public static boolean isLogicalViewPacDataUnit(PacDataUnitTypeValues value) {
        return PacTransformationData.arrayContainsElement(VALUES_LVIEW_ARRAY, value);
    }

    private static boolean arrayContainsElement(PacDataUnitTypeValues[] types, PacDataUnitTypeValues value) {
        int i = 0;
        while (i < types.length) {
            if (types[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

