/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacCobolTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacMapTypeValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationDialog;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacTransformationCobolType {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _SCREEN = 1;
    public static final int _SERVER = 2;
    public static final int _DIALOG = 3;
    public static final int _DIALOG_SERVER = 4;
    public static final int _STANDARD_DIALOG = 5;
    public static final int _STANDARD_SCREEN = 6;
    public static final int _CLIENT_DIALOG = 7;
    public static final int _CLIENT_SCREEN = 8;

    public static final String transformCobolType(PacCobolTypeValues value) {
        switch (value.getValue()) {
            case 0: {
                return " ";
            }
            case 1: {
                return "N";
            }
            case 2: {
                return "X";
            }
            case 3: {
                return "1";
            }
            case 4: {
                return "3";
            }
            case 5: {
                return "4";
            }
            case 6: {
                return "5";
            }
            case 7: {
                return "6";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "F";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "K";
            }
            case 12: {
                return "O";
            }
            case 13: {
                return "Q";
            }
            case 14: {
                return "R";
            }
            case 15: {
                return "U";
            }
            case 16: {
                return "Z";
            }
        }
        System.out.println("transformPacCobolType(...) - Unknown PacCobolTypeValue: " + value.toString());
        return " ";
    }

    public static ArrayList<PacCobolTypeValues> getCobolTypes(PacAbstractDialog absDialog) {
        if (absDialog instanceof PacScreen) {
            return PacTransformationCobolType.getCobolTypes(1);
        }
        if (absDialog instanceof PacDialog) {
            return PacTransformationCobolType.getCobolTypes(3);
        }
        return null;
    }

    public static ArrayList<PacCobolTypeValues> getCobolTypes(PacAbstractDialogServer absDialogServer) {
        if (absDialogServer instanceof PacServer) {
            return PacTransformationCobolType.getCobolTypes(2);
        }
        if (absDialogServer instanceof PacDialogServer) {
            return PacTransformationCobolType.getCobolTypes(4);
        }
        return null;
    }

    public static ArrayList<PacCobolTypeValues> getCobolTypes(PacAbstractDialogFolder absDialogFolder) {
        if (absDialogFolder instanceof PacFolder) {
            return PacTransformationCobolType.getCobolTypes(2);
        }
        if (absDialogFolder instanceof PacDialogFolder) {
            return PacTransformationCobolType.getCobolTypes(4);
        }
        return null;
    }

    public static ArrayList<PacCobolTypeValues> getCobolTypes(int type) {
        ArrayList<PacCobolTypeValues> cobolTypes = new ArrayList<PacCobolTypeValues>();
        switch (type) {
            case 1: {
                cobolTypes.add(PacCobolTypeValues._NONE_LITERAL);
                cobolTypes.add(PacCobolTypeValues._N_LITERAL);
                cobolTypes.add(PacCobolTypeValues._X_LITERAL);
                cobolTypes.add(PacCobolTypeValues._1_LITERAL);
                cobolTypes.add(PacCobolTypeValues._3_LITERAL);
                cobolTypes.add(PacCobolTypeValues._4_LITERAL);
                cobolTypes.add(PacCobolTypeValues._5_LITERAL);
                cobolTypes.add(PacCobolTypeValues._6_LITERAL);
                cobolTypes.add(PacCobolTypeValues._8_LITERAL);
                cobolTypes.add(PacCobolTypeValues._F_LITERAL);
                cobolTypes.add(PacCobolTypeValues._I_LITERAL);
                cobolTypes.add(PacCobolTypeValues._K_LITERAL);
                cobolTypes.add(PacCobolTypeValues._O_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Q_LITERAL);
                cobolTypes.add(PacCobolTypeValues._R_LITERAL);
                cobolTypes.add(PacCobolTypeValues._U_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Z_LITERAL);
                break;
            }
            case 2: {
                cobolTypes.add(PacCobolTypeValues._NONE_LITERAL);
                cobolTypes.add(PacCobolTypeValues._N_LITERAL);
                cobolTypes.add(PacCobolTypeValues._X_LITERAL);
                cobolTypes.add(PacCobolTypeValues._1_LITERAL);
                cobolTypes.add(PacCobolTypeValues._3_LITERAL);
                cobolTypes.add(PacCobolTypeValues._4_LITERAL);
                cobolTypes.add(PacCobolTypeValues._5_LITERAL);
                cobolTypes.add(PacCobolTypeValues._6_LITERAL);
                cobolTypes.add(PacCobolTypeValues._8_LITERAL);
                cobolTypes.add(PacCobolTypeValues._F_LITERAL);
                cobolTypes.add(PacCobolTypeValues._I_LITERAL);
                cobolTypes.add(PacCobolTypeValues._K_LITERAL);
                cobolTypes.add(PacCobolTypeValues._O_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Q_LITERAL);
                cobolTypes.add(PacCobolTypeValues._R_LITERAL);
                cobolTypes.add(PacCobolTypeValues._U_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Z_LITERAL);
                break;
            }
            case 3: {
                cobolTypes.add(PacCobolTypeValues._N_LITERAL);
                cobolTypes.add(PacCobolTypeValues._X_LITERAL);
                cobolTypes.add(PacCobolTypeValues._1_LITERAL);
                cobolTypes.add(PacCobolTypeValues._3_LITERAL);
                cobolTypes.add(PacCobolTypeValues._4_LITERAL);
                cobolTypes.add(PacCobolTypeValues._5_LITERAL);
                cobolTypes.add(PacCobolTypeValues._6_LITERAL);
                cobolTypes.add(PacCobolTypeValues._8_LITERAL);
                cobolTypes.add(PacCobolTypeValues._F_LITERAL);
                cobolTypes.add(PacCobolTypeValues._I_LITERAL);
                cobolTypes.add(PacCobolTypeValues._K_LITERAL);
                cobolTypes.add(PacCobolTypeValues._O_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Q_LITERAL);
                cobolTypes.add(PacCobolTypeValues._R_LITERAL);
                cobolTypes.add(PacCobolTypeValues._U_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Z_LITERAL);
                break;
            }
            case 4: {
                cobolTypes.add(PacCobolTypeValues._N_LITERAL);
                cobolTypes.add(PacCobolTypeValues._X_LITERAL);
                cobolTypes.add(PacCobolTypeValues._1_LITERAL);
                cobolTypes.add(PacCobolTypeValues._3_LITERAL);
                cobolTypes.add(PacCobolTypeValues._4_LITERAL);
                cobolTypes.add(PacCobolTypeValues._5_LITERAL);
                cobolTypes.add(PacCobolTypeValues._6_LITERAL);
                cobolTypes.add(PacCobolTypeValues._8_LITERAL);
                cobolTypes.add(PacCobolTypeValues._F_LITERAL);
                cobolTypes.add(PacCobolTypeValues._I_LITERAL);
                cobolTypes.add(PacCobolTypeValues._K_LITERAL);
                cobolTypes.add(PacCobolTypeValues._O_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Q_LITERAL);
                cobolTypes.add(PacCobolTypeValues._R_LITERAL);
                cobolTypes.add(PacCobolTypeValues._U_LITERAL);
                cobolTypes.add(PacCobolTypeValues._Z_LITERAL);
            }
        }
        return cobolTypes;
    }

    public static ArrayList<PacDialogTypeValues> getDialogTypes(PacAbstractDialog absDialog) {
        if (absDialog instanceof PacScreen) {
            return PacTransformationCobolType.getDialogTypes(1);
        }
        if (absDialog instanceof PacDialog) {
            return PacTransformationCobolType.getDialogTypes(3);
        }
        return null;
    }

    public static ArrayList<PacDialogTypeValues> getDialogTypesByFamily(PacAbstractDialog absDialog) {
        if (absDialog instanceof PacScreen) {
            PacScreen screen = (PacScreen)absDialog;
            if (((Object)((Object)absDialog.getDialogType())).equals((Object)PacDialogTypeValues._INHERITED_LITERAL)) {
                if (PacTransformationDialog.isServerDialogOrScreen(((PacScreen)absDialog).getDialog())) {
                    return PacTransformationCobolType.getDialogTypes(8);
                }
                return PacTransformationCobolType.getDialogTypes(6);
            }
            if (PacTransformationDialog.isServerDialogOrScreen(absDialog)) {
                if (!PacTransformationDialog.isServerDialogOrScreen(screen.getDialog())) {
                    return PacTransformationCobolType.getDialogTypes(7);
                }
                return PacTransformationCobolType.getDialogTypes(8);
            }
            if (PacTransformationDialog.isServerDialogOrScreen(screen.getDialog())) {
                return PacTransformationCobolType.getDialogTypes(5);
            }
            return PacTransformationCobolType.getDialogTypes(6);
        }
        if (absDialog instanceof PacDialog) {
            if (PacTransformationDialog.isServerDialogOrScreen(absDialog)) {
                return PacTransformationCobolType.getDialogTypes(7);
            }
            return PacTransformationCobolType.getDialogTypes(5);
        }
        return null;
    }

    public static ArrayList<PacDialogServerTypeValues> getDialogServerTypes(PacAbstractDialogServer absDialogServer) {
        if (absDialogServer instanceof PacServer) {
            return PacTransformationCobolType.getDialogServerTypes(2);
        }
        if (absDialogServer instanceof PacDialogServer) {
            return PacTransformationCobolType.getDialogServerTypes(4);
        }
        return null;
    }

    public static ArrayList<PacDialogTypeValues> getDialogTypes(int type) {
        ArrayList<PacDialogTypeValues> dialogTypes = new ArrayList<PacDialogTypeValues>();
        switch (type) {
            case 1: {
                dialogTypes.add(PacDialogTypeValues._NONE_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MW_LITERAL);
                dialogTypes.add(PacDialogTypeValues._C_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MC_LITERAL);
                dialogTypes.add(PacDialogTypeValues._SC_LITERAL);
                dialogTypes.add(PacDialogTypeValues._INHERITED_LITERAL);
                break;
            }
            case 3: {
                dialogTypes.add(PacDialogTypeValues._NONE_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MW_LITERAL);
                dialogTypes.add(PacDialogTypeValues._C_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MC_LITERAL);
                dialogTypes.add(PacDialogTypeValues._SC_LITERAL);
                break;
            }
            case 6: {
                dialogTypes.add(PacDialogTypeValues._NONE_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MW_LITERAL);
                dialogTypes.add(PacDialogTypeValues._INHERITED_LITERAL);
                break;
            }
            case 5: {
                dialogTypes.add(PacDialogTypeValues._NONE_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MW_LITERAL);
                break;
            }
            case 8: {
                dialogTypes.add(PacDialogTypeValues._C_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MC_LITERAL);
                dialogTypes.add(PacDialogTypeValues._SC_LITERAL);
                dialogTypes.add(PacDialogTypeValues._INHERITED_LITERAL);
                break;
            }
            case 7: {
                dialogTypes.add(PacDialogTypeValues._C_LITERAL);
                dialogTypes.add(PacDialogTypeValues._MC_LITERAL);
                dialogTypes.add(PacDialogTypeValues._SC_LITERAL);
            }
        }
        return dialogTypes;
    }

    public static ArrayList<PacDialogServerTypeValues> getDialogServerTypes(int type) {
        ArrayList<PacDialogServerTypeValues> dialogServerTypes = new ArrayList<PacDialogServerTypeValues>();
        switch (type) {
            case 2: {
                dialogServerTypes.add(PacDialogServerTypeValues._MS_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._S_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._IT_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._MV_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._E_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._INHERITED_LITERAL);
                break;
            }
            case 4: {
                dialogServerTypes.add(PacDialogServerTypeValues._MS_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._S_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._IT_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._MV_LITERAL);
                dialogServerTypes.add(PacDialogServerTypeValues._E_LITERAL);
            }
        }
        return dialogServerTypes;
    }

    public static List<PacMapTypeValues> getMapTypes(Object object) {
        ArrayList<PacMapTypeValues> mapTypes = new ArrayList<PacMapTypeValues>();
        if (object instanceof PacScreen || object instanceof PacServer || object instanceof PacCommunicationMonitor || object instanceof PacFolder) {
            mapTypes.add(PacMapTypeValues._NONE_LITERAL);
            mapTypes.add(PacMapTypeValues._N_LITERAL);
            mapTypes.add(PacMapTypeValues._0_LITERAL);
            mapTypes.add(PacMapTypeValues._1_LITERAL);
            mapTypes.add(PacMapTypeValues._2_LITERAL);
            mapTypes.add(PacMapTypeValues._3_LITERAL);
            mapTypes.add(PacMapTypeValues._4_LITERAL);
            mapTypes.add(PacMapTypeValues._5_LITERAL);
            mapTypes.add(PacMapTypeValues._C_LITERAL);
            mapTypes.add(PacMapTypeValues._F_LITERAL);
            mapTypes.add(PacMapTypeValues._R_LITERAL);
            mapTypes.add(PacMapTypeValues._S_LITERAL);
        }
        if (object instanceof PacDialog || object instanceof PacDialogServer || object instanceof PacDialogCommunicationMonitor || object instanceof PacDialogFolder) {
            mapTypes.add(PacMapTypeValues._N_LITERAL);
            mapTypes.add(PacMapTypeValues._0_LITERAL);
            mapTypes.add(PacMapTypeValues._1_LITERAL);
            mapTypes.add(PacMapTypeValues._2_LITERAL);
            mapTypes.add(PacMapTypeValues._3_LITERAL);
            mapTypes.add(PacMapTypeValues._4_LITERAL);
            mapTypes.add(PacMapTypeValues._5_LITERAL);
            mapTypes.add(PacMapTypeValues._C_LITERAL);
            mapTypes.add(PacMapTypeValues._F_LITERAL);
            mapTypes.add(PacMapTypeValues._R_LITERAL);
            mapTypes.add(PacMapTypeValues._S_LITERAL);
        }
        return mapTypes;
    }

    public static List<PacCobolTypeValues> getCobolTypes(PacAbstractDialogCommunicationMonitor absDialogCM) {
        if (absDialogCM instanceof PacCommunicationMonitor) {
            return PacTransformationCobolType.getCobolTypes(2);
        }
        if (absDialogCM instanceof PacDialogCommunicationMonitor) {
            return PacTransformationCobolType.getCobolTypes(4);
        }
        return null;
    }

    public static PacCobolTypeValues getCorrespondingCobolType(String literal) {
        if (PacCobolTypeValues.get(literal) != null) {
            return PacCobolTypeValues.get(literal);
        }
        return PacCobolTypeValues._N_LITERAL;
    }
}

