/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.PacBlockBaseTypeValues;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacTransformationBlockBaseType {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String transformBlockBaseType(PacBlockBaseTypeValues value) {
        switch (value.getValue()) {
            case 0: {
                return "DP";
            }
            case 1: {
                return "DR";
            }
            case 2: {
                return "DL";
            }
            case 3: {
                return "IP";
            }
            case 4: {
                return "IS";
            }
            case 5: {
                return "PC";
            }
            case 6: {
                return "PS";
            }
            case 7: {
                return "M1";
            }
            case 8: {
                return "M2";
            }
            case 9: {
                return "M3";
            }
            case 10: {
                return "M4";
            }
            case 11: {
                return "I1";
            }
            case 12: {
                return "I2";
            }
            case 13: {
                return "I3";
            }
            case 14: {
                return "D0";
            }
            case 15: {
                return "D2";
            }
            case 16: {
                return "D4";
            }
            case 36: {
                return "SO";
            }
            case 20: {
                return "SA";
            }
            case 21: {
                return "SS";
            }
            case 22: {
                return "DB";
            }
            case 17: {
                return "S1";
            }
            case 18: {
                return "S3";
            }
            case 24: {
                return "PF";
            }
            case 23: {
                return "LF";
            }
            case 25: {
                return "Q2";
            }
            case 26: {
                return "Q3";
            }
            case 27: {
                return "QB";
            }
            case 28: {
                return "QC";
            }
            case 29: {
                return "QN";
            }
            case 30: {
                return "QP";
            }
            case 31: {
                return "QR";
            }
            case 32: {
                return "QS";
            }
            case 33: {
                return "QT";
            }
            case 34: {
                return "QU";
            }
            case 35: {
                return "QY";
            }
            case 37: {
                return "TD";
            }
            case 19: {
                return "20";
            }
        }
        System.out.println("transformBlockBaseType(...) - Unknown BlockBaseType value: " + value.toString());
        return "  ";
    }

    public static boolean isRelationalBlockBaseType(PacBlockBaseTypeValues value) {
        return value != null && (value == PacBlockBaseTypeValues._Q2_LITERAL || value == PacBlockBaseTypeValues._Q3_LITERAL || value == PacBlockBaseTypeValues._QC_LITERAL || value == PacBlockBaseTypeValues._QN_LITERAL || value == PacBlockBaseTypeValues._QS_LITERAL || value == PacBlockBaseTypeValues._QT_LITERAL || value == PacBlockBaseTypeValues._QR_LITERAL || value == PacBlockBaseTypeValues._QP_LITERAL || value == PacBlockBaseTypeValues._QB_LITERAL || value == PacBlockBaseTypeValues._QU_LITERAL || value == PacBlockBaseTypeValues._QY_LITERAL);
    }

    public static boolean isHierarchicalBlockBaseType(PacBlockBaseTypeValues value) {
        return value != null && (value == PacBlockBaseTypeValues._DL_LITERAL || value == PacBlockBaseTypeValues._DP_LITERAL || value == PacBlockBaseTypeValues._DR_LITERAL || value == PacBlockBaseTypeValues._IP_LITERAL || value == PacBlockBaseTypeValues._PF_LITERAL || value == PacBlockBaseTypeValues._LF_LITERAL || value == PacBlockBaseTypeValues._IS_LITERAL || value == PacBlockBaseTypeValues._PS_LITERAL || value == PacBlockBaseTypeValues._PC_LITERAL);
    }

    public static boolean isCodasylBlockBaseType(PacBlockBaseTypeValues value) {
        return value != null && (value == PacBlockBaseTypeValues._DB_LITERAL || value == PacBlockBaseTypeValues._20_LITERAL || value == PacBlockBaseTypeValues._D0_LITERAL || value == PacBlockBaseTypeValues._D2_LITERAL || value == PacBlockBaseTypeValues._D4_LITERAL || value == PacBlockBaseTypeValues._I1_LITERAL || value == PacBlockBaseTypeValues._I2_LITERAL || value == PacBlockBaseTypeValues._I3_LITERAL || value == PacBlockBaseTypeValues._M1_LITERAL || value == PacBlockBaseTypeValues._M2_LITERAL || value == PacBlockBaseTypeValues._M3_LITERAL || value == PacBlockBaseTypeValues._M4_LITERAL || value == PacBlockBaseTypeValues._S1_LITERAL || value == PacBlockBaseTypeValues._S3_LITERAL || value == PacBlockBaseTypeValues._TD_LITERAL);
    }

    public static boolean isSocrateBlockBaseType(PacBlockBaseTypeValues value) {
        return value != null && (value == PacBlockBaseTypeValues._SO_LITERAL || value == PacBlockBaseTypeValues._SA_LITERAL || value == PacBlockBaseTypeValues._SS_LITERAL);
    }

    public static List<PacBlockBaseTypeValues> getRelationalFamilyBlockBaseType() {
        ArrayList<PacBlockBaseTypeValues> values = new ArrayList<PacBlockBaseTypeValues>();
        values.add(PacBlockBaseTypeValues._Q2_LITERAL);
        values.add(PacBlockBaseTypeValues._Q3_LITERAL);
        values.add(PacBlockBaseTypeValues._QC_LITERAL);
        values.add(PacBlockBaseTypeValues._QN_LITERAL);
        values.add(PacBlockBaseTypeValues._QS_LITERAL);
        values.add(PacBlockBaseTypeValues._QT_LITERAL);
        values.add(PacBlockBaseTypeValues._QR_LITERAL);
        values.add(PacBlockBaseTypeValues._QP_LITERAL);
        values.add(PacBlockBaseTypeValues._QB_LITERAL);
        values.add(PacBlockBaseTypeValues._QU_LITERAL);
        values.add(PacBlockBaseTypeValues._QY_LITERAL);
        return values;
    }

    public static List<PacBlockBaseTypeValues> getHierarchicalFamilyBlockBaseType() {
        ArrayList<PacBlockBaseTypeValues> values = new ArrayList<PacBlockBaseTypeValues>();
        values.add(PacBlockBaseTypeValues._DL_LITERAL);
        values.add(PacBlockBaseTypeValues._DP_LITERAL);
        values.add(PacBlockBaseTypeValues._DR_LITERAL);
        values.add(PacBlockBaseTypeValues._IP_LITERAL);
        values.add(PacBlockBaseTypeValues._PF_LITERAL);
        values.add(PacBlockBaseTypeValues._LF_LITERAL);
        values.add(PacBlockBaseTypeValues._IS_LITERAL);
        values.add(PacBlockBaseTypeValues._PS_LITERAL);
        values.add(PacBlockBaseTypeValues._PC_LITERAL);
        return values;
    }

    public static List<PacBlockBaseTypeValues> getCodasylFamilyBlockBaseType() {
        ArrayList<PacBlockBaseTypeValues> values = new ArrayList<PacBlockBaseTypeValues>();
        values.add(PacBlockBaseTypeValues._20_LITERAL);
        values.add(PacBlockBaseTypeValues._D0_LITERAL);
        values.add(PacBlockBaseTypeValues._D2_LITERAL);
        values.add(PacBlockBaseTypeValues._D4_LITERAL);
        values.add(PacBlockBaseTypeValues._I1_LITERAL);
        values.add(PacBlockBaseTypeValues._I2_LITERAL);
        values.add(PacBlockBaseTypeValues._I3_LITERAL);
        values.add(PacBlockBaseTypeValues._M1_LITERAL);
        values.add(PacBlockBaseTypeValues._M2_LITERAL);
        values.add(PacBlockBaseTypeValues._M3_LITERAL);
        values.add(PacBlockBaseTypeValues._M4_LITERAL);
        values.add(PacBlockBaseTypeValues._S1_LITERAL);
        values.add(PacBlockBaseTypeValues._S3_LITERAL);
        values.add(PacBlockBaseTypeValues._DB_LITERAL);
        values.add(PacBlockBaseTypeValues._TD_LITERAL);
        return values;
    }

    public static List<PacBlockBaseTypeValues> getSocrateFamilyBlockBaseType() {
        ArrayList<PacBlockBaseTypeValues> values = new ArrayList<PacBlockBaseTypeValues>();
        values.add(PacBlockBaseTypeValues._SO_LITERAL);
        values.add(PacBlockBaseTypeValues._SA_LITERAL);
        values.add(PacBlockBaseTypeValues._SS_LITERAL);
        return values;
    }

    public static int getBlockBaseFamily(PacBlockBaseTypeValues value) {
        if (PacTransformationBlockBaseType.isRelationalBlockBaseType(value)) {
            return 0;
        }
        if (PacTransformationBlockBaseType.isHierarchicalBlockBaseType(value)) {
            return 1;
        }
        if (PacTransformationBlockBaseType.isCodasylBlockBaseType(value)) {
            return 2;
        }
        if (PacTransformationBlockBaseType.isSocrateBlockBaseType(value)) {
            return 3;
        }
        return -1;
    }
}

