/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.UserEntity;
import com.ibm.pdp.mdl.pacbase.PacText;
import com.ibm.pdp.mdl.pacbase.PacTextSection;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacTextSectionLinkUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Pattern REFERENCE_PATTERN = Pattern.compile("@\\S+");
    private static Map<String, EClass> eClassMap = new HashMap<String, EClass>();
    private static Map<String, String> eTypeMap;

    static {
        eClassMap.put("DEL", KernelPackage.eINSTANCE.getDataElement());
        eClassMap.put("DST", KernelPackage.eINSTANCE.getDataUnit());
        eClassMap.put("SEG", KernelPackage.eINSTANCE.getDataAggregate());
        eClassMap.put("TXT", PacbasePackage.eINSTANCE.getPacText());
        eClassMap.put("IAD", PacbasePackage.eINSTANCE.getPacInputAid());
        eClassMap.put("VOL", PacbasePackage.eINSTANCE.getPacVolume());
        eClassMap.put("DBD", PacbasePackage.eINSTANCE.getPacBlockBase());
        eClassMap.put("LIB", PacbasePackage.eINSTANCE.getPacLibrary());
        eClassMap.put("RPT", PacbasePackage.eINSTANCE.getPacReport());
        eClassMap.put("OST", PacbasePackage.eINSTANCE.getPacDialog());
        eClassMap.put("OSV", PacbasePackage.eINSTANCE.getPacDialogServer());
        eClassMap.put("SCR", PacbasePackage.eINSTANCE.getPacScreen());
        eClassMap.put("SRV", PacbasePackage.eINSTANCE.getPacServer());
        eClassMap.put("OFL", PacbasePackage.eINSTANCE.getPacDialogFolder());
        eClassMap.put("FLD", PacbasePackage.eINSTANCE.getPacFolder());
        eClassMap.put("OFV", PacbasePackage.eINSTANCE.getPacDialogFolderView());
        eClassMap.put("FLV", PacbasePackage.eINSTANCE.getPacFolderView());
        eClassMap.put("OFL", PacbasePackage.eINSTANCE.getPacDialogFolder());
        eClassMap.put("FLD", PacbasePackage.eINSTANCE.getPacFolder());
        eClassMap.put("OCM", PacbasePackage.eINSTANCE.getPacDialogCommunicationMonitor());
        eClassMap.put("CMO", PacbasePackage.eINSTANCE.getPacCommunicationMonitor());
        eClassMap.put("PGM", PacbasePackage.eINSTANCE.getPacProgram());
        eClassMap.put("MSP", PacbasePackage.eINSTANCE.getPacMacro());
        eClassMap.put("MET", KernelPackage.eINSTANCE.getMetaEntity());
        eClassMap.put("USE", KernelPackage.eINSTANCE.getUserEntity());
        eTypeMap = new HashMap<String, String>();
        eTypeMap.put(KernelPackage.eINSTANCE.getDataElement().getName().toLowerCase(), "DEL");
        eTypeMap.put(KernelPackage.eINSTANCE.getDataUnit().getName().toLowerCase(), "DST");
        eTypeMap.put(KernelPackage.eINSTANCE.getDataAggregate().getName().toLowerCase(), "SEG");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacText().getName().toLowerCase(), "TXT");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacInputAid().getName().toLowerCase(), "IAD");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacVolume().getName().toLowerCase(), "VOL");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacBlockBase().getName().toLowerCase(), "DBD");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacLibrary().getName().toLowerCase(), "LIB");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacReport().getName().toLowerCase(), "RPT");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacDialog().getName().toLowerCase(), "OST");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacDialogServer().getName().toLowerCase(), "OSV");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacScreen().getName().toLowerCase(), "SCR");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacServer().getName().toLowerCase(), "SRV");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacDialogFolder().getName().toLowerCase(), "OFL");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacFolder().getName().toLowerCase(), "FLD");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacDialogFolderView().getName().toLowerCase(), "OFV");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacFolderView().getName().toLowerCase(), "FLV");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacDialogCommunicationMonitor().getName().toLowerCase(), "OCM");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacCommunicationMonitor().getName().toLowerCase(), "CMO");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacProgram().getName().toLowerCase(), "PGM");
        eTypeMap.put(PacbasePackage.eINSTANCE.getPacMacro().getName().toLowerCase(), "MSP");
        eTypeMap.put(KernelPackage.eINSTANCE.getMetaEntity().getName().toLowerCase(), "MET");
        eTypeMap.put(KernelPackage.eINSTANCE.getUserEntity().getName().toLowerCase(), "USE");
    }

    public static Collection<String> getTypes() {
        return eClassMap.keySet();
    }

    public static EClass getEClassForType(String type) {
        return eClassMap.get(type);
    }

    public static String getTypeForEClass(EClass eClass) {
        for (String type : eClassMap.keySet()) {
            if (eClassMap.get(type) != eClass) continue;
            return type;
        }
        return null;
    }

    public static String getTypeForEntityType(String designId) {
        for (String type : eClassMap.keySet()) {
            if (!designId.endsWith(eClassMap.get(type).getName().toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public static String getTypeintText(String designType) {
        for (String type : eTypeMap.keySet()) {
            if (!designType.equals(type)) continue;
            return eTypeMap.get(type);
        }
        return null;
    }

    public static void collectCalledReferences(PacText pacText, Map<RadicalEntity, List<String>> calledInstances) {
        for (Object object : pacText.getSections()) {
            PacTextSection pacTextSection = (PacTextSection)object;
            PacTextSectionLinkUtil.collectCalledReferences(pacTextSection, calledInstances);
        }
    }

    public static void collectCalledReferences(PacTextSection pacTextSection, Map<RadicalEntity, List<String>> calledInstances) {
        HashMap<EClass, HashSet<String>> map = new HashMap<EClass, HashSet<String>>();
        String source = pacTextSection.getSource();
        if (source == null) {
            return;
        }
        Matcher matcher = PacTextSectionLinkUtil.getMatcher().matcher(source);
        while (matcher.find()) {
            String[] link;
            EClass eClass;
            int end;
            int start = matcher.start();
            String relation = source.substring(start + 1, end = matcher.end());
            if (relation.length() < 4 || (eClass = PacTextSectionLinkUtil.getEClassForType((link = PacTextSectionLinkUtil.parseLink(relation))[0])) == null) continue;
            HashSet<String> list = (HashSet<String>)map.get(eClass);
            if (list == null) {
                list = new HashSet<String>();
                map.put(eClass, list);
            }
            list.add(link[1].trim());
        }
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("sections");
        for (EClass eClass : map.keySet()) {
            for (String code : (Set)map.get(eClass)) {
                RadicalEntity radicalEntity = (RadicalEntity)eClass.getEPackage().getEFactoryInstance().create(eClass);
                if (radicalEntity instanceof UserEntity) {
                    UserEntity userEntity = (UserEntity)radicalEntity;
                    if (!PacTextSectionLinkUtil.initUserEntity(userEntity, code)) {
                        continue;
                    }
                } else {
                    radicalEntity.setName(code);
                }
                calledInstances.put(radicalEntity, properties);
            }
        }
    }

    public static boolean initUserEntity(UserEntity userEntity, String fullCode) {
        int idx = fullCode.lastIndexOf(46);
        if (idx < 0) {
            return false;
        }
        MetaEntity metaEntity = KernelFactory.eINSTANCE.createMetaEntity();
        metaEntity.setName(fullCode.substring(idx + 1));
        userEntity.setMetaEntity(metaEntity);
        userEntity.setName(fullCode.substring(0, idx));
        return true;
    }

    public static String[] parseLink(String link) {
        String type = link.substring(0, 3);
        String code = link.substring(3);
        return new String[]{type, code};
    }

    public static void renameCalledReferences(PacText pacText) {
        String[] context = (String[])System.getProperties().get("PTActionPolicyRenameContext");
        if (context == null) {
            return;
        }
        String type = PacTextSectionLinkUtil.getTypeForEntityType(context[0]);
        if (type == null) {
            return;
        }
        String temp = context[0].substring(1);
        int start = temp.indexOf(47);
        int end = temp.lastIndexOf(46);
        String oldPattern = String.valueOf('@') + type + temp.substring(start + 1, end);
        String newPattern = String.valueOf('@') + type + context[1];
        if ("USE".equals(type)) {
            int idx = oldPattern.lastIndexOf(46);
            if (idx < 0) {
                return;
            }
            newPattern = String.valueOf(newPattern) + oldPattern.substring(idx);
        }
        for (Object object : pacText.getSections()) {
            PacTextSection pacTextSection = (PacTextSection)object;
            String source = pacTextSection.getSource();
            if (source == null) continue;
            pacTextSection.setSource(source.replace(oldPattern, newPattern));
        }
    }

    public static Pattern getMatcher() {
        return REFERENCE_PATTERN;
    }
}

