/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.kernel.DescriptionType;
import com.ibm.pdp.mdl.kernel.Documentation;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.ExportInfo;
import com.ibm.pdp.mdl.kernel.Field;
import com.ibm.pdp.mdl.kernel.Keyword;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.pacbase.PacCobolTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacGeneratedSkeletonLanguageValues;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacMapTypeValues;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacSourceInheritanceGenerationHeader;
import com.ibm.pdp.mdl.pacbase.util.PacAbstractWrapper;
import com.ibm.pdp.mdl.pacbase.util.RadicalEntityWrapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacServerWrapper
extends PacAbstractWrapper
implements PacServer,
RadicalEntityWrapper {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacServer referencedServer;
    private PacServer headerServer;

    public PacServerWrapper(PacServer headerServer) {
        this.headerServer = headerServer;
        PacGenerationHeader genHeader = headerServer.getGenerationHeader();
        if (genHeader == null) {
            this.referencedServer = headerServer;
            return;
        }
        if (genHeader instanceof PacLibrarySubstitutionGenerationHeader) {
            PacLibrarySubstitutionGenerationHeader libGenerationheader = (PacLibrarySubstitutionGenerationHeader)genHeader;
            this.referencedServer = (PacServer)libGenerationheader.getGeneratedRadicalEntity();
            return;
        }
        if (genHeader instanceof PacSourceInheritanceGenerationHeader) {
            PacSourceInheritanceGenerationHeader sourceGenheader = (PacSourceInheritanceGenerationHeader)genHeader;
            this.referencedServer = (PacServer)sourceGenheader.getGeneratedRadicalEntity();
        }
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) {
        return this.headerServer.findMaxProblemSeverity(type, includeSubtypes, depth);
    }

    @Override
    public String getCobolFolder() {
        return this.headerServer.getCobolFolder();
    }

    @Override
    public String getCobolProject() {
        return this.headerServer.getCobolProject();
    }

    @Override
    public PacCobolTypeValues getCobolType() {
        PacDialogServer dialog;
        PacCobolTypeValues value;
        PacGenerationHeader pgh;
        if (this.referencedServer != this.headerServer && (pgh = this.headerServer.getGenerationHeader()) instanceof PacLibrarySubstitutionGenerationHeader) {
            PacCobolTypeValues value2 = this.headerServer.getCobolType();
            if (!((Object)((Object)value2)).equals((Object)PacCobolTypeValues._NONE_LITERAL)) {
                return value2;
            }
            PacDialogServer dialog2 = this.referencedServer.getDialog();
            if (dialog2 != null) {
                return dialog2.getCobolType();
            }
        }
        if (((Object)((Object)(value = this.referencedServer.getCobolType()))).equals((Object)PacCobolTypeValues._NONE_LITERAL) && (dialog = this.referencedServer.getDialog()) != null) {
            value = dialog.getCobolType();
        }
        return value;
    }

    public Map<RadicalEntity, List<String>> getSolidRelations() {
        return null;
    }

    public Map<RadicalEntity, List<String>> getFreeRelations() {
        return null;
    }

    public Set<RadicalEntity> getCalledProxies() {
        return null;
    }

    public EList<?> getCPLines() {
        return this.referencedServer.getCPLines();
    }

    public EList<?> getCSLines() {
        return this.referencedServer.getCSLines();
    }

    public URI getDesignURI() {
        return this.headerServer.getDesignURI();
    }

    @Override
    public PacDialogServer getDialog() {
        return this.referencedServer.getDialog();
    }

    @Override
    public PacDialogServerTypeValues getDialogType() {
        PacDialogServer dialog;
        PacDialogServerTypeValues value = this.headerServer.getDialogType();
        if (((Object)((Object)value)).equals((Object)PacDialogServerTypeValues._INHERITED_LITERAL) && (dialog = this.referencedServer.getDialog()) != null) {
            value = dialog.getDialogType();
        }
        return value;
    }

    public EClass eClass() {
        return this.headerServer.eClass();
    }

    public ExportInfo getExportInfo() {
        return null;
    }

    public EList<RadicalEntityExtension> getExtensions() {
        return this.headerServer.getExtensions();
    }

    public IFile getFile(List<String> paths) {
        return null;
    }

    public Documentation getFunctionalDocumentation() {
        return this.referencedServer.getFunctionalDocumentation();
    }

    public EList<?> getGCLines() {
        return this.referencedServer.getGCLines();
    }

    public EList<?> getGELines() {
        return this.referencedServer.getGELines();
    }

    @Override
    public PacGenerationHeader getGenerationHeader() {
        return null;
    }

    @Override
    public PacLibrary getGenerationParameter() {
        if (this.referencedServer == this.headerServer) {
            return this.referencedServer.getGenerationParameter();
        }
        PacGenerationHeader pgh = this.headerServer.getGenerationHeader();
        if (pgh instanceof PacLibrarySubstitutionGenerationHeader) {
            PacLibrarySubstitutionGenerationHeader libHeader = (PacLibrarySubstitutionGenerationHeader)pgh;
            return libHeader.getGenerationParameter();
        }
        return this.referencedServer.getGenerationParameter();
    }

    public EList<?> getGGLines() {
        return this.referencedServer.getGGLines();
    }

    public EList<?> getGOLines() {
        return this.referencedServer.getGOLines();
    }

    public EList<Keyword> getKeywords() {
        return this.headerServer.getKeywords();
    }

    public String getLabel() {
        return this.headerServer.getLabel();
    }

    public String getLocation() {
        return this.referencedServer.getLocation();
    }

    @Override
    public PacMapTypeValues getMapType() {
        PacDialogServer dialog;
        PacMapTypeValues value;
        PacGenerationHeader pgh;
        if (this.referencedServer != this.headerServer && (pgh = this.headerServer.getGenerationHeader()) instanceof PacLibrarySubstitutionGenerationHeader) {
            PacMapTypeValues value2 = this.headerServer.getMapType();
            if (!((Object)((Object)value2)).equals((Object)PacMapTypeValues._NONE_LITERAL)) {
                return value2;
            }
            PacDialogServer dialog2 = this.referencedServer.getDialog();
            if (dialog2 != null) {
                return dialog2.getMapType();
            }
        }
        if (((Object)((Object)(value = this.referencedServer.getMapType()))).equals((Object)PacMapTypeValues._NONE_LITERAL) && (dialog = this.referencedServer.getDialog()) != null) {
            value = dialog.getMapType();
        }
        return value;
    }

    public String getModelVersion() {
        return null;
    }

    public String getName() {
        return this.referencedServer.getName();
    }

    public RadicalEntity getOwner() {
        return null;
    }

    public String getPackage() {
        return this.headerServer.getPackage();
    }

    public IPath getPath(String projectName) {
        return null;
    }

    @Override
    public String getProgramExternalName() {
        return this.headerServer.getProgramExternalName();
    }

    public String getProject() {
        return this.headerServer.getProject();
    }

    public String getProxyName() {
        return null;
    }

    public URI getProxyURI() {
        return null;
    }

    @Override
    public String getServerExternalName() {
        return this.headerServer.getServerExternalName();
    }

    public String getStateId() {
        return this.headerServer.getStateId();
    }

    public Documentation getTechnicalDocumentation() {
        return this.referencedServer.getTechnicalDocumentation();
    }

    @Override
    public String getTransactionCode() {
        return this.referencedServer.getTransactionCode();
    }

    public Documentation getUserDocumentation() {
        return this.referencedServer.getUserDocumentation();
    }

    public EList<?> getWLines() {
        return this.referencedServer.getWLines();
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isSame(Entity eObject) {
        return false;
    }

    public int isSameHashCode() {
        return 0;
    }

    public boolean isResolved(List<String> paths) {
        return false;
    }

    public void save() throws IOException {
    }

    @Override
    public void setCobolFolder(String value) {
    }

    @Override
    public void setCobolProject(String value) {
    }

    @Override
    public void setCobolType(PacCobolTypeValues value) {
    }

    @Override
    public void setDialog(PacDialogServer value) {
    }

    @Override
    public void setDialogType(PacDialogServerTypeValues value) {
    }

    public void setExportInfo(ExportInfo value) {
    }

    public void setFunctionalDocumentation(Documentation value) {
    }

    @Override
    public void setGenerationHeader(PacGenerationHeader value) {
    }

    @Override
    public void setGenerationParameter(PacLibrary value) {
    }

    public void setLabel(String value) {
    }

    public void setLocation(String location) {
    }

    @Override
    public void setMapType(PacMapTypeValues value) {
    }

    public void setModelVersion(String value) {
    }

    public void setName(String value) {
    }

    public void setPackage(String value) {
    }

    @Override
    public void setProgramExternalName(String value) {
    }

    public void setProject(String project) {
    }

    public void setProxyURI(URI uri) {
    }

    @Override
    public void setServerExternalName(String value) {
    }

    public void setTechnicalDocumentation(Documentation value) {
    }

    public void setTimestamp(String value) {
    }

    @Override
    public void setTransactionCode(String value) {
    }

    public void setUserDocumentation(Documentation value) {
    }

    public String getDesignId(String projectName) {
        return this.headerServer.getDesignId(projectName);
    }

    public String getIdentifier() {
        return this.headerServer.getIdentifier();
    }

    public Field getField() {
        return this.headerServer.getField();
    }

    public void setField(Field value) {
        this.headerServer.setField(value);
    }

    public MetaEntity getMetaEntity() {
        return this.headerServer.getMetaEntity();
    }

    public void setMetaEntity(MetaEntity value) {
        this.headerServer.setMetaEntity(value);
    }

    @Override
    public PacGeneratedSkeletonLanguageValues getSkeletonLanguage() {
        return this.headerServer.getSkeletonLanguage();
    }

    @Override
    public void setSkeletonLanguage(PacGeneratedSkeletonLanguageValues value) {
        this.headerServer.setSkeletonLanguage(value);
    }

    public EList<DescriptionType> getDescriptionTypes() {
        return this.headerServer.getDescriptionTypes();
    }

    @Override
    public RadicalEntity getHeaderRadicalEntity() {
        return this.headerServer;
    }

    @Override
    public RadicalEntity getReferencedRadicalEntity() {
        return this.referencedServer;
    }

    public String getUserInfo() {
        return this.headerServer.getUserInfo();
    }

    public void setUserInfo(String value) {
        this.headerServer.setUserInfo(value);
    }

    public String getMasterStateId() {
        return null;
    }

    public void setMasterStateId(String value) {
    }

    public PacServer getMaster() {
        return null;
    }

    public void setMaster(PacServer value) {
    }

    public void enableENotification(boolean eNotify) {
    }

    public String getEntityVersion() {
        return null;
    }

    public void setEntityVersion(String value) {
    }

    public String getGenStateId(Map<String, List<String>> patternExceptions) {
        if (this.referencedServer == this.headerServer) {
            return this.referencedServer.getGenStateId(patternExceptions);
        }
        return this.headerServer.getGenStateId(patternExceptions);
    }

    @Override
    public String getProxyProject() {
        return this.headerServer.getProxyProject();
    }

    @Override
    public void setProxyProject(String value) {
    }

    @Override
    public String getProxyFolder() {
        return this.headerServer.getProxyFolder();
    }

    @Override
    public void setProxyFolder(String value) {
    }

    @Override
    public String getServiceProject() {
        return this.headerServer.getServiceProject();
    }

    @Override
    public void setServiceProject(String value) {
    }

    @Override
    public String getServiceFolder() {
        return this.headerServer.getServiceFolder();
    }

    @Override
    public void setServiceFolder(String value) {
    }
}

