/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacOptions {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ACCESERR = "ACCESERR=";
    public static final String ATTRE_YES = "ATTRE=YES";
    public static final String ATTRIB_YES = "ATTRIB=YES";
    public static final String BASE = "BASE=";
    public static final String BASELOC_LOCAL = "BASELOC=LOCAL";
    public static final String BASELOC_REMOTE = "BASELOC=REMOTE";
    public static final String BREAKDATE_NO = "BREAKDATE=NO";
    public static final String BREAKDATE_YES = "BREAKDATE=YES";
    public static final String CALLSPG_CALL = "CALLSPG=CALL";
    public static final String CALLSPG_LINK = "CALLSPG=LINK";
    public static final String CALLTYPE_CALL = "CALLTYPE=CALL";
    public static final String CALLTYPE_LINK = "CALLTYPE=LINK";
    public static final String CALLTYPE_CHNG = "CALLTYPE=CHNG";
    public static final String CALLTYPE_NTPR = "CALLTYPE=NTPR";
    public static final String CHANGE_YES = "CHANGE=YES";
    public static final String CHANGE_NO = "CHANGE=NO";
    public static final String CHECKSER_YES = "CHECKSER=YES";
    public static final String CHECKSER_NO = "CHECKSER=NO";
    public static final String CONNECT_YES = "CONNECT=YES";
    public static final String CONNECT_NO = "CONNECT=NO";
    public static final String CSSA_YES = "CSSA=YES";
    public static final String CURSUFF_YES = "CURSUFF=YES";
    public static final String CURSUFF_NO = "CURSUFF=NO";
    public static final String DATAERR = "DATAERR=01";
    public static final String DCPROC_YES = "DCPROC=YES";
    public static final String DFHAID_YES = "DFHAID=YES";
    public static final String DYNAM_YES = "DYNAM=YES";
    public static final String DYNPRT_YES = "DYNPRT=YES";
    public static final String ERRLAB_YES = "ERRLAB=YES";
    public static final String ERRLAB_NO = "ERRLAB=NO";
    public static final String ERRSERV = "ERRSERV=";
    public static final String F10_YES = "F10=YES";
    public static final String FOR_YES = "FOR=YES";
    public static final String FORMAT_EXTENDED = "FORMAT=EXTENDED";
    public static final String FORMAT_INTERNAL = "FORMAT=INTERNAL";
    public static final String HEXVAL_YES = "HEXVAL=YES";
    public static final String HLPI_YES = "HLPI=YES";
    public static final String HLPVAL_YES = "HLPVAL=YES";
    public static final String HPRT_YES = "HPRT=YES";
    public static final String IMSME_YES = "IMSME=YES";
    public static final String INDEXS_YES = "INDEXS=YES";
    public static final String INITSERV = "INITSERV=";
    public static final String LGCOMM = "LGCOMM=";
    public static final String LGCOMZS = "LGCOMZS=";
    public static final String LOCATION = "LOCATION=";
    public static final String LOCKMODE_NO = "LOCKMODE=NO";
    public static final String LOCKMODE_OPTIMIST = "LOCKMODE=OPTIMIST";
    public static final String LOCKMODE_PESSIMIST = "LOCKMODE=PESSIMIST";
    public static final String LOGMES_YES = "LOGMES=YES";
    public static final String LPA_YES = "LPA=YES";
    public static final String LPAGE_YES = "LPAGE=YES";
    public static final String LTHENATT = "LTHENATT=";
    public static final String LTHREPET = "LTHREPET=";
    public static final String LTHSCREEN = "LTHSCREEN=";
    public static final String MOFF_YES = "MOFF=YES";
    public static final String MONIT_YES = "MONIT=YES";
    public static final String MONITOFF_YES = "MONITOFF=YES";
    public static final String MONSER = "MONSER=";
    public static final String NOATTR_YES = "NOATTR=YES";
    public static final String NOLOCK_YES = "NOLOCK=YES";
    public static final String NOMAP_NO = "NOMAP=NO";
    public static final String NOMAP_YES = "NOMAP=YES";
    public static final String NOOCF_YES = "NOOCF=YES";
    public static final String NOOPEN_YES = "NOOPEN=YES";
    public static final String NOPSB_YES = "NOPSB=YES";
    public static final String NORPT_YES = "NORPT=YES";
    public static final String NOSAV_YES = "NOSAV=YES";
    public static final String NOSDERR_YES = "NOSDERR=YES";
    public static final String NOTRAC_YES = "NOTRAC=YES";
    public static final String NULLMNGT_YES = "NULLMNGT=YES";
    public static final String NULLMNGT_NO = "NULLMNGT=NO";
    public static final String OCF_YES = "OCF=YES";
    public static final String OFF_YES = "OFF=YES";
    public static final String ON_YES = "ON=YES";
    public static final String PACSQL_YES = "PACSQL=YES";
    public static final String PACTABLE = "PACTABLE=";
    public static final String PAGEMODE_EXTEND = "PAGEMODE=EXTEND";
    public static final String PAGEMODE_NOEXTEND = "PAGEMODE=NOEXTEND";
    public static final String PSBINIT_YES = "PSBINIT=YES";
    public static final String REF_YES = "REF=YES";
    public static final String REFER_YES = "REFER=YES";
    public static final String REPET_YES = "REPET=YES";
    public static final String RPT_YES = "RPT=YES";
    public static final String SEGMBUFF = "SEGMBUFF=";
    public static final String SERVBUFF = "SERVBUFF=";
    public static final String SQA_YES = "SQA=YES";
    public static final String SQC_YES = "SQC=YES";
    public static final String SQI_YES = "SQI=YES";
    public static final String SQLALL_YES = "SQLALL=YES";
    public static final String SQLCA_YES = "SQLCA=YES";
    public static final String SQLIND_YES = "SQLIND=YES";
    public static final String SQLREF_YES = "SQLREF=YES";
    public static final String SQR_YES = "SQR=YES";
    public static final String SRVMGR_YES = "SRVMGR=YES";
    public static final String SRVMGR_NO = "SRVMGR=NO";
    public static final String SSMON_YES = "SSMON=YES";
    public static final String SWAP_YES = "SWAP=YES";
    public static final String TERMSERV = "TERMSERV=";
    public static final String TMF_YES = "TMF=YES";
    public static final String TRAN_YES = "TRAN=YES";
    public static final String TRAN_NO = "TRAN=NO";
    public static final String TS_YES = "TS=YES";
    public static final String TZVAR_YES = "TZVAR=YES";
    public static final String VECTPRES_YES = "VECTPRES=YES";
    public static final String VECTPRES_NO = "VECTPRES=NO";
    public static final String WAITINT = "WAITINT=";
    public static final String WORKFILB = "WORKFILB=";
    public static final String WORKFILS = "WORKFILS=";
    public static final String WORKFILO_V = "WORKFILO=V";
    public static final String WORKFILO_H = "WORKFILO=H";
    public static final String WORKFILO_W = "WORKFILO=W";
    public static final String ZNUM_YES = "ZNUM=YES";
    public static final String DATPRO = "DATPRO=";
    public static final String MULTIROW = "MULTIROW=";
    public static final String SUBPRO = "SUBPRO=YES";
    public static final String[] lsUnisys2200Options = new String[]{"ATTRE=YES", "ATTRIB=YES", "NOSDERR=YES"};
    public static final String[] lsCicsOptions = new String[]{"ATTRIB=YES", "DFHAID=YES", "MONIT=YES", "PSBINIT=YES", "TS=YES"};
    public static final String[] lsUnisysAOptions = new String[]{"HEXVAL=YES", "MONIT=YES"};
    public static final String[] lsImsOptions = new String[]{"IMSME=YES", "MOFF=YES", "MONITOFF=YES", "NOTRAC=YES", "SWAP=YES"};
    public static final String[] lsDecOptions = new String[]{"NOOPEN=YES", "NOSAV=YES"};
    public static final String[] lsMicrofocusOptions = new String[]{"NOOPEN=YES", "NOSAV=YES"};
    public static final String[] lsGcos7Options = new String[]{"NOSAV=YES"};
    public static final String[] lsTuxedo = new String[]{"CHANGE=NO", "CHANGE=YES", "TRAN=NO", "TRAN=YES"};
    public static final String[] lsCallCics = new String[]{"CALLTYPE=CALL", "CALLTYPE=LINK"};
    public static final String[] lsCallIMS = new String[]{"CALLTYPE=CALL", "CALLTYPE=CHNG"};
    public static final String[] lsCallGcos7 = new String[]{"CALLTYPE=CALL", "CALLTYPE=NTPR"};
    public static final String[] lsCallGcos8 = new String[]{"CALLTYPE=CALL", "CALLTYPE=NTPR", "CALLTYPE=LINK"};
    public static final String[] lsScrCommonOptions = new String[]{"BREAKDATE=YES", "BREAKDATE=NO", "DCPROC=YES", "DYNAM=YES", "DYNPRT=YES", "F10=YES", "FOR=YES", "HLPI=YES", "HLPVAL=YES", "HPRT=YES", "INDEXS=YES", "LPA=YES", "LPAGE=YES", "NOMAP=YES", "NOMAP=NO", "NOOCF=YES", "NOPSB=YES", "NORPT=YES", "OCF=YES", "OFF=YES", "ON=YES", "PACSQL=YES", "REF=YES", "REFER=YES", "REPET=YES", "RPT=YES", "SQA=YES", "SQLALL=YES", "SQC=YES", "SQLCA=YES", "SQI=YES", "SQLIND=YES", "SQR=YES", "SQLREF=YES", "SSMON=YES", "TMF=YES"};
    public static final String[] lsCliCommonOptions = new String[]{"BREAKDATE=YES", "BREAKDATE=NO", "FORMAT=INTERNAL", "FORMAT=EXTENDED", "INITSERV=", "LTHENATT=", "LTHREPET=", "LTHSCREEN=", "NOMAP=NO", "NOMAP=YES"};
    public static final String[] lsCliSrvMonitOptions = new String[]{"CALLSPG=CALL", "CALLSPG=LINK", "LGCOMZS="};
    public static final String[] lsSrvCommonOptions = new String[]{"BREAKDATE=YES", "BREAKDATE=NO", "ACCESERR=", "FORMAT=EXTENDED", "CHECKSER=NO", "CHECKSER=YES", "CONNECT=NO", "CONNECT=YES", "CURSUFF=NO", "CURSUFF=YES", "DATAERR=01", "INITSERV=", "LGCOMM=", "LOCATION=", "MONSER=", "NULLMNGT=NO", "NULLMNGT=YES", "SERVBUFF=", "VECTPRES=NO", "VECTPRES=YES"};
    public static final String[] lsSrvMonoViewOptions = new String[]{"ERRLAB=NO", "ERRLAB=YES", "ERRSERV=", "LOCKMODE=NO", "LOCKMODE=OPTIMIST", "LOCKMODE=PESSIMIST", "PAGEMODE=EXTEND", "PAGEMODE=NOEXTEND", "SRVMGR=NO", "SRVMGR=YES"};
    public static final String[] lsSrvITOptions = new String[]{"ACCESERR=", "DATAERR=01"};
    public static final String[] lsCommMonCommonOptions = new String[]{"BREAKDATE=YES", "BREAKDATE=NO", "BASE=", "BASELOC=LOCAL", "BASELOC=REMOTE", "SERVBUFF=", "WAITINT=", "WORKFILB=", "WORKFILS=", "WORKFILO=H", "WORKFILO=V", "WORKFILO=W"};
    public static final String[] lsFolderCommonOptions = new String[]{"BREAKDATE=YES", "BREAKDATE=NO", "ERRLAB=NO", "ERRLAB=YES", "INITSERV=", "LOCATION=", "NULLMNGT=NO", "NULLMNGT=YES"};
    public static final String[] lsProgramOptions = new String[]{"BREAKDATE=YES", "BREAKDATE=NO", "DATPRO=", "MULTIROW=", "SUBPRO=YES"};

    public static List<Object> buildList(RadicalEntity radicalEntity, String variante) {
        int i;
        ArrayList<String> liste = new ArrayList<String>();
        if (radicalEntity instanceof PacAbstractDialog) {
            PacAbstractDialog pad = (PacAbstractDialog)radicalEntity;
            if (pad instanceof PacDialog && !PacOptions.isClient((PacDialog)pad) || pad instanceof PacScreen && !PacOptions.isClient((PacScreen)pad)) {
                i = 0;
                while (i < lsScrCommonOptions.length) {
                    liste.add(lsScrCommonOptions[i]);
                    ++i;
                }
                if (pad instanceof PacDialog) {
                    liste.add(CSSA_YES);
                }
                if (PacOptions.isVarianteUnisys2200(variante)) {
                    liste.addAll(Arrays.asList(lsUnisys2200Options));
                }
                if (PacOptions.isVarianteCICS(variante)) {
                    liste.addAll(Arrays.asList(lsCicsOptions));
                }
                if (PacOptions.isVarianteUnisysA(variante)) {
                    liste.addAll(Arrays.asList(lsUnisysAOptions));
                }
                if (PacOptions.isVarianteIMS(variante)) {
                    liste.addAll(Arrays.asList(lsImsOptions));
                }
                if (PacOptions.isVarianteMicrofocus(variante)) {
                    liste.addAll(Arrays.asList(lsMicrofocusOptions));
                }
                if (PacOptions.isVarianteGCOS7(variante)) {
                    liste.addAll(Arrays.asList(lsGcos7Options));
                }
                if (variante.equals("I0")) {
                    liste.addAll(Arrays.asList(lsDecOptions));
                }
                if (variante.equals("XC") || variante.equals("30")) {
                    liste.add(LOGMES_YES);
                }
                if (variante.equals("O0")) {
                    liste.add(NOLOCK_YES);
                }
                if (variante.equals("KC")) {
                    liste.add(NOSAV_YES);
                }
                if (variante.equals("4C") || variante.equals("5C") || variante.equals("6C")) {
                    liste.add(TZVAR_YES);
                }
                if (variante.equals("40") || variante.equals("41") || variante.equals("4C") || variante.equals("50") || variante.equals("51") || variante.equals("5C") || variante.equals("60") || variante.equals("61") || variante.equals("6C")) {
                    liste.add(ZNUM_YES);
                }
            }
            if (pad instanceof PacDialog && PacOptions.isClient((PacDialog)pad) || pad instanceof PacScreen && PacOptions.isClient((PacScreen)pad)) {
                i = 0;
                while (i < lsCliCommonOptions.length) {
                    liste.add(lsCliCommonOptions[i]);
                    ++i;
                }
                if (PacOptions.isClientMonitor(pad)) {
                    liste.addAll(Arrays.asList(lsCliSrvMonitOptions));
                }
                if (PacOptions.isVarianteCICS(variante)) {
                    liste.addAll(Arrays.asList(lsCallCics));
                }
                if (PacOptions.isVarianteIMS(variante)) {
                    liste.addAll(Arrays.asList(lsCallIMS));
                }
                if (PacOptions.isVarianteGCOS7(variante)) {
                    liste.addAll(Arrays.asList(lsCallGcos7));
                }
                if (PacOptions.isVarianteGCOS8(variante)) {
                    liste.addAll(Arrays.asList(lsCallGcos8));
                }
                if (PacOptions.isVarianteMicrofocus(variante) || PacOptions.isVarianteTuxedo(variante)) {
                    liste.add(CALLTYPE_CALL);
                }
            }
        }
        if (radicalEntity instanceof PacAbstractDialogServer) {
            PacAbstractDialogServer padcs = (PacAbstractDialogServer)radicalEntity;
            if (!PacOptions.isServerIT(padcs)) {
                i = 0;
                while (i < lsSrvCommonOptions.length) {
                    liste.add(lsSrvCommonOptions[i]);
                    ++i;
                }
                if (PacOptions.isServerMonitor(padcs)) {
                    liste.addAll(Arrays.asList(lsCliSrvMonitOptions));
                }
                if (PacOptions.isVarianteTuxedo(variante)) {
                    liste.addAll(Arrays.asList(lsTuxedo));
                }
                if (PacOptions.isVarianteCICS(variante)) {
                    liste.add(PACTABLE);
                }
                if (padcs instanceof PacServer && ((Object)((Object)padcs.getDialogType())).equals((Object)PacDialogServerTypeValues._S_LITERAL)) {
                    liste.add(SEGMBUFF);
                }
                if (padcs instanceof PacServer && ((PacServer)padcs).getServerExternalName().trim().length() > 0) {
                    liste.addAll(Arrays.asList(lsSrvMonoViewOptions));
                }
                if (PacOptions.isVarianteCICS(variante)) {
                    liste.addAll(Arrays.asList(lsCallCics));
                }
                if (PacOptions.isVarianteIMS(variante)) {
                    liste.addAll(Arrays.asList(lsCallIMS));
                }
                if (PacOptions.isVarianteGCOS7(variante)) {
                    liste.addAll(Arrays.asList(lsCallGcos7));
                }
                if (PacOptions.isVarianteGCOS8(variante)) {
                    liste.addAll(Arrays.asList(lsCallGcos8));
                }
                if (PacOptions.isVarianteMicrofocus(variante) || PacOptions.isVarianteTuxedo(variante)) {
                    liste.add(CALLTYPE_CALL);
                }
            } else {
                i = 0;
                while (i < lsSrvITOptions.length) {
                    liste.add(lsSrvITOptions[i]);
                    ++i;
                }
                if (PacOptions.isVarianteTuxedo(variante)) {
                    liste.addAll(Arrays.asList(lsTuxedo));
                }
            }
        }
        if (radicalEntity instanceof PacAbstractDialogCommunicationMonitor) {
            int i2 = 0;
            while (i2 < lsCommMonCommonOptions.length) {
                liste.add(lsCommMonCommonOptions[i2]);
                ++i2;
            }
            if (PacOptions.isVarianteCICS(variante)) {
                liste.addAll(Arrays.asList(lsCallCics));
            }
            if (PacOptions.isVarianteIMS(variante)) {
                liste.addAll(Arrays.asList(lsCallIMS));
            }
            if (PacOptions.isVarianteGCOS7(variante)) {
                liste.addAll(Arrays.asList(lsCallGcos7));
            }
            if (PacOptions.isVarianteGCOS8(variante)) {
                liste.addAll(Arrays.asList(lsCallGcos8));
            }
            if (PacOptions.isVarianteMicrofocus(variante) || PacOptions.isVarianteTuxedo(variante) || variante.equals("F0")) {
                liste.add(CALLTYPE_CALL);
            }
        }
        if (radicalEntity instanceof PacAbstractDialogFolder) {
            int i3 = 0;
            while (i3 < lsFolderCommonOptions.length) {
                liste.add(lsFolderCommonOptions[i3]);
                ++i3;
            }
            if (PacOptions.isVarianteTuxedo(variante)) {
                liste.addAll(Arrays.asList(lsTuxedo));
            }
            if (PacOptions.isVarianteCICS(variante)) {
                liste.addAll(Arrays.asList(lsCallCics));
            }
            if (PacOptions.isVarianteIMS(variante)) {
                liste.addAll(Arrays.asList(lsCallIMS));
            }
            if (PacOptions.isVarianteGCOS7(variante)) {
                liste.addAll(Arrays.asList(lsCallGcos7));
            }
            if (PacOptions.isVarianteGCOS8(variante)) {
                liste.addAll(Arrays.asList(lsCallGcos8));
            }
            if (PacOptions.isVarianteMicrofocus(variante) || PacOptions.isVarianteTuxedo(variante)) {
                liste.add(CALLTYPE_CALL);
            }
        }
        if (radicalEntity instanceof PacProgram) {
            int i4 = 0;
            while (i4 < lsProgramOptions.length) {
                liste.add(lsProgramOptions[i4]);
                ++i4;
            }
        }
        Collections.sort(liste);
        ArrayList<Object> objects = new ArrayList<Object>();
        int j = 0;
        while (j < liste.size()) {
            objects.add(liste.get(j));
            ++j;
        }
        return objects;
    }

    private static boolean isServerIT(PacAbstractDialogServer pad) {
        if (((Object)((Object)pad.getDialogType())).equals((Object)PacDialogServerTypeValues._IT_LITERAL)) {
            return true;
        }
        return pad instanceof PacServer && ((Object)((Object)pad.getDialogType())).equals((Object)PacDialogServerTypeValues._INHERITED_LITERAL) && ((Object)((Object)((PacServer)pad).getDialog().getDialogType())).equals((Object)PacDialogServerTypeValues._IT_LITERAL);
    }

    private static boolean isClientMonitor(PacAbstractDialog pad) {
        if (((Object)((Object)pad.getDialogType())).equals((Object)PacDialogTypeValues._MC_LITERAL) || ((Object)((Object)pad.getDialogType())).equals((Object)PacDialogTypeValues._SC_LITERAL)) {
            return true;
        }
        return pad instanceof PacScreen && ((Object)((Object)pad.getDialogType())).equals((Object)PacDialogTypeValues._INHERITED_LITERAL) && (((Object)((Object)((PacScreen)pad).getDialog().getDialogType())).equals((Object)PacDialogTypeValues._MC_LITERAL) || ((Object)((Object)((PacScreen)pad).getDialog().getDialogType())).equals((Object)PacDialogTypeValues._SC_LITERAL));
    }

    private static boolean isServerMonitor(PacAbstractDialogServer pad) {
        if (((Object)((Object)pad.getDialogType())).equals((Object)PacDialogServerTypeValues._MS_LITERAL)) {
            return true;
        }
        return pad instanceof PacServer && ((Object)((Object)pad.getDialogType())).equals((Object)PacDialogServerTypeValues._INHERITED_LITERAL) && ((Object)((Object)((PacServer)pad).getDialog().getDialogType())).equals((Object)PacDialogServerTypeValues._MS_LITERAL);
    }

    private static boolean isVarianteUnisys2200(String var) {
        return var.equals("U0") || var.equals("UC");
    }

    private static boolean isVarianteTuxedo(String var) {
        return var.equals("R0") || var.equals("RC");
    }

    private static boolean isVarianteCICS(String var) {
        return var.equals("X0") || var.equals("X2") || var.equals("X5") || var.equals("XC");
    }

    private static boolean isVarianteGCOS7(String var) {
        return var.equals("40") || var.equals("41") || var.equals("4C") || var.equals("4F");
    }

    private static boolean isVarianteGCOS8(String var) {
        return var.equals("80") || var.equals("81") || var.equals("8C") || var.equals("8F");
    }

    private static boolean isVarianteIMS(String var) {
        return var.equals("X1") || var.equals("X3") || var.endsWith("X4");
    }

    private static boolean isVarianteMicrofocus(String var) {
        return var.equals("30") || var.equals("31") || var.equals("32") || var.equals("33");
    }

    private static boolean isVarianteUnisysA(String var) {
        return var.equals("80") || var.equals("81") || var.equals("8C");
    }

    public static boolean isClient(PacDialog dlg) {
        if (((Object)((Object)dlg.getDialogType())).equals((Object)PacDialogTypeValues._NONE_LITERAL)) {
            return false;
        }
        return !((Object)((Object)dlg.getDialogType())).equals((Object)PacDialogTypeValues._MW_LITERAL);
    }

    public static boolean isClient(PacScreen scr) {
        if (((Object)((Object)scr.getDialogType())).equals((Object)PacDialogTypeValues._NONE_LITERAL)) {
            return false;
        }
        if (((Object)((Object)scr.getDialogType())).equals((Object)PacDialogTypeValues._MW_LITERAL)) {
            return false;
        }
        if (((Object)((Object)scr.getDialogType())).equals((Object)PacDialogTypeValues._INHERITED_LITERAL) && ((Object)((Object)scr.getDialog().getDialogType())).equals((Object)PacDialogTypeValues._NONE_LITERAL)) {
            return false;
        }
        return !((Object)((Object)scr.getDialogType())).equals((Object)PacDialogTypeValues._INHERITED_LITERAL) || !((Object)((Object)scr.getDialog().getDialogType())).equals((Object)PacDialogTypeValues._MW_LITERAL);
    }
}

