/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.PacCobolRecordLevelValues;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacCopybookCobolLocationCodeValues;
import com.ibm.pdp.mdl.pacbase.PacCopybookGenerationTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCopybookPresIndicatorValues;
import com.ibm.pdp.mdl.pacbase.PacFormatTypeValues;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGenElemFromGuideInputAid;
import com.ibm.pdp.mdl.pacbase.PacGenElemFromVirtualInputAid;
import com.ibm.pdp.mdl.pacbase.PacGeneratedDescriptionTypeValues;
import com.ibm.pdp.mdl.pacbase.PacGenerationElementGuide;
import com.ibm.pdp.mdl.pacbase.PacGenerationElementVirtual;
import com.ibm.pdp.mdl.pacbase.PacInputAid;
import com.ibm.pdp.mdl.pacbase.PacInputAidCallTypeLineValues;
import com.ibm.pdp.mdl.pacbase.PacInputAidDescriptionLine;
import com.ibm.pdp.mdl.pacbase.PacInputAidDescriptionLineTypeValues;
import com.ibm.pdp.mdl.pacbase.PacInputAidGLine;
import com.ibm.pdp.mdl.pacbase.PacInputAidSymbolicValueLine;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.impl.PacbaseImplLabel;
import com.ibm.pdp.mdl.pacbase.util.PacInputAidCompletedDetail;
import com.ibm.pdp.mdl.pacbase.util.PacbaseLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PacInputAidCompletedDetailManager {
    public final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2013, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HashMap<String, PacInputAidSymbolicValueLine> hssb;

    public List<PacInputAidCompletedDetail> getIACLines(PacInputAidGLine gline, List<String> val) {
        ArrayList<PacInputAidCompletedDetail> lines = new ArrayList<PacInputAidCompletedDetail>();
        if (this.getHssb() == null) {
            this.hssb = new HashMap();
        } else {
            this.hssb.clear();
        }
        this.completehm(gline.getPacInputAid());
        Object listdata = new ArrayList();
        listdata = val == null || val.isEmpty() ? gline.getData() : val;
        this.createLines(lines, gline, (List<String>)listdata);
        return lines;
    }

    public List<PacInputAidCompletedDetail> getIACLines(PacGenElemFromVirtualInputAid gline, List<String> val) {
        ArrayList<PacInputAidCompletedDetail> lines = new ArrayList<PacInputAidCompletedDetail>();
        if (this.getHssb() == null) {
            this.hssb = new HashMap();
        } else {
            this.hssb.clear();
        }
        this.completehm(gline.getPacInputAid());
        Object listdata = new ArrayList();
        listdata = val == null ? gline.getData() : val;
        this.createLines(lines, gline, (List<String>)listdata);
        return lines;
    }

    public List<PacInputAidCompletedDetail> getIACLines(PacGenElemFromGuideInputAid gline, List<String> val) {
        ArrayList<PacInputAidCompletedDetail> lines = new ArrayList<PacInputAidCompletedDetail>();
        if (this.getHssb() == null) {
            this.hssb = new HashMap();
        } else {
            this.hssb.clear();
        }
        this.completehm(gline.getPacInputAid());
        Object listdata = new ArrayList();
        listdata = val == null ? gline.getData() : val;
        this.createLines(lines, gline, (List<String>)listdata);
        return lines;
    }

    private void createLines(List<PacInputAidCompletedDetail> lines, PacInputAidGLine gline, List<String> listdata) {
        if (gline.getPacInputAid() == null) {
            return;
        }
        Iterator it = gline.getPacInputAid().getDescriptionLines().iterator();
        int i = 0;
        String data = null;
        while (it.hasNext()) {
            PacInputAidDescriptionLine dline = (PacInputAidDescriptionLine)it.next();
            if (i < listdata.size()) {
                data = listdata.get(i);
            }
            PacInputAidCompletedDetail pacIac = this.createIac(dline);
            if (((Object)((Object)dline.getLineType())).equals((Object)PacInputAidDescriptionLineTypeValues._C_LITERAL)) {
                this.createCommentLines(pacIac, dline);
            } else {
                if (data != null) {
                    this.createVariableLines(pacIac, dline, data);
                }
                ++i;
            }
            pacIac.setIagline(gline);
            lines.add(pacIac);
        }
    }

    private void createLines(List<PacInputAidCompletedDetail> lines, PacInputAidGLine gline, List<String> listdata, PacInputAid pia) {
        Iterator it = pia.getDescriptionLines().iterator();
        int i = 0;
        String data = null;
        while (it.hasNext()) {
            PacInputAidDescriptionLine dline = (PacInputAidDescriptionLine)it.next();
            if (i < listdata.size()) {
                data = listdata.get(i);
            }
            PacInputAidCompletedDetail pacIac = this.createIac(dline);
            if (((Object)((Object)dline.getLineType())).equals((Object)PacInputAidDescriptionLineTypeValues._C_LITERAL)) {
                this.createCommentLines(pacIac, dline);
            } else {
                if (data != null) {
                    this.createVariableLines(pacIac, dline, data);
                }
                ++i;
            }
            pacIac.setIagline(gline);
            lines.add(pacIac);
        }
    }

    private void createLines(List<PacInputAidCompletedDetail> lines, PacGenElemFromGuideInputAid gline, List<String> listdata) {
        Iterator it = gline.getPacInputAid().getDescriptionLines().iterator();
        int i = 0;
        String data = null;
        while (it.hasNext()) {
            PacInputAidDescriptionLine dline = (PacInputAidDescriptionLine)it.next();
            if (i < listdata.size()) {
                data = listdata.get(i);
            }
            PacInputAidCompletedDetail pacIac = this.createIac(dline);
            if (((Object)((Object)dline.getLineType())).equals((Object)PacInputAidDescriptionLineTypeValues._C_LITERAL)) {
                this.createCommentLines(pacIac, dline);
            } else {
                this.createVariableLines(pacIac, dline, data);
                ++i;
            }
            pacIac.setIaggline(gline);
            lines.add(pacIac);
        }
    }

    private void createLines(List<PacInputAidCompletedDetail> lines, PacGenElemFromVirtualInputAid gline, List<String> listdata) {
        Iterator it = gline.getPacInputAid().getDescriptionLines().iterator();
        int i = 0;
        String data = null;
        while (it.hasNext()) {
            PacInputAidDescriptionLine dline = (PacInputAidDescriptionLine)it.next();
            if (i < listdata.size()) {
                data = listdata.get(i);
            }
            PacInputAidCompletedDetail pacIac = this.createIac(dline);
            if (((Object)((Object)dline.getLineType())).equals((Object)PacInputAidDescriptionLineTypeValues._C_LITERAL)) {
                this.createCommentLines(pacIac, dline);
            } else {
                this.createVariableLines(pacIac, dline, data);
                ++i;
            }
            pacIac.setIagvline(gline);
            lines.add(pacIac);
        }
    }

    private void createVariableLines(PacInputAidCompletedDetail iac, PacInputAidDescriptionLine dline, String data) {
        if (data.trim().length() > 0) {
            if (data.length() >= 1 && data.length() < 4 && data.startsWith("$")) {
                iac.setVariableLabel("");
                iac.setSymbolicValue(this.getSymbolicValueFor(data));
            } else {
                iac.setSymbolicValue(null);
                iac.setVariableLabel(data);
            }
        } else if (dline.getSymbolicParameter().trim().length() > 0) {
            iac.setSymbolicValue(this.getSymbolicValueFor(data));
            iac.setVariableLabel("");
        } else {
            iac.setVariableLabel("");
            iac.setSymbolicValue(null);
        }
    }

    private void createCommentLines(PacInputAidCompletedDetail iac, PacInputAidDescriptionLine dline) {
        if (dline.getSymbolicParameter().trim().length() > 0) {
            iac.setSymbolicValue(this.getSymbolicValueFor(dline.getSymbolicParameter().trim()));
            iac.setVariableLabel("");
        } else {
            iac.setVariableLabel(dline.getVariableLabel());
            iac.setSymbolicValue(null);
        }
    }

    private PacInputAidCompletedDetail createIac(PacInputAidDescriptionLine dline) {
        PacInputAidCompletedDetail iac = new PacInputAidCompletedDetail();
        iac.setTypeLine(dline.getCallTypeLine());
        iac.setFixedLabel(dline.getFixedLabel());
        iac.setTypeDescriptionLine(dline.getLineType());
        iac.setLength(dline.getLength());
        return iac;
    }

    private void completehm(PacInputAid pacInputAid) {
        if (pacInputAid == null) {
            return;
        }
        if (!pacInputAid.getSymbolicValueLines().isEmpty()) {
            for (PacInputAidSymbolicValueLine line : pacInputAid.getSymbolicValueLines()) {
                this.getHssb().put(line.getParameter(), line);
            }
        }
    }

    public PacInputAidSymbolicValueLine getSymbolicValueFor(String data) {
        if (this.getHssb() != null) {
            return this.getHssb().get(data);
        }
        return null;
    }

    public String checkLengthValidity(PacInputAidCompletedDetail detail) {
        String message = "";
        if (!((Object)((Object)detail.getTypeDescriptionLine())).equals((Object)PacInputAidDescriptionLineTypeValues._C_LITERAL) && detail.getVariableLabel() != null && detail.getVariableLabel().length() > detail.getLength() && detail.getSymbolicValue() == null) {
            Object[] array = new String[]{detail.getVariableLabel()};
            message = PacbaseLabel.getString(PacbaseLabel._GLINE_IACALL_LABEL_LENGTH, array);
        }
        return message;
    }

    public List<AsGLine> getAsGLineList(PacInputAidGLine gline, boolean withValueOnly) {
        List<PacInputAidCompletedDetail> iaclines = this.getIACLines(gline, null);
        return this.createAsGlineList(iaclines, withValueOnly);
    }

    public List<AsGLine> getAsGLineList(PacGenElemFromVirtualInputAid gline, boolean withValueOnly) {
        List<PacInputAidCompletedDetail> iaclines = this.getIACLines(gline, null);
        return this.createAsGlineList(iaclines, withValueOnly);
    }

    public List<AsGLine> getAsGLineList(PacGenElemFromGuideInputAid gline, boolean withValueOnly) {
        List<PacInputAidCompletedDetail> iaclines = this.getIACLines(gline, null);
        return this.createAsGlineList(iaclines, withValueOnly);
    }

    public List<AsGLine> formatGLine(PacGLine gline) {
        List<AsGLine> list = new ArrayList<AsGLine>();
        if (gline instanceof PacInputAidGLine) {
            if (!((PacInputAidGLine)gline).getData().isEmpty()) {
                list = this.getAsGLineList((PacInputAidGLine)gline, true);
            }
        } else if (gline instanceof PacGenElemFromVirtualInputAid) {
            PacGenElemFromVirtualInputAid pbbgei = (PacGenElemFromVirtualInputAid)gline;
            if (!pbbgei.getData().isEmpty()) {
                list = this.getAsGLineList((PacGenElemFromVirtualInputAid)gline, true);
            }
        } else if (gline instanceof PacGenElemFromGuideInputAid) {
            PacGenElemFromGuideInputAid pbbgei = (PacGenElemFromGuideInputAid)gline;
            if (!pbbgei.getData().isEmpty()) {
                list = this.getAsGLineList((PacGenElemFromGuideInputAid)gline, true);
            }
        } else if (!(gline instanceof PacGenerationElementGuide) && !(gline instanceof PacGenerationElementVirtual)) {
            AsGLine line = new AsGLine(gline.getLineType());
            line.setDescription(gline.getDescription());
            list.add(line);
        }
        return list;
    }

    private List<AsGLine> createAsGlineList(List<PacInputAidCompletedDetail> iaclines, boolean withValueOnly) {
        ArrayList<AsGLine> lines = new ArrayList<AsGLine>();
        for (PacInputAidCompletedDetail dline : iaclines) {
            String type = "";
            type = ((Object)((Object)dline.getTypeLine())).equals((Object)PacInputAidCallTypeLineValues._NONE_LITERAL) ? " " : dline.getTypeLine().getLiteral().substring(1);
            AsGLine asgl = new AsGLine(type);
            StringBuffer sb = new StringBuffer();
            boolean isValueExist = false;
            String fixedLabel20 = dline.getFixedLabel();
            if (fixedLabel20.length() < 20) {
                fixedLabel20 = this.addBlanc(fixedLabel20, 20);
            }
            sb.append(fixedLabel20);
            if (dline.getSymbolicValue() == null) {
                if (!withValueOnly || dline.getLength() == 0 || dline.getVariableLabel() != null && dline.getVariableLabel().trim().length() > 0) {
                    sb.append(dline.getVariableLabel());
                    isValueExist = true;
                }
            } else if (!withValueOnly || dline.getLength() == 0 || dline.getSymbolicValue() != null) {
                sb.append(dline.getSymbolicValue().getValue());
                isValueExist = true;
            }
            if (withValueOnly && sb.toString().trim().length() == 0) {
                isValueExist = false;
            }
            if (withValueOnly && !isValueExist) continue;
            asgl.setDescription(sb.toString());
            lines.add(asgl);
        }
        return lines;
    }

    private String addBlanc(String initialZone, int finalLength) {
        String finalZone = initialZone;
        int newLengthfinalZone = initialZone.length();
        while (newLengthfinalZone < finalLength) {
            finalZone = finalZone.concat(" ");
            newLengthfinalZone = finalZone.length();
        }
        return finalZone;
    }

    public List<String> checkDATAValidity(List<PacInputAidCompletedDetail> lsdetail, PacCopybook cp, List<String> listSeg) {
        ArrayList<String> lsMessage = new ArrayList<String>();
        String message = "";
        String parameter = "";
        Object[] array = new String[]{"DATA"};
        if (lsdetail.get(2) != null) {
            parameter = this.prmCalc(lsdetail.get(2));
            if (parameter.trim().length() > 0) {
                message = this.checkEmplacementDesc(parameter, (String[])array);
            }
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(3) != null) {
            parameter = this.prmCalc(lsdetail.get(3));
            message = this.checkVariant(parameter, (String[])array);
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(4) != null) {
            parameter = this.prmCalc(lsdetail.get(4));
            message = this.checkFormatType(parameter, (String[])array);
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(5) != null) {
            parameter = this.prmCalc(lsdetail.get(5));
            message = this.checkDescriptionType(parameter, (String[])array);
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(6) != null) {
            parameter = this.prmCalc(lsdetail.get(6));
            if (parameter.trim().length() > 0) {
                message = this.checkDescrLevel(parameter, (String[])array);
            }
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(8) != null) {
            parameter = this.prmCalc(lsdetail.get(8));
            if (parameter.length() > 0) {
                message = this.checkSelectedSegment(parameter, cp, listSeg, (String[])array);
            }
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        return lsMessage;
    }

    public boolean findPIACall(List<PacInputAidCompletedDetail> lsdetail, PacCopybook cp) {
        String message = "";
        String parameter = "";
        if (lsdetail.get(1) != null) {
            parameter = this.prmCalc(lsdetail.get(1));
            message = this.checkExternalName(parameter, cp);
            return message.length() <= 0;
        }
        return false;
    }

    private String checkVariant(String parameter, String[] array) {
        if (!(parameter.equals(PacProgramVariantValues._X_LITERAL.getLiteral().substring(1)) || parameter.equals(PacProgramVariantValues._3_LITERAL.getLiteral().substring(1)) || parameter.equals(PacProgramVariantValues._4_LITERAL.getLiteral().substring(1)) || parameter.equals(PacProgramVariantValues._Q_LITERAL.getLiteral().substring(1)) || parameter.equals(PacProgramVariantValues._N_LITERAL.getLiteral().substring(1)))) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGVARIANT, array);
        }
        return "";
    }

    private String prmCalc(PacInputAidCompletedDetail pacInputAidCompletedDetail) {
        if (pacInputAidCompletedDetail.getSymbolicValue() == null) {
            return this.trimRight(pacInputAidCompletedDetail.getVariableLabel()).toUpperCase();
        }
        return this.trimRight(pacInputAidCompletedDetail.getSymbolicValue().getParameter().toUpperCase());
    }

    public String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    private String checkSelectedSegment(String parameter, PacCopybook cp, List<String> listSeg, String[] array) {
        if (parameter.length() % 2 != 0) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGSELECTEDSEGMENT, array);
        }
        int i = 0;
        boolean allFound = true;
        while (i + 2 <= parameter.length()) {
            String segmentCode = String.valueOf(cp.getDataStructure().getName()) + parameter.substring(i, i + 2);
            boolean found = this.ifFound(listSeg, segmentCode);
            if (!found) {
                allFound = false;
            }
            i += 2;
        }
        if (!allFound) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGSELECTEDSEGMENT, array);
        }
        return "";
    }

    private boolean ifFound(List<String> listSeg, String segmentCode) {
        boolean isfound = false;
        int j = 0;
        while (j < listSeg.size()) {
            if (segmentCode.equals(listSeg.get(j))) {
                isfound = true;
                break;
            }
            ++j;
        }
        return isfound;
    }

    private String checkDescrLevel(String parameter, String[] array) {
        if (!(parameter.equals(PacCobolRecordLevelValues._1_LITERAL.getLiteral().substring(1)) || parameter.equals(PacCobolRecordLevelValues._2_LITERAL.getLiteral().substring(1)) || parameter.equals(PacCobolRecordLevelValues._3_LITERAL.getLiteral().substring(1)))) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGLEVEL, array);
        }
        return "";
    }

    private String checkDescriptionType(String parameter, String[] array) {
        if (!(parameter.equals(PacGeneratedDescriptionTypeValues._1_LITERAL.getLiteral().substring(1)) || parameter.equals(PacGeneratedDescriptionTypeValues._2_LITERAL.getLiteral().substring(1)) || parameter.equals(PacGeneratedDescriptionTypeValues._3_LITERAL.getLiteral().substring(1)) || parameter.equals(PacGeneratedDescriptionTypeValues._4_LITERAL.getLiteral().substring(1)) || parameter.startsWith(PacGeneratedDescriptionTypeValues._NONE_LITERAL.getLiteral().substring(1)) || parameter.trim().length() == 0)) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGDESCRTYPE, array);
        }
        return "";
    }

    private String checkFormatType(String parameter, String[] array) {
        if (!(parameter.equals(PacFormatTypeValues._E_LITERAL.getLiteral().substring(1)) || parameter.equals(PacFormatTypeValues._I_LITERAL.getLiteral().substring(1)) || parameter.equals(PacFormatTypeValues._S_LITERAL.getLiteral().substring(1)))) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGFORMATTYPE, array);
        }
        return "";
    }

    private String checkEmplacementDesc(String parameter, String[] array) {
        if (!parameter.equals(PacCopybookCobolLocationCodeValues._W_LITERAL.getLiteral().substring(1)) && !parameter.equals(PacCopybookCobolLocationCodeValues._F_LITERAL.getLiteral().substring(1))) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGEMPLDESC, array);
        }
        return "";
    }

    private String checkExternalName(String parameter, PacCopybook cp) {
        Object[] array = new String[]{""};
        array = ((Object)((Object)cp.getGenerationType())).equals((Object)PacCopybookGenerationTypeValues._DSQC1_LITERAL) ? new String[]{"DATASQ"} : new String[]{"DATA"};
        if (!parameter.equalsIgnoreCase(cp.getName())) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGEXTNAME, array);
        }
        return "";
    }

    public List getIACLines(PacInputAidGLine gline, List<String> val, PacInputAid resolvedPIA) {
        ArrayList<PacInputAidCompletedDetail> lines = new ArrayList<PacInputAidCompletedDetail>();
        if (this.getHssb() == null) {
            this.hssb = new HashMap();
        } else {
            this.hssb.clear();
        }
        this.completehm(gline.getPacInputAid());
        Object listdata = new ArrayList();
        listdata = val == null || val.isEmpty() ? gline.getData() : val;
        this.createLines(lines, gline, (List<String>)listdata, resolvedPIA);
        return lines;
    }

    public List getAsGLineList(PacInputAidGLine gline, boolean withValueOnly, PacInputAid resolvedpia) {
        List iaclines = this.getIACLines(gline, null, resolvedpia);
        return this.createAsGlineList(iaclines, withValueOnly);
    }

    public List<String> checkDATASQValidity(List<PacInputAidCompletedDetail> lsdetail, PacCopybook cp, List<String> listSeg) {
        ArrayList<String> lsMessage = new ArrayList<String>();
        String message = "";
        String parameter = "";
        Object[] array = new String[]{"DATASQ"};
        if (lsdetail.get(2) != null) {
            parameter = this.prmCalc(lsdetail.get(2));
            if (parameter.trim().length() > 6) {
                message = PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGDBD, array);
            }
            if (parameter.trim().length() == 0) {
                lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_DBDMISSING, array));
            }
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(3) != null) {
            parameter = this.prmCalc(lsdetail.get(3));
            message = this.checkVariant(parameter, (String[])array);
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(4) != null) {
            parameter = this.prmCalc(lsdetail.get(4));
            message = this.checkPresenceIndicator(parameter, (String[])array);
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        if (lsdetail.get(6) != null) {
            parameter = this.prmCalc(lsdetail.get(6));
            if (parameter.length() > 0) {
                message = this.checkSelectedSegment(parameter, cp, listSeg, (String[])array);
            }
            if (message.length() > 0) {
                lsMessage.add(message);
            }
        } else {
            lsMessage.add(PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_PRMMISSING, array));
        }
        return lsMessage;
    }

    private String checkPresenceIndicator(String parameter, String[] array) {
        if (!parameter.equals(PacCopybookPresIndicatorValues._N_LITERAL.getLiteral().substring(1)) && !parameter.equals(PacCopybookPresIndicatorValues._Y_LITERAL.getLiteral().substring(1))) {
            return PacbaseImplLabel.getString(PacbaseImplLabel.PacCopyBookImpl_PIADATA_WRONGPRESIND, array);
        }
        return "";
    }

    public HashMap<String, PacInputAidSymbolicValueLine> getHssb() {
        return this.hssb;
    }

    public void setHssb(HashMap<String, PacInputAidSymbolicValueLine> hssb) {
        this.hssb = hssb;
    }

    public PacInputAidSymbolicValueLine getSymbolicValueFor(PacInputAidCompletedDetail newPiacd, String valueS) {
        PacInputAid pia = null;
        if (newPiacd.getIagline() != null) {
            pia = newPiacd.getIagline().getPacInputAid();
        }
        if (newPiacd.getIaggline() != null) {
            pia = newPiacd.getIaggline().getPacInputAid();
        }
        if (newPiacd.getIagvline() != null) {
            pia = newPiacd.getIagvline().getPacInputAid();
        }
        for (PacInputAidSymbolicValueLine line : pia.getSymbolicValueLines()) {
            if (!line.getParameter().equals(valueS)) continue;
            return line;
        }
        return null;
    }

    public static class AsGLine {
        private String type;
        private String description;

        public AsGLine(String type) {
            this.setType(type);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

