/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacBlockBaseTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCobolTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacMapTypeValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.util.PacBlockBaseValidityType;
import com.ibm.pdp.mdl.pacbase.util.PacScreenValidityVariant;
import com.ibm.pdp.mdl.pacbase.util.PacbaseLabel;
import java.util.ArrayList;

public class PacGenerationValidityChecking {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static ArrayList<PacScreenValidityVariant> lsOKStandard = new ArrayList();
    static String type = "";
    static final String ST = "STANDARD";
    static final String CL = "CLIENT";
    static final String SR = "SERVER";
    static final String EB = "SERVEREB";
    static ArrayList<PacScreenValidityVariant> lsStOK = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsStDEP = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsStNA = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsClOK = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsClDEP = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsClNA = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsSrOK = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsSrDEP = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsSrNA = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsSrEBOK = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsSrEBDEP = new ArrayList();
    static ArrayList<PacScreenValidityVariant> lsSrEBNA = new ArrayList();

    static void getVariantOK(String dialogType) {
        PacGenerationValidityChecking.getType(dialogType);
        for (PacScreenValidityVariant vv : PacScreenValidityVariant.lsVar) {
            if (!type.equals(ST)) continue;
            if (vv.getStandardValidity().equals((Object)PacScreenValidityVariant.ValidityType.OK)) {
                lsStOK.add(vv);
                continue;
            }
            if (type.equals(CL)) {
                if (!vv.getClientValidity().equals((Object)PacScreenValidityVariant.ValidityType.OK)) continue;
                lsClOK.add(vv);
                continue;
            }
            if (type.equals(SR)) {
                if (!vv.getServerValidity().equals((Object)PacScreenValidityVariant.ValidityType.OK)) continue;
                lsSrOK.add(vv);
                continue;
            }
            if (!type.equals(EB) || !vv.getServerValidity().equals((Object)PacScreenValidityVariant.ValidityType.OK)) continue;
            lsSrEBOK.add(vv);
        }
    }

    static void getVariantDEP(String dialogType) {
        PacGenerationValidityChecking.getType(dialogType);
        for (PacScreenValidityVariant vv : PacScreenValidityVariant.lsVar) {
            if (!type.equals(ST)) continue;
            if (vv.getStandardValidity().equals((Object)PacScreenValidityVariant.ValidityType.DEP)) {
                lsStDEP.add(vv);
                continue;
            }
            if (type.equals(CL)) {
                if (!vv.getClientValidity().equals((Object)PacScreenValidityVariant.ValidityType.DEP)) continue;
                lsClDEP.add(vv);
                continue;
            }
            if (type.equals(SR)) {
                if (!vv.getServerValidity().equals((Object)PacScreenValidityVariant.ValidityType.DEP)) continue;
                lsSrDEP.add(vv);
                continue;
            }
            if (!type.equals(EB) || !vv.getServerValidity().equals((Object)PacScreenValidityVariant.ValidityType.DEP)) continue;
            lsSrEBDEP.add(vv);
        }
    }

    static void getVariantNA(String dialogType) {
        PacGenerationValidityChecking.getType(dialogType);
        for (PacScreenValidityVariant vv : PacScreenValidityVariant.lsVar) {
            if (!type.equals(ST)) continue;
            if (vv.getStandardValidity().equals((Object)PacScreenValidityVariant.ValidityType.NA)) {
                lsStNA.add(vv);
                continue;
            }
            if (type.equals(CL)) {
                if (!vv.getClientValidity().equals((Object)PacScreenValidityVariant.ValidityType.NA)) continue;
                lsClNA.add(vv);
                continue;
            }
            if (type.equals(SR)) {
                if (!vv.getServerValidity().equals((Object)PacScreenValidityVariant.ValidityType.NA)) continue;
                lsSrNA.add(vv);
                continue;
            }
            if (!type.equals(EB) || !vv.getServerValidity().equals((Object)PacScreenValidityVariant.ValidityType.NA)) continue;
            lsSrEBNA.add(vv);
        }
    }

    static String getType(String typeValue) {
        type = typeValue.equals(PacDialogTypeValues._NONE_LITERAL.getLiteral()) ? ST : (typeValue.equals(PacDialogTypeValues._C_LITERAL.getLiteral()) || typeValue.equals(PacDialogTypeValues._SC_LITERAL.getLiteral()) || typeValue.equals(PacDialogTypeValues._MC_LITERAL.getLiteral()) ? CL : (typeValue.equals(PacDialogServerTypeValues._IT_LITERAL.getLiteral()) ? EB : SR));
        return type;
    }

    static PacScreenValidityVariant.ValidityType getValidity(PacCobolTypeValues cobType, PacMapTypeValues mapType, String dialogType) {
        PacGenerationValidityChecking.getType(dialogType);
        for (PacScreenValidityVariant vv : PacScreenValidityVariant.lsVar) {
            if (!((Object)((Object)cobType)).equals((Object)vv.getCobolType()) || !((Object)((Object)mapType)).equals((Object)vv.getMapType())) continue;
            if (type.equals(ST)) {
                return vv.getStandardValidity();
            }
            if (type.equals(CL)) {
                return vv.getClientValidity();
            }
            if (type.equals(SR)) {
                return vv.getServerValidity();
            }
            if (!type.equals(EB)) continue;
            return vv.getServerEBValidity();
        }
        return PacScreenValidityVariant.ValidityType.NA;
    }

    public static String CheckProgramVariantValidity(PacProgram pacPgm) {
        String message = "";
        PacProgramVariantValues varPgm = pacPgm.getVariante();
        if (varPgm != PacProgramVariantValues._X_LITERAL && varPgm != PacProgramVariantValues._3_LITERAL && varPgm != PacProgramVariantValues._4_LITERAL && varPgm != PacProgramVariantValues._Q_LITERAL && varPgm != PacProgramVariantValues._Z_LITERAL && varPgm != PacProgramVariantValues._O_LITERAL && varPgm != PacProgramVariantValues._C_LITERAL) {
            message = varPgm == PacProgramVariantValues._N_LITERAL ? PacbaseLabel._PAC_NO_VARIANT : (varPgm == PacProgramVariantValues._0_LITERAL || varPgm == PacProgramVariantValues._1_LITERAL ? PacbaseLabel._PAC_DEPRECATED_VARIANT : PacbaseLabel._PAC_UNSUPPORTED_VARIANT);
        }
        return message;
    }

    public static String CheckScreenVariantValidity(PacAbstractDialog pacScreen, PacDialog dialog) {
        PacMapTypeValues mapType;
        new PacScreenValidityVariant();
        String message = "";
        PacCobolTypeValues cobType = pacScreen.getCobolType();
        if (cobType == PacCobolTypeValues._NONE_LITERAL && dialog != null) {
            cobType = dialog.getCobolType();
        }
        if ((mapType = pacScreen.getMapType()) == PacMapTypeValues._NONE_LITERAL && dialog != null) {
            mapType = dialog.getMapType();
        }
        if (((Object)((Object)cobType)).equals((Object)PacCobolTypeValues._NONE_LITERAL)) {
            mapType = PacMapTypeValues._NONE_LITERAL;
        }
        String dialogType = pacScreen.getDialogType().getLiteral();
        if (((Object)((Object)pacScreen.getDialogType())).equals((Object)PacDialogTypeValues._INHERITED_LITERAL)) {
            dialogType = dialog.getDialogType().getLiteral();
        }
        PacScreenValidityVariant.ValidityType valid = PacGenerationValidityChecking.getValidity(cobType, mapType, dialogType);
        message = PacGenerationValidityChecking.getMessage(valid);
        return message;
    }

    private static String getMessage(PacScreenValidityVariant.ValidityType valid) {
        String message = "";
        if (valid.equals((Object)PacScreenValidityVariant.ValidityType.DEP)) {
            message = PacbaseLabel._PAC_DEPRECATED_VARIANT;
        } else if (valid.equals((Object)PacScreenValidityVariant.ValidityType.NA)) {
            message = PacbaseLabel._PAC_UNSUPPORTED_VARIANT;
        } else if (valid.equals((Object)PacScreenValidityVariant.ValidityType.NO)) {
            message = PacbaseLabel._PAC_NO_VARIANT;
        }
        return message;
    }

    public static String checkServerTypeValidity(PacAbstractDialogServer pacServer, PacDialogServer dialog) {
        String message = "";
        PacDialogServerTypeValues typeValues = pacServer.getDialogType();
        if (typeValues == null) {
            message = PacbaseLabel._PAC_UNSUPPORTED_TYPE;
        }
        return message;
    }

    public static String checkBlockBaseTypeValidity(PacBlockBase blockBase) {
        String message = "";
        PacBlockBaseTypeValues typeValue = blockBase.getBlockType();
        if (typeValue == null) {
            message = PacbaseLabel._PAC_UNSUPPORTED_TYPE;
        } else {
            new PacBlockBaseValidityType();
            PacBlockBaseValidityType.ValidityBBType valid = PacGenerationValidityChecking.getValidityType(typeValue);
            message = PacGenerationValidityChecking.getMessageBBType(valid);
        }
        return message;
    }

    private static PacBlockBaseValidityType.ValidityBBType getValidityType(PacBlockBaseTypeValues typeValue) {
        for (PacBlockBaseValidityType vt : PacBlockBaseValidityType.lsVar) {
            if (!((Object)((Object)typeValue)).equals((Object)vt.getBlockBaseType())) continue;
            return vt.getStandardValidity();
        }
        return PacBlockBaseValidityType.ValidityBBType.NA;
    }

    static PacScreenValidityVariant.ValidityType getValidityType(PacCobolTypeValues cobType, PacMapTypeValues mapType, String dialogType) {
        PacGenerationValidityChecking.getType(dialogType);
        for (PacScreenValidityVariant vv : PacScreenValidityVariant.lsVar) {
            if (!((Object)((Object)cobType)).equals((Object)vv.getCobolType()) || !((Object)((Object)mapType)).equals((Object)vv.getMapType())) continue;
            if (type.equals(ST)) {
                return vv.getStandardValidity();
            }
            if (type.equals(CL)) {
                return vv.getClientValidity();
            }
            if (type.equals(SR)) {
                return vv.getServerValidity();
            }
            if (!type.equals(EB)) continue;
            return vv.getServerEBValidity();
        }
        return PacScreenValidityVariant.ValidityType.NA;
    }

    private static String getMessageBBType(PacBlockBaseValidityType.ValidityBBType valid) {
        String message = "";
        if (valid.equals((Object)PacBlockBaseValidityType.ValidityBBType.NA)) {
            message = PacbaseLabel._PAC_UNSUPPORTED_TYPE;
        }
        return message;
    }

    public static String CheckServerVariantValidity(PacAbstractDialogServer pacSrv, PacDialogServer dialogSrv) {
        PacMapTypeValues mapType;
        new PacScreenValidityVariant();
        String message = "";
        PacCobolTypeValues cobType = pacSrv.getCobolType();
        if (cobType == PacCobolTypeValues._NONE_LITERAL && dialogSrv != null) {
            cobType = dialogSrv.getCobolType();
        }
        if ((mapType = pacSrv.getMapType()) == PacMapTypeValues._NONE_LITERAL && dialogSrv != null) {
            mapType = dialogSrv.getMapType();
        }
        if (((Object)((Object)cobType)).equals((Object)PacCobolTypeValues._NONE_LITERAL)) {
            mapType = PacMapTypeValues._NONE_LITERAL;
        }
        String dialogType = pacSrv.getDialogType().getLiteral();
        if (((Object)((Object)pacSrv.getDialogType())).equals((Object)PacDialogServerTypeValues._INHERITED_LITERAL)) {
            dialogType = dialogSrv.getDialogType().getLiteral();
        }
        PacScreenValidityVariant.ValidityType valid = PacGenerationValidityChecking.getValidity(cobType, mapType, dialogType);
        message = PacGenerationValidityChecking.getMessage(valid);
        return message;
    }

    public static String CheckCommunicationMonitorVariantValidityCom(PacAbstractDialogCommunicationMonitor pacCommMon, PacDialogCommunicationMonitor dialogCommMon) {
        PacMapTypeValues mapType;
        new PacScreenValidityVariant();
        String message = "";
        PacCobolTypeValues cobType = pacCommMon.getCobolType();
        if (cobType == PacCobolTypeValues._NONE_LITERAL && dialogCommMon != null) {
            cobType = dialogCommMon.getCobolType();
        }
        if ((mapType = pacCommMon.getMapType()) == PacMapTypeValues._NONE_LITERAL && dialogCommMon != null) {
            mapType = dialogCommMon.getMapType();
        }
        if (((Object)((Object)cobType)).equals((Object)PacCobolTypeValues._NONE_LITERAL)) {
            mapType = PacMapTypeValues._NONE_LITERAL;
        }
        PacScreenValidityVariant.ValidityType valid = PacGenerationValidityChecking.getValidity(cobType, mapType, "EB");
        message = PacGenerationValidityChecking.getMessage(valid);
        return message;
    }

    public static String CheckFolderVariantValidity(PacAbstractDialogFolder pacFolder, PacDialogFolder dialogFolder) {
        PacMapTypeValues mapType;
        new PacScreenValidityVariant();
        String message = "";
        PacCobolTypeValues cobType = pacFolder.getCobolType();
        if (cobType == PacCobolTypeValues._NONE_LITERAL && dialogFolder != null) {
            cobType = dialogFolder.getCobolType();
        }
        if ((mapType = dialogFolder.getMapType()) == PacMapTypeValues._NONE_LITERAL && dialogFolder != null) {
            mapType = dialogFolder.getMapType();
        }
        if (((Object)((Object)cobType)).equals((Object)PacCobolTypeValues._NONE_LITERAL)) {
            mapType = PacMapTypeValues._NONE_LITERAL;
        }
        PacScreenValidityVariant.ValidityType valid = PacGenerationValidityChecking.getValidity(cobType, mapType, "EB");
        message = PacGenerationValidityChecking.getMessage(valid);
        return message;
    }

    public static String CheckProgramVariantValidity(PacCopybook re) {
        String message = "";
        PacProgramVariantValues varPgm = re.getCobolType();
        if (varPgm != PacProgramVariantValues._X_LITERAL && varPgm != PacProgramVariantValues._3_LITERAL && varPgm != PacProgramVariantValues._4_LITERAL && varPgm != PacProgramVariantValues._Q_LITERAL && varPgm != PacProgramVariantValues._Z_LITERAL && varPgm != PacProgramVariantValues._O_LITERAL && varPgm != PacProgramVariantValues._C_LITERAL) {
            message = varPgm == PacProgramVariantValues._N_LITERAL ? PacbaseLabel._PAC_NO_VARIANT : (varPgm == PacProgramVariantValues._0_LITERAL || varPgm == PacProgramVariantValues._1_LITERAL ? PacbaseLabel._PAC_DEPRECATED_VARIANT : PacbaseLabel._PAC_UNSUPPORTED_VARIANT);
        }
        return message;
    }

    public static String CheckCommunicationMonitorVariantValiditySrv(PacAbstractDialogCommunicationMonitor pacCommMon, PacDialogServer dialogServer) {
        PacMapTypeValues mapType;
        new PacScreenValidityVariant();
        String message = "";
        PacCobolTypeValues cobType = pacCommMon.getCobolType();
        if (cobType == PacCobolTypeValues._NONE_LITERAL && dialogServer != null) {
            cobType = dialogServer.getCobolType();
        }
        if ((mapType = pacCommMon.getMapType()) == PacMapTypeValues._NONE_LITERAL && dialogServer != null) {
            mapType = dialogServer.getMapType();
        }
        if (((Object)((Object)cobType)).equals((Object)PacCobolTypeValues._NONE_LITERAL)) {
            mapType = PacMapTypeValues._NONE_LITERAL;
        }
        PacScreenValidityVariant.ValidityType valid = PacGenerationValidityChecking.getValidity(cobType, mapType, "EB");
        message = PacGenerationValidityChecking.getMessage(valid);
        return message;
    }

    public static boolean isValidExternalName(String externalName) {
        String[] tableCaract = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"};
        int i = 0;
        while (i < tableCaract.length) {
            if (externalName.indexOf(tableCaract[i]) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

