/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.GenerationProject;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogFolderView;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;

public class PacGenerationTargetUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DEFAULT = "";

    public static String getLibraryFolderName(RadicalEntity re, PacLibrary pacLibrary, String patternName, int rank) {
        if (re == null || pacLibrary == null) {
            return null;
        }
        for (Object object : pacLibrary.getGenerationProjects()) {
            GenerationProject generationProject = (GenerationProject)object;
            if (rank != generationProject.getRank() || !patternName.equals(generationProject.getPattern()) || !re.eClass().getName().toLowerCase().equals(generationProject.getDesignType())) continue;
            String folderTmp = generationProject.getFolder();
            if (folderTmp != null) {
                return folderTmp.trim();
            }
            return DEFAULT;
        }
        return null;
    }

    public static String getLibraryProjectName(RadicalEntity re, PacLibrary pacLibrary, String patternName, int rank) {
        if (re == null || pacLibrary == null) {
            return null;
        }
        for (Object object : pacLibrary.getGenerationProjects()) {
            GenerationProject generationProject = (GenerationProject)object;
            if (rank != generationProject.getRank() || !patternName.equals(generationProject.getPattern()) || !re.eClass().getName().toLowerCase().equals(generationProject.getDesignType())) continue;
            String projectTmp = generationProject.getProject();
            if (projectTmp != null) {
                return projectTmp.trim();
            }
            return DEFAULT;
        }
        return null;
    }

    public static String getComputedDialogProjectName(RadicalEntity re) {
        String projectTmp;
        PacDialogFolderView dlg;
        if (re == null) {
            return null;
        }
        if (re instanceof PacScreen) {
            PacDialog dlg2 = ((PacScreen)re).getDialog();
            if (dlg2 != null) {
                String projectTmp2 = dlg2.getMapProject();
                if (projectTmp2 != null && !projectTmp2.equals(DEFAULT)) {
                    return projectTmp2;
                }
                projectTmp2 = dlg2.getCobolProject();
                if (projectTmp2 != null && !projectTmp2.equals(DEFAULT)) {
                    return projectTmp2;
                }
            }
        } else if (re instanceof PacServer) {
            String projectTmp3;
            PacDialogServer dlg3 = ((PacServer)re).getDialog();
            if (dlg3 != null && (projectTmp3 = dlg3.getCobolProject()) != null && !projectTmp3.equals(DEFAULT)) {
                return projectTmp3;
            }
        } else if (re instanceof PacCommunicationMonitor) {
            String projectTmp4;
            String projectTmp5;
            PacDialogServer dlg4 = ((PacCommunicationMonitor)re).getPacDialogServer();
            if (dlg4 != null && (projectTmp5 = dlg4.getCobolProject()) != null && !projectTmp5.equals(DEFAULT)) {
                return projectTmp5;
            }
            PacDialogCommunicationMonitor dlg1 = ((PacCommunicationMonitor)re).getPacDialogCommunicationMonitor();
            if (dlg1 != null && (projectTmp4 = dlg1.getCobolProject()) != null && !projectTmp4.equals(DEFAULT)) {
                return projectTmp4;
            }
        } else if (re instanceof PacFolder) {
            String projectTmp6;
            PacDialogFolder dlg5 = ((PacFolder)re).getPacDialogFolder();
            if (dlg5 != null && (projectTmp6 = dlg5.getCobolProject()) != null && !projectTmp6.equals(DEFAULT)) {
                return projectTmp6;
            }
        } else if (re instanceof PacFolderView && (dlg = ((PacFolderView)re).getPacDialogFolderView()) != null && (projectTmp = dlg.getDestinationProject()) != null && !projectTmp.equals(DEFAULT)) {
            return projectTmp;
        }
        return null;
    }

    public static String getComputedDialogFolderName(RadicalEntity re, boolean isMap) {
        String folderTmp;
        PacDialogFolderView dlg;
        if (re == null) {
            return null;
        }
        if (re instanceof PacScreen) {
            PacDialog dlg2 = ((PacScreen)re).getDialog();
            if (dlg2 != null) {
                String folderTmp2 = DEFAULT;
                folderTmp2 = !isMap ? dlg2.getCobolFolder() : dlg2.getMapFolder();
                if (folderTmp2 != null && !folderTmp2.equals(DEFAULT)) {
                    return folderTmp2;
                }
            }
        } else if (re instanceof PacServer) {
            String folderTmp3;
            PacDialogServer dlg3 = ((PacServer)re).getDialog();
            if (dlg3 != null && (folderTmp3 = dlg3.getCobolFolder()) != null && !folderTmp3.equals(DEFAULT)) {
                return folderTmp3;
            }
        } else if (re instanceof PacCommunicationMonitor) {
            String folderTmp4;
            String folderTmp5;
            PacDialogServer dlg4 = ((PacCommunicationMonitor)re).getPacDialogServer();
            if (dlg4 != null && (folderTmp5 = dlg4.getCobolFolder()) != null && !folderTmp5.equals(DEFAULT)) {
                return folderTmp5;
            }
            PacDialogCommunicationMonitor dlg1 = ((PacCommunicationMonitor)re).getPacDialogCommunicationMonitor();
            if (dlg1 != null && (folderTmp4 = dlg1.getCobolFolder()) != null && !folderTmp4.equals(DEFAULT)) {
                return folderTmp4;
            }
        } else if (re instanceof PacFolder) {
            String folderTmp6;
            PacDialogFolder dlg5 = ((PacFolder)re).getPacDialogFolder();
            if (dlg5 != null && (folderTmp6 = dlg5.getCobolFolder()) != null && !folderTmp6.equals(DEFAULT)) {
                return folderTmp6;
            }
        } else if (re instanceof PacFolderView && (dlg = ((PacFolderView)re).getPacDialogFolderView()) != null && (folderTmp = dlg.getDestinationFolder()) != null && !folderTmp.equals(DEFAULT)) {
            return folderTmp;
        }
        return null;
    }
}

