/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.pacbase.util.IPacFunctionConstants;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class PacFunctionCheckingUtilities
implements IPacFunctionConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean isParameterWithDollarWellFormed(String parameter, String[] values) {
        char[] cars = parameter.toCharArray();
        StringBuilder carsBefore = new StringBuilder();
        StringBuilder carNext = new StringBuilder("$");
        StringBuilder carsEnd = new StringBuilder();
        int step = 0;
        char[] cArray = cars;
        int n = cars.length;
        int n2 = 0;
        while (n2 < n) {
            char car = cArray[n2];
            if (car == '$') {
                if (step != 0) {
                    boolean b = PacFunctionCheckingUtilities.checkValues(carsBefore, carNext, carsEnd, values);
                    if (!b) {
                        return false;
                    }
                    step = 0;
                    carsBefore = new StringBuilder();
                    carNext = new StringBuilder("$");
                    carsEnd = new StringBuilder();
                }
                step = 1;
            } else if (step == 0) {
                carsBefore.append(car);
            } else if (step == 1) {
                carNext = carNext.append(car);
                step = 2;
            } else {
                carsEnd.append(car);
            }
            ++n2;
        }
        return PacFunctionCheckingUtilities.checkValues(carsBefore, carNext, carsEnd, values);
    }

    private static boolean checkValues(StringBuilder carsBefore, StringBuilder carNext, StringBuilder carsEnd, String[] values) {
        if (!PacFunctionCheckingUtilities.isElementFoundInList(carNext.toString(), PARAMS$)) {
            return false;
        }
        if (values != null) {
            int n;
            ArrayList<String> list = new ArrayList<String>();
            if (carsBefore.length() > 0) {
                String[] stringArray = values;
                n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (value.startsWith(carsBefore.toString())) {
                        list.add(value);
                    }
                    ++n2;
                }
                if (list.size() == 0) {
                    return false;
                }
            }
            if (carsEnd.length() > 0) {
                boolean found = false;
                String[] stringArray = values;
                int n3 = values.length;
                n = 0;
                while (n < n3) {
                    String value = stringArray[n];
                    if (value.endsWith(carsEnd.toString()) && !list.isEmpty() && list.contains(value)) {
                        found = true;
                        break;
                    }
                    ++n;
                }
                if (!found) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isElementFoundInList(String param, String[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (param.equals(elements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IPacFunctionConstants.FunctionModelPatternValues searchPattern(String fct, String reference, String action, IPacFunctionConstants.FunctionModelPatternValues pattern) {
        if ("*B".equals(action)) {
            return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
        }
        if ("*C".equals(action)) {
            return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
        }
        if (reference.length() == 0) {
            return IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN;
        }
        StringTokenizer tokenizer = new StringTokenizer(reference, " ");
        ArrayList<String> refs = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            refs.add(tokenizer.nextToken());
        }
        if (refs.size() > 2) {
            return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
        }
        String function = fct.substring(0, 3);
        if ("F80".equals(function)) {
            if (refs.size() > 1 && ("R1".equals(refs.get(1)) || "R2".equals(refs.get(1)) || "R3".equals(refs.get(1)) || "RA".equals(refs.get(1)))) {
                return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
            }
            return pattern == null ? IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN : pattern;
        }
        if (refs.size() == 1 && reference.startsWith("$") && reference.length() == 2) {
            return pattern == null ? IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN : pattern;
        }
        if (!PacFunctionCheckingUtilities.isDialogFunction(function) || PacFunctionCheckingUtilities.isDialogFunction(function) && refs.size() > 1 && ((String)refs.get(1)).length() > 2) {
            if (!((String)refs.get(0)).startsWith("$")) {
                String process;
                String[] stringArray = LOGICAL_VIEW_PROCESS;
                int n = LOGICAL_VIEW_PROCESS.length;
                int n2 = 0;
                while (n2 < n) {
                    process = stringArray[n2];
                    if (process.equals(refs.get(0))) {
                        return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
                    }
                    ++n2;
                }
                stringArray = LEVEL_SQL_PROCESS;
                n = LEVEL_SQL_PROCESS.length;
                n2 = 0;
                while (n2 < n) {
                    process = stringArray[n2];
                    if (process.equals(refs.get(0))) {
                        return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
                    }
                    ++n2;
                }
                stringArray = LOGICAL_ACCESS_PROCESS;
                n = LOGICAL_ACCESS_PROCESS.length;
                n2 = 0;
                while (n2 < n) {
                    process = stringArray[n2];
                    if (process.equals(refs.get(0))) {
                        return IPacFunctionConstants.FunctionModelPatternValues.SERVER_PATTERN;
                    }
                    ++n2;
                }
            }
        } else if (PacFunctionCheckingUtilities.isDialogFunction(function) && refs.size() == 1) {
            return pattern == null ? IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN : pattern;
        }
        return IPacFunctionConstants.FunctionModelPatternValues.NO_SPECIFIC_PATTERN;
    }

    public static boolean isDialogFunction(String function) {
        boolean isDialogFct = false;
        String[] stringArray = DIALOG_FUNCTIONS;
        int n = DIALOG_FUNCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String fct = stringArray[n2];
            if (fct.equals(function)) {
                isDialogFct = true;
                break;
            }
            ++n2;
        }
        return isDialogFct;
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }
}

