/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

public class PacFreeRelationsUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2016, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String getPacCommunicationMonitorFromPacFolderGOLine(String description) {
        if (description.startsWith("LOCATION=")) {
            return PacFreeRelationsUtil.getFMorITCode(description.substring(9));
        }
        return null;
    }

    public static String getPacServerITFromPacFolderGOLine(String description) {
        if (description.startsWith("INITSERV=")) {
            return PacFreeRelationsUtil.getFMorITCode(description.substring(9));
        }
        return null;
    }

    public static String getFMorITCode(String description) {
        int endBlank = -1;
        int i = 0;
        while (i < description.length()) {
            char charact = description.charAt(i);
            if (!Character.isWhitespace(charact)) {
                endBlank = i;
                break;
            }
            ++i;
        }
        String code = "";
        int endScreen = Math.min(6, description.length());
        code = endBlank > -1 ? description.substring(endBlank, endBlank + endScreen) : description.substring(endScreen);
        if (code.trim().length() > 0) {
            return code;
        }
        return null;
    }

    public static String renamePacDataElementFromPacUpdateSegmentCode(String description, String oldName, String newName) {
        String code = "";
        if (description.length() > 4) {
            code = PacFreeRelationsUtil.trimRight(description.substring(4));
        }
        if (code.length() > 0 && code.equals(oldName)) {
            return String.valueOf(description.substring(0, 4)) + description.substring(4).replace(oldName, newName);
        }
        return null;
    }

    public static String getPacDataElementFromPacUpdateSegmentCode(String description) {
        String code = "";
        if (description.length() > 4) {
            code = PacFreeRelationsUtil.trimRight(description.substring(4));
        }
        if (code.length() > 0) {
            return code;
        }
        return null;
    }

    public static String getPacDataElementFromPacDisplaySegmentCode(String description) {
        return PacFreeRelationsUtil.getPacDataElementFromPacUpdateSegmentCode(description);
    }

    public static String renamePacDataElementFromPacAccesKeySourceCode(String description, String oldName, String newName) {
        int endrub;
        int index;
        if (description.indexOf(oldName) == -1) {
            return null;
        }
        String code = "";
        if (description.length() > 5 && (index = description.lastIndexOf(45)) != -1 && (code = PacFreeRelationsUtil.trimRight(description.substring(++index, endrub = Math.min(index + 6, description.length())))).equals(oldName)) {
            return String.valueOf(description.substring(0, index)) + newName;
        }
        return null;
    }

    public static String getPacDataElementFromPacAccesKeySourceCode(String description) {
        int endrub;
        int index;
        String code = "";
        if (description.length() > 5 && (index = description.lastIndexOf(45)) != -1 && (code = PacFreeRelationsUtil.trimRight(description.substring(++index, endrub = Math.min(index + 6, description.length())))).length() > 0) {
            return code;
        }
        return null;
    }

    public static String renamePacDataElementFromPacUpdateTargetCode(String description, String oldName, String newName) {
        return PacFreeRelationsUtil.renamePacDataElementFromPacUpdateSegmentCode(description, oldName, newName);
    }

    public static String getPacDataElementFromPacUpdateTargetCode(String description) {
        return PacFreeRelationsUtil.getPacDataElementFromPacUpdateSegmentCode(description);
    }

    public static String renamePacDataElementFromPacSourceLineSource(String description, String oldName, String newName) {
        String code = "";
        if (description.length() > 4) {
            int endrub = Math.min(10, description.length());
            code = PacFreeRelationsUtil.trimRight(description.substring(4, endrub));
        }
        if (code.length() > 0 && code.equals(oldName)) {
            return String.valueOf(description.substring(0, 4)) + newName;
        }
        return null;
    }

    public static String getPacDataElementFromPacSourceLineSource(String description) {
        String code = "";
        if (description.length() > 4) {
            int endrub = Math.min(10, description.length());
            code = PacFreeRelationsUtil.trimRight(description.substring(4, endrub));
        }
        if (code.length() > 0) {
            return code;
        }
        return null;
    }

    public static String renamePacDataElementFromPacCategoryCondition(String description, String oldName, String newName) {
        String lgrub;
        int index;
        if (description.indexOf(oldName) == -1) {
            return null;
        }
        String code = "";
        if (description.length() > 0 && (index = description.lastIndexOf(45)) != -1 && (lgrub = description.substring(index + 1)).length() < 7 && (code = lgrub).length() > 0 && code.equals(oldName)) {
            return String.valueOf(description.substring(0, index + 1)) + newName;
        }
        return null;
    }

    public static String getPacDataElementFromPacCategoryCondition(String description) {
        String lgrub;
        int index;
        String code = "";
        if (description.length() > 0 && (index = description.lastIndexOf(45)) != -1 && (lgrub = description.substring(index + 1)).length() < 7 && (code = lgrub).length() > 0) {
            return code;
        }
        return null;
    }

    public static String renamePacDataElementFromPacGLineDescriptionUnderBrackets(String description, String oldName, String newName) {
        int index;
        String code = "";
        if (description.length() > 0 && description.charAt(0) == '<' && (index = description.indexOf(62)) != -1) {
            String lgrub;
            if (index == 7 && (code = PacFreeRelationsUtil.trimRight(lgrub = description.substring(1, 7))).length() > 0 && code.equals(oldName)) {
                String newNameOn6Chars = newName;
                while (newNameOn6Chars.length() < 6) {
                    newNameOn6Chars = String.valueOf(newNameOn6Chars) + " ";
                }
                return String.valueOf('<') + newNameOn6Chars + '>';
            }
            if (index == 12 && (code = PacFreeRelationsUtil.trimRight(lgrub = description.substring(6, 12))).length() > 0 && code.equals(oldName)) {
                String newNameOn6Chars = newName;
                while (newNameOn6Chars.length() < 6) {
                    newNameOn6Chars = String.valueOf(newNameOn6Chars) + " ";
                }
                return String.valueOf(description.substring(0, 6)) + newNameOn6Chars + '>';
            }
        }
        return null;
    }

    public static String getPacDataElementFromPacGLineDescriptionUnderBrackets(String description) {
        int index;
        String code = "";
        if (description.length() > 0 && description.charAt(0) == '<' && (index = description.indexOf(62)) != -1) {
            String lgrub;
            if (index == 7) {
                lgrub = description.substring(1, 7);
                code = PacFreeRelationsUtil.trimRight(lgrub);
            }
            if (index == 12) {
                lgrub = description.substring(6, 12);
                code = PacFreeRelationsUtil.trimRight(lgrub);
            }
            if (code.length() > 0) {
                return code;
            }
        }
        return null;
    }

    public static String getPacDataElementFromCPParameter(String description) {
        String code = "";
        if (description.length() > 2 && description.startsWith("E=")) {
            code = PacFreeRelationsUtil.trimRight(description.substring(2));
        }
        if (code.length() > 0) {
            return code;
        }
        return null;
    }

    public static String renamePacDataElementFromCPParameter(String description, String oldName, String newName) {
        String code = "";
        if (description.length() > 2 && description.startsWith("E=")) {
            code = PacFreeRelationsUtil.trimRight(description.substring(2));
        }
        if (code.length() > 0 && code.equals(oldName)) {
            return String.valueOf(description.substring(0, 2)) + description.substring(2).replace(oldName, newName);
        }
        return null;
    }

    public static String getPacDataAggregateFromCPParameter(String description) {
        String code = "";
        if (description.length() > 2 && description.startsWith("S=")) {
            code = PacFreeRelationsUtil.trimRight(description.substring(2));
        }
        if (code.length() > 0) {
            return code;
        }
        return null;
    }

    public static String renamePacDataAggregateFromCPParameter(String description, String oldName, String newName) {
        String code = "";
        if (description.length() > 2 && description.startsWith("S=")) {
            code = PacFreeRelationsUtil.trimRight(description.substring(2));
        }
        if (code.length() > 0 && code.equals(oldName)) {
            return String.valueOf(description.substring(0, 2)) + description.substring(2, 5).replace(oldName, newName);
        }
        return null;
    }

    public static String getPacDataUnitFromCPParameter(String description) {
        String code = "";
        if (description.length() > 2 && description.startsWith("D=")) {
            code = PacFreeRelationsUtil.trimRight(description.substring(2));
        }
        if (code.length() > 0) {
            return code;
        }
        return null;
    }

    public static String renamePacDataUnitFromCPParameter(String description, String oldName, String newName) {
        String code = "";
        if (description.length() > 2 && description.startsWith("D=")) {
            code = PacFreeRelationsUtil.trimRight(description.substring(2));
        }
        if (code.length() > 0 && code.equals(oldName)) {
            return String.valueOf(description.substring(0, 2)) + description.substring(2, 3).replace(oldName, newName);
        }
        return null;
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }
}

