/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.util;

import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataDescriptionExtension;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacTimestampFractionValues;
import com.ibm.pdp.mdl.pacbase.PacTimezoneValues;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;
import java.util.Iterator;

public class PacExtensionsUtilities {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static PacDataElementDescription GetPacDEExtension(DataElementDescription kded) {
        PacDataElementDescription pacExt = null;
        if (kded != null) {
            for (Object obj : kded.getExtensions()) {
                if (!(obj instanceof PacDataElementDescription)) continue;
                pacExt = (PacDataElementDescription)obj;
                break;
            }
        }
        return pacExt;
    }

    public static PacDataElementDescription GetPacDataElementDescription(DataElement dataElement) {
        for (DataDescriptionExtension dde : dataElement.getDataDescription().getExtensions()) {
            if (!(dde instanceof PacDataElementDescription)) continue;
            return (PacDataElementDescription)dde;
        }
        return null;
    }

    public static PacFiller GetPacFillerExtension(DataComponent kdc) {
        Iterator extensions = kdc.getExtensions().iterator();
        PacFiller pacFil = null;
        while (extensions.hasNext()) {
            Object obj = extensions.next();
            if (!(obj instanceof PacFiller)) continue;
            pacFil = (PacFiller)obj;
            break;
        }
        return pacFil;
    }

    public static String GetInternalFormat(PacDataElementDescription pded) {
        DataElement de;
        if (pded.getInternalFormat().trim().length() == 0 && (de = pded.getParent()) != null) {
            DataElementDescription ded = (DataElementDescription)de.getDataDescription();
            PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
            return pded2.getInternalFormat();
        }
        return pded.getInternalFormat();
    }

    public static PacTimestampFractionValues GetInternalSecond(PacDataElementDescription pded) {
        if (PacExtensionsUtilities.GetInternalFormat(pded).trim().equals("TS")) {
            if (pded.getInternalTimestamp() != null) {
                if (((Object)((Object)pded.getInternalTimestamp().getFraction())).equals((Object)PacTimestampFractionValues._INHERITED_LITERAL)) {
                    DataElement de = pded.getParent();
                    if (de != null) {
                        DataElementDescription ded = (DataElementDescription)de.getDataDescription();
                        PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
                        if (pded2.getInternalTimestamp() != null && !((Object)((Object)pded2.getInternalTimestamp().getFraction())).equals((Object)PacTimestampFractionValues._INHERITED_LITERAL)) {
                            return pded2.getInternalTimestamp().getFraction();
                        }
                        return PacTimestampFractionValues._6_LITERAL;
                    }
                    return PacTimestampFractionValues._6_LITERAL;
                }
                return pded.getInternalTimestamp().getFraction();
            }
            DataElement de = pded.getParent();
            if (de != null) {
                DataElementDescription ded = (DataElementDescription)de.getDataDescription();
                PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
                if (pded2.getInternalTimestamp() != null) {
                    return pded2.getInternalTimestamp().getFraction();
                }
                return PacTimestampFractionValues._6_LITERAL;
            }
            return PacTimestampFractionValues._6_LITERAL;
        }
        return PacTimestampFractionValues._0_LITERAL;
    }

    public static PacTimezoneValues GetInternalTimezone(PacDataElementDescription pded) {
        if (pded.getInternalTimestamp() != null) {
            DataElement de;
            if (((Object)((Object)pded.getInternalTimestamp().getTimezone())).equals((Object)PacTimezoneValues._INHERITED_LITERAL) && (de = pded.getParent()) != null) {
                DataElementDescription ded = (DataElementDescription)de.getDataDescription();
                PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
                if (pded2.getInternalTimestamp() != null) {
                    return pded2.getInternalTimestamp().getTimezone();
                }
                return PacTimezoneValues._FALSE_LITERAL;
            }
            return pded.getInternalTimestamp().getTimezone();
        }
        DataElement de = pded.getParent();
        if (de != null) {
            DataElementDescription ded = (DataElementDescription)de.getDataDescription();
            PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
            if (pded2.getInternalTimestamp() != null) {
                return pded2.getInternalTimestamp().getTimezone();
            }
            return PacTimezoneValues._FALSE_LITERAL;
        }
        return PacTimezoneValues._FALSE_LITERAL;
    }

    public static String GetInputFormat(PacDataElementDescription pded) {
        DataElement de;
        if (pded.getInputFormat().trim().length() == 0 && (de = pded.getParent()) != null) {
            DataElementDescription ded = (DataElementDescription)de.getDataDescription();
            PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
            return pded2.getInputFormat();
        }
        return pded.getInputFormat();
    }

    public static PacTimestampFractionValues GetInputSecond(PacDataElementDescription pded) {
        if (PacExtensionsUtilities.GetInputFormat(pded).trim().equals("TS")) {
            if (pded.getInputTimestamp() != null) {
                if (((Object)((Object)pded.getInputTimestamp().getFraction())).equals((Object)PacTimestampFractionValues._INHERITED_LITERAL)) {
                    DataElement de = pded.getParent();
                    if (de != null) {
                        DataElementDescription ded = (DataElementDescription)de.getDataDescription();
                        PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
                        if (pded2.getInputTimestamp() != null && !((Object)((Object)pded2.getInputTimestamp().getFraction())).equals((Object)PacTimestampFractionValues._INHERITED_LITERAL)) {
                            return pded2.getInputTimestamp().getFraction();
                        }
                        return PacTimestampFractionValues._6_LITERAL;
                    }
                    return PacTimestampFractionValues._6_LITERAL;
                }
                return pded.getInputTimestamp().getFraction();
            }
            return PacTimestampFractionValues._6_LITERAL;
        }
        return PacTimestampFractionValues._0_LITERAL;
    }

    public static PacTimezoneValues GetInputTimezone(PacDataElementDescription pded) {
        if (pded.getInputTimestamp() != null) {
            DataElement de;
            if (((Object)((Object)pded.getInputTimestamp().getTimezone())).equals((Object)PacTimezoneValues._INHERITED_LITERAL) && (de = pded.getParent()) != null) {
                DataElementDescription ded = (DataElementDescription)de.getDataDescription();
                PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
                if (pded2.getInputTimestamp() != null) {
                    return pded2.getInputTimestamp().getTimezone();
                }
                return PacTimezoneValues._FALSE_LITERAL;
            }
            return pded.getInputTimestamp().getTimezone();
        }
        return PacTimezoneValues._FALSE_LITERAL;
    }

    public static String GetOutputFormat(PacDataElementDescription pded) {
        DataElement de;
        if (pded.getOutputFormat().trim().length() == 0 && (de = pded.getParent()) != null) {
            DataElementDescription ded = (DataElementDescription)de.getDataDescription();
            PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
            return pded2.getOutputFormat();
        }
        return pded.getOutputFormat();
    }

    public static PacTimestampFractionValues GetOutputSecond(PacDataElementDescription pded) {
        if (PacExtensionsUtilities.GetOutputFormat(pded).trim().equals("TS")) {
            if (pded.getOutputTimestamp() != null) {
                if (((Object)((Object)pded.getOutputTimestamp().getFraction())).equals((Object)PacTimestampFractionValues._INHERITED_LITERAL)) {
                    DataElement de = pded.getParent();
                    if (de != null) {
                        DataElementDescription ded = (DataElementDescription)de.getDataDescription();
                        PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
                        if (pded2.getOutputTimestamp() != null && !((Object)((Object)pded2.getOutputTimestamp().getFraction())).equals((Object)PacTimestampFractionValues._INHERITED_LITERAL)) {
                            return pded2.getOutputTimestamp().getFraction();
                        }
                        return PacTimestampFractionValues._6_LITERAL;
                    }
                    return PacTimestampFractionValues._6_LITERAL;
                }
                return pded.getOutputTimestamp().getFraction();
            }
            return PacTimestampFractionValues._6_LITERAL;
        }
        return PacTimestampFractionValues._0_LITERAL;
    }

    public static PacTimezoneValues GetOutputTimezone(PacDataElementDescription pded) {
        if (pded.getOutputTimestamp() != null) {
            DataElement de;
            if (((Object)((Object)pded.getOutputTimestamp().getTimezone())).equals((Object)PacTimezoneValues._INHERITED_LITERAL) && (de = pded.getParent()) != null) {
                DataElementDescription ded = (DataElementDescription)de.getDataDescription();
                PacDataElementDescription pded2 = PacExtensionsUtilities.GetPacDEExtension(ded);
                if (pded2.getOutputTimestamp() != null) {
                    return pded2.getOutputTimestamp().getTimezone();
                }
                return PacTimezoneValues._FALSE_LITERAL;
            }
            return pded.getOutputTimestamp().getTimezone();
        }
        return PacTimezoneValues._FALSE_LITERAL;
    }

    public static boolean isNumeric(PacDataElementDescription pded) {
        PacPictureParser pictureParser = new PacPictureParser(PacExtensionsUtilities.GetOutputFormat(pded));
        char usage = '?';
        if (pded.getInternalUsage() != null) {
            usage = pded.getInternalUsage().getLiteral().charAt(1);
        }
        if (pictureParser.isAlphabetic() || pictureParser.isAlphanumeric()) {
            return false;
        }
        if (pictureParser.isNumeric() || PacPictureParser.IsNativeUsage(usage) || PacPictureParser.IsBytesPictureUsage(usage)) {
            return true;
        }
        if (pictureParser.isDate()) {
            return false;
        }
        return false;
    }
}

