/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.lal.util.converter;

import com.ibm.pdp.mdl.pacbase.PacGeneratedLanguageValues;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacFormat;
import com.ibm.pdp.mdl.pacbase.util.PacbasePattern;
import java.util.ArrayList;
import java.util.List;

public class PacNumericFormat
extends PacFormat {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int fieldDecimalLength = 0;
    private boolean fieldSigned = false;
    private char fieldUsage = (char)68;
    public static final String BINARY = "BINARY";
    public static final String BINARY_1 = "BINARY-1";
    private static final String BINARY_SYNC_RIGHT = "BINARY SYNC RIGHT";
    public static final String BLANK_WHEN_ZERO = "BLANK WHEN ZERO";
    private static final String COMP_1_SYNC_RIGHT = "COMPUTATIONAL-1 SYNC RIGHT";
    private static final String COMP_3_PK_SYNC = "COMPUTATIONAL-3 PK SYNC";
    private static final String COMP_SYNC_RIGHT = "COMPUTATIONAL SYNC RIGHT";
    public static final String COMPUTATIONAL = "COMPUTATIONAL";
    private static final String COMPUTATIONAL_1 = "COMPUTATIONAL-1";
    private static final String COMPUTATIONAL_2 = "COMPUTATIONAL-2";
    private static final String COMPUTATIONAL_3 = "COMPUTATIONAL-3";
    private static final String COMPUTATIONAL_4 = "COMPUTATIONAL-4";
    private static final String COMPUTATIONAL_5 = "COMPUTATIONAL-5";
    private static final String COMPUTATIONAL_6 = "COMPUTATIONAL-6";
    private static final String COMPUTATIONAL_7 = "COMPUTATIONAL-7";
    private static final String COMPUTATIONAL_9 = "COMPUTATIONAL-9";
    private static final String COMPUTATIONAL_10 = "COMPUTATIONAL-10";
    private static final String COMPUTATIONAL_11 = "COMPUTATIONAL-11";
    private static final String COMPUTATIONAL_12 = "COMPUTATIONAL-12";
    private static final String DB_KEY = "DB-KEY";
    private static final String DISPLAY_1 = "DISPLAY-1";
    private static final String DISPLAY_2 = "DISPLAY-2";
    private static final String PACKED_DECIMAL = "PACKED-DECIMAL";
    private static final String POINTER = "POINTER";
    private static final String REAL = "REAL";
    private static final String OLD_SIGN_IS_LEADING_SEPARATE_CHARACTER = "SIGN IS LEADING SEPARATE";
    private static final String SIGN_IS_LEADING_SEPARATE_CHARACTER = "SIGN IS LEADING SEPARATE CHARACTER";
    private static final String SIGN_IS_TRAILING_SEPARATE_CHARACTER = "SIGN IS TRAILING SEPARATE CHARACTER";
    public static final List<String> ListOfComments = new ArrayList<String>();

    static {
        ListOfComments.add(BINARY);
        ListOfComments.add(BINARY_1);
        ListOfComments.add(BINARY_SYNC_RIGHT);
        ListOfComments.add(BLANK_WHEN_ZERO);
        ListOfComments.add(COMP_1_SYNC_RIGHT);
        ListOfComments.add(COMP_3_PK_SYNC);
        ListOfComments.add(COMP_SYNC_RIGHT);
        ListOfComments.add(COMPUTATIONAL);
        ListOfComments.add(COMPUTATIONAL_1);
        ListOfComments.add(COMPUTATIONAL_2);
        ListOfComments.add(COMPUTATIONAL_3);
        ListOfComments.add(COMPUTATIONAL_4);
        ListOfComments.add(COMPUTATIONAL_5);
        ListOfComments.add(COMPUTATIONAL_6);
        ListOfComments.add(COMPUTATIONAL_7);
        ListOfComments.add(COMPUTATIONAL_9);
        ListOfComments.add(COMPUTATIONAL_10);
        ListOfComments.add(COMPUTATIONAL_11);
        ListOfComments.add(COMPUTATIONAL_12);
        ListOfComments.add(DB_KEY);
        ListOfComments.add(DISPLAY_1);
        ListOfComments.add(DISPLAY_2);
        ListOfComments.add(PACKED_DECIMAL);
        ListOfComments.add(POINTER);
        ListOfComments.add(REAL);
        ListOfComments.add(OLD_SIGN_IS_LEADING_SEPARATE_CHARACTER);
        ListOfComments.add(SIGN_IS_LEADING_SEPARATE_CHARACTER);
        ListOfComments.add(SIGN_IS_TRAILING_SEPARATE_CHARACTER);
    }

    public PacNumericFormat(int totalLength, int aDecimalLength, boolean aSigned, char aUsage, char aVaria) {
        this.setTotalLength(totalLength);
        this.setDecimalLength(aDecimalLength);
        this.setSigned(aSigned);
        this.setUsage(aUsage);
        this.convertToLibraryCobolType(aVaria);
        this.setTotalLength(this.getInternalLength(aVaria));
    }

    public void convertToLibraryCobolType(char varia) {
        if (varia == 'N') {
            return;
        }
        int tempUsage = 32;
        char usage = this.getUsage();
        int newUsage = this.getUsage();
        int totalLength = 0;
        boolean newNF = false;
        if (usage == '3' || usage == '4' || usage == '8' || usage == '9' || usage == 'N' || usage == 'T' || usage == 'Q' || usage == 'O') {
            tempUsage = 51;
        } else if (usage == '2' || usage == 'K' || usage == 'D' || usage == ' ' || usage == 'I') {
            tempUsage = 68;
        } else if (usage == 'B' || usage == 'L' || usage == '7') {
            tempUsage = usage;
        } else if (usage == '1' || usage == 'X') {
            tempUsage = 88;
        } else {
            if (usage == '5' || usage == '0') {
                totalLength = 4;
                newNF = true;
            }
            if (usage == '6' || usage == 'F' || usage == 'U' || usage == 'W' || usage == 'J' || usage == 'Y') {
                totalLength = 8;
                newNF = true;
            }
            tempUsage = 67;
        }
        switch (varia) {
            case '8': {
                if (usage == 'J') {
                    totalLength = 0;
                    newNF = true;
                    break;
                }
                newUsage = tempUsage;
                if (newUsage == 51) {
                    newUsage = 78;
                    break;
                }
                if (newUsage == 68 || newUsage == 88) break;
                newUsage = 80;
                break;
            }
            case 'K': {
                if (usage == 'U' || usage == 'S') {
                    newUsage = 71;
                }
                if (newUsage == 71 || newUsage == 72 || (tempUsage = newUsage) == 66 || tempUsage == 76) break;
                newUsage = 55;
                newNF = true;
                totalLength = 8 * (this.getTotalLength() / 4 + 2);
                break;
            }
            case 'U': {
                if (usage == 'U' || usage == 'W' || usage == 'I' || usage == '1' || usage == 'O') break;
                newUsage = tempUsage;
                if (tempUsage != 51 && tempUsage != 67) break;
                newUsage = 72;
                break;
            }
            case '0': 
            case '1': {
                if (usage == 'F' || usage == 'R' || usage == 'W' || usage == '1') break;
                newUsage = tempUsage;
                break;
            }
            case 'X': {
                if (usage == 'F' || usage == 'R' || usage == 'Y' || usage == 'W' || usage == '1') break;
                newUsage = tempUsage;
                break;
            }
            case '4': {
                if (usage == 'Y') break;
                if (usage == 'W' || usage == '1') {
                    totalLength = 0;
                    newNF = true;
                    break;
                }
                newUsage = tempUsage;
                if (tempUsage == 51) {
                    newUsage = 56;
                }
                if (tempUsage != 67) break;
                if (this.getTotalLength() < 5 && this.getTotalLength() > 0 || this.getTotalLength() == 0 && totalLength < 5) {
                    newUsage = 53;
                    break;
                }
                newUsage = 54;
                break;
            }
            case '5': {
                if (usage == 'J' || usage == 'F' || usage == 'Y' || usage == '1' || usage == 'W' || usage == '8' || usage == '0') break;
                newUsage = tempUsage;
                if (tempUsage == 51) {
                    newUsage = 57;
                }
                if (tempUsage != 67) break;
                if (this.getTotalLength() < 5 && this.getTotalLength() > 0 || this.getTotalLength() == 0 && totalLength < 5) {
                    newUsage = 53;
                    break;
                }
                newUsage = 54;
                break;
            }
            case '3': 
            case 'Z': {
                if (usage == 'W' || usage == 'F' || usage == '1') break;
                newUsage = tempUsage;
            }
        }
        this.setUsage((char)newUsage);
        if (newNF) {
            this.setTotalLength(totalLength);
            this.setDecimalLength(0);
            if (newUsage != 7) {
                this.setSigned(totalLength != 0);
            }
        }
    }

    public int getDecimalLength() {
        return this.fieldDecimalLength;
    }

    public char getUsage() {
        return this.fieldUsage;
    }

    public boolean isBytesPictureUsage() {
        return PacNumericFormat.IsBytesPictureUsage(this.getUsage());
    }

    public static boolean IsBytesPictureUsage(char c) {
        return c == 'B' || c == 'L' || c == '7';
    }

    public boolean isNativeUsage() {
        return PacNumericFormat.IsNativeUsage(this.getUsage());
    }

    public static boolean IsNativeUsage(char c) {
        return c == 'F' || c == 'W' || c == 'Y' || c == 'J' || c == 'U' || c == '0' || c == '5' || c == '6';
    }

    public boolean isSigned() {
        return this.fieldSigned;
    }

    public void setDecimalLength(int decimalLength) {
        this.fieldDecimalLength = decimalLength;
    }

    public void setSigned(boolean signed) {
        this.fieldSigned = signed;
    }

    public void setUsage(char usage) {
        this.fieldUsage = usage;
    }

    public String toString() {
        String result = this.isSigned() ? "+" : "";
        result = String.valueOf(result) + (this.getDecimalLength() > 0 ? "dec[" : "int[");
        result = String.valueOf(result) + this.getTotalLength();
        result = String.valueOf(result) + (this.getDecimalLength() > 0 ? ", " + this.getDecimalLength() : "");
        result = String.valueOf(result) + "]";
        return result;
    }

    public static String GetCommentsForUsage(char usageAfterConversion, char pattern_Variant, PacGeneratedLanguageValues generatedLanguage, PacbasePattern pattern) {
        if (usageAfterConversion == '0') {
            return COMPUTATIONAL_7;
        }
        if (usageAfterConversion == '2') {
            return DISPLAY_2;
        }
        if (usageAfterConversion == '3') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return PACKED_DECIMAL;
            }
            if ("4_G_M".indexOf(pattern_Variant) != -1) {
                return COMPUTATIONAL;
            }
            return COMPUTATIONAL_3;
        }
        if (usageAfterConversion == '5') {
            if (pattern_Variant == 'A') {
                return COMPUTATIONAL;
            }
            return COMPUTATIONAL_1;
        }
        if (usageAfterConversion == '6') {
            return COMPUTATIONAL_2;
        }
        if (usageAfterConversion == '7') {
            return COMPUTATIONAL_5;
        }
        if (usageAfterConversion == '8') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return BINARY;
            }
            return COMPUTATIONAL;
        }
        if (usageAfterConversion == '9') {
            return COMPUTATIONAL_3;
        }
        if (usageAfterConversion == 'B') {
            if (pattern_Variant == 'U') {
                return BINARY_1;
            }
            return "";
        }
        if (usageAfterConversion == 'F') {
            if (pattern_Variant == '4') {
                return COMPUTATIONAL_9;
            }
            if (pattern_Variant == '5') {
                return COMPUTATIONAL_11;
            }
            return COMPUTATIONAL_1;
        }
        if (usageAfterConversion == 'G') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return BINARY_SYNC_RIGHT;
            }
            if ("3_Q_Z".indexOf(pattern_Variant) != -1) {
                return COMPUTATIONAL_5;
            }
            return COMP_SYNC_RIGHT;
        }
        if (usageAfterConversion == 'H') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return BINARY;
            }
            return COMPUTATIONAL;
        }
        if (usageAfterConversion == 'J') {
            if (pattern_Variant == '8') {
                return REAL;
            }
            return COMPUTATIONAL_6;
        }
        if (usageAfterConversion == 'K') {
            return COMPUTATIONAL;
        }
        if (usageAfterConversion == 'L') {
            return COMP_1_SYNC_RIGHT;
        }
        if (usageAfterConversion == 'M') {
            return COMPUTATIONAL_1;
        }
        if (usageAfterConversion == 'N') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return BINARY;
            }
            if (pattern_Variant == '5') {
                return COMPUTATIONAL_4;
            }
            return COMPUTATIONAL;
        }
        if (usageAfterConversion == 'O') {
            if (pattern_Variant == 'U') {
                return COMPUTATIONAL_4;
            }
            return "";
        }
        if (usageAfterConversion == 'P') {
            if (pattern_Variant == '8') {
                return BINARY;
            }
            return COMPUTATIONAL_1;
        }
        if (usageAfterConversion == 'Q') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return BINARY;
            }
            return COMPUTATIONAL;
        }
        if (usageAfterConversion == 'S') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return BINARY_SYNC_RIGHT;
            }
            return COMP_SYNC_RIGHT;
        }
        if (usageAfterConversion == 'U') {
            return COMPUTATIONAL_2;
        }
        if (usageAfterConversion == 'W') {
            if (pattern_Variant == '4') {
                return COMPUTATIONAL_10;
            }
            if (pattern_Variant == '5') {
                return COMPUTATIONAL_12;
            }
            return COMPUTATIONAL_2;
        }
        if (usageAfterConversion == 'X') {
            return SIGN_IS_TRAILING_SEPARATE_CHARACTER;
        }
        if (usageAfterConversion == 'Y') {
            if ("0_1_3_Q_X_Z".indexOf(pattern_Variant) != -1) {
                return POINTER;
            }
            return DB_KEY;
        }
        if (usageAfterConversion == 'Z') {
            return BLANK_WHEN_ZERO;
        }
        if (usageAfterConversion == '1') {
            if (pattern == PacbasePattern.BATCH) {
                return SIGN_IS_LEADING_SEPARATE_CHARACTER;
            }
            return OLD_SIGN_IS_LEADING_SEPARATE_CHARACTER;
        }
        if (usageAfterConversion == 'C') {
            if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                return BINARY;
            }
            if (pattern_Variant == 'K') {
                return COMPUTATIONAL_6;
            }
            if (pattern == PacbasePattern.BATCH) {
                if (pattern_Variant == 'Y' || pattern_Variant == 'O') {
                    return COMPUTATIONAL_4;
                }
                if ("0_X_1_3_Q_Z".indexOf(pattern_Variant) != -1) {
                    return BINARY;
                }
            } else {
                if (pattern_Variant == '2') {
                    return COMPUTATIONAL_4;
                }
                if ("O_X_Y".indexOf(pattern_Variant) != -1) {
                    return BINARY;
                }
            }
            return COMPUTATIONAL;
        }
        if (usageAfterConversion == 'R') {
            if (pattern == PacbasePattern.BATCH) {
                if (pattern_Variant == 'U' && generatedLanguage == PacGeneratedLanguageValues._D_LITERAL) {
                    return BINARY_SYNC_RIGHT;
                }
            } else if ("3_Z".indexOf(pattern_Variant) != -1) {
                return COMPUTATIONAL_4;
            }
            return COMP_SYNC_RIGHT;
        }
        if (usageAfterConversion == 'T') {
            if (pattern == PacbasePattern.BATCH) {
                return COMP_3_PK_SYNC;
            }
            return COMPUTATIONAL_3;
        }
        if (usageAfterConversion == 'I' && pattern_Variant == 'U') {
            return DISPLAY_1;
        }
        return "";
    }
}

