/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.lal.util.converter;

import com.ibm.pdp.mdl.pacbase.PacTimestampFractionValues;
import com.ibm.pdp.mdl.pacbase.PacTimezoneValues;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacDateFormat;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacNumericFormat;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationDataElementType;

public abstract class PacFormat {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private char fieldCobolType = (char)78;
    private char fieldAlphanumericDelimiter = (char)39;
    private char fieldCountryDateFormat = (char)69;
    private char fieldDecimalPointDelimiter = (char)46;
    public static final char NO_GENERATION = 'N';
    public static final char ENGLISH = 'E';
    public static final char FRENCH = 'F';
    public static final char DECIMALPOINT = '.';
    public static final char DECIMALCOMMA = ',';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    private char fieldGeneratedLanguage = (char)68;
    public static final char COBOL = 'C';
    public static final char COBOL_85 = 'D';
    public static final char COBOL_VAR_IBM_MVS = '0';
    public static final char COBOL_VAR_IBM_DOS = '1';
    public static final char COBOL_VAR_PC_MICROFOCUS = '3';
    public static final char COBOL_VAR_BULL_DPS7 = '4';
    public static final char COBOL_VAR_BULL_DPS8 = '5';
    public static final char COBOL_VAR_UNISYS_A = '8';
    public static final char COBOL_VAR_TANDEM = 'F';
    public static final char COBOL_VAR_ICL_2900 = 'K';
    public static final char COBOL_VAR_IBM_AS400 = 'O';
    public static final char COBOL_VAR_UNISYS_1100 = 'U';
    public static final char COBOL_VAR_IBM_COBOLII = 'X';
    public static final char COBOL_VAR_AIX = 'Z';
    private static int fieldTotalLength = 1;
    public static final char ALPHABETIC = 'A';
    public static final char LOWER_ALPHABETIC = 'L';
    public static final char UPPER_ALPHABETIC = 'U';
    public static final char NUMERIC = '9';
    public static final char B_NUMERIC = 'B';
    public static final char Z_NUMERIC = 'Z';
    public static final char NO_CONTROL = '0';

    public int getInternalLength(char language) {
        boolean b;
        int totalLength;
        int result = totalLength = fieldTotalLength;
        if (!(this instanceof PacNumericFormat)) {
            if (!(this instanceof PacDateFormat)) {
                return result;
            }
            char pictureDate = ((PacDateFormat)this).getFormat();
            PacTimestampFractionValues nbSec = ((PacDateFormat)this).getNbSec();
            int nbSecI = 0;
            PacTimezoneValues timezone = ((PacDateFormat)this).getTimezone();
            if (pictureDate == 'I' || pictureDate == 'D') {
                result = 6;
            } else if (pictureDate == 'E' || pictureDate == 'C' || pictureDate == 'S' || pictureDate == 'T') {
                result = 8;
            } else if (pictureDate == 'M' || pictureDate == 'G') {
                result = 10;
            } else if (pictureDate == 'X') {
                if (((Object)((Object)timezone)).equals((Object)PacTimezoneValues._FALSE_LITERAL)) {
                    if (nbSec == PacTimestampFractionValues._0_LITERAL) {
                        result = 19;
                    } else {
                        nbSecI = PacTransformationDataElementType.transformFraction(nbSec);
                        result = 19 + (nbSecI + 1);
                    }
                }
                if (((Object)((Object)timezone)).equals((Object)PacTimezoneValues._TRUE_LITERAL)) {
                    if (nbSec == PacTimestampFractionValues._0_LITERAL) {
                        result = 26;
                    } else {
                        nbSecI = PacTransformationDataElementType.transformFraction(nbSec);
                        result = 26 + (nbSecI + 1);
                    }
                }
            }
            if (language == 'B' || language == '8') {
                return 2 * result;
            }
            return result;
        }
        char usage = ((PacNumericFormat)this).getUsage();
        int decimalLength = ((PacNumericFormat)this).getDecimalLength();
        boolean isSigned = ((PacNumericFormat)this).isSigned();
        boolean bl = b = (language == 'B' || language == '8') && usage != 'A' && usage != 'E' && usage != 'N';
        if (usage == '5' || usage == '0') {
            result = 2;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'J' && (language == '8' || language == 'B')) {
            result = 6;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'Y' || usage == '6' || usage == 'F' || usage == 'J') {
            result = 4;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'W') {
            result = 8;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'U') {
            result = 10;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (isSigned && (usage == 'B' || usage == 'T' || usage == '1' || usage == 'L' || usage == '7' || usage == '8' || usage == '9' || usage == 'X' || usage == 'N' || usage == '3' && language == 'B')) {
            ++result;
        }
        if (usage == 'B' && language != 'U' || usage == 'L') {
            result = 6;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'B' && language == 'U') {
            if (result < 10) {
                result = 1;
            } else if (result < 19) {
                result = 2;
            } else if (result < 28) {
                result = 3;
            } else if (result < 37) {
                result = 4;
            } else if (result < 46) {
                result = 5;
            } else if (result < 55) {
                result = 6;
            } else if (result < 64) {
                result = 7;
            } else if (result < 73) {
                result = 8;
            }
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'C' || language == 'R') {
            result = result < 5 ? 2 : (result < 10 ? 4 : 8);
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'G' && language != '3' && language != 'R') {
            result = result < 10 ? 4 : 8;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'G' && (language == '3' || language == 'R')) {
            result = result < 5 ? 2 : (result < 10 ? 4 : 8);
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'M') {
            result = result <= 14 ? 10 : 20;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'P' && language == '8') {
            result = result < 12 ? 6 : 12;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'P' && language != '8') {
            result = result < 9 ? 6 : 12;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'Q') {
            result = (totalLength -= decimalLength) == 0 && decimalLength < 9 || totalLength < 4 && decimalLength < 6 || totalLength < 6 && decimalLength < 4 || totalLength < 9 && decimalLength == 0 ? 6 : 12;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'S') {
            result = result < 7 ? 4 : (result < 14 ? 8 : 12);
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'T') {
            if (result >= 5) {
                result = result < 9 ? 6 : (result < 13 ? 9 : 12);
            }
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'H' && language == 'U') {
            if (result != 1) {
                if (result == 3) {
                    result = 2;
                } else if (result < 10) {
                    result /= 2;
                } else if (result < 11) {
                    result = 4;
                } else if (result < 14) {
                    result = 5;
                } else if (result < 16) {
                    result = 6;
                } else if (result < 19) {
                    result = 7;
                }
            }
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'H' && language == 'K') {
            if (++result == 10 || result == 12 || result > 13) {
                result /= 2;
                --result;
            } else {
                result /= 2;
            }
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == '3') {
            result /= 2;
            ++result;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == '4' || usage == '8' || usage == '9') {
            ++result;
            result /= 2;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == '7') {
            result = 8;
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'O') {
            if (result >= 3) {
                if (result == 3) {
                    result = 2;
                } else if (result < 6) {
                    result = 3;
                } else if (result == 6) {
                    result = 4;
                } else if (result < 9) {
                    result = 5;
                } else if (result < 11) {
                    result = 6;
                } else if (result < 13) {
                    result = 7;
                } else if (result < 15) {
                    result = 8;
                } else if (result == 15) {
                    result = 9;
                } else if (result < 18) {
                    result = 10;
                } else if (result == 18) {
                    result = 11;
                }
            }
            if (b) {
                return 2 * result;
            }
            return result;
        }
        if (usage == 'R') {
            if (result < 5) {
                return 2;
            }
            if (result < 10) {
                return 4;
            }
            return 8;
        }
        if (b) {
            return 2 * result;
        }
        return result;
    }

    public int getTotalLength() {
        return fieldTotalLength;
    }

    public void setTotalLength(int totalLength) {
        fieldTotalLength = totalLength;
    }
}

