/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.lal.util;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataDefinition;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.pacbase.PacBlankWhenZeroValues;
import com.ibm.pdp.mdl.pacbase.PacDLine;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementInternalUsageValues;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacRadicalEntity;
import com.ibm.pdp.mdl.pacbase.converter.PacDelimiterConverter;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacDateFormat;
import com.ibm.pdp.mdl.pacbase.lal.util.converter.PacNumericFormat;
import com.ibm.pdp.mdl.pacbase.util.PacExtensionsUtilities;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationDataElementType;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationInternalUsage;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationProgramVariantType;
import com.ibm.pdp.mdl.pacbase.util.PacbasePattern;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacbaseLalDescription {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String FILLER = "FILLER";
    public static final char DISPLAY_USAGE = 'D';
    public static final String DATA_TYPE = "R";
    public static final String INTERNAL_FORMAT = "I";
    public static final String INPUT_FORMAT = "E";
    public static final String OUTPUT_FORMAT = "S";
    public static final int currentLevelinitialvalue = 10;
    static final String _REDEFINES = "R*";
    private static char ConvertedUsage = (char)68;
    private int level = -1;
    private String name = "";
    private String Label = "";
    private String relLabel = "";
    private String internalFormat = "";
    private boolean isInternalFormatDate = false;
    private String inputFormat = "";
    private boolean isInputFormatDate = false;
    private String outputFormat = "";
    private boolean isOutputFormatDate = false;
    private boolean isBlankWhenZero = false;
    private char usage = (char)68;
    private char usageAfterConversion = (char)32;
    private String defaultValue = "";
    private String Tyrub = "";
    private int internalPos = 1;
    private int inputPos = 1;
    private int outputPos = 1;
    private int internalLength = 0;
    private int inputLength = 0;
    private int outputLength = 0;
    private boolean redefines = false;
    private boolean isSegment = false;
    private int occurs = 1;
    private String sortKey = "";
    private PacbaseLalDescription parent = null;
    private int _nbElementaryFields = 0;
    private int _nbDataElements = 0;
    private int _nbDataElementsInGroup = 0;
    private int _nbSegmentCalls = 0;
    private ArrayList<PacbaseLalDescription> children = new ArrayList();
    private Entity entity;
    private char currentDElibVariant;
    private GenerationContext generationContext = new GenerationContext();
    private int nextInternalAddress;
    private int nextInputAddress;
    private int nextOutputAddress;
    private boolean isLargeObject = false;
    private boolean isFirstOnRedefines = false;
    private PacbaseLalDescription firstofRedefines = null;
    private DataUnionDescription dud = null;
    private boolean containsOnlyDud = false;

    public PacbaseLalDescription() {
        this.currentDElibVariant = this.generationContext.getGenerationParameterVariant();
    }

    public PacbaseLalDescription(GenerationContext ctx) {
        this();
        this.generationContext = ctx;
        this.currentDElibVariant = this.generationContext.getGenerationParameterVariant();
    }

    public static int getLength(PacPictureParser pictureParser, char usg, char varia, boolean internalFormat) {
        ConvertedUsage = '\u0000';
        String usageStri = new String(new StringBuffer().append(usg).toString());
        if (usageStri.equals("F") || usageStri.equals("W") || usageStri.equals("Y") || usageStri.equals("J") || usageStri.equals("U") || usageStri.equals("0") || usageStri.equals("5") || usageStri.equals("6")) {
            PacNumericFormat nf = new PacNumericFormat(pictureParser.getCapacity(), pictureParser.getDecimals(), pictureParser.hasSign(), usg, varia);
            if (internalFormat) {
                ConvertedUsage = nf.getUsage();
            }
            return nf.getTotalLength();
        }
        if (pictureParser.isNumeric()) {
            PacNumericFormat nf = new PacNumericFormat(pictureParser.getCapacity(), pictureParser.getDecimals(), pictureParser.hasSign(), usg, varia);
            if (internalFormat) {
                ConvertedUsage = nf.getUsage();
            }
            return nf.getTotalLength();
        }
        if (pictureParser.isDate()) {
            PacDateFormat df = null;
            df = pictureParser.getDateFormat() != 'X' ? new PacDateFormat(pictureParser.getDateFormat(), pictureParser.getDateSeparator(), varia) : new PacDateFormat(pictureParser.getDateFormat(), pictureParser.getDateSeparator(), varia, pictureParser.getNbSec(), pictureParser.getTimezone());
            return df.getTotalLength();
        }
        if (pictureParser.isAlphanumeric()) {
            return pictureParser.getCapacity();
        }
        if (pictureParser.isAlphabetic()) {
            return pictureParser.getCapacity();
        }
        return 0;
    }

    private int getCobolLength(DataElementDescription kde, String formattype) {
        int len = 0;
        PacDataElementDescription pacExt = PacExtensionsUtilities.GetPacDEExtension(kde);
        if (pacExt != null) {
            PacPictureParser pictureParser = null;
            if (formattype.equalsIgnoreCase(INTERNAL_FORMAT)) {
                char usageAtBeginning = this.usageAfterConversion;
                ConvertedUsage = this.usageAfterConversion == ' ' ? this.usage : this.usageAfterConversion;
                pictureParser = new PacPictureParser(PacExtensionsUtilities.GetInternalFormat(pacExt), PacExtensionsUtilities.GetInternalSecond(pacExt), PacExtensionsUtilities.GetInternalTimezone(pacExt));
                char usge = 'D';
                usge = PacTransformationInternalUsage.transformInternalUsage(pacExt.getInternalUsage(), pacExt.getParent()).charAt(0);
                len = usageAtBeginning != ' ' && usageAtBeginning != usge ? PacbaseLalDescription.getLength(pictureParser, usageAtBeginning, this.getVariant(this.generationContext), true) : PacbaseLalDescription.getLength(pictureParser, usge, this.getVariant(this.generationContext), true);
                this.usageAfterConversion = ConvertedUsage != '\u0000' ? ConvertedUsage : usge;
                this.isInternalFormatDate = pictureParser.isDate();
                if (this.usageAfterConversion != usageAtBeginning) {
                    usageAtBeginning = this.usageAfterConversion;
                }
                if (len == 0 && pacExt.getParent() != null) {
                    DataElement parentDe = pacExt.getParent();
                    len = this.getCobolLength((DataElementDescription)parentDe.getDataDescription(), formattype);
                    if (!((Object)((Object)pacExt.getInternalUsage())).equals((Object)PacDataElementInternalUsageValues._INHERITED_LITERAL) && this.usageAfterConversion != usageAtBeginning) {
                        this.usageAfterConversion = usageAtBeginning;
                    }
                }
            } else if (formattype.equalsIgnoreCase(INPUT_FORMAT)) {
                if (pacExt.getInputFormat().trim().length() == 0) {
                    if (pacExt.getParent() != null) {
                        DataElement parentDe = pacExt.getParent();
                        len = this.getCobolLength((DataElementDescription)parentDe.getDataDescription(), formattype);
                    } else {
                        pictureParser = new PacPictureParser(PacExtensionsUtilities.GetInternalFormat(pacExt), PacExtensionsUtilities.GetInternalSecond(pacExt), PacExtensionsUtilities.GetInternalTimezone(pacExt));
                        len = PacbaseLalDescription.getLength(pictureParser, 'D', this.getVariant(this.generationContext), false);
                    }
                } else {
                    pictureParser = new PacPictureParser(PacExtensionsUtilities.GetInputFormat(pacExt), PacExtensionsUtilities.GetInputSecond(pacExt), PacExtensionsUtilities.GetInputTimezone(pacExt));
                    len = PacbaseLalDescription.getLength(pictureParser, 'D', this.getVariant(this.generationContext), false);
                    this.isInputFormatDate = pictureParser.isDate();
                }
            } else {
                DataElement parentDE;
                DataElementDescription dataD;
                PacDataElementDescription pacExtPar;
                if (pacExt.getOutputFormat().trim().length() == 0) {
                    if (pacExt.getParent() != null) {
                        DataElement parentDe = pacExt.getParent();
                        len = this.getCobolLength((DataElementDescription)parentDe.getDataDescription(), formattype);
                    } else {
                        pictureParser = new PacPictureParser(PacExtensionsUtilities.GetInternalFormat(pacExt), PacExtensionsUtilities.GetInternalSecond(pacExt), PacExtensionsUtilities.GetInternalTimezone(pacExt));
                        len = PacbaseLalDescription.getLength(pictureParser, 'D', this.getVariant(this.generationContext), false);
                    }
                } else {
                    pictureParser = new PacPictureParser(PacExtensionsUtilities.GetOutputFormat(pacExt), PacExtensionsUtilities.GetOutputSecond(pacExt), PacExtensionsUtilities.GetOutputTimezone(pacExt));
                    len = PacbaseLalDescription.getLength(pictureParser, 'D', this.getVariant(this.generationContext), false);
                    this.isOutputFormatDate = pictureParser.isDate();
                }
                if (((Object)((Object)pacExt.getBlkWhenZero())).equals((Object)PacBlankWhenZeroValues._TRUE_LITERAL)) {
                    this.isBlankWhenZero = true;
                } else if (((Object)((Object)pacExt.getBlkWhenZero())).equals((Object)PacBlankWhenZeroValues._FALSE_LITERAL)) {
                    this.isBlankWhenZero = false;
                } else if (pacExt.getParent() != null && (pacExtPar = PacExtensionsUtilities.GetPacDEExtension(dataD = (DataElementDescription)(parentDE = pacExt.getParent()).getDataDescription())) != null && dataD != null) {
                    if (((Object)((Object)pacExtPar.getBlkWhenZero())).equals((Object)PacBlankWhenZeroValues._TRUE_LITERAL)) {
                        this.isBlankWhenZero = true;
                    }
                    if (((Object)((Object)pacExtPar.getBlkWhenZero())).equals((Object)PacBlankWhenZeroValues._FALSE_LITERAL)) {
                        this.isBlankWhenZero = false;
                    }
                }
            }
        }
        return len;
    }

    private int getCobolLength(Filler filler, String formattype) {
        int len = 0;
        PacFiller pacFil = PacExtensionsUtilities.GetPacFillerExtension((DataComponent)filler);
        if (pacFil != null) {
            PacPictureParser pictureParser = null;
            pictureParser = new PacPictureParser(pacFil.getFormat());
            char usge = 'D';
            try {
                usge = PacTransformationInternalUsage.transformInternalUsage(pacFil.getUsage(), null).charAt(0);
            }
            catch (Exception exception) {}
            len = PacbaseLalDescription.getLength(pictureParser, usge, this.getVariant(this.generationContext), INTERNAL_FORMAT.equals(formattype));
            if (INPUT_FORMAT.equals(formattype)) {
                this.isInputFormatDate = pictureParser.isDate();
            } else if (INTERNAL_FORMAT.equals(formattype)) {
                this.usageAfterConversion = ConvertedUsage != '\u0000' ? ConvertedUsage : usge;
                this.isInternalFormatDate = pictureParser.isDate();
            } else if (OUTPUT_FORMAT.equals(formattype)) {
                this.isOutputFormatDate = pictureParser.isDate();
            }
        }
        return len;
    }

    public PacbaseLalDescription(DataAggregate da, GenerationContext ctx) {
        this(ctx);
        this.entity = da;
    }

    public PacbaseLalDescription(DataElement de, GenerationContext ctx) {
        this(ctx);
        this.entity = de;
        Iterator it2 = de.getExtensions().iterator();
        PacRadicalEntity pre = null;
        while (it2.hasNext() && pre == null) {
            RadicalEntityExtension ree = (RadicalEntityExtension)it2.next();
            if (!(ree instanceof PacRadicalEntity)) continue;
            pre = (PacRadicalEntity)ree;
        }
        if (pre != null && pre.getGenerationParameter() != null) {
            this.currentDElibVariant = PacTransformationProgramVariantType.transformProgramVariant(pre.getGenerationParameter().getCobolType()).charAt(0);
        }
    }

    public PacbaseLalDescription(DataElementDescription ded, GenerationContext ctx) {
        this(ctx);
        this.entity = ded;
        this.setName(ded.getName());
        this.setLabel(ded.getLabel());
    }

    public PacbaseLalDescription(DataCall dc, GenerationContext ctx) {
        this(ctx);
        this.entity = dc;
    }

    public PacbaseLalDescription(DataAggregateDescription dad, GenerationContext ctx) {
        this(ctx);
        this.entity = dad;
    }

    public PacbaseLalDescription(Filler filler, GenerationContext ctx) {
        this(ctx);
        ConvertedUsage = (char)68;
        this.entity = filler;
        RadicalEntity re = filler.getOwner();
        if (re != null && re instanceof DataAggregate) {
            Iterator it2 = re.getExtensions().iterator();
            PacRadicalEntity pre = null;
            while (it2.hasNext() && pre == null) {
                RadicalEntityExtension ree = (RadicalEntityExtension)it2.next();
                if (!(ree instanceof PacRadicalEntity)) continue;
                pre = (PacRadicalEntity)ree;
            }
            if (pre != null && pre.getGenerationParameter() != null) {
                this.currentDElibVariant = PacTransformationProgramVariantType.transformProgramVariant(pre.getGenerationParameter().getCobolType()).charAt(0);
            }
        }
    }

    public int getLevel() {
        return this.level;
    }

    void setLevel(int level) {
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.Label;
    }

    void setLabel(Object objet) {
        String label = "";
        if (objet instanceof DataElement) {
            DataElement de = (DataElement)objet;
            if (de.getLabel().trim().length() == 0) {
                if (((DataElement)objet).getDataDescription() != null) {
                    this.setLabel(((DataElement)objet).getDataDescription());
                }
            } else {
                this.setLabel(de.getLabel());
            }
        } else {
            if (objet instanceof DataElementDescription) {
                DataElementDescription deDesc = (DataElementDescription)objet;
                if (deDesc.getLabel().trim().length() == 0) {
                    PacDataElementDescription pacExt = PacExtensionsUtilities.GetPacDEExtension(deDesc);
                    if (pacExt != null && pacExt.getParent() != null) {
                        label = pacExt.getParent().getLabel();
                    }
                } else {
                    label = deDesc.getLabel();
                }
            }
            this.setLabel(label);
        }
    }

    void setLabel(String label) {
        this.Label = label;
    }

    public String getTyrub() {
        return this.Tyrub;
    }

    void setTyrub(Object objet) {
        String tyrub = DATA_TYPE;
        if (objet instanceof DataElement) {
            if (((DataElement)objet).getDataDescription() != null) {
                this.setTyrub(((DataElement)objet).getDataDescription());
            }
        } else if (objet instanceof DataElementDescription) {
            DataElementDescription deDesc = (DataElementDescription)objet;
            PacDataElementDescription pacExt = PacExtensionsUtilities.GetPacDEExtension(deDesc);
            if (pacExt != null) {
                if (pacExt.getParent() != null && pacExt.getType() == PacDataElementTypeValues._INHERITED_LITERAL) {
                    this.setTyrub(pacExt.getParent());
                } else {
                    this.setTyrub(PacTransformationDataElementType.transformDataElementType(pacExt.getType()));
                }
            }
        } else {
            this.setTyrub(tyrub);
        }
    }

    void setTyrub(String tyrub) {
        this.Tyrub = tyrub;
    }

    public String getFormat(String formatType) {
        if (INPUT_FORMAT.equals(formatType)) {
            return this.getInputFormat();
        }
        if (INTERNAL_FORMAT.equals(formatType)) {
            return this.getInternalFormat();
        }
        if (OUTPUT_FORMAT.equals(formatType)) {
            return this.getOutputFormat();
        }
        return "";
    }

    public String getInternalFormat() {
        return this.internalFormat;
    }

    void setInternalFormat(String internalFormat) {
        this.internalFormat = internalFormat;
    }

    public int getInternalAddress() {
        return this.internalPos;
    }

    public void setInternalAddress(int pos) {
        this.internalPos = pos;
    }

    public int getNextInternalAddress() {
        return this.nextInternalAddress;
    }

    public boolean isFirstOnRedefines() {
        return this.isFirstOnRedefines;
    }

    public void setFirstOnRedefines(boolean isFirstOnRedefines) {
        this.isFirstOnRedefines = isFirstOnRedefines;
    }

    public PacbaseLalDescription getFirstofRedefines() {
        return this.firstofRedefines;
    }

    public void setFirstofRedefines(PacbaseLalDescription firstofRedefines) {
        this.firstofRedefines = firstofRedefines;
    }

    public DataUnionDescription getDud() {
        return this.dud;
    }

    public void setDud(DataUnionDescription dud) {
        this.dud = dud;
    }

    public boolean containsOnlyDud() {
        return this.containsOnlyDud;
    }

    public void setContainsOnlyDud(boolean containsOnlyDud) {
        this.containsOnlyDud = containsOnlyDud;
    }

    public void setNextInternalAddress(int nextInternalAddress) {
        this.nextInternalAddress = nextInternalAddress;
    }

    public int getNextInputAddress() {
        return this.nextInputAddress;
    }

    public void setNextInputAddress(int nextInputAddress) {
        this.nextInputAddress = nextInputAddress;
    }

    public int getNextOutputAddress() {
        return this.nextOutputAddress;
    }

    public void setNextOutputAddress(int nextOutputAddress) {
        this.nextOutputAddress = nextOutputAddress;
    }

    public int getOccurs() {
        return this.occurs;
    }

    void setOccurs(int occurs) {
        this.occurs = occurs;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public int getInternalLength() {
        return this.internalLength;
    }

    void setInternalLength(int length) {
        this.internalLength = length;
    }

    void setLength(DataElement de, String format) {
        int length = this.getCobolLength((DataElementDescription)de.getDataDescription(), format);
        if (this.isLargeObject) {
            length = 0;
        }
        if (INPUT_FORMAT.equals(format)) {
            this.setInputLength(length);
        } else if (INTERNAL_FORMAT.equals(format)) {
            this.setInternalLength(length);
        } else if (OUTPUT_FORMAT.equals(format)) {
            this.setOutputLength(length);
        }
    }

    void setLength(DataElementDescription ded, String format) {
        int length = this.getCobolLength(ded, format);
        if (INPUT_FORMAT.equals(format)) {
            this.setInputLength(length);
        } else if (INTERNAL_FORMAT.equals(format)) {
            this.setInternalLength(length);
        } else if (OUTPUT_FORMAT.equals(format)) {
            this.setOutputLength(length);
        }
    }

    void setLength(Filler fil, String format) {
        int length = this.getCobolLength(fil, format);
        if (INPUT_FORMAT.equals(format)) {
            this.setInputLength(length);
        } else if (INTERNAL_FORMAT.equals(format)) {
            this.setInternalLength(length);
        } else if (OUTPUT_FORMAT.equals(format)) {
            this.setOutputLength(length);
        }
    }

    void setLength(DataCall dc) {
        int length = 0;
        this.setInputLength(length);
        this.setInternalLength(length);
    }

    void setLength(DataAggregateDescription dad) {
        int length = 0;
        this.setInputLength(length);
        this.setInternalLength(length);
    }

    public boolean getRedefines() {
        return this.redefines;
    }

    void setRedefines(boolean redefines) {
        this.redefines = redefines;
    }

    public String getUsage() {
        return String.valueOf(this.usage);
    }

    public String getUsageAfterConversion() {
        return String.valueOf(this.usageAfterConversion);
    }

    public String getDefaultValue(String formatType) {
        if (this.defaultValue.trim().length() > 0) {
            return this.getTranscodedValue(this.defaultValue);
        }
        PacPictureParser ppp = null;
        if (INPUT_FORMAT.equals(formatType)) {
            ppp = new PacPictureParser(this.getInputFormat());
        } else if (INTERNAL_FORMAT.equals(formatType)) {
            if (this.getEntity() != null && this.getEntity() instanceof DataElement) {
                if (this.usageAfterConversion == PacDataElementInternalUsageValues._Y_LITERAL.getLiteral().charAt(1)) {
                    return "NULL";
                }
                if (this.usageAfterConversion == PacDataElementInternalUsageValues._W_LITERAL.getLiteral().charAt(1)) {
                    return "ZERO";
                }
            }
            ppp = new PacPictureParser(this.getRealFormat(this.getInternalFormat()));
        } else if (OUTPUT_FORMAT.equals(formatType)) {
            ppp = new PacPictureParser(this.getOutputFormat());
        }
        if (ppp.isNumeric()) {
            int ww11Usagei;
            String format = "";
            if (INTERNAL_FORMAT.equals(formatType)) {
                format = this.internalFormat;
            }
            if (INPUT_FORMAT.equals(formatType)) {
                format = this.inputFormat;
            }
            if (OUTPUT_FORMAT.equals(formatType)) {
                format = this.outputFormat;
            }
            if ((ww11Usagei = format.startsWith(OUTPUT_FORMAT) || format.startsWith("9") || format.startsWith("Z") || format.startsWith("V") || format.startsWith("1") || this.usage != 'D' && (this.usage != '2' || this.getVariant(this.generationContext) == 'P') && this.usage != ' ' ? 57 : 88) == 57 || this.outputFormat.startsWith("+") || this.outputFormat.startsWith("-")) {
                return "ZERO";
            }
            return "SPACE";
        }
        return "SPACE";
    }

    void setUsage(char usage) {
        this.usage = usage;
    }

    private char getCobolUsage(DataElementDescription kde) {
        PacDataElementDescription pacExt = PacExtensionsUtilities.GetPacDEExtension(kde);
        char usage = 'D';
        try {
            usage = PacTransformationInternalUsage.transformInternalUsage(pacExt.getInternalUsage(), pacExt.getParent()).charAt(0);
        }
        catch (Exception exception) {}
        return usage;
    }

    void setUsage(DataElement de) {
        this.setUsage(this.getCobolUsage((DataElementDescription)de.getDataDescription()));
    }

    void setUsage(DataElementDescription ded) {
        this.setUsage(this.getCobolUsage(ded));
    }

    void setValue(String value) {
        this.defaultValue = value;
    }

    void setUsage(Filler fil) {
        PacFiller pFiller = PacExtensionsUtilities.GetPacFillerExtension((DataComponent)fil);
        if (pFiller != null) {
            this.setUsage(PacTransformationInternalUsage.transformInternalUsage(pFiller.getUsage(), null).charAt(0));
        } else {
            this.setUsage('D');
        }
    }

    private char getVariant(GenerationContext ctx) {
        String pattern_generationVariant = String.valueOf(ctx.getPatternVariant());
        char patternLibrary_generationVariant = ctx.getGenerationParameterVariant();
        if (this.usage == 'Y' && pattern_generationVariant.equals("4") || "J_F_Y_1_W_8_0".indexOf(this.usage) != -1 && pattern_generationVariant.equals("5") || this.usage == 'J' && pattern_generationVariant.equals("8") || this.usage == 'H' && pattern_generationVariant.equals("K") || "H_U_W_1_I_O".indexOf(this.usage) != -1 && pattern_generationVariant.equals("U") || "F_1_W".indexOf(this.usage) != -1 && (pattern_generationVariant.equals("3") || pattern_generationVariant.equals("Q")) || this.currentDElibVariant == patternLibrary_generationVariant) {
            return 'N';
        }
        return ctx.getGenerationParameterVariant();
    }

    public String getComments(GenerationContext ctx) {
        if ("L".equals(this.Tyrub)) {
            if (GenerationContext.BlocType.DB2 == ctx.getBlocType()) {
                switch (this.usageAfterConversion) {
                    case '1': {
                        StringBuilder result = new StringBuilder("USAGE SQL TYPE IS BLOB (");
                        result.append(this.getInternalFormat());
                        result.append(")");
                        return result.toString();
                    }
                    case '2': {
                        StringBuilder result = new StringBuilder("USAGE SQL TYPE IS CLOB (");
                        result.append(this.getInternalFormat());
                        result.append(")");
                        return result.toString();
                    }
                    case '3': {
                        StringBuilder result = new StringBuilder("USAGE SQL TYPE IS DBCLOB (");
                        result.append(this.getInternalFormat());
                        result.append(")");
                        return result.toString();
                    }
                    case '4': {
                        return "USAGE SQL TYPE IS BLOB-LOCATOR";
                    }
                    case '5': {
                        return "USAGE SQL TYPE IS CLOB-LOCATOR";
                    }
                    case '6': {
                        return "USAGE SQL TYPE IS DBCLOB-LOCATOR";
                    }
                    case '7': {
                        return "USAGE SQL TYPE IS BLOB-FILE";
                    }
                    case '8': {
                        return "USAGE SQL TYPE IS BLOB-FILE";
                    }
                    case '9': {
                        return "USAGE SQL TYPE IS BLOB-FILE";
                    }
                }
            } else if (GenerationContext.BlocType.ORACLE == ctx.getBlocType()) {
                switch (this.usageAfterConversion) {
                    case '1': {
                        return "SQL-BLOB";
                    }
                    case '2': {
                        return "SQL-CLOB";
                    }
                    case '3': {
                        return "SQL-BFILE";
                    }
                }
            }
            return "";
        }
        return PacNumericFormat.GetCommentsForUsage(this.usageAfterConversion, ctx.getPatternVariant(), ctx.getGeneratedLanguage(), ctx.getPattern());
    }

    public String getRealFormat(String currentFormat) {
        if (this.usageAfterConversion == 'C') {
            if (this.usage == '0' || this.usage == '5') {
                return "S9(4)";
            }
            if (this.usage == '6' || this.usage == 'J' || this.usage == 'U' || this.usage == 'Y') {
                return "S9(8)";
            }
        }
        return currentFormat;
    }

    public ArrayList<PacbaseLalDescription> getChildren(boolean withAddresses) {
        if (withAddresses) {
            this.setInternalAddresses(this.children, 1, 1);
            this.setInputAddresses(this.children, 1, 1);
            this.setOutputAddresses(this.children, 1, 1);
        }
        return this.children;
    }

    public ArrayList<PacbaseLalDescription> getChildren() {
        return this.getChildren(false);
    }

    void setChildren(ArrayList<PacbaseLalDescription> children) {
        this.children = children;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getLevelDisplay() {
        int j = this.getLevel() - 10;
        StringBuilder sb = new StringBuilder(10);
        int i = 0;
        while (i < sb.capacity()) {
            sb.append(" ");
            ++i;
        }
        if (j < sb.capacity() - 1) {
            sb.replace(j, j + 1, String.valueOf(this.getLevel()));
        } else {
            sb.replace(sb.capacity() - 1, sb.capacity(), String.valueOf(this.getLevel()));
        }
        return sb.toString();
    }

    public String getRedefinesDisplay() {
        return this.getRedefines() ? _REDEFINES : "";
    }

    public String getOccursDisplay() {
        return this.getOccurs() == 0 ? "" : String.valueOf(this.getOccurs());
    }

    private int setInternalAddresses(ArrayList<PacbaseLalDescription> lines, int internalAddress, int previousOccurs) {
        PacbaseLalDescription previousLal = null;
        int i = 0;
        while (i < lines.size()) {
            int occurs;
            PacbaseLalDescription lal = lines.get(i);
            int n = occurs = lal.getOccurs() == 0 ? previousOccurs : previousOccurs * lal.getOccurs();
            if (i > 0) {
                previousLal = lines.get(i - 1);
                if (previousLal.isFirstOnRedefines()) {
                    if (previousLal.getParent() == null && lal.getParent() == null || previousLal.getParent() != null && lal.getParent() != null && previousLal.getParent() == lal.getParent()) {
                        lal.setFirstofRedefines(previousLal);
                        previousLal.setNextInternalAddress(internalAddress);
                    }
                } else if (lal.getRedefines()) {
                    lal.setFirstofRedefines(previousLal.getFirstofRedefines());
                } else {
                    lal.setFirstofRedefines(null);
                    if (!lal.getChildren().isEmpty()) {
                        boolean sameDud = true;
                        DataUnionDescription currentdud = null;
                        DataUnionDescription previousdud = null;
                        for (PacbaseLalDescription lalinDud : lal.getChildren()) {
                            currentdud = lalinDud.getDud();
                            if (currentdud == null || previousdud != null && previousdud != currentdud) {
                                sameDud = false;
                                break;
                            }
                            if (sameDud && lal.getDud() != null && currentdud != null && lal.getDud() != currentdud) {
                                sameDud = false;
                                break;
                            }
                            previousdud = currentdud;
                        }
                        if (sameDud) {
                            lal.setContainsOnlyDud(true);
                            lal.setFirstofRedefines(lal.getChildren().get(0));
                        }
                    }
                }
            }
            if (lal.getFirstofRedefines() != null) {
                lal.setNextInternalAddress(previousLal.getNextInternalAddress() + lal.getFirstofRedefines().getInternalLength() * occurs);
            } else if (Integer.parseInt(lal.getTotalInternalLength()) > lal.getInternalLength()) {
                lal.setNextInternalAddress(internalAddress + Integer.parseInt(lal.getTotalInternalLength()) * occurs);
            } else {
                lal.setNextInternalAddress(internalAddress + lal.getInternalLength() * occurs);
            }
            if (lal.getRedefines()) {
                lal.setInternalAddress(lal.getFirstofRedefines().getInternalAddress());
            } else {
                lal.setInternalAddress(internalAddress);
                if (previousLal != null && previousLal.getFirstofRedefines() != null) {
                    if (previousLal.getRedefines() && !lal.isFirstOnRedefines()) {
                        lal.setInternalAddress(previousLal.getFirstofRedefines().getNextInternalAddress());
                        lal.setNextInternalAddress(lal.getInternalAddress() + lal.getInternalLength() * occurs);
                    }
                    if (!previousLal.getRedefines() && !previousLal.isFirstOnRedefines() && previousLal.containsOnlyDud()) {
                        lal.setInternalAddress(previousLal.getFirstofRedefines().getNextInternalAddress());
                    }
                    if (previousLal.getRedefines() && lal.getDud() != previousLal.getDud()) {
                        lal.setInternalAddress(previousLal.getFirstofRedefines().getNextInternalAddress());
                    }
                } else if (previousLal != null && !previousLal.getRedefines() && previousLal.getNextInternalAddress() > internalAddress) {
                    lal.setInternalAddress(previousLal.getNextInternalAddress());
                }
            }
            internalAddress = lal.getChildren().isEmpty() ? lal.getInternalAddress() + occurs * lal.getInternalLength() : this.setInternalAddresses(lal.getChildren(), lal.getInternalAddress(), occurs);
            ++i;
        }
        return internalAddress;
    }

    private int setInputAddresses(ArrayList<PacbaseLalDescription> lines, int inputAddress, int previousOccurs) {
        PacbaseLalDescription previousLal = null;
        int i = 0;
        while (i < lines.size()) {
            int occurs;
            PacbaseLalDescription lal = lines.get(i);
            int n = occurs = lal.getOccurs() == 0 ? previousOccurs : previousOccurs * lal.getOccurs();
            if (i > 0) {
                previousLal = lines.get(i - 1);
                if (previousLal.isFirstOnRedefines()) {
                    if (previousLal.getParent() == null && lal.getParent() == null || previousLal.getParent() != null && lal.getParent() != null && previousLal.getParent() == lal.getParent()) {
                        lal.setFirstofRedefines(previousLal);
                        previousLal.setNextInputAddress(inputAddress);
                    }
                } else if (lal.getRedefines()) {
                    lal.setFirstofRedefines(previousLal.getFirstofRedefines());
                } else {
                    lal.setFirstofRedefines(null);
                    if (!lal.getChildren().isEmpty()) {
                        boolean sameDud = true;
                        DataUnionDescription currentdud = null;
                        DataUnionDescription previousdud = null;
                        for (PacbaseLalDescription lalinDud : lal.getChildren()) {
                            currentdud = lalinDud.getDud();
                            if (currentdud == null || previousdud != null && previousdud != currentdud) {
                                sameDud = false;
                                break;
                            }
                            if (sameDud && lal.getDud() != null && currentdud != null && lal.getDud() != currentdud) {
                                sameDud = false;
                                break;
                            }
                            previousdud = currentdud;
                        }
                        if (sameDud) {
                            lal.setContainsOnlyDud(true);
                            lal.setFirstofRedefines(lal.getChildren().get(0));
                        }
                    }
                }
            }
            if (lal.getFirstofRedefines() != null) {
                lal.setNextInputAddress(previousLal.getNextInputAddress() + lal.getFirstofRedefines().getInputLength() * occurs);
            } else if (Integer.parseInt(lal.getTotalInputLength()) > lal.getInputLength()) {
                lal.setNextInputAddress(inputAddress + Integer.parseInt(lal.getTotalInputLength()) * occurs);
            } else {
                lal.setNextInputAddress(inputAddress + lal.getInputLength() * occurs);
            }
            if (lal.getRedefines()) {
                lal.setInputAddress(lal.getFirstofRedefines().getInputAddress());
            } else {
                lal.setInputAddress(inputAddress);
                if (previousLal != null && previousLal.getFirstofRedefines() != null) {
                    if (previousLal.getRedefines() && !lal.isFirstOnRedefines()) {
                        lal.setInputAddress(previousLal.getFirstofRedefines().getNextInputAddress());
                        lal.setNextInputAddress(lal.getInputAddress() + lal.getInputLength() * occurs);
                    }
                    if (!previousLal.getRedefines() && !previousLal.isFirstOnRedefines() && previousLal.containsOnlyDud()) {
                        lal.setInputAddress(previousLal.getFirstofRedefines().getNextInputAddress());
                    }
                    if (previousLal.getRedefines() && lal.getDud() != previousLal.getDud()) {
                        lal.setInputAddress(previousLal.getFirstofRedefines().getNextInputAddress());
                    }
                } else if (previousLal != null && !previousLal.getRedefines() && previousLal.getNextInputAddress() > inputAddress) {
                    lal.setInputAddress(previousLal.getNextInputAddress());
                }
            }
            inputAddress = lal.getChildren().isEmpty() ? lal.getInputAddress() + occurs * lal.getInputLength() : this.setInputAddresses(lal.getChildren(), lal.getInputAddress(), occurs);
            ++i;
        }
        return inputAddress;
    }

    public PacbaseLalDescription getParent() {
        return this.parent;
    }

    public void setParent(PacbaseLalDescription parent) {
        this.parent = parent;
    }

    public String toString() {
        return String.valueOf(this.getLevel()) + " " + this.getName() + "(" + this.getRedefinesDisplay() + ")" + " " + this.getInternalLength() + (this.getOccurs() > 0 ? " [x " + this.getOccurs() + "] " : " ") + this.getInternalAddress();
    }

    public boolean isLargeObject() {
        return this.isLargeObject;
    }

    void setLargeObject(boolean b) {
        this.isLargeObject = b;
    }

    public int getInputAddress() {
        return this.inputPos;
    }

    public int getOutputAddress() {
        return this.outputPos;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public int getInputLength() {
        return this.inputLength;
    }

    void setInputLength(int length) {
        this.inputLength = length;
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    void setOutputLength(int length) {
        this.outputLength = length;
    }

    public void setInputAddress(int pos) {
        this.inputPos = pos;
    }

    public int getNbElementaryFields() {
        return this._nbElementaryFields;
    }

    void setNbElementaryFields(int elementaryFields) {
        this._nbElementaryFields = elementaryFields;
    }

    public int getNbDataElements() {
        return this._nbDataElements;
    }

    void setNbDataElements(int dataElements) {
        this._nbDataElements = dataElements;
    }

    public int getNbDataElementsInGroup() {
        return this._nbDataElementsInGroup;
    }

    void setNbDataElementsInGroup(int dataElementsInGroup) {
        this._nbDataElementsInGroup = dataElementsInGroup;
    }

    public int getNbSegmentCalls() {
        return this._nbSegmentCalls;
    }

    void setNbSegmentCalls(int segmentCalls) {
        this._nbSegmentCalls = segmentCalls;
    }

    public void calculateNumbers() {
        this._nbDataElements = 0;
        this._nbDataElementsInGroup = 0;
        this._nbElementaryFields = 0;
        this._nbSegmentCalls = 0;
        this.calculateNumbers(this.getChildren(), 0);
    }

    void setFormat(String type, Object object) {
        String pic = "";
        if (object instanceof DataCall) {
            DataCall dataCall = (DataCall)object;
            DataDefinition definition = dataCall.getDataDefinition();
            DataDescription description = dataCall.getDataDescription();
            if (definition != null) {
                pic = this.searchFormat(type, definition);
            } else if (description != null) {
                pic = this.searchFormat(type, description);
            }
        } else if (object instanceof Filler) {
            Filler kFiller = (Filler)object;
            if (kFiller != null && PacExtensionsUtilities.GetPacFillerExtension((DataComponent)kFiller) != null) {
                pic = PacExtensionsUtilities.GetPacFillerExtension((DataComponent)kFiller).getFormat();
            }
        } else if (object instanceof DataDefinition) {
            pic = this.searchFormat(type, (DataDefinition)object);
        }
        this.setFormat(type, pic);
    }

    void setFormat(String type, String format) {
        if (INPUT_FORMAT.equals(type)) {
            this.setInputFormat(format);
        } else if (INTERNAL_FORMAT.equals(type)) {
            this.setInternalFormat(format);
        } else if (OUTPUT_FORMAT.equals(type)) {
            this.setOutputFormat(format);
        }
    }

    void setInputFormat(Object object) {
        this.setFormat(INPUT_FORMAT, object);
    }

    void setInternalFormat(Object object) {
        this.setFormat(INTERNAL_FORMAT, object);
    }

    void setOutputFormat(Object object) {
        this.setFormat(OUTPUT_FORMAT, object);
    }

    private String searchFormat(String type, DataDefinition definition) {
        String format = "";
        EList extensions = definition.getDataDescription().getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataElementDescription) {
                if (INPUT_FORMAT.equals(type)) {
                    format = String.valueOf(format) + ((PacDataElementDescription)object).getInputFormat();
                } else if (INTERNAL_FORMAT.equals(type)) {
                    format = String.valueOf(format) + ((PacDataElementDescription)object).getInternalFormat();
                } else if (OUTPUT_FORMAT.equals(type)) {
                    format = String.valueOf(format) + ((PacDataElementDescription)object).getOutputFormat();
                }
                if (format.trim().length() != 0 || ((PacDataElementDescription)object).getParent() == null) break;
                format = this.searchFormat(type, ((PacDataElementDescription)object).getParent().getDataDescription());
                break;
            }
            ++i;
        }
        return format;
    }

    private String searchFormat(String type, DataDescription description) {
        String format = "";
        EList extensions = description.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataElementDescription) {
                if (INPUT_FORMAT.equals(type)) {
                    format = String.valueOf(format) + ((PacDataElementDescription)object).getInputFormat();
                } else if (INTERNAL_FORMAT.equals(type)) {
                    format = String.valueOf(format) + ((PacDataElementDescription)object).getInternalFormat();
                } else if (OUTPUT_FORMAT.equals(type)) {
                    format = String.valueOf(format) + ((PacDataElementDescription)object).getOutputFormat();
                }
            }
            ++i;
        }
        return format;
    }

    void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getTotalInternalLength() {
        return String.valueOf(this.calculateTotalInternalLength(this.getChildren(), 0, 1));
    }

    public String getTotalInputLength() {
        return String.valueOf(this.calculateTotalInputLength(this.getChildren(), 0, 1));
    }

    public String getTotalOutputLength() {
        return String.valueOf(this.calculateTotalOutputLength(this.getChildren(), 0, 1));
    }

    public int calculateTotalInternalLength(ArrayList<PacbaseLalDescription> lines, int totalLength, int previousOccurs) {
        int i = 0;
        while (i < lines.size()) {
            int occurs;
            PacbaseLalDescription lal = lines.get(i);
            int n = occurs = lal.getOccurs() == 0 ? previousOccurs : previousOccurs * lal.getOccurs();
            if (!lal.getRedefines()) {
                totalLength = lal.getChildren().isEmpty() ? (totalLength += occurs * lal.getInternalLength()) : this.calculateTotalInternalLength(lal.getChildren(), totalLength, occurs);
            }
            ++i;
        }
        return totalLength;
    }

    public int calculateTotalInputLength(ArrayList<PacbaseLalDescription> lines, int totalLength, int previousOccurs) {
        int i = 0;
        while (i < lines.size()) {
            int occurs;
            PacbaseLalDescription lal = lines.get(i);
            int n = occurs = lal.getOccurs() == 0 ? previousOccurs : previousOccurs * lal.getOccurs();
            if (!lal.getRedefines()) {
                totalLength = lal.getChildren().isEmpty() ? (totalLength += occurs * lal.getInputLength()) : this.calculateTotalInputLength(lal.getChildren(), totalLength, occurs);
            }
            ++i;
        }
        return totalLength;
    }

    private String getTranscodedValue(String value) {
        return PacDelimiterConverter.ConvertDelimiterAtExtremity(value, this.generationContext.getAlphanumericDelimiter());
    }

    public int calculateTotalOutputLength(ArrayList<PacbaseLalDescription> lines, int totalLength, int previousOccurs) {
        int i = 0;
        while (i < lines.size()) {
            int occurs;
            PacbaseLalDescription lal = lines.get(i);
            int n = occurs = lal.getOccurs() == 0 ? previousOccurs : previousOccurs * lal.getOccurs();
            if (!lal.getRedefines()) {
                totalLength = lal.getChildren().isEmpty() ? (totalLength += occurs * lal.getOutputLength()) : this.calculateTotalOutputLength(lal.getChildren(), totalLength, occurs);
            }
            ++i;
        }
        return totalLength;
    }

    public void setOutputAddress(int pos) {
        this.outputPos = pos;
    }

    private int setOutputAddresses(ArrayList<PacbaseLalDescription> lines, int outputAddress, int previousOccurs) {
        PacbaseLalDescription previousLal = null;
        int i = 0;
        while (i < lines.size()) {
            int occurs;
            PacbaseLalDescription lal = lines.get(i);
            int n = occurs = lal.getOccurs() == 0 ? previousOccurs : previousOccurs * lal.getOccurs();
            if (i > 0) {
                previousLal = lines.get(i - 1);
                if (previousLal.isFirstOnRedefines()) {
                    if (previousLal.getParent() == null && lal.getParent() == null || previousLal.getParent() != null && lal.getParent() != null && previousLal.getParent() == lal.getParent()) {
                        lal.setFirstofRedefines(previousLal);
                        previousLal.setNextOutputAddress(outputAddress);
                    }
                } else if (lal.getRedefines()) {
                    lal.setFirstofRedefines(previousLal.getFirstofRedefines());
                } else {
                    lal.setFirstofRedefines(null);
                    if (!lal.getChildren().isEmpty()) {
                        boolean sameDud = true;
                        DataUnionDescription currentdud = null;
                        DataUnionDescription previousdud = null;
                        for (PacbaseLalDescription lalinDud : lal.getChildren()) {
                            currentdud = lalinDud.getDud();
                            if (currentdud == null || previousdud != null && previousdud != currentdud) {
                                sameDud = false;
                                break;
                            }
                            if (sameDud && lal.getDud() != null && currentdud != null && lal.getDud() != currentdud) {
                                sameDud = false;
                                break;
                            }
                            previousdud = currentdud;
                        }
                        if (sameDud) {
                            lal.setContainsOnlyDud(true);
                            lal.setFirstofRedefines(lal.getChildren().get(0));
                        }
                    }
                }
            }
            if (lal.getFirstofRedefines() != null) {
                lal.setNextOutputAddress(previousLal.getNextOutputAddress() + lal.getFirstofRedefines().getOutputLength() * occurs);
            } else if (Integer.parseInt(lal.getTotalOutputLength()) > lal.getOutputLength()) {
                lal.setNextOutputAddress(outputAddress + Integer.parseInt(lal.getTotalOutputLength()) * occurs);
            } else {
                lal.setNextOutputAddress(outputAddress + lal.getOutputLength() * occurs);
            }
            if (lal.getRedefines()) {
                lal.setOutputAddress(lal.getFirstofRedefines().getOutputAddress());
            } else {
                lal.setOutputAddress(outputAddress);
                if (previousLal != null && previousLal.getFirstofRedefines() != null) {
                    if (previousLal.getRedefines() && !lal.isFirstOnRedefines()) {
                        lal.setOutputAddress(previousLal.getFirstofRedefines().getNextOutputAddress());
                        lal.setNextOutputAddress(lal.getOutputAddress() + lal.getOutputLength() * occurs);
                    }
                    if (!previousLal.getRedefines() && !previousLal.isFirstOnRedefines() && previousLal.containsOnlyDud()) {
                        lal.setOutputAddress(previousLal.getFirstofRedefines().getNextOutputAddress());
                    }
                    if (previousLal.getRedefines() && lal.getDud() != previousLal.getDud()) {
                        lal.setOutputAddress(previousLal.getFirstofRedefines().getNextOutputAddress());
                    }
                } else if (previousLal != null && !previousLal.getRedefines() && previousLal.getNextOutputAddress() > outputAddress) {
                    lal.setOutputAddress(previousLal.getNextOutputAddress());
                }
            }
            outputAddress = lal.getChildren().isEmpty() ? lal.getOutputAddress() + occurs * lal.getOutputLength() : this.setOutputAddresses(lal.getChildren(), lal.getOutputAddress(), occurs);
            ++i;
        }
        return outputAddress;
    }

    private void calculateNumbers(ArrayList<PacbaseLalDescription> lines, int level) {
        int i = 0;
        while (i < lines.size()) {
            PacbaseLalDescription lal = lines.get(i);
            if (!lal.isLargeObject()) {
                ++this._nbDataElements;
                ++this._nbDataElementsInGroup;
                if (lal.getChildren().isEmpty()) {
                    if (!(lal.getEntity() instanceof Filler)) {
                        ++this._nbElementaryFields;
                    }
                } else {
                    --this._nbDataElementsInGroup;
                    if (lal.isSegment()) {
                        ++this._nbSegmentCalls;
                    }
                }
                this.calculateNumbers(lal.getChildren(), ++level);
            }
            ++i;
        }
    }

    void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean isDate(String formatType) {
        if (INPUT_FORMAT.equals(formatType)) {
            return this.isInputFormatDate();
        }
        if (INTERNAL_FORMAT.equals(formatType)) {
            return this.isInternalFormatDate();
        }
        if (OUTPUT_FORMAT.equals(formatType)) {
            return this.isOutputFormatDate();
        }
        return false;
    }

    public boolean isPictureNeeded() {
        if (PacNumericFormat.IsNativeUsage(this.usageAfterConversion)) {
            return false;
        }
        return !"L".equals(this.Tyrub);
    }

    public boolean isBlankWhenZero(GenerationContext gc) {
        if (this.isBlankWhenZero) {
            if (!gc.getPattern().equals((Object)PacbasePattern.BATCH)) {
                return !gc.isBreakDateOption();
            }
            return true;
        }
        return false;
    }

    public boolean isInternalFormatDate() {
        return this.isInternalFormatDate;
    }

    public boolean isInputFormatDate() {
        return this.isInputFormatDate;
    }

    public boolean isOutputFormatDate() {
        return this.isOutputFormatDate;
    }

    public boolean isSegment() {
        return this.isSegment;
    }

    public void setSegment(boolean isSegment) {
        this.isSegment = isSegment;
    }

    void updateOccursOnPacDataAggregate(List<?> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        for (Object o : extensions) {
            if (!(o instanceof PacDataAggregate)) continue;
            PacDataAggregate pdc = (PacDataAggregate)o;
            this.setOccurs(pdc.getTableSize());
        }
    }

    public String getRelLabel() {
        return this.relLabel;
    }

    public void setRelLabel(String relLabel) {
        this.relLabel = relLabel;
    }

    public static String getRelationalLabel(DataElement de, DataAggregate dag) {
        if (de != null) {
            return PacbaseLalDescription.getRelationLabelFromDE(de, dag);
        }
        return "";
    }

    public static String getRelationLabelFromDE(DataElement de, DataAggregate dag) {
        String relationalLabel = "";
        PacDataElement pacDataElement = null;
        EList extensions = de.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataElement) {
                pacDataElement = (PacDataElement)object;
                String relationalLabelInD = "";
                EList dLines = pacDataElement.getDLines();
                int j = 0;
                while (j < dLines.size()) {
                    PacDLine dline = (PacDLine)dLines.get(j);
                    if (dline.getLineType().equals(DATA_TYPE)) {
                        relationalLabelInD = dline.getDescription();
                        break;
                    }
                    ++j;
                }
                String relationalLabelInDag = PacbaseLalDescription.findRelationalLabelInDag(de.getName(), dag);
                relationalLabel = relationalLabelInDag == null ? (relationalLabelInD.trim().length() > 0 ? relationalLabelInD : de.getName()) : relationalLabelInDag;
            }
            ++i;
        }
        return relationalLabel;
    }

    public static String getRelationLabelFromDE(DataElement de) {
        String relationalLabel = "";
        PacDataElement pacDataElement = null;
        String relationalLabelInD = "";
        EList extensions = de.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataElement) {
                pacDataElement = (PacDataElement)object;
                EList dLines = pacDataElement.getDLines();
                int j = 0;
                while (j < dLines.size()) {
                    PacDLine dline = (PacDLine)dLines.get(j);
                    if (dline.getLineType().equals(DATA_TYPE)) {
                        relationalLabelInD = dline.getDescription();
                        break;
                    }
                    ++j;
                }
            }
            relationalLabel = relationalLabelInD.trim().length() > 0 ? relationalLabelInD : de.getName();
            ++i;
        }
        return relationalLabel;
    }

    public static String findRelationalLabelInDag(String dataElementCode, DataAggregate dag) {
        DataCall datacall = null;
        DataAggregateDescription dad = (DataAggregateDescription)dag.getDataDescription();
        block0: for (Object obj : dad.getComponents()) {
            DataCall dc2;
            if (!(obj instanceof DataCall)) continue;
            DataCall dc = (DataCall)obj;
            DataDefinition dcDef = dc.getDataDefinition();
            DataAggregateDescription dcDesc = null;
            DataElementDescription dcDataElemDesc = null;
            if (dc instanceof DataAggregateDescription || dc.getDataDescription() instanceof DataAggregateDescription) {
                dcDesc = (DataAggregateDescription)dc.getDataDescription();
            }
            if (dc.getDataDescription() instanceof DataElementDescription) {
                dcDataElemDesc = (DataElementDescription)dc.getDataDescription();
            }
            if (dc.getDataDescription() instanceof DataUnionDescription) {
                for (Object objRedefines : ((DataUnionDescription)dc.getDataDescription()).getRedefines()) {
                    if (!(objRedefines instanceof DataCall)) continue;
                    DataCall dcRedefines = (DataCall)objRedefines;
                    dcDef = dcRedefines.getDataDefinition();
                    if (dcDef != null && dcDef.getOwner().getName().equals(dataElementCode)) {
                        dc = dcRedefines;
                        break;
                    }
                    if (dcRedefines instanceof DataAggregateDescription) {
                        DataAggregateDescription dcDescRedefines = (DataAggregateDescription)dcRedefines.getDataDescription();
                        if (!dcDescRedefines.getName().equals(dataElementCode)) break;
                        dcDesc = dcDescRedefines;
                        break;
                    }
                    if (!(dcRedefines.getDataDescription() instanceof DataElementDescription)) continue;
                    DataElementDescription dcDataElemDescRedefines = (DataElementDescription)dcRedefines.getDataDescription();
                    if (!dcDataElemDescRedefines.getName().equals(dataElementCode)) break;
                    dcDataElemDesc = dcDataElemDescRedefines;
                    break;
                }
            }
            if (dcDef != null) {
                if (!dcDef.getOwner().getName().equals(dataElementCode)) continue;
                datacall = dc;
                break;
            }
            if (dcDesc != null) {
                for (Object obj2 : dcDesc.getComponents()) {
                    DataDefinition dcDef2;
                    if (!(obj2 instanceof DataCall) || (dcDef2 = (dc2 = (DataCall)obj2).getDataDefinition()) == null || !dcDef2.getOwner().getName().equals(dataElementCode)) continue;
                    datacall = dc2;
                    continue block0;
                }
                continue;
            }
            if (dcDataElemDesc == null || !dcDataElemDesc.getName().equals(dataElementCode)) continue;
            for (Object obj2 : dc.getExtensions()) {
                if (obj2 instanceof DataCall) {
                    datacall = dc2 = (DataCall)obj2;
                    continue block0;
                }
                if (!(obj2 instanceof PacDataCall)) continue;
                PacDataCall pacDataCall = (PacDataCall)obj2;
                return PacbaseLalDescription.searchAlias(pacDataCall);
            }
        }
        if (datacall != null) {
            PacDataCall pacDataCall = null;
            EList extensions = datacall.getExtensions();
            int j = 0;
            while (j < extensions.size()) {
                Object object = extensions.get(j);
                if (object instanceof PacDataCall) {
                    pacDataCall = (PacDataCall)object;
                    return PacbaseLalDescription.searchAlias(pacDataCall);
                }
                ++j;
            }
        }
        return dataElementCode;
    }

    public static String searchAlias(PacDataCall pacDataCall) {
        if (pacDataCall != null) {
            PacDataCallMore pacDataCallMor2 = null;
            EList extensMoreLine = pacDataCall.getMoreLines();
            if (extensMoreLine != null) {
                for (PacDataCallMore pacDataCallMor2 : extensMoreLine) {
                    if (pacDataCallMor2.getUpdateTarget().trim().length() <= 0 || !pacDataCallMor2.getUpdateTarget().startsWith("A*")) continue;
                    return pacDataCallMor2.getUpdateTarget().substring(2);
                }
            }
        }
        return null;
    }
}

