/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.lal.util;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataComponent;
import com.ibm.pdp.mdl.kernel.DataDescription;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnion;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.KernelPackage;
import com.ibm.pdp.mdl.kernel.impl.KernelFactoryImpl;
import com.ibm.pdp.mdl.pacbase.PacDLine;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataComponent;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacbaseFactory;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.impl.PacbaseFactoryImpl;
import com.ibm.pdp.mdl.pacbase.lal.util.GenerationContext;
import com.ibm.pdp.mdl.pacbase.lal.util.PacbaseLalDescription;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthAndPositionVisitor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final PacbasePackage modelPackagePB = PacbasePackage.eINSTANCE;
    protected static final KernelPackage modelPackageKernel = KernelPackage.eINSTANCE;
    protected KernelFactory kFactory = KernelFactoryImpl.eINSTANCE;
    protected PacbaseFactory pbFactory = PacbaseFactoryImpl.eINSTANCE;
    protected GenerationContext generationContext;
    private PacbaseLalDescription _topParentLal = null;
    private PacbaseLalDescription _currentGroupLal;
    private PacbaseLalDescription _currentLal;
    private DataAggregateDescription _currentDataAggregateDesc;
    private DataCall _currentDataCall;
    private DataCall _previousDataAggregateCall;
    private int _numberOfCalls = 0;
    private DataUnionDescription _currentDataUnionDescription;
    private int _lengthOfCurrentGroupInternal = 0;
    private int _lengthOfCurrentGroupInput = 0;
    private int _lengthOfCurrentGroupOutput = 0;
    private int _currentLevel = 10;
    private boolean isManagingSetOfRedefines = false;
    private boolean isfirstinSetOfRedefines = false;
    private boolean isSegmentCall = false;
    protected static final String _blank = " ";
    List<String> _paths;
    private Hashtable<String, PacbaseLalDescription> dataCallLalMatching = new Hashtable();
    private ArrayList<PacbaseLalDescription> dataCallLalMatchingArray = new ArrayList();

    public LengthAndPositionVisitor(List<String> paths, GenerationContext ctx) {
        this._paths = paths;
        this._currentLevel = 10;
        this.generationContext = ctx;
    }

    public EObject caseDataElement(DataElement kDataElement) {
        this.printTrace("caseDataElement : " + kDataElement.getName() + " - " + kDataElement.getLabel());
        if (kDataElement.getOwner().isResolved(this._paths)) {
            PacDataElementDescription pded;
            PacbaseLalDescription deLal = new PacbaseLalDescription(kDataElement, this.generationContext);
            if (this._currentDataCall == null) {
                this._lengthOfCurrentGroupInternal = 0;
                this._lengthOfCurrentGroupInput = 0;
                this._lengthOfCurrentGroupOutput = 0;
                this._topParentLal = deLal;
            }
            if ((pded = LengthAndPositionVisitor.getPacDescription(kDataElement.getDataDescription())) != null && ((Object)((Object)pded.getType())).equals((Object)PacDataElementTypeValues._L_LITERAL)) {
                deLal.setLargeObject(true);
            }
            deLal.setLevel(this._currentLevel);
            deLal.setLength(kDataElement, "E");
            deLal.setLength(kDataElement, "S");
            deLal.setLength(kDataElement, "I");
            deLal.setName(kDataElement.getName());
            deLal.setLabel(kDataElement);
            if (this._currentDataAggregateDesc != null && (DataAggregate)this._currentDataAggregateDesc.getOwner() != null) {
                if (this._currentDataCall.eContainer() instanceof DataAggregateDescription) {
                    deLal.setRelLabel(PacbaseLalDescription.getRelationalLabel(kDataElement, (DataAggregate)((DataAggregateDescription)this._currentDataCall.eContainer()).getOwner()));
                } else if (this._currentDataCall.eContainer() instanceof DataUnionDescription) {
                    deLal.setRelLabel(PacbaseLalDescription.getRelationLabelFromDE(kDataElement));
                } else {
                    deLal.setRelLabel(PacbaseLalDescription.getRelationalLabel(kDataElement, (DataAggregate)this._currentDataAggregateDesc.getOwner()));
                }
            }
            deLal.setUsage(kDataElement);
            deLal.setTyrub(kDataElement);
            deLal.setInternalFormat(kDataElement);
            deLal.setInputFormat(kDataElement);
            deLal.setOutputFormat(kDataElement);
            if (this._currentDataCall != null) {
                deLal.setOccurs(this._currentDataCall.getMaximumCardinality());
                PacDataCall pDataCall = LengthAndPositionVisitor.getPacDataCall((DataComponent)this._currentDataCall);
                if (pDataCall != null) {
                    deLal.setSortKey(pDataCall.getSortKey());
                }
            }
            if (this._currentGroupLal != this._topParentLal) {
                deLal.setParent(this._currentGroupLal);
            } else {
                deLal.setParent(null);
            }
            if (this.isManagingSetOfRedefines && this._currentDataUnionDescription != null && this._currentDataUnionDescription.getRedefines().contains((Object)this._currentDataCall)) {
                deLal.setDud(this._currentDataUnionDescription);
            }
            if (this.isManagingSetOfRedefines && !this.isfirstinSetOfRedefines && this._currentDataUnionDescription != null) {
                deLal.setRedefines(this._currentDataUnionDescription.getRedefines().contains((Object)this._currentDataCall));
            }
            if (!deLal.getRedefines() && !deLal.isLargeObject()) {
                this._lengthOfCurrentGroupInternal += deLal.getOccurs() > 0 ? deLal.getInternalLength() * deLal.getOccurs() : deLal.getInternalLength();
                this._lengthOfCurrentGroupInput += deLal.getOccurs() > 0 ? deLal.getInputLength() * deLal.getOccurs() : deLal.getInputLength();
                this._lengthOfCurrentGroupOutput += deLal.getOccurs() > 0 ? deLal.getOutputLength() * deLal.getOccurs() : deLal.getOutputLength();
            }
            if (this.isfirstinSetOfRedefines) {
                deLal.setFirstOnRedefines(this.isfirstinSetOfRedefines);
            }
            if (this._currentGroupLal != null) {
                this._currentGroupLal.getChildren().add(deLal);
            }
        }
        return kDataElement;
    }

    protected static PacDataElementDescription getPacDescription(DataDescription description) {
        PacDataElementDescription pacDescription = null;
        EList extensions = description.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataElementDescription) {
                pacDescription = (PacDataElementDescription)object;
                break;
            }
            ++i;
        }
        if (pacDescription == null) {
            pacDescription = PacbaseFactory.eINSTANCE.createPacDataElementDescription();
            extensions.add(pacDescription);
        }
        return pacDescription;
    }

    public EObject caseDataAggregate(DataAggregate kDataAggregate) {
        this.printTrace("caseDataAggregate " + kDataAggregate.getName() + " - " + kDataAggregate.getLabel());
        if (kDataAggregate.getOwner().isResolved(this._paths)) {
            if (this._currentDataCall == null) {
                this._lengthOfCurrentGroupInternal = 0;
                this._lengthOfCurrentGroupInput = 0;
                this._lengthOfCurrentGroupOutput = 0;
                this._topParentLal = new PacbaseLalDescription(kDataAggregate, this.generationContext);
                this._topParentLal.setName(kDataAggregate.getName());
                this._topParentLal.setLevel(this._currentLevel);
                this._topParentLal.updateOccursOnPacDataAggregate((List<?>)kDataAggregate.getExtensions());
                this._currentGroupLal = this._topParentLal;
            }
            this.isSegmentCall = true;
            this.doSwitch((EObject)kDataAggregate.getDataDescription());
        }
        return kDataAggregate;
    }

    public EObject casePacDataAggregate(PacDataAggregate pDataAggregate) {
        this.printTrace("casePacDataAggregate " + pDataAggregate.getOwner().getName() + " - " + pDataAggregate.getOwner().getLabel());
        this.doSwitch((EObject)pDataAggregate.getOwner());
        return pDataAggregate;
    }

    public EObject caseDataUnion(DataUnion kDataUnion) {
        this.printTrace("caseDataUnion: " + kDataUnion.getName() + " - " + kDataUnion.getLabel());
        this.doSwitch((EObject)kDataUnion.getDataDescription());
        return kDataUnion;
    }

    public EObject caseDataElementDescription(DataElementDescription kDataElementDescription) {
        this.printTrace("caseDataElementDescription " + kDataElementDescription.getName() + " - " + kDataElementDescription.getLabel());
        PacbaseLalDescription dedLal = new PacbaseLalDescription(kDataElementDescription, this.generationContext);
        dedLal.setLevel(this._currentLevel);
        dedLal.setLength(kDataElementDescription, "E");
        dedLal.setLength(kDataElementDescription, "I");
        dedLal.setLength(kDataElementDescription, "S");
        dedLal.setName(kDataElementDescription.getName());
        if (this._currentDataCall != null && this._currentDataCall.eContainer().eContainer() instanceof DataAggregate) {
            String relationalLabelInDag = PacbaseLalDescription.findRelationalLabelInDag(kDataElementDescription.getName(), (DataAggregate)this._currentDataCall.eContainer().eContainer());
            if (relationalLabelInDag == null) {
                dedLal.setRelLabel(kDataElementDescription.getName());
            } else {
                dedLal.setRelLabel(relationalLabelInDag);
            }
        }
        dedLal.setLabel(kDataElementDescription);
        dedLal.setUsage(kDataElementDescription);
        dedLal.setTyrub(kDataElementDescription);
        dedLal.setOccurs(this._currentDataCall.getMaximumCardinality());
        PacDataCall pDataCall = LengthAndPositionVisitor.getPacDataCall((DataComponent)this._currentDataCall);
        if (pDataCall != null) {
            dedLal.setSortKey(pDataCall.getSortKey());
        }
        dedLal.setInternalFormat(this._currentDataCall);
        dedLal.setInputFormat(this._currentDataCall);
        dedLal.setOutputFormat(this._currentDataCall);
        if (this._currentGroupLal != this._topParentLal) {
            dedLal.setParent(this._currentGroupLal);
        } else {
            dedLal.setParent(null);
        }
        if (this.isManagingSetOfRedefines && this._currentDataUnionDescription != null && this._currentDataUnionDescription.getRedefines().contains((Object)this._currentDataCall)) {
            dedLal.setDud(this._currentDataUnionDescription);
        }
        if (this.isManagingSetOfRedefines && !this.isfirstinSetOfRedefines && this._currentDataUnionDescription != null) {
            dedLal.setRedefines(this._currentDataUnionDescription.getRedefines().contains((Object)this._currentDataCall));
        }
        if (!dedLal.getRedefines()) {
            this._lengthOfCurrentGroupInternal += dedLal.getOccurs() > 0 ? dedLal.getInternalLength() * dedLal.getOccurs() : dedLal.getInternalLength();
            this._lengthOfCurrentGroupInput += dedLal.getOccurs() > 0 ? dedLal.getInputLength() * dedLal.getOccurs() : dedLal.getInputLength();
            this._lengthOfCurrentGroupOutput += dedLal.getOccurs() > 0 ? dedLal.getOutputLength() * dedLal.getOccurs() : dedLal.getOutputLength();
        }
        if (this.isManagingSetOfRedefines) {
            dedLal.setFirstOnRedefines(this.isfirstinSetOfRedefines);
        }
        this._currentGroupLal.getChildren().add(dedLal);
        return kDataElementDescription;
    }

    public EObject caseDataAggregateDescription(DataAggregateDescription kDataAggregateDescription) {
        if (kDataAggregateDescription.getOwner() != null) {
            this.printTrace("caseDataAggregateDescription (Defined): " + kDataAggregateDescription.getOwner().getName() + " - " + kDataAggregateDescription.getOwner().getLabel());
        } else {
            this.printTrace("caseDataAggregateDescription (Undefined): " + kDataAggregateDescription.getName() + " - " + kDataAggregateDescription.getLabel());
        }
        PacbaseLalDescription oldGroupLal = null;
        int lengthOfOldGroupInternal = 0;
        int lengthOfOldGroupInput = 0;
        int lengthOfOldGroupOutput = 0;
        this._currentDataAggregateDesc = kDataAggregateDescription;
        boolean isInRedefines = false;
        if (this._currentDataCall != null) {
            PacbaseLalDescription daLal = new PacbaseLalDescription(kDataAggregateDescription, this.generationContext);
            this._currentGroupLal.getChildren().add(daLal);
            daLal.setLevel(this._currentLevel);
            daLal.setOccurs(this._currentDataCall.getMaximumCardinality());
            PacDataCall pDataCall = LengthAndPositionVisitor.getPacDataCall((DataComponent)this._currentDataCall);
            if (pDataCall != null) {
                daLal.setSortKey(pDataCall.getSortKey());
            }
            daLal.setInternalFormat("");
            daLal.setInputFormat("");
            daLal.setOutputFormat("");
            daLal.setSegment(this.isSegmentCall);
            if (this._currentGroupLal != this._topParentLal) {
                daLal.setParent(this._currentGroupLal);
            } else {
                daLal.setParent(null);
            }
            if (this.isManagingSetOfRedefines && this._currentDataUnionDescription != null && this._currentDataUnionDescription.getRedefines().contains((Object)this._currentDataCall)) {
                daLal.setDud(this._currentDataUnionDescription);
            }
            if (this.isManagingSetOfRedefines && !this.isfirstinSetOfRedefines && this._currentDataUnionDescription != null) {
                daLal.setRedefines(this._currentDataUnionDescription.getRedefines().contains((Object)this._currentDataCall));
                isInRedefines = daLal.getRedefines();
            }
            if (kDataAggregateDescription.getName().trim().length() != 0) {
                daLal.setName(kDataAggregateDescription.getName());
                daLal.setLabel(kDataAggregateDescription.getLabel());
                daLal.setRelLabel(kDataAggregateDescription.getName());
            } else if (kDataAggregateDescription.getOwner() != null) {
                daLal.setName(kDataAggregateDescription.getOwner().getName());
                daLal.setLabel(kDataAggregateDescription.getOwner().getLabel());
                daLal.setRelLabel(kDataAggregateDescription.getOwner().getLabel());
            }
            if (this.isManagingSetOfRedefines) {
                daLal.setFirstOnRedefines(this.isfirstinSetOfRedefines);
            }
            ++this._currentLevel;
            oldGroupLal = this._currentGroupLal;
            lengthOfOldGroupInternal = this._lengthOfCurrentGroupInternal;
            this._lengthOfCurrentGroupInternal = 0;
            lengthOfOldGroupInput = this._lengthOfCurrentGroupInput;
            this._lengthOfCurrentGroupInput = 0;
            lengthOfOldGroupOutput = this._lengthOfCurrentGroupOutput;
            this._lengthOfCurrentGroupOutput = 0;
            this._currentGroupLal = daLal;
        }
        this.isSegmentCall = false;
        for (DataComponent aDataComponent : this._currentDataAggregateDesc.getComponents()) {
            this.doSwitch((EObject)aDataComponent);
        }
        if (this._currentDataCall != null) {
            --this._currentLevel;
            this._currentGroupLal.setInternalLength(this._lengthOfCurrentGroupInternal);
            this._currentGroupLal.setInputLength(this._lengthOfCurrentGroupInput);
            this._currentGroupLal.setOutputLength(this._lengthOfCurrentGroupOutput);
            this._currentGroupLal = oldGroupLal;
            if (isInRedefines) {
                this._lengthOfCurrentGroupInternal = lengthOfOldGroupInternal;
                this._lengthOfCurrentGroupInput = lengthOfOldGroupInput;
                this._lengthOfCurrentGroupOutput = lengthOfOldGroupOutput;
            } else {
                this._lengthOfCurrentGroupInternal += lengthOfOldGroupInternal;
                this._lengthOfCurrentGroupInput += lengthOfOldGroupInput;
                this._lengthOfCurrentGroupOutput += lengthOfOldGroupOutput;
            }
        }
        return kDataAggregateDescription;
    }

    public EObject caseDataUnionDescription(DataUnionDescription kDataUnionDescription) {
        this.printTrace("caseDataUnionDescription: " + kDataUnionDescription.getName() + " - " + kDataUnionDescription.getLabel());
        boolean isManagingSetOfRedefinesBefore = this.isManagingSetOfRedefines;
        this.isManagingSetOfRedefines = true;
        this.isfirstinSetOfRedefines = true;
        DataUnionDescription oldDataUnionDescription = null;
        oldDataUnionDescription = this._currentDataUnionDescription;
        this._currentDataUnionDescription = kDataUnionDescription;
        for (DataComponent aDataComponent : kDataUnionDescription.getRedefines()) {
            this.doSwitch((EObject)aDataComponent);
            this.isfirstinSetOfRedefines = false;
        }
        this._currentDataUnionDescription = oldDataUnionDescription;
        this.isManagingSetOfRedefines = isManagingSetOfRedefinesBefore;
        return kDataUnionDescription;
    }

    public EObject caseDataCall(DataCall kDataCall) {
        if (kDataCall.getDataDefinition() != null) {
            this.printTrace("caseDataCall - Data Definition: ");
            if (kDataCall.getDataDefinition() instanceof DataElement) {
                this._currentDataCall = kDataCall;
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            } else if (kDataCall.getDataDefinition() instanceof DataAggregate) {
                this._currentDataCall = kDataCall;
                DataAggregateDescription dagd = null;
                if (this._previousDataAggregateCall != null && this._previousDataAggregateCall.getDataDefinition() != null) {
                    if (this._previousDataAggregateCall.getDataDefinition().getDataDescription() != null && this._previousDataAggregateCall.getDataDefinition().getDataDescription() instanceof DataAggregateDescription) {
                        dagd = (DataAggregateDescription)this._previousDataAggregateCall.getDataDefinition().getDataDescription();
                    }
                    if (dagd != null) {
                        if (this.isPotentialLoop((DataAggregateDescription)this._previousDataAggregateCall.getDataDefinition().getDataDescription(), new ArrayList<String>())) {
                            ++this._numberOfCalls;
                            this.printTrace(String.valueOf(this._previousDataAggregateCall.getDataDefinition().getName()) + " contains " + this._currentDataCall.getDataDefinition().getName());
                        } else {
                            this._numberOfCalls = 0;
                            this._previousDataAggregateCall = null;
                        }
                    }
                }
                this._previousDataAggregateCall = kDataCall;
                if (this._numberOfCalls < 3) {
                    this.doSwitch((EObject)kDataCall.getDataDefinition());
                }
            } else if (kDataCall.getDataDefinition() instanceof DataUnion) {
                this._currentDataCall = kDataCall;
                this.doSwitch((EObject)kDataCall.getDataDefinition());
            }
        } else if (kDataCall.getDataDescription() != null) {
            this.printTrace("caseDataCall - Data Description: ");
            this._currentDataCall = kDataCall;
            if (kDataCall.getDataDescription() instanceof DataElementDescription) {
                this.doSwitch((EObject)kDataCall.getDataDescription());
            } else if (kDataCall.getDataDescription() instanceof DataAggregateDescription) {
                this.doSwitch((EObject)kDataCall.getDataDescription());
            } else if (kDataCall.getDataDescription() instanceof DataUnionDescription) {
                this.doSwitch((EObject)kDataCall.getDataDescription());
            }
        }
        if (this._currentGroupLal != null) {
            for (PacbaseLalDescription this._currentLal : this._currentGroupLal.getChildren()) {
            }
            this.updateDefaultValue(this._currentLal, (List<?>)kDataCall.getExtensions());
        }
        return kDataCall;
    }

    private void updateDefaultValue(PacbaseLalDescription lal, List<?> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        for (Object o : extensions) {
            PacDataComponent pdc;
            if (o instanceof PacDataComponent && !(pdc = (PacDataComponent)o).getMoreLines().isEmpty()) {
                for (PacDataCallMore pdcm : pdc.getMoreLines()) {
                    String controlType = pdcm.getControlType();
                    if (controlType == null) continue;
                    String controlValue = pdcm.getControlValue();
                    if (controlType.trim().equals("V")) {
                        DataElement de;
                        EList extens;
                        if (controlValue != null && controlValue.trim().length() > 0) {
                            lal.setValue(controlValue);
                            continue;
                        }
                        if (this._currentDataCall == null || this._currentDataCall.getDataDefinition() == null || !(this._currentDataCall.getDataDefinition() instanceof DataElement) || (extens = (de = (DataElement)this._currentDataCall.getDataDefinition()).getExtensions()).isEmpty()) continue;
                        boolean continu = true;
                        Iterator itDE = extens.iterator();
                        while (itDE.hasNext() && continu) {
                            PacDataElement pde;
                            EList dLines;
                            Object obj = itDE.next();
                            if (!(obj instanceof PacDataElement) || (dLines = (pde = (PacDataElement)obj).getDLines()).isEmpty()) continue;
                            Iterator itDL = dLines.iterator();
                            while (itDL.hasNext() && continu) {
                                PacDLine dline = (PacDLine)itDL.next();
                                if (!dline.getLineType().equals("D")) continue;
                                lal.setValue(dline.getAllowedValues());
                                continu = false;
                            }
                        }
                        continue;
                    }
                    if (!controlType.trim().equals("W")) continue;
                    String updateTarget = pdcm.getUpdateTarget();
                    String value = "";
                    if (controlValue != null && controlValue.trim().length() > 0) {
                        value = String.valueOf(value) + controlValue;
                    }
                    if (updateTarget != null && updateTarget.trim().length() > 0) {
                        value = String.valueOf(value) + updateTarget;
                    }
                    lal.setValue(LengthAndPositionVisitor.trimRight(value));
                }
            }
            if (!(o instanceof PacFiller)) continue;
            PacFiller pf = (PacFiller)o;
            lal.setLabel(pf.getLabel());
        }
    }

    public EObject caseFiller(Filler kFiller) {
        this.printTrace("caseFiller : " + kFiller.getLength());
        if (kFiller.getOwner().isResolved(this._paths)) {
            PacbaseLalDescription fillerLal = new PacbaseLalDescription(kFiller, this.generationContext);
            fillerLal.setLevel(this._currentLevel);
            fillerLal.setName("FILLER");
            fillerLal.setLabel(this.getPacLabelFiller(kFiller));
            fillerLal.setLength(kFiller, "I");
            fillerLal.setLength(kFiller, "E");
            fillerLal.setLength(kFiller, "S");
            fillerLal.setUsage(kFiller);
            fillerLal.setTyrub(kFiller);
            fillerLal.setOccurs(kFiller.getMaximumCardinality());
            PacFiller pFiller = LengthAndPositionVisitor.getPacFiller((DataComponent)kFiller);
            if (pFiller != null) {
                fillerLal.setSortKey(pFiller.getSortKey());
            }
            fillerLal.setInternalFormat(kFiller);
            fillerLal.setInputFormat(kFiller);
            fillerLal.setOutputFormat(kFiller);
            this.updateDefaultValue(fillerLal, (List<?>)kFiller.getExtensions());
            if (this._currentGroupLal != this._topParentLal) {
                fillerLal.setParent(this._currentGroupLal);
            } else {
                fillerLal.setParent(null);
            }
            if (this.isManagingSetOfRedefines && this._currentDataUnionDescription != null && this._currentDataUnionDescription.getRedefines().contains((Object)this._currentDataCall)) {
                fillerLal.setDud(this._currentDataUnionDescription);
            }
            if (this.isManagingSetOfRedefines && !this.isfirstinSetOfRedefines && this._currentDataUnionDescription != null) {
                fillerLal.setRedefines(this._currentDataUnionDescription.getRedefines().contains((Object)kFiller));
            }
            if (!fillerLal.getRedefines()) {
                this._lengthOfCurrentGroupInternal += fillerLal.getOccurs() > 0 ? fillerLal.getInternalLength() * fillerLal.getOccurs() : fillerLal.getInternalLength();
                this._lengthOfCurrentGroupInput += fillerLal.getOccurs() > 0 ? fillerLal.getInputLength() * fillerLal.getOccurs() : fillerLal.getInputLength();
                this._lengthOfCurrentGroupOutput += fillerLal.getOccurs() > 0 ? fillerLal.getOutputLength() * fillerLal.getOccurs() : fillerLal.getOutputLength();
            }
            if (this.isfirstinSetOfRedefines) {
                fillerLal.setFirstOnRedefines(this.isfirstinSetOfRedefines);
            }
            this._currentGroupLal.getChildren().add(fillerLal);
        }
        return kFiller;
    }

    private String getPacLabelFiller(Filler kFiller) {
        return null;
    }

    public EObject doSwitch(EObject theEObject) {
        this.doSwitch(theEObject.eClass(), theEObject);
        return theEObject;
    }

    protected EObject doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackagePB) {
            this.doSwitchPB(theEClass.getClassifierID(), theEObject);
        } else if (theEClass.eContainer() == modelPackageKernel) {
            this.doSwitchKernel(theEClass.getClassifierID(), theEObject);
        }
        return theEObject;
    }

    protected EObject doSwitchKernel(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 44: {
                DataElement kernelObject = (DataElement)theEObject;
                this.caseDataElement(kernelObject);
                break;
            }
            case 45: {
                DataAggregate kernelObject = (DataAggregate)theEObject;
                this.caseDataAggregate(kernelObject);
                break;
            }
            case 46: {
                DataUnion kernelObject = (DataUnion)theEObject;
                this.caseDataUnion(kernelObject);
                break;
            }
            case 33: {
                DataElementDescription kernelObject = (DataElementDescription)theEObject;
                this.caseDataElementDescription(kernelObject);
                break;
            }
            case 18: {
                DataAggregateDescription kernelObject = (DataAggregateDescription)theEObject;
                this.caseDataAggregateDescription(kernelObject);
                break;
            }
            case 35: {
                DataUnionDescription kernelObject = (DataUnionDescription)theEObject;
                this.caseDataUnionDescription(kernelObject);
                break;
            }
            case 37: {
                DataCall kernelObject = (DataCall)theEObject;
                this.caseDataCall(kernelObject);
                break;
            }
            case 43: {
                Filler kernelObject = (Filler)theEObject;
                this.caseFiller(kernelObject);
                break;
            }
            default: {
                System.out.println("Kernel case not defined: " + theEObject.getClass().toString());
            }
        }
        return theEObject;
    }

    protected void doSwitchPB(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 48: {
                PacDataAggregate pacbaseObject = (PacDataAggregate)theEObject;
                this.casePacDataAggregate(pacbaseObject);
                break;
            }
            default: {
                System.out.println("Pacbase case not defined: " + theEObject.getClass().toString());
            }
        }
    }

    public PacbaseLalDescription getTopParentLal() {
        return this._topParentLal;
    }

    protected void printTrace(String label) {
    }

    public Hashtable<String, PacbaseLalDescription> defineMatchingTable(PacbaseLalDescription pLal) {
        pLal.calculateNumbers();
        return this._defineMatchingTable(pLal);
    }

    private Hashtable<String, PacbaseLalDescription> _defineMatchingTable(PacbaseLalDescription pLal) {
        for (PacbaseLalDescription child : pLal.getChildren()) {
            String idLal = this.getMatchingId(child);
            this.dataCallLalMatching.put(idLal, child);
            this._defineMatchingTable(child);
        }
        return this.dataCallLalMatching;
    }

    public ArrayList<PacbaseLalDescription> defineMatchingArray(PacbaseLalDescription pLal) {
        if (!this.dataCallLalMatchingArray.isEmpty()) {
            return this.dataCallLalMatchingArray;
        }
        pLal.calculateNumbers();
        ArrayList<PacbaseLalDescription> lines = pLal.getChildren(true);
        return this._defineMatchingArray(lines);
    }

    private ArrayList<PacbaseLalDescription> _defineMatchingArray(ArrayList<PacbaseLalDescription> lines) {
        for (PacbaseLalDescription child : lines) {
            this.dataCallLalMatchingArray.add(child);
            if (child.getChildren() == null) continue;
            this._defineMatchingArray(child.getChildren());
        }
        return this.dataCallLalMatchingArray;
    }

    private String getMatchingId(PacbaseLalDescription pLal) {
        StringBuffer idLal = new StringBuffer();
        idLal.append(pLal.getName());
        if (pLal.getParent() != null) {
            idLal.append(this.getMatchingId(pLal.getParent()));
        }
        return idLal.toString();
    }

    private boolean isPotentialLoop(DataAggregateDescription dad, List<String> daAlreadyFound) {
        Iterator components = dad.getComponents().iterator();
        String designURI = null;
        DataComponent dataComponent = null;
        DataCall dataCall = null;
        DataAggregateDescription aDADesc = null;
        while (components.hasNext()) {
            aDADesc = null;
            dataComponent = (DataComponent)components.next();
            if (!(dataComponent instanceof DataCall)) continue;
            dataCall = (DataCall)dataComponent;
            if (dataCall.getDataDefinition() != null && dataCall.getDataDefinition() instanceof DataAggregate) {
                designURI = dataCall.getDataDefinition().getDesignURI().toString();
                if (daAlreadyFound.contains(designURI)) {
                    return true;
                }
                daAlreadyFound.add(designURI);
                aDADesc = (DataAggregateDescription)dataCall.getDataDefinition().getDataDescription();
            } else if (dataCall.getDataDescription() != null && dataCall.getDataDescription() instanceof DataAggregateDescription) {
                aDADesc = (DataAggregateDescription)dataCall.getDataDescription();
            }
            if (aDADesc == null || !this.isPotentialLoop(aDADesc, daAlreadyFound)) continue;
            return true;
        }
        return false;
    }

    public static String trimRight(String value) {
        int end = value.length() - 1;
        char[] val = value.toCharArray();
        while (end >= 0 && val[end] <= ' ') {
            --end;
        }
        return new String(val, 0, end + 1);
    }

    protected static PacDataCall getPacDataCall(DataComponent dataComponent) {
        PacDataCall pacDataCall = null;
        EList extensions = dataComponent.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataCall) {
                pacDataCall = (PacDataCall)object;
                break;
            }
            ++i;
        }
        return pacDataCall;
    }

    protected static PacFiller getPacFiller(DataComponent dataComponent) {
        PacFiller pacFiller = null;
        EList extensions = dataComponent.getExtensions();
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacFiller) {
                pacFiller = (PacFiller)object;
                break;
            }
            ++i;
        }
        return pacFiller;
    }
}

