/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.impl;

import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.pacbase.PacSourceLine;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.util.PacFreeRelationsUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class PacSourceLineImpl
extends EntityImpl
implements PacSourceLine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String CONTINUED_EDEFAULT = "";
    protected String continued = "";
    protected static final String OPERATION_EDEFAULT = "";
    protected String operation = "";
    protected static final String WS_PREFIX_EDEFAULT = "";
    protected String wsPrefix = "";
    protected static final String SOURCE_EDEFAULT = "";
    protected String source = "";
    protected static final String CONDITION_EDEFAULT = "";
    protected String condition = "";

    protected PacSourceLineImpl() {
    }

    protected EClass eStaticClass() {
        return PacbasePackage.Literals.PAC_SOURCE_LINE;
    }

    public String getContinued() {
        return this.continued;
    }

    public void setContinued(String newContinued) {
        String oldContinued = this.continued;
        this.continued = newContinued;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldContinued, (Object)this.continued));
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String newOperation) {
        String oldOperation = this.operation;
        this.operation = newOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldOperation, (Object)this.operation));
        }
    }

    public String getWsPrefix() {
        return this.wsPrefix;
    }

    public void setWsPrefix(String newWsPrefix) {
        String oldWsPrefix = this.wsPrefix;
        this.wsPrefix = newWsPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldWsPrefix, (Object)this.wsPrefix));
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String newSource) {
        String oldSource = this.source;
        this.source = newSource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldSource, (Object)this.source));
        }
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String newCondition) {
        String oldCondition = this.condition;
        this.condition = newCondition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldCondition, (Object)this.condition));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getContinued();
            }
            case 1: {
                return this.getOperation();
            }
            case 2: {
                return this.getWsPrefix();
            }
            case 3: {
                return this.getSource();
            }
            case 4: {
                return this.getCondition();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setContinued((String)newValue);
                return;
            }
            case 1: {
                this.setOperation((String)newValue);
                return;
            }
            case 2: {
                this.setWsPrefix((String)newValue);
                return;
            }
            case 3: {
                this.setSource((String)newValue);
                return;
            }
            case 4: {
                this.setCondition((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setContinued("");
                return;
            }
            case 1: {
                this.setOperation("");
                return;
            }
            case 2: {
                this.setWsPrefix("");
                return;
            }
            case 3: {
                this.setSource("");
                return;
            }
            case 4: {
                this.setCondition("");
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return "" == null ? this.continued != null : !"".equals(this.continued);
            }
            case 1: {
                return "" == null ? this.operation != null : !"".equals(this.operation);
            }
            case 2: {
                return "" == null ? this.wsPrefix != null : !"".equals(this.wsPrefix);
            }
            case 3: {
                return "" == null ? this.source != null : !"".equals(this.source);
            }
            case 4: {
                return "" == null ? this.condition != null : !"".equals(this.condition);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (continued: ");
        result.append(this.continued);
        result.append(", operation: ");
        result.append(this.operation);
        result.append(", wsPrefix: ");
        result.append(this.wsPrefix);
        result.append(", source: ");
        result.append(this.source);
        result.append(", condition: ");
        result.append(this.condition);
        result.append(')');
        return result.toString();
    }

    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof PacSourceLine) {
            PacSourceLine inputSourceLine = (PacSourceLine)eObject;
            isSame = this.getContinued().equals(inputSourceLine.getContinued());
            if (isSame && (isSame = this.getOperation().equals(inputSourceLine.getOperation())) && (isSame = this.getWsPrefix().equals(inputSourceLine.getWsPrefix())) && (isSame = this.getSource().equals(inputSourceLine.getSource()))) {
                isSame = this.getCondition().equals(inputSourceLine.getCondition());
            }
        }
        return isSame;
    }

    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        hashCode += this.getContinued().hashCode();
        hashCode += this.getOperation().hashCode();
        hashCode += this.getWsPrefix().hashCode();
        hashCode += this.getSource().hashCode();
        return hashCode += this.getCondition().hashCode();
    }

    protected boolean renameFreeReferences(String nodePath, String type, String oldName, String newName, List changedArtifactIds) {
        String newSource;
        boolean result = false;
        if (this.getSource().length() > 0 && !this.getWsPrefix().equals("*") && (newSource = PacFreeRelationsUtil.renamePacDataElementFromPacSourceLineSource(this.getSource(), oldName, newName)) != null) {
            this.setSource(newSource);
            result = true;
        }
        String condition = this.getCondition();
        String newCondition = "";
        if (condition.length() != 0 && condition.indexOf(oldName) != -1) {
            String[] wordcond = condition.split("[=><'\\s]+");
            int currentWordCondIndex = 0;
            int i = 0;
            while (i < wordcond.length) {
                int newWordContIndex = condition.indexOf(wordcond[i], currentWordCondIndex);
                String stringBeforeWordCond = condition.substring(currentWordCondIndex, newWordContIndex);
                newCondition = String.valueOf(newCondition) + stringBeforeWordCond;
                currentWordCondIndex += stringBeforeWordCond.length();
                String replacedWordCondition = PacFreeRelationsUtil.renamePacDataElementFromPacCategoryCondition(wordcond[i].trim(), oldName, newName);
                if (replacedWordCondition != null) {
                    newCondition = String.valueOf(newCondition) + replacedWordCondition;
                    result = true;
                } else {
                    newCondition = String.valueOf(newCondition) + wordcond[i];
                }
                currentWordCondIndex += wordcond[i].length();
                ++i;
            }
        }
        if (result) {
            this.setCondition(newCondition);
        }
        boolean superResult = super.renameFreeReferences(nodePath, type, oldName, newName, changedArtifactIds);
        return result || superResult;
    }

    protected void _getFreeRelations(String nodePath, Map freeRelations) {
        if (this.getSource().length() > 0 && !this.getWsPrefix().equals("*")) {
            String code = PacFreeRelationsUtil.getPacDataElementFromPacSourceLineSource(this.getSource());
            if (code != null) {
                DataElement dataElement = KernelFactory.eINSTANCE.createDataElement();
                dataElement.setName(code);
                EAttribute eAttribute = PacbasePackage.eINSTANCE.getPacSourceLine_Source();
                PacSourceLineImpl.registerRelation((String)nodePath, (String)eAttribute.getName(), (RadicalEntity)dataElement, (Map)freeRelations, null);
            }
            super._getFreeRelations(nodePath, freeRelations);
        }
        if (this.getCondition().length() > 0) {
            String[] wordcond = this.getCondition().split("[=><'\\s]+");
            int i = 0;
            while (i < wordcond.length) {
                String code = PacFreeRelationsUtil.getPacDataElementFromPacCategoryCondition(wordcond[i]);
                if (code != null) {
                    DataElement dataElement = KernelFactory.eINSTANCE.createDataElement();
                    dataElement.setName(code);
                    EAttribute eAttribute = PacbasePackage.eINSTANCE.getPacSourceLine_Condition();
                    PacSourceLineImpl.registerRelation((String)nodePath, (String)eAttribute.getName(), (RadicalEntity)dataElement, (Map)freeRelations, null);
                }
                super._getFreeRelations(nodePath, freeRelations);
                ++i;
            }
        }
    }
}

