/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.impl;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogFolder;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacText;
import com.ibm.pdp.mdl.pacbase.PacbaseFactory;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.util.PacFreeRelationsUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class PacGLineImpl
extends EntityImpl
implements PacGLine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String LINE_TYPE_EDEFAULT = "";
    protected String lineType = "";
    protected static final String DESCRIPTION_EDEFAULT = "";
    protected String description = "";
    protected RadicalEntity linkedEntity;

    protected PacGLineImpl() {
    }

    protected EClass eStaticClass() {
        return PacbasePackage.Literals.PAC_GLINE;
    }

    public String getLineType() {
        return this.lineType;
    }

    public void setLineType(String newLineType) {
        String oldLineType = this.lineType;
        this.lineType = newLineType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLineType, (Object)this.lineType));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDescription, (Object)this.description));
        }
    }

    public RadicalEntity getLinkedEntity() {
        if (this.linkedEntity != null && this.linkedEntity.eIsProxy()) {
            InternalEObject oldLinkedEntity = (InternalEObject)this.linkedEntity;
            this.linkedEntity = (RadicalEntity)this.eResolveProxy(oldLinkedEntity);
            if (this.linkedEntity != oldLinkedEntity && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldLinkedEntity, (Object)this.linkedEntity));
            }
        }
        this.linkedEntity = this.resolveReference(this.linkedEntity);
        return this.linkedEntity;
    }

    public RadicalEntity basicGetLinkedEntity() {
        return this.linkedEntity;
    }

    public void setLinkedEntity(RadicalEntity newLinkedEntity) {
        RadicalEntity oldLinkedEntity = this.linkedEntity;
        this.linkedEntity = newLinkedEntity;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldLinkedEntity, (Object)this.linkedEntity));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getLineType();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                if (resolve) {
                    return this.getLinkedEntity();
                }
                return this.basicGetLinkedEntity();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLineType((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
            case 2: {
                this.setLinkedEntity((RadicalEntity)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLineType("");
                return;
            }
            case 1: {
                this.setDescription("");
                return;
            }
            case 2: {
                this.setLinkedEntity(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return "" == null ? this.lineType != null : !"".equals(this.lineType);
            }
            case 1: {
                return "" == null ? this.description != null : !"".equals(this.description);
            }
            case 2: {
                return this.linkedEntity != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (lineType: ");
        result.append(this.lineType);
        result.append(", description: ");
        result.append(this.description);
        result.append(')');
        return result.toString();
    }

    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof PacGLine) {
            PacGLine inputGLine = (PacGLine)eObject;
            isSame = this.getLineType().equals(inputGLine.getLineType());
            if (isSame && (isSame = this.getDescription().equals(inputGLine.getDescription())) && this.getLinkedEntity() != null && inputGLine.getLinkedEntity() != null) {
                if (this.getLinkedEntity() instanceof DataElement && inputGLine.getLinkedEntity() instanceof DataElement) {
                    DataElement de = (DataElement)this.getLinkedEntity();
                    DataElement inputDe = (DataElement)inputGLine.getLinkedEntity();
                    URI uri = de.getDesignURI();
                    URI inputUri = inputDe.getDesignURI();
                    isSame = uri.equals(inputUri);
                } else if (this.getLinkedEntity() instanceof DataAggregate && inputGLine.getLinkedEntity() instanceof DataAggregate) {
                    DataAggregate dag = (DataAggregate)this.getLinkedEntity();
                    DataAggregate inputDag = (DataAggregate)inputGLine.getLinkedEntity();
                    URI uri = dag.getDesignURI();
                    URI inputUri = inputDag.getDesignURI();
                    isSame = uri.equals(inputUri);
                } else if (this.getLinkedEntity() instanceof PacText && inputGLine.getLinkedEntity() instanceof PacText) {
                    PacText text = (PacText)this.getLinkedEntity();
                    PacText inputText = (PacText)inputGLine.getLinkedEntity();
                    URI uri = text.getDesignURI();
                    URI inputUri = inputText.getDesignURI();
                    isSame = uri.equals(inputUri);
                }
            }
        }
        return isSame;
    }

    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        hashCode += this.getLineType().hashCode();
        hashCode += this.getDescription().hashCode();
        if (this.getLinkedEntity() != null) {
            hashCode += this.getLinkedEntity().getDesignURI().hashCode();
        }
        return hashCode;
    }

    protected boolean renameFreeReferences(String nodePath, String type, String oldName, String newName, List changedArtifactIds) {
        if (this.getDescription() == null || this.getDescription().trim().length() == 0) {
            return false;
        }
        if (changedArtifactIds != null) {
            return false;
        }
        boolean result = false;
        if (nodePath.contains("GOLines[])") && (this.getOwner() instanceof PacFolder || this.getOwner() instanceof PacDialogFolder || this.getOwner() instanceof PacServer || this.getOwner() instanceof PacDialogServer)) {
            String codeMC = PacFreeRelationsUtil.getPacCommunicationMonitorFromPacFolderGOLine(this.getDescription().trim());
            if (codeMC != null && PacCommunicationMonitor.class.getSimpleName().equalsIgnoreCase(type) && oldName.equals(codeMC)) {
                String description = this.getDescription();
                String newDescription = description.replace(oldName, newName);
                this.setDescription(newDescription);
                return true;
            }
            String codeIT = PacFreeRelationsUtil.getPacServerITFromPacFolderGOLine(this.getDescription().trim());
            if (codeIT != null && PacServer.class.getSimpleName().equalsIgnoreCase(type) && oldName.equals(codeIT)) {
                String description = this.getDescription();
                String newDescription = description.replace(oldName, newName);
                this.setDescription(newDescription);
                return true;
            }
            boolean otherResult = super.renameFreeReferences(nodePath, type, oldName, newName, changedArtifactIds);
            if (otherResult) {
                result = true;
            }
        }
        if (nodePath.contains("GGLines[])") && (this.getOwner() instanceof DataAggregate || this.getOwner() instanceof PacBlockBase)) {
            boolean otherResult;
            String description = this.getDescription();
            if (description.charAt(0) == '<') {
                String newDescription = PacFreeRelationsUtil.renamePacDataElementFromPacGLineDescriptionUnderBrackets(description, oldName, newName);
                if (newDescription != null) {
                    this.setDescription(newDescription);
                    result = true;
                }
            } else if (description.length() != 0 && description.contains(oldName)) {
                String newCondition = "";
                String[] wordcond = this.getDescription().split("[):>\\s]+");
                int currentWordCondIndex = 0;
                int i = 0;
                while (i < wordcond.length) {
                    int newWordContIndex = description.indexOf(wordcond[i], currentWordCondIndex);
                    String stringBeforeWordCond = description.substring(currentWordCondIndex, newWordContIndex);
                    newCondition = String.valueOf(newCondition) + stringBeforeWordCond;
                    currentWordCondIndex += stringBeforeWordCond.length();
                    String replacedWordCondition = PacFreeRelationsUtil.renamePacDataElementFromPacCategoryCondition(wordcond[i], oldName, newName);
                    if (replacedWordCondition != null) {
                        newCondition = String.valueOf(newCondition) + replacedWordCondition;
                        result = true;
                    } else {
                        newCondition = String.valueOf(newCondition) + wordcond[i];
                    }
                    currentWordCondIndex += wordcond[i].length();
                    ++i;
                }
                if (newCondition.length() > 0) {
                    this.setDescription(newCondition);
                }
            }
            if (otherResult = super.renameFreeReferences(nodePath, type, oldName, newName, changedArtifactIds)) {
                result = true;
            }
        }
        return result;
    }

    protected void _getFreeRelations(String nodePath, Map freeRelations) {
        if (this.getDescription() == null || this.getDescription().trim().length() == 0) {
            return;
        }
        if (nodePath.contains("GOLines[])") && (this.getOwner() instanceof PacFolder || this.getOwner() instanceof PacDialogFolder || this.getOwner() instanceof PacServer || this.getOwner() instanceof PacDialogServer)) {
            String codeIT;
            String codeMC = PacFreeRelationsUtil.getPacCommunicationMonitorFromPacFolderGOLine(this.getDescription().trim());
            if (codeMC != null) {
                PacCommunicationMonitor communicationMonitor = PacbaseFactory.eINSTANCE.createPacCommunicationMonitor();
                communicationMonitor.setName(codeMC);
                PacGLineImpl.registerRelation((String)nodePath, (String)PacbasePackage.eINSTANCE.getPacAbstractDialogFolder_GOLines().getName(), (RadicalEntity)communicationMonitor, (Map)freeRelations, null);
            }
            if ((codeIT = PacFreeRelationsUtil.getPacServerITFromPacFolderGOLine(this.getDescription().trim())) != null) {
                PacServer serverIT = PacbaseFactory.eINSTANCE.createPacServer();
                serverIT.setName(codeIT);
                serverIT.setDialogType(PacDialogServerTypeValues._IT_LITERAL);
                PacGLineImpl.registerRelation((String)nodePath, (String)PacbasePackage.eINSTANCE.getPacAbstractDialogFolder_GOLines().getName(), (RadicalEntity)serverIT, (Map)freeRelations, null);
            }
            super._getFreeRelations(nodePath, freeRelations);
        }
        if (nodePath.contains("GGLines[])") && (this.getOwner() instanceof DataAggregate || this.getOwner() instanceof PacBlockBase)) {
            if (this.getDescription().charAt(0) == '<') {
                String code = PacFreeRelationsUtil.getPacDataElementFromPacGLineDescriptionUnderBrackets(this.getDescription());
                if (code != null) {
                    DataElement dataElement = KernelFactory.eINSTANCE.createDataElement();
                    dataElement.setName(code);
                    EAttribute eAttribute = PacbasePackage.eINSTANCE.getPacGLine_Description();
                    PacGLineImpl.registerRelation((String)nodePath, (String)eAttribute.getName(), (RadicalEntity)dataElement, (Map)freeRelations, null);
                }
                super._getFreeRelations(nodePath, freeRelations);
            } else {
                String[] wordcond = this.getDescription().split("[):>\\s]+");
                int i = 0;
                while (i < wordcond.length) {
                    String code = PacFreeRelationsUtil.getPacDataElementFromPacCategoryCondition(wordcond[i]);
                    if (code != null) {
                        DataElement dataElement = KernelFactory.eINSTANCE.createDataElement();
                        dataElement.setName(code);
                        EAttribute eAttribute = PacbasePackage.eINSTANCE.getPacGLine_Description();
                        PacGLineImpl.registerRelation((String)nodePath, (String)eAttribute.getName(), (RadicalEntity)dataElement, (Map)freeRelations, null);
                    }
                    super._getFreeRelations(nodePath, freeRelations);
                    ++i;
                }
            }
        }
    }
}

