/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.impl;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.pacbase.PacDRLine;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacGeneratedTransactionTypeValues;
import com.ibm.pdp.mdl.pacbase.PacKLine;
import com.ibm.pdp.mdl.pacbase.PacKeyTypeValues;
import com.ibm.pdp.mdl.pacbase.PacSQLRecordTypeValues;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PacDRLineImpl
extends EntityImpl
implements PacDRLine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DataAggregate segment;
    protected EList kLines;
    protected static final PacSQLRecordTypeValues SQL_RECORD_TYPE_EDEFAULT = PacSQLRecordTypeValues._P_LITERAL;
    protected PacSQLRecordTypeValues sqlRecordType = SQL_RECORD_TYPE_EDEFAULT;
    protected static final String DATA_BASE_OBJECT_EXTERNAL_NAME_EDEFAULT = "";
    protected String dataBaseObjectExternalName = "";
    protected static final PacGeneratedTransactionTypeValues COMMAND_GENERATION_TYPE_EDEFAULT = PacGeneratedTransactionTypeValues._NONE_LITERAL;
    protected PacGeneratedTransactionTypeValues commandGenerationType = COMMAND_GENERATION_TYPE_EDEFAULT;
    protected static final PacKeyTypeValues KEY_TYPE_EDEFAULT = PacKeyTypeValues._BLANK_LITERAL;
    protected PacKeyTypeValues keyType = KEY_TYPE_EDEFAULT;
    protected EList ggLines;
    protected EList gcLines;
    protected DataAggregate referencedTable;

    protected PacDRLineImpl() {
    }

    protected EClass eStaticClass() {
        return PacbasePackage.Literals.PAC_DR_LINE;
    }

    public DataAggregate getSegment() {
        RadicalEntity resolvedObject;
        if (this.segment != null && this.segment.eIsProxy()) {
            InternalEObject oldSegment = (InternalEObject)this.segment;
            this.segment = (DataAggregate)this.eResolveProxy(oldSegment);
            if (this.segment != oldSegment && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldSegment, (Object)this.segment));
            }
        }
        if ((resolvedObject = this.resolveReference((RadicalEntity)this.segment)) instanceof DataAggregate) {
            this.segment = (DataAggregate)resolvedObject;
        }
        return this.segment;
    }

    public DataAggregate basicGetSegment() {
        return this.segment;
    }

    public void setSegment(DataAggregate newSegment) {
        DataAggregate oldSegment = this.segment;
        this.segment = newSegment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldSegment, (Object)this.segment));
        }
    }

    public EList getKLines() {
        if (this.kLines == null) {
            this.kLines = new EObjectContainmentEList(PacKLine.class, (InternalEObject)this, 1);
        }
        return this.kLines;
    }

    public PacSQLRecordTypeValues getSqlRecordType() {
        return this.sqlRecordType;
    }

    public void setSqlRecordType(PacSQLRecordTypeValues newSqlRecordType) {
        PacSQLRecordTypeValues oldSqlRecordType = this.sqlRecordType;
        PacSQLRecordTypeValues pacSQLRecordTypeValues = this.sqlRecordType = newSqlRecordType == null ? SQL_RECORD_TYPE_EDEFAULT : newSqlRecordType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSqlRecordType, (Object)this.sqlRecordType));
        }
    }

    public String getDataBaseObjectExternalName() {
        return this.dataBaseObjectExternalName;
    }

    public void setDataBaseObjectExternalName(String newDataBaseObjectExternalName) {
        String oldDataBaseObjectExternalName = this.dataBaseObjectExternalName;
        this.dataBaseObjectExternalName = newDataBaseObjectExternalName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDataBaseObjectExternalName, (Object)this.dataBaseObjectExternalName));
        }
    }

    public PacGeneratedTransactionTypeValues getCommandGenerationType() {
        return this.commandGenerationType;
    }

    public void setCommandGenerationType(PacGeneratedTransactionTypeValues newCommandGenerationType) {
        PacGeneratedTransactionTypeValues oldCommandGenerationType = this.commandGenerationType;
        PacGeneratedTransactionTypeValues pacGeneratedTransactionTypeValues = this.commandGenerationType = newCommandGenerationType == null ? COMMAND_GENERATION_TYPE_EDEFAULT : newCommandGenerationType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldCommandGenerationType, (Object)this.commandGenerationType));
        }
    }

    public PacKeyTypeValues getKeyType() {
        return this.keyType;
    }

    public void setKeyType(PacKeyTypeValues newKeyType) {
        PacKeyTypeValues oldKeyType = this.keyType;
        PacKeyTypeValues pacKeyTypeValues = this.keyType = newKeyType == null ? KEY_TYPE_EDEFAULT : newKeyType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldKeyType, (Object)this.keyType));
        }
    }

    public EList getGGLines() {
        if (this.ggLines == null) {
            this.ggLines = new EObjectContainmentEList(PacGLine.class, (InternalEObject)this, 6);
        }
        return this.ggLines;
    }

    public EList getGCLines() {
        if (this.gcLines == null) {
            this.gcLines = new EObjectContainmentEList(PacGLine.class, (InternalEObject)this, 7);
        }
        return this.gcLines;
    }

    public DataAggregate getReferencedTable() {
        if (this.referencedTable != null && this.referencedTable.eIsProxy()) {
            InternalEObject oldReferencedTable = (InternalEObject)this.referencedTable;
            this.referencedTable = (DataAggregate)this.eResolveProxy(oldReferencedTable);
            if (this.referencedTable != oldReferencedTable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldReferencedTable, (Object)this.referencedTable));
            }
        }
        return this.referencedTable;
    }

    public DataAggregate basicGetReferencedTable() {
        return this.referencedTable;
    }

    public void setReferencedTable(DataAggregate newReferencedTable) {
        DataAggregate oldReferencedTable = this.referencedTable;
        this.referencedTable = newReferencedTable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldReferencedTable, (Object)this.referencedTable));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getKLines()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getGGLines()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getGCLines()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getSegment();
                }
                return this.basicGetSegment();
            }
            case 1: {
                return this.getKLines();
            }
            case 2: {
                return this.getSqlRecordType();
            }
            case 3: {
                return this.getDataBaseObjectExternalName();
            }
            case 4: {
                return this.getCommandGenerationType();
            }
            case 5: {
                return this.getKeyType();
            }
            case 6: {
                return this.getGGLines();
            }
            case 7: {
                return this.getGCLines();
            }
            case 8: {
                if (resolve) {
                    return this.getReferencedTable();
                }
                return this.basicGetReferencedTable();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setSegment((DataAggregate)newValue);
                return;
            }
            case 1: {
                this.getKLines().clear();
                this.getKLines().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setSqlRecordType((PacSQLRecordTypeValues)((Object)newValue));
                return;
            }
            case 3: {
                this.setDataBaseObjectExternalName((String)newValue);
                return;
            }
            case 4: {
                this.setCommandGenerationType((PacGeneratedTransactionTypeValues)((Object)newValue));
                return;
            }
            case 5: {
                this.setKeyType((PacKeyTypeValues)((Object)newValue));
                return;
            }
            case 6: {
                this.getGGLines().clear();
                this.getGGLines().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getGCLines().clear();
                this.getGCLines().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setReferencedTable((DataAggregate)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setSegment(null);
                return;
            }
            case 1: {
                this.getKLines().clear();
                return;
            }
            case 2: {
                this.setSqlRecordType(SQL_RECORD_TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setDataBaseObjectExternalName(DATA_BASE_OBJECT_EXTERNAL_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setCommandGenerationType(COMMAND_GENERATION_TYPE_EDEFAULT);
                return;
            }
            case 5: {
                this.setKeyType(KEY_TYPE_EDEFAULT);
                return;
            }
            case 6: {
                this.getGGLines().clear();
                return;
            }
            case 7: {
                this.getGCLines().clear();
                return;
            }
            case 8: {
                this.setReferencedTable(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.segment != null;
            }
            case 1: {
                return this.kLines != null && !this.kLines.isEmpty();
            }
            case 2: {
                return this.sqlRecordType != SQL_RECORD_TYPE_EDEFAULT;
            }
            case 3: {
                return DATA_BASE_OBJECT_EXTERNAL_NAME_EDEFAULT == null ? this.dataBaseObjectExternalName != null : !DATA_BASE_OBJECT_EXTERNAL_NAME_EDEFAULT.equals(this.dataBaseObjectExternalName);
            }
            case 4: {
                return this.commandGenerationType != COMMAND_GENERATION_TYPE_EDEFAULT;
            }
            case 5: {
                return this.keyType != KEY_TYPE_EDEFAULT;
            }
            case 6: {
                return this.ggLines != null && !this.ggLines.isEmpty();
            }
            case 7: {
                return this.gcLines != null && !this.gcLines.isEmpty();
            }
            case 8: {
                return this.referencedTable != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sqlRecordType: ");
        result.append((Object)this.sqlRecordType);
        result.append(", dataBaseObjectExternalName: ");
        result.append(this.dataBaseObjectExternalName);
        result.append(", commandGenerationType: ");
        result.append((Object)this.commandGenerationType);
        result.append(", keyType: ");
        result.append((Object)this.keyType);
        result.append(')');
        return result.toString();
    }

    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof PacDRLine) {
            PacDRLine inputDRLine = (PacDRLine)eObject;
            isSame = ((Object)((Object)this.getSqlRecordType())).equals((Object)inputDRLine.getSqlRecordType());
            if (isSame) {
                URI inputUri;
                URI uri;
                isSame = this.getDataBaseObjectExternalName().equals(inputDRLine.getDataBaseObjectExternalName());
                if (isSame && this.getReferencedTable() != null && inputDRLine.getReferencedTable() != null) {
                    uri = this.getReferencedTable().getDesignURI();
                    inputUri = inputDRLine.getReferencedTable().getDesignURI();
                    isSame = uri.equals(inputUri);
                }
                if (isSame && this.getSegment() != null && inputDRLine.getSegment() != null) {
                    uri = this.getSegment().getDesignURI();
                    inputUri = inputDRLine.getSegment().getDesignURI();
                    isSame = uri.equals(inputUri);
                }
            }
        }
        return isSame;
    }

    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        hashCode += ((Object)((Object)this.getSqlRecordType())).hashCode();
        hashCode += this.getDataBaseObjectExternalName().hashCode();
        if (this.getReferencedTable() != null) {
            hashCode += this.getReferencedTable().getDesignURI().hashCode();
        }
        if (this.getSegment() != null) {
            hashCode += this.getSegment().getDesignURI().hashCode();
        }
        return hashCode;
    }
}

