/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.impl;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.pacbase.PacCodasylRecordTypeValues;
import com.ibm.pdp.mdl.pacbase.PacDCLine;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PacDCLineImpl
extends EntityImpl
implements PacDCLine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final PacCodasylRecordTypeValues NETWORK_RECORD_TYPE_EDEFAULT = PacCodasylRecordTypeValues._S_LITERAL;
    protected PacCodasylRecordTypeValues networkRecordType = NETWORK_RECORD_TYPE_EDEFAULT;
    protected static final String DATA_BASE_OBJECT_NAME_EDEFAULT = "";
    protected String dataBaseObjectName = "";
    protected static final String METHOD_CODE_EDEFAULT = "";
    protected String methodCode = "";
    protected static final int NUMBER_OCCURRENCES_SET_EDEFAULT = 0;
    protected int numberOccurrencesSet = 0;
    protected DataAggregate segment;
    protected DataAggregate child;
    protected static final String COMMENT_OR_NAME_EDEFAULT = "";
    protected String commentOrName = "";
    protected EList ggLines;
    protected DataAggregate fromSegment;
    protected EList gcLines;

    protected PacDCLineImpl() {
    }

    protected EClass eStaticClass() {
        return PacbasePackage.Literals.PAC_DC_LINE;
    }

    public PacCodasylRecordTypeValues getNetworkRecordType() {
        return this.networkRecordType;
    }

    public void setNetworkRecordType(PacCodasylRecordTypeValues newNetworkRecordType) {
        PacCodasylRecordTypeValues oldNetworkRecordType = this.networkRecordType;
        PacCodasylRecordTypeValues pacCodasylRecordTypeValues = this.networkRecordType = newNetworkRecordType == null ? NETWORK_RECORD_TYPE_EDEFAULT : newNetworkRecordType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldNetworkRecordType, (Object)this.networkRecordType));
        }
    }

    public String getDataBaseObjectName() {
        return this.dataBaseObjectName;
    }

    public void setDataBaseObjectName(String newDataBaseObjectName) {
        String oldDataBaseObjectName = this.dataBaseObjectName;
        this.dataBaseObjectName = newDataBaseObjectName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDataBaseObjectName, (Object)this.dataBaseObjectName));
        }
    }

    public String getMethodCode() {
        return this.methodCode;
    }

    public void setMethodCode(String newMethodCode) {
        String oldMethodCode = this.methodCode;
        this.methodCode = newMethodCode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldMethodCode, (Object)this.methodCode));
        }
    }

    public int getNumberOccurrencesSet() {
        return this.numberOccurrencesSet;
    }

    public void setNumberOccurrencesSet(int newNumberOccurrencesSet) {
        int oldNumberOccurrencesSet = this.numberOccurrencesSet;
        this.numberOccurrencesSet = newNumberOccurrencesSet;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldNumberOccurrencesSet, this.numberOccurrencesSet));
        }
    }

    public DataAggregate getSegment() {
        RadicalEntity resolvedObject;
        if (this.segment != null && this.segment.eIsProxy()) {
            InternalEObject oldSegment = (InternalEObject)this.segment;
            this.segment = (DataAggregate)this.eResolveProxy(oldSegment);
            if (this.segment != oldSegment && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldSegment, (Object)this.segment));
            }
        }
        if ((resolvedObject = this.resolveReference((RadicalEntity)this.segment)) instanceof DataAggregate) {
            this.segment = (DataAggregate)resolvedObject;
        }
        return this.segment;
    }

    public DataAggregate basicGetSegment() {
        return this.segment;
    }

    public void setSegment(DataAggregate newSegment) {
        DataAggregate oldSegment = this.segment;
        this.segment = newSegment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSegment, (Object)this.segment));
        }
    }

    public DataAggregate getChild() {
        RadicalEntity resolvedObject;
        if (this.child != null && this.child.eIsProxy()) {
            InternalEObject oldChild = (InternalEObject)this.child;
            this.child = (DataAggregate)this.eResolveProxy(oldChild);
            if (this.child != oldChild && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldChild, (Object)this.child));
            }
        }
        if ((resolvedObject = this.resolveReference((RadicalEntity)this.child)) instanceof DataAggregate) {
            this.child = (DataAggregate)resolvedObject;
        }
        return this.child;
    }

    public DataAggregate basicGetChild() {
        return this.child;
    }

    public void setChild(DataAggregate newChild) {
        DataAggregate oldChild = this.child;
        this.child = newChild;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldChild, (Object)this.child));
        }
    }

    public String getCommentOrName() {
        return this.commentOrName;
    }

    public void setCommentOrName(String newCommentOrName) {
        String oldCommentOrName = this.commentOrName;
        this.commentOrName = newCommentOrName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldCommentOrName, (Object)this.commentOrName));
        }
    }

    public EList getGGLines() {
        if (this.ggLines == null) {
            this.ggLines = new EObjectContainmentEList(PacGLine.class, (InternalEObject)this, 7);
        }
        return this.ggLines;
    }

    public DataAggregate getFromSegment() {
        RadicalEntity resolvedObject;
        if (this.fromSegment != null && this.fromSegment.eIsProxy()) {
            InternalEObject oldFromSegment = (InternalEObject)this.fromSegment;
            this.fromSegment = (DataAggregate)this.eResolveProxy(oldFromSegment);
            if (this.fromSegment != oldFromSegment && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldFromSegment, (Object)this.fromSegment));
            }
        }
        if ((resolvedObject = this.resolveReference((RadicalEntity)this.fromSegment)) instanceof DataAggregate) {
            this.fromSegment = (DataAggregate)resolvedObject;
        }
        return this.fromSegment;
    }

    public DataAggregate basicGetFromSegment() {
        return this.fromSegment;
    }

    public void setFromSegment(DataAggregate newFromSegment) {
        DataAggregate oldFromSegment = this.fromSegment;
        this.fromSegment = newFromSegment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldFromSegment, (Object)this.fromSegment));
        }
    }

    public EList getGCLines() {
        if (this.gcLines == null) {
            this.gcLines = new EObjectContainmentEList(PacGLine.class, (InternalEObject)this, 9);
        }
        return this.gcLines;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getGGLines()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getGCLines()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getNetworkRecordType();
            }
            case 1: {
                return this.getDataBaseObjectName();
            }
            case 2: {
                return this.getMethodCode();
            }
            case 3: {
                return new Integer(this.getNumberOccurrencesSet());
            }
            case 4: {
                if (resolve) {
                    return this.getSegment();
                }
                return this.basicGetSegment();
            }
            case 5: {
                if (resolve) {
                    return this.getChild();
                }
                return this.basicGetChild();
            }
            case 6: {
                return this.getCommentOrName();
            }
            case 7: {
                return this.getGGLines();
            }
            case 8: {
                if (resolve) {
                    return this.getFromSegment();
                }
                return this.basicGetFromSegment();
            }
            case 9: {
                return this.getGCLines();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setNetworkRecordType((PacCodasylRecordTypeValues)((Object)newValue));
                return;
            }
            case 1: {
                this.setDataBaseObjectName((String)newValue);
                return;
            }
            case 2: {
                this.setMethodCode((String)newValue);
                return;
            }
            case 3: {
                this.setNumberOccurrencesSet((Integer)newValue);
                return;
            }
            case 4: {
                this.setSegment((DataAggregate)newValue);
                return;
            }
            case 5: {
                this.setChild((DataAggregate)newValue);
                return;
            }
            case 6: {
                this.setCommentOrName((String)newValue);
                return;
            }
            case 7: {
                this.getGGLines().clear();
                this.getGGLines().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setFromSegment((DataAggregate)newValue);
                return;
            }
            case 9: {
                this.getGCLines().clear();
                this.getGCLines().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setNetworkRecordType(NETWORK_RECORD_TYPE_EDEFAULT);
                return;
            }
            case 1: {
                this.setDataBaseObjectName("");
                return;
            }
            case 2: {
                this.setMethodCode("");
                return;
            }
            case 3: {
                this.setNumberOccurrencesSet(0);
                return;
            }
            case 4: {
                this.setSegment(null);
                return;
            }
            case 5: {
                this.setChild(null);
                return;
            }
            case 6: {
                this.setCommentOrName("");
                return;
            }
            case 7: {
                this.getGGLines().clear();
                return;
            }
            case 8: {
                this.setFromSegment(null);
                return;
            }
            case 9: {
                this.getGCLines().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.networkRecordType != NETWORK_RECORD_TYPE_EDEFAULT;
            }
            case 1: {
                return "" == null ? this.dataBaseObjectName != null : !"".equals(this.dataBaseObjectName);
            }
            case 2: {
                return "" == null ? this.methodCode != null : !"".equals(this.methodCode);
            }
            case 3: {
                return this.numberOccurrencesSet != 0;
            }
            case 4: {
                return this.segment != null;
            }
            case 5: {
                return this.child != null;
            }
            case 6: {
                return "" == null ? this.commentOrName != null : !"".equals(this.commentOrName);
            }
            case 7: {
                return this.ggLines != null && !this.ggLines.isEmpty();
            }
            case 8: {
                return this.fromSegment != null;
            }
            case 9: {
                return this.gcLines != null && !this.gcLines.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (networkRecordType: ");
        result.append((Object)this.networkRecordType);
        result.append(", dataBaseObjectName: ");
        result.append(this.dataBaseObjectName);
        result.append(", methodCode: ");
        result.append(this.methodCode);
        result.append(", numberOccurrencesSet: ");
        result.append(this.numberOccurrencesSet);
        result.append(", commentOrName: ");
        result.append(this.commentOrName);
        result.append(')');
        return result.toString();
    }

    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof PacDCLine) {
            PacDCLine inputDCLine = (PacDCLine)eObject;
            isSame = ((Object)((Object)this.getNetworkRecordType())).equals((Object)inputDCLine.getNetworkRecordType());
            if (isSame) {
                isSame = this.getDataBaseObjectName().equals(inputDCLine.getDataBaseObjectName());
            }
            if (isSame) {
                if (this.getSegment() != null && inputDCLine.getSegment() != null) {
                    URI inputUri;
                    URI uri = this.getSegment().getDesignURI();
                    isSame = uri.equals(inputUri = inputDCLine.getSegment().getDesignURI());
                    if (isSame && this.getChild() != null && inputDCLine.getChild() != null) {
                        URI uric = this.getChild().getDesignURI();
                        URI inputUric = inputDCLine.getChild().getDesignURI();
                        isSame = uric.equals(inputUric);
                    }
                } else if (this.getChild() != null && inputDCLine.getChild() != null) {
                    URI uric = this.getChild().getDesignURI();
                    URI inputUric = inputDCLine.getChild().getDesignURI();
                    isSame = uric.equals(inputUric);
                }
            }
        }
        return isSame;
    }

    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        hashCode += ((Object)((Object)this.getNetworkRecordType())).hashCode();
        hashCode += this.getDataBaseObjectName().hashCode();
        if (this.getSegment() != null) {
            hashCode += this.getSegment().getDesignURI().hashCode();
        }
        if (this.getChild() != null) {
            hashCode += this.getChild().getDesignURI().hashCode();
        }
        return hashCode;
    }
}

