/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.impl;

import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.pacbase.PacCategory;
import com.ibm.pdp.mdl.pacbase.PacCategoryTypeValues;
import com.ibm.pdp.mdl.pacbase.PacEditionLine;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import com.ibm.pdp.mdl.pacbase.util.PacFreeRelationsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PacCategoryImpl
extends EntityImpl
implements PacCategory {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected EList editionLines;
    protected static final String CATEGORY_ID_EDEFAULT = "";
    protected String categoryID = "";
    protected static final PacCategoryTypeValues CATEGORY_TYPE_EDEFAULT = PacCategoryTypeValues._NONE_LITERAL;
    protected PacCategoryTypeValues categoryType = CATEGORY_TYPE_EDEFAULT;
    protected static final String COMMENT_EDEFAULT = "";
    protected String comment = "";
    protected static final int REPETITION_EDEFAULT = 0;
    protected int repetition = 0;
    protected static final String CATEGORY_CONDITION_EDEFAULT = "";
    protected String categoryCondition = "";

    protected PacCategoryImpl() {
    }

    protected EClass eStaticClass() {
        return PacbasePackage.Literals.PAC_CATEGORY;
    }

    public EList getEditionLines() {
        if (this.editionLines == null) {
            this.editionLines = new EObjectContainmentEList(PacEditionLine.class, (InternalEObject)this, 0);
        }
        return this.editionLines;
    }

    public String getCategoryID() {
        return this.categoryID;
    }

    public void setCategoryID(String newCategoryID) {
        String oldCategoryID = this.categoryID;
        this.categoryID = newCategoryID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCategoryID, (Object)this.categoryID));
        }
    }

    public PacCategoryTypeValues getCategoryType() {
        return this.categoryType;
    }

    public void setCategoryType(PacCategoryTypeValues newCategoryType) {
        PacCategoryTypeValues oldCategoryType = this.categoryType;
        PacCategoryTypeValues pacCategoryTypeValues = this.categoryType = newCategoryType == null ? CATEGORY_TYPE_EDEFAULT : newCategoryType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldCategoryType, (Object)this.categoryType));
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        String oldComment = this.comment;
        this.comment = newComment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldComment, (Object)this.comment));
        }
    }

    public int getRepetition() {
        return this.repetition;
    }

    public void setRepetition(int newRepetition) {
        int oldRepetition = this.repetition;
        this.repetition = newRepetition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldRepetition, this.repetition));
        }
    }

    public String getCategoryCondition() {
        return this.categoryCondition;
    }

    public void setCategoryCondition(String newCategoryCondition) {
        String oldCategoryCondition = this.categoryCondition;
        this.categoryCondition = newCategoryCondition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCategoryCondition, (Object)this.categoryCondition));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getEditionLines()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getEditionLines();
            }
            case 1: {
                return this.getCategoryID();
            }
            case 2: {
                return this.getCategoryType();
            }
            case 3: {
                return this.getComment();
            }
            case 4: {
                return new Integer(this.getRepetition());
            }
            case 5: {
                return this.getCategoryCondition();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getEditionLines().clear();
                this.getEditionLines().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setCategoryID((String)newValue);
                return;
            }
            case 2: {
                this.setCategoryType((PacCategoryTypeValues)((Object)newValue));
                return;
            }
            case 3: {
                this.setComment((String)newValue);
                return;
            }
            case 4: {
                this.setRepetition((Integer)newValue);
                return;
            }
            case 5: {
                this.setCategoryCondition((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getEditionLines().clear();
                return;
            }
            case 1: {
                this.setCategoryID("");
                return;
            }
            case 2: {
                this.setCategoryType(CATEGORY_TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setComment("");
                return;
            }
            case 4: {
                this.setRepetition(0);
                return;
            }
            case 5: {
                this.setCategoryCondition("");
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.editionLines != null && !this.editionLines.isEmpty();
            }
            case 1: {
                return "" == null ? this.categoryID != null : !"".equals(this.categoryID);
            }
            case 2: {
                return this.categoryType != CATEGORY_TYPE_EDEFAULT;
            }
            case 3: {
                return "" == null ? this.comment != null : !"".equals(this.comment);
            }
            case 4: {
                return this.repetition != 0;
            }
            case 5: {
                return "" == null ? this.categoryCondition != null : !"".equals(this.categoryCondition);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (categoryID: ");
        result.append(this.categoryID);
        result.append(", categoryType: ");
        result.append((Object)this.categoryType);
        result.append(", comment: ");
        result.append(this.comment);
        result.append(", repetition: ");
        result.append(this.repetition);
        result.append(", categoryCondition: ");
        result.append(this.categoryCondition);
        result.append(')');
        return result.toString();
    }

    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof PacCategory) {
            PacCategory inputCategory = (PacCategory)eObject;
            isSame = this.getCategoryID().equals(inputCategory.getCategoryID());
        }
        return isSame;
    }

    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        return hashCode += this.getCategoryID().hashCode();
    }

    protected boolean renameFreeReferences(String nodePath, String type, String oldName, String newName, List changedArtifactIds) {
        boolean result = false;
        String condition = this.getCategoryCondition();
        String newCondition = "";
        if (condition.length() != 0 && condition.indexOf(oldName) != -1) {
            String[] wordcond = this.getCategoryCondition().split("[=><'\\s]+");
            int currentWordCondIndex = 0;
            int i = 0;
            while (i < wordcond.length) {
                int newWordContIndex = condition.indexOf(wordcond[i], currentWordCondIndex);
                String stringBeforeWordCond = condition.substring(currentWordCondIndex, newWordContIndex);
                newCondition = String.valueOf(newCondition) + stringBeforeWordCond;
                currentWordCondIndex += stringBeforeWordCond.length();
                String replacedWordCondition = PacFreeRelationsUtil.renamePacDataElementFromPacCategoryCondition(wordcond[i].trim(), oldName, newName);
                if (replacedWordCondition != null) {
                    newCondition = String.valueOf(newCondition) + replacedWordCondition;
                    result = true;
                } else {
                    newCondition = String.valueOf(newCondition) + wordcond[i];
                }
                currentWordCondIndex += wordcond[i].length();
                ++i;
            }
        }
        if (result) {
            this.setCategoryCondition(newCondition);
        }
        boolean superResult = super.renameFreeReferences(nodePath, type, oldName, newName, changedArtifactIds);
        return result || superResult;
    }

    protected void _getFreeRelations(String nodePath, Map freeRelations) {
        if (this.getCategoryCondition().length() > 0) {
            String[] wordcond = this.getCategoryCondition().split("[=><'\\s]+");
            int i = 0;
            while (i < wordcond.length) {
                String code = PacFreeRelationsUtil.getPacDataElementFromPacCategoryCondition(wordcond[i]);
                if (code != null && code.length() > 0) {
                    DataElement dataElement = KernelFactory.eINSTANCE.createDataElement();
                    dataElement.setName(code);
                    EAttribute eAttribute = PacbasePackage.eINSTANCE.getPacCategory_CategoryCondition();
                    PacCategoryImpl.registerRelation((String)nodePath, (String)eAttribute.getName(), (RadicalEntity)dataElement, (Map)freeRelations, null);
                }
                ++i;
            }
        }
        super._getFreeRelations(nodePath, freeRelations);
    }
}

