/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.impl;

import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacStructuredLanguageEntity;
import com.ibm.pdp.mdl.pacbase.PacbaseFactory;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PacCPLineImpl
extends EntityImpl
implements PacCPLine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PacStructuredLanguageEntity macro;
    protected EList parameters;
    protected static final int LINE_NUMBER_EDEFAULT = 0;
    protected int lineNumber = 0;
    protected static final String COMMENT_EDEFAULT = "";
    protected String comment = "";

    protected PacCPLineImpl() {
    }

    protected EClass eStaticClass() {
        return PacbasePackage.Literals.PAC_CP_LINE;
    }

    public PacStructuredLanguageEntity getMacro() {
        RadicalEntity resolvedObject;
        if (this.macro != null && this.macro.eIsProxy()) {
            InternalEObject oldMacro = (InternalEObject)this.macro;
            this.macro = (PacStructuredLanguageEntity)this.eResolveProxy(oldMacro);
            if (this.macro != oldMacro && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldMacro, (Object)this.macro));
            }
        }
        if ((resolvedObject = this.resolveReference(this.macro)) instanceof PacStructuredLanguageEntity) {
            this.macro = (PacStructuredLanguageEntity)resolvedObject;
        }
        return this.macro;
    }

    public PacStructuredLanguageEntity basicGetMacro() {
        return this.macro;
    }

    public void setMacro(PacStructuredLanguageEntity newMacro) {
        PacStructuredLanguageEntity oldMacro = this.macro;
        this.macro = newMacro;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldMacro, (Object)this.macro));
        }
    }

    public EList getParameters() {
        if (this.parameters == null) {
            this.parameters = new EObjectContainmentEList(PacMacroParameter.class, (InternalEObject)this, 1);
        }
        return this.parameters;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int newLineNumber) {
        int oldLineNumber = this.lineNumber;
        this.lineNumber = newLineNumber;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldLineNumber, this.lineNumber));
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        String oldComment = this.comment;
        this.comment = newComment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldComment, (Object)this.comment));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getMacro();
                }
                return this.basicGetMacro();
            }
            case 1: {
                return this.getParameters();
            }
            case 2: {
                return new Integer(this.getLineNumber());
            }
            case 3: {
                return this.getComment();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setMacro((PacStructuredLanguageEntity)newValue);
                return;
            }
            case 1: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setLineNumber((Integer)newValue);
                return;
            }
            case 3: {
                this.setComment((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setMacro(null);
                return;
            }
            case 1: {
                this.getParameters().clear();
                return;
            }
            case 2: {
                this.setLineNumber(0);
                return;
            }
            case 3: {
                this.setComment(COMMENT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.macro != null;
            }
            case 1: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
            case 2: {
                return this.lineNumber != 0;
            }
            case 3: {
                return COMMENT_EDEFAULT == null ? this.comment != null : !COMMENT_EDEFAULT.equals(this.comment);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (lineNumber: ");
        result.append(this.lineNumber);
        result.append(", comment: ");
        result.append(this.comment);
        result.append(')');
        return result.toString();
    }

    public void initDefaultParameters() {
        String params = "1234567890";
        int i = 0;
        while (i < params.length()) {
            PacMacroParameter parameter = PacbaseFactory.eINSTANCE.createPacMacroParameter();
            parameter.setId("$" + params.charAt(i));
            this.getParameters().add((Object)parameter);
            ++i;
        }
    }

    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof PacCPLine) {
            PacCPLine inputCPLine = (PacCPLine)eObject;
            boolean bl = isSame = this.getLineNumber() == inputCPLine.getLineNumber();
            if (isSame && this.getMacro() != null && inputCPLine.getMacro() != null) {
                isSame = this.getMacro().getDesignURI().equals(inputCPLine.getMacro().getDesignURI());
            }
        }
        return isSame;
    }

    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        hashCode += this.getLineNumber();
        if (this.getMacro() != null) {
            hashCode += this.getMacro().getDesignURI().hashCode();
        }
        return hashCode;
    }
}

