/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.impl;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.Entity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.impl.EntityImpl;
import com.ibm.pdp.mdl.pacbase.PacAbstractNode;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacbasePackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public abstract class PacAbstractNodeImpl
extends EntityImpl
implements PacAbstractNode {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected PacServer pacServer;
    protected static final String NODE_CODE_EDEFAULT = "";
    protected String nodeCode = "";
    protected DataAggregate logicalView;

    protected PacAbstractNodeImpl() {
    }

    protected EClass eStaticClass() {
        return PacbasePackage.Literals.PAC_ABSTRACT_NODE;
    }

    public PacServer getPacServer() {
        this.getPacServerGen();
        RadicalEntity resolvedObject = this.resolveReference(this.pacServer);
        if (resolvedObject instanceof PacServer) {
            this.pacServer = (PacServer)resolvedObject;
        }
        return this.pacServer;
    }

    public PacServer getPacServerGen() {
        if (this.pacServer != null && this.pacServer.eIsProxy()) {
            InternalEObject oldPacServer = (InternalEObject)this.pacServer;
            this.pacServer = (PacServer)this.eResolveProxy(oldPacServer);
            if (this.pacServer != oldPacServer && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldPacServer, (Object)this.pacServer));
            }
        }
        return this.pacServer;
    }

    public PacServer basicGetPacServer() {
        return this.pacServer;
    }

    public void setPacServer(PacServer newPacServer) {
        PacServer oldPacServer = this.pacServer;
        this.pacServer = newPacServer;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPacServer, (Object)this.pacServer));
        }
    }

    public DataAggregate getLogicalView() {
        this.getLogicalViewGen();
        RadicalEntity resolvedObject = this.resolveReference((RadicalEntity)this.logicalView);
        if (resolvedObject instanceof DataAggregate) {
            this.logicalView = (DataAggregate)resolvedObject;
        }
        return this.logicalView;
    }

    public DataAggregate getLogicalViewGen() {
        if (this.logicalView != null && this.logicalView.eIsProxy()) {
            InternalEObject oldLogicalView = (InternalEObject)this.logicalView;
            this.logicalView = (DataAggregate)this.eResolveProxy(oldLogicalView);
            if (this.logicalView != oldLogicalView && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldLogicalView, (Object)this.logicalView));
            }
        }
        return this.logicalView;
    }

    public DataAggregate basicGetLogicalView() {
        return this.logicalView;
    }

    public void setLogicalView(DataAggregate newLogicalView) {
        DataAggregate oldLogicalView = this.logicalView;
        this.logicalView = newLogicalView;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldLogicalView, (Object)this.logicalView));
        }
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public void setNodeCode(String newNodeCode) {
        String oldNodeCode = this.nodeCode;
        this.nodeCode = newNodeCode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldNodeCode, (Object)this.nodeCode));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getPacServer();
                }
                return this.basicGetPacServer();
            }
            case 1: {
                return this.getNodeCode();
            }
            case 2: {
                if (resolve) {
                    return this.getLogicalView();
                }
                return this.basicGetLogicalView();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPacServer((PacServer)newValue);
                return;
            }
            case 1: {
                this.setNodeCode((String)newValue);
                return;
            }
            case 2: {
                this.setLogicalView((DataAggregate)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPacServer(null);
                return;
            }
            case 1: {
                this.setNodeCode(NODE_CODE_EDEFAULT);
                return;
            }
            case 2: {
                this.setLogicalView(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.pacServer != null;
            }
            case 1: {
                return NODE_CODE_EDEFAULT == null ? this.nodeCode != null : !NODE_CODE_EDEFAULT.equals(this.nodeCode);
            }
            case 2: {
                return this.logicalView != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (nodeCode: ");
        result.append(this.nodeCode);
        result.append(')');
        return result.toString();
    }

    public boolean isSame(Entity eObject) {
        boolean isSame = false;
        if (eObject instanceof PacAbstractNode) {
            URI inputUri;
            URI uri;
            PacAbstractNode inputNode = (PacAbstractNode)eObject;
            isSame = this.getNodeCode().equals(inputNode.getNodeCode());
            if (isSame && this.getLogicalView() != null && inputNode.getLogicalView() != null) {
                uri = this.getLogicalView().getDesignURI();
                inputUri = inputNode.getLogicalView().getDesignURI();
                isSame = uri.equals(inputUri);
            }
            if (isSame && this.getPacServer() != null && inputNode.getPacServer() != null) {
                uri = this.getPacServer().getDesignURI();
                inputUri = inputNode.getPacServer().getDesignURI();
                isSame = uri.equals(inputUri);
            }
        }
        return isSame;
    }

    public int isSameHashCode() {
        int hashCode = this.eClass().getName().hashCode();
        hashCode += this.getNodeCode().hashCode();
        if (this.getLogicalView() != null) {
            hashCode += this.getLogicalView().getDesignURI().hashCode();
        }
        if (this.getPacServer() != null) {
            hashCode += this.getPacServer().getDesignURI().hashCode();
        }
        return hashCode;
    }
}

