/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.converter;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DateTimeType;
import com.ibm.pdp.mdl.kernel.DecimalType;
import com.ibm.pdp.mdl.kernel.IntegerType;
import com.ibm.pdp.mdl.kernel.KernelFactory;
import com.ibm.pdp.mdl.kernel.SimpleType;
import com.ibm.pdp.mdl.kernel.StringType;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacGeneratedDateFormatValues;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;

public class PacTypeConverter {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static SimpleType normalize(PacDataElementDescription pacDescription) {
        StringType simpleType = null;
        PacPictureParser pictureParser = new PacPictureParser(pacDescription.getInternalFormat());
        char usage = '?';
        if (pacDescription.getInternalUsage() != null) {
            usage = pacDescription.getInternalUsage().getLiteral().charAt(1);
        }
        if (pictureParser.isAlphabetic() || pictureParser.isAlphanumeric()) {
            StringType stringType = KernelFactory.eINSTANCE.createStringType();
            stringType.setMaxLength(pictureParser.getCapacity());
            simpleType = stringType;
        } else if (pictureParser.isNumeric() || PacPictureParser.IsNativeUsage(usage) || PacPictureParser.IsBytesPictureUsage(usage)) {
            if (pictureParser.getDecimals() == 0) {
                IntegerType integerType = KernelFactory.eINSTANCE.createIntegerType();
                String max = "";
                String min = "0";
                int i = 0;
                while (i < pictureParser.getCapacity()) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                if (pictureParser.hasSign()) {
                    min = "-" + max;
                }
                integerType.setMaxValue(max);
                integerType.setMinValue(min);
                simpleType = integerType;
            } else {
                DecimalType decimalType = KernelFactory.eINSTANCE.createDecimalType();
                String max = "";
                String min = "0";
                int intLength = pictureParser.getCapacity() - pictureParser.getDecimals();
                int i = 0;
                while (i < intLength) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                max = String.valueOf(max) + ".";
                i = 0;
                while (i < pictureParser.getDecimals()) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                if (max.startsWith(".")) {
                    max = String.valueOf('0') + max;
                }
                if (min.startsWith(".")) {
                    min = String.valueOf('0') + min;
                }
                if (pictureParser.hasSign()) {
                    min = "-" + max;
                }
                decimalType.setMaxValue(max);
                decimalType.setMinValue(min);
                simpleType = decimalType;
            }
        } else if (pictureParser.isDate()) {
            DateTimeType dateTimeType = KernelFactory.eINSTANCE.createDateTimeType();
            PacGeneratedDateFormatValues dF = PacGeneratedDateFormatValues._E_LITERAL;
            if (pacDescription.eContainer() != null && pacDescription.eContainer().eContainer() != null && pacDescription.eContainer().eContainer() instanceof DataElement) {
                DataElement dataElement = (DataElement)pacDescription.eContainer().eContainer();
                for (Object object : dataElement.getExtensions()) {
                    if (!(object instanceof PacDataElement)) continue;
                    PacDataElement pacDataElement = (PacDataElement)object;
                    dF = pacDataElement.getGenerationParameter().getGeneratedDateFormat();
                    break;
                }
            }
            switch (pictureParser.getDateFormat()) {
                case 'D': {
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MMddyy");
                        break;
                    }
                    dateTimeType.setFormat("ddMMyy");
                    break;
                }
                case 'I': {
                    dateTimeType.setFormat("yyMMdd");
                    break;
                }
                case 'E': {
                    char sep = PacTypeConverter.getRealDateSeparator(pacDescription, pictureParser);
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MM" + sep + "dd" + sep + "yy");
                        break;
                    }
                    dateTimeType.setFormat("dd" + sep + "MM" + sep + "yy");
                    break;
                }
                case 'S': {
                    dateTimeType.setFormat("yyyyMMdd");
                    break;
                }
                case 'C': {
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MMddyyyy");
                        break;
                    }
                    dateTimeType.setFormat("ddMMyyyy");
                    break;
                }
                case 'M': {
                    char sep = PacTypeConverter.getRealDateSeparator(pacDescription, pictureParser);
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MM" + sep + "dd" + sep + "yyyy");
                        break;
                    }
                    dateTimeType.setFormat("dd" + sep + "MM" + sep + "yyyy");
                    break;
                }
                case 'G': {
                    char sep = PacTypeConverter.getRealDateSeparator(pacDescription, pictureParser);
                    dateTimeType.setFormat("yyyy" + sep + "MM" + sep + "dd");
                    break;
                }
                case 'T': {
                    char sep = PacTypeConverter.getRealTimeSeparator(pacDescription, pictureParser);
                    dateTimeType.setFormat("HH" + sep + "mm" + sep + "ss");
                    break;
                }
                case 'X': {
                    dateTimeType.setFormat("yyyy/MM/dd-HH:mm:ss.S");
                    break;
                }
            }
            simpleType = dateTimeType;
        }
        return simpleType;
    }

    private static char getRealDateSeparator(PacDataElementDescription pacDescription, PacPictureParser pictureParser) {
        int sep = pictureParser.getDateSeparator();
        if (sep == 32) {
            sep = pictureParser.getDateFormat() == 'G' ? 45 : 47;
        }
        return (char)sep;
    }

    private static char getRealDateSeparator(PacFiller pacFiller, PacPictureParser pictureParser) {
        int sep = pictureParser.getDateSeparator();
        if (sep == 32) {
            sep = pictureParser.getDateFormat() == 'G' ? 45 : 47;
        }
        return (char)sep;
    }

    private static char getRealTimeSeparator(PacDataElementDescription pacDescription, PacPictureParser pictureParser) {
        char sep = pictureParser.getDateSeparator();
        if (sep == ' ') {
            sep = ':';
        }
        return (char)sep;
    }

    private static char getRealTimeSeparator(PacFiller pacFiller, PacPictureParser pictureParser) {
        char sep = pictureParser.getDateSeparator();
        if (sep == ' ') {
            sep = ':';
        }
        return (char)sep;
    }

    public static SimpleType normalize(PacFiller pacFiller, PacLibrary lib) {
        StringType simpleType = null;
        PacPictureParser pictureParser = new PacPictureParser(pacFiller.getFormat());
        char usage = '?';
        if (pacFiller.getUsage() != null) {
            usage = pacFiller.getUsage().getLiteral().charAt(1);
        }
        if (pictureParser.isAlphabetic() || pictureParser.isAlphanumeric()) {
            StringType stringType = KernelFactory.eINSTANCE.createStringType();
            stringType.setMaxLength(pictureParser.getCapacity());
            simpleType = stringType;
        } else if (pictureParser.isNumeric() || PacPictureParser.IsNativeUsage(usage) || PacPictureParser.IsBytesPictureUsage(usage)) {
            if (pictureParser.getDecimals() == 0) {
                IntegerType integerType = KernelFactory.eINSTANCE.createIntegerType();
                String max = "";
                String min = "0";
                int i = 0;
                while (i < pictureParser.getCapacity()) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                if (pictureParser.hasSign()) {
                    min = "-" + max;
                }
                integerType.setMaxValue(max);
                integerType.setMinValue(min);
                simpleType = integerType;
            } else {
                DecimalType decimalType = KernelFactory.eINSTANCE.createDecimalType();
                String max = "";
                String min = "0";
                int intLength = pictureParser.getCapacity() - pictureParser.getDecimals();
                int i = 0;
                while (i < intLength) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                max = String.valueOf(max) + ".";
                i = 0;
                while (i < pictureParser.getDecimals()) {
                    max = String.valueOf(max) + "9";
                    ++i;
                }
                if (max.startsWith(".")) {
                    max = String.valueOf('0') + max;
                }
                if (min.startsWith(".")) {
                    min = String.valueOf('0') + min;
                }
                if (pictureParser.hasSign()) {
                    min = "-" + max;
                }
                decimalType.setMaxValue(max);
                decimalType.setMinValue(min);
                simpleType = decimalType;
            }
        } else if (pictureParser.isDate()) {
            DateTimeType dateTimeType = KernelFactory.eINSTANCE.createDateTimeType();
            PacGeneratedDateFormatValues dF = PacGeneratedDateFormatValues._E_LITERAL;
            if (pacFiller.eContainer() != null && pacFiller.eContainer().eContainer() != null && pacFiller.eContainer().eContainer().eContainer() != null && pacFiller.eContainer().eContainer().eContainer() instanceof DataAggregate) {
                dF = lib.getGeneratedDateFormat();
            }
            switch (pictureParser.getDateFormat()) {
                case 'D': {
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MMddyy");
                        break;
                    }
                    dateTimeType.setFormat("ddMMyy");
                    break;
                }
                case 'I': {
                    dateTimeType.setFormat("yyMMdd");
                    break;
                }
                case 'E': {
                    char sep = PacTypeConverter.getRealDateSeparator(pacFiller, pictureParser);
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MM" + sep + "dd" + sep + "yy");
                        break;
                    }
                    dateTimeType.setFormat("dd" + sep + "MM" + sep + "yy");
                    break;
                }
                case 'S': {
                    dateTimeType.setFormat("yyyyMMdd");
                    break;
                }
                case 'C': {
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MMddyyyy");
                        break;
                    }
                    dateTimeType.setFormat("ddMMyyyy");
                    break;
                }
                case 'M': {
                    char sep = PacTypeConverter.getRealDateSeparator(pacFiller, pictureParser);
                    if (dF == PacGeneratedDateFormatValues._E_LITERAL) {
                        dateTimeType.setFormat("MM" + sep + "dd" + sep + "yyyy");
                        break;
                    }
                    dateTimeType.setFormat("dd" + sep + "MM" + sep + "yyyy");
                    break;
                }
                case 'G': {
                    char sep = PacTypeConverter.getRealDateSeparator(pacFiller, pictureParser);
                    dateTimeType.setFormat("yyyy" + sep + "MM" + sep + "dd");
                    break;
                }
                case 'T': {
                    char sep = PacTypeConverter.getRealTimeSeparator(pacFiller, pictureParser);
                    dateTimeType.setFormat("HH" + sep + "mm" + sep + "ss");
                    break;
                }
                case 'X': {
                    dateTimeType.setFormat("yyyy/MM/dd-HH:mm:ss.S");
                    break;
                }
            }
            simpleType = dateTimeType;
        }
        return simpleType;
    }
}

