/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.converter;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.MetaEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.UserEntity;
import com.ibm.pdp.mdl.pacbase.AssignmentCall;
import com.ibm.pdp.mdl.pacbase.PacAbstracttextLine;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacInputAid;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacText;
import com.ibm.pdp.mdl.pacbase.PacTextAssignmentLine;
import com.ibm.pdp.mdl.pacbase.PacTextAssignmentText;
import com.ibm.pdp.mdl.pacbase.PacTextLine;
import com.ibm.pdp.mdl.pacbase.PacTextLineTypeValues;
import com.ibm.pdp.mdl.pacbase.PacTextSection;
import com.ibm.pdp.mdl.pacbase.PacVolume;
import com.ibm.pdp.mdl.pacbase.util.PacEnumerationLabel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacTextConverter {
    public static final String Copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _60Space = "                                                             ";
    public static final int _TextMaxLineLength = 60;

    public static String formatSourceSection(PacTextSection section) {
        Iterator lines = section.getLines().iterator();
        StringBuilder buffer = new StringBuilder("");
        while (lines.hasNext()) {
            PacAbstracttextLine line = (PacAbstracttextLine)lines.next();
            buffer.append(PacTextConverter.transformPacTextContent(line));
        }
        return buffer.toString();
    }

    public static String transformPacTextContent(PacAbstracttextLine object) {
        PacAbstracttextLine txtLine = object;
        StringBuilder buffer = new StringBuilder("");
        if (txtLine instanceof PacTextLine) {
            PacTextLine line = (PacTextLine)txtLine;
            buffer.append(PacTextConverter.transformPacTextLine(line));
            buffer.append(System.getProperty("line.separator"));
        } else if (txtLine instanceof PacTextAssignmentLine) {
            PacTextAssignmentLine line = (PacTextAssignmentLine)txtLine;
            buffer.append(PacTextConverter.transformPacTextAssignmentLine(line));
            buffer.append(System.getProperty("line.separator"));
        } else if (txtLine instanceof PacTextAssignmentText) {
            PacTextAssignmentText line = (PacTextAssignmentText)txtLine;
            buffer.append(PacTextConverter.transformPacTextAssignmentText(line));
            buffer.append(System.getProperty("line.separator"));
        } else {
            buffer.append("ko");
        }
        return buffer.toString();
    }

    public static String transformPacTextLine(PacTextLine object) {
        String line = "";
        PacTextLine txtLine = object;
        StringBuilder buffer = new StringBuilder("");
        StringBuilder bufferTemp = new StringBuilder(PacTextConverter.getLineType(txtLine)).append(" ").append(txtLine.getLineText());
        String de = PacTextConverter.getDataElement(txtLine);
        if (de.trim().length() > 0) {
            buffer.append(PacTextConverter.fillStringWithSpace(bufferTemp.toString(), 61));
            buffer.append(" @DEL").append(de);
        } else {
            buffer.append((CharSequence)bufferTemp);
        }
        line = PacTextConverter.fillStringWithSpace(buffer.toString(), 72);
        return line;
    }

    public static List<PacTextLineCommonModel> CutSectionToLine(PacTextSection section, PacText text) {
        if (!text.getEntityVersion().equals("9.1.2")) {
            Iterator it = section.getLines().iterator();
            ArrayList<PacTextLineCommonModel> res = new ArrayList<PacTextLineCommonModel>(section.getLines().size());
            while (it.hasNext()) {
                PacAbstracttextLine l = (PacAbstracttextLine)it.next();
                if (!(l instanceof PacTextLine)) continue;
                PacTextLineCommonModel oldLine = new PacTextLineCommonModel((PacTextLine)l);
                res.add(oldLine);
            }
            return res;
        }
        if (section.getSource() == null) {
            return new ArrayList<PacTextLineCommonModel>();
        }
        String[] allLines = section.getSource().split(System.getProperty("line.separator"));
        ArrayList<PacTextLineCommonModel> res = new ArrayList<PacTextLineCommonModel>(allLines.length);
        int i = 0;
        while (i < allLines.length) {
            String line = allLines[i];
            PacTextLineCommonModel oldLine = new PacTextLineCommonModel(line);
            if (!(line.length() >= 4 && (((Object)((Object)oldLine.getLineType())).equals((Object)PacTextLineTypeValues._I_LITERAL) || ((Object)((Object)oldLine.getLineType())).equals((Object)PacTextLineTypeValues._J_LITERAL) || ((Object)((Object)oldLine.getLineType())).equals((Object)PacTextLineTypeValues._E_LITERAL) || ((Object)((Object)oldLine.getLineType())).equals((Object)PacTextLineTypeValues._B_LITERAL) || ((Object)((Object)oldLine.getLineType())).equals((Object)PacTextLineTypeValues._Y_LITERAL)))) {
                res.add(oldLine);
            }
            ++i;
        }
        return res;
    }

    public static String transformPacTextAssignmentLine(PacTextAssignmentLine object) {
        String line = "";
        PacTextAssignmentLine txtLine = object;
        StringBuilder buffer = new StringBuilder("");
        StringBuilder bufferTemp = new StringBuilder(PacTextConverter.getLineType(txtLine));
        bufferTemp.append(" ");
        if (txtLine.getLineType() == PacTextLineTypeValues._I_LITERAL || txtLine.getLineType() == PacTextLineTypeValues._B_LITERAL) {
            bufferTemp.append(PacTextConverter.getAssignLine(txtLine, (EList<AssignmentCall>)txtLine.getAssignmentCalls(), PacTextConverter.getLineType(txtLine)));
        }
        if (txtLine.getLineType() == PacTextLineTypeValues._J_LITERAL || txtLine.getLineType() == PacTextLineTypeValues._E_LITERAL) {
            bufferTemp.append(PacTextConverter.getAssignLine(txtLine, (EList<AssignmentCall>)txtLine.getEndAssignmentCalls(), PacTextConverter.getLineType(txtLine)));
        }
        bufferTemp.append(" " + txtLine.getUnknownEntities());
        StringBuilder bufferTemp2 = new StringBuilder();
        if (bufferTemp.toString().length() > 60) {
            String[] lines = PacTextConverter.wrapText(bufferTemp.toString(), 0, 60);
            String newText = "";
            int i = 0;
            while (i < lines.length) {
                newText = String.valueOf(newText) + lines[i];
                if (i < lines.length - 1) {
                    newText = String.valueOf(newText) + System.getProperty("line.separator") + PacTextConverter.getLineType(txtLine) + " ";
                }
                ++i;
            }
            bufferTemp2.append(newText);
        } else {
            bufferTemp2 = bufferTemp;
        }
        String de = PacTextConverter.getDataElement(txtLine);
        if (de.trim().length() > 0) {
            buffer.append(PacTextConverter.fillStringWithSpace(bufferTemp2.toString(), 61));
            buffer.append(" @DEL").append(de);
        } else {
            buffer.append((CharSequence)bufferTemp2);
        }
        line = PacTextConverter.fillStringWithSpace(buffer.toString(), 72);
        return line;
    }

    public static String transformPacTextAssignmentText(PacTextAssignmentText object) {
        String line = "";
        PacTextAssignmentText txtLine = object;
        StringBuilder buffer = new StringBuilder("");
        StringBuilder bufferTemp = new StringBuilder("");
        bufferTemp.append(PacTextConverter.getLineType(txtLine)).append(" ");
        String str = (String.valueOf(PacTextConverter.getAssignText(txtLine, txtLine.getReferencedText())) + _60Space).substring(0, 60);
        bufferTemp.append(str);
        String de = PacTextConverter.getDataElement(txtLine);
        if (de.trim().length() > 0) {
            buffer.append(PacTextConverter.fillStringWithSpace(bufferTemp.toString(), 61));
            buffer.append(" @DEL").append(de);
        } else {
            buffer.append((CharSequence)bufferTemp);
        }
        line = PacTextConverter.fillStringWithSpace(buffer.toString(), 72);
        return line;
    }

    public static String getAssignText(PacTextAssignmentText line, PacText refText) {
        StringBuilder element = new StringBuilder(" @TXT");
        element.append(refText == null ? "unknown" : refText.getProxyName());
        if (line.getSectionCode() != null) {
            element.append(" ");
            element.append(line.getSectionCode());
        }
        return element.toString();
    }

    public static String fillStringWithSpace(String stringToFill, int minLength) {
        if (stringToFill.length() >= minLength) {
            return stringToFill;
        }
        StringBuilder builder = new StringBuilder(stringToFill);
        while (builder.length() < minLength) {
            builder = builder.append(" ");
        }
        return builder.toString();
    }

    public static String getAssignLine(PacTextAssignmentLine line, EList<AssignmentCall> entities, String lineType) {
        StringBuilder elements = new StringBuilder("");
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            StringBuilder element = new StringBuilder("@");
            AssignmentCall ac = (AssignmentCall)iterator.next();
            RadicalEntity rad = ac.getRadicalEntity();
            if (rad instanceof PacBlockBase) {
                element.append("DBD");
            } else if (rad instanceof DataUnit) {
                element.append("DST");
            } else if (rad instanceof DataElement) {
                element.append("DEL");
            } else if (rad instanceof PacDialog) {
                element.append("OST");
            } else if (rad instanceof PacDialogServer) {
                element.append("OSV");
            } else if (rad instanceof PacScreen) {
                element.append("SCR");
            } else if (rad instanceof PacServer) {
                element.append("SRV");
            } else if (rad instanceof PacProgram) {
                element.append("PGM");
            } else if (rad instanceof PacMacro) {
                element.append("MSP");
            } else if (rad instanceof PacReport) {
                element.append("RPT");
            } else if (rad instanceof DataAggregate) {
                element.append("SEG");
            } else if (rad instanceof PacText) {
                element.append("TXT");
            } else if (rad instanceof PacInputAid) {
                element.append("IAD");
            } else if (rad instanceof PacLibrary) {
                element.append("LIB");
            } else if (rad instanceof PacReport) {
                element.append("RPT");
            } else if (rad instanceof MetaEntity) {
                element.append("MET");
            } else if (rad instanceof PacVolume) {
                element.append("VOL");
            } else if (rad instanceof UserEntity) {
                UserEntity cfr_ignored_0 = (UserEntity)rad;
                element.append("USE");
            }
            element.append(rad.getProxyName());
            if (rad instanceof UserEntity) {
                element.append(".");
                element.append(String.valueOf(rad.getMetaEntity().getProxyName()) + " ");
            } else {
                element.append(" ");
            }
            elements.append((CharSequence)element);
        }
        elements.trimToSize();
        return elements.toString();
    }

    public static String getLineType(PacAbstracttextLine line) {
        PacTextLineTypeValues value = line.getLineType();
        if (value.getName().equals("_None")) {
            return " ";
        }
        String sValue = PacEnumerationLabel.getString(PacTextLineTypeValues.class, value);
        return sValue.substring(0, 1);
    }

    public static String getDataElement(PacAbstracttextLine line) {
        String element = "";
        if (line.getDataDefinition() != null) {
            element = line.getDataDefinition().getName();
        } else if (line.getDataDescription() != null) {
            element = line.getDataDescription().getName();
        }
        return element;
    }

    public static String[] wrapText(String _text, int _left, int _right) {
        String text = _text;
        if (text == null) {
            return new String[0];
        }
        if (_right <= 0) {
            return new String[]{text};
        }
        if (text.length() <= _right) {
            return new String[]{text};
        }
        char[] chars = text.toCharArray();
        Vector<String> lines = new Vector<String>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            word.append(chars[i]);
            if (chars[i] == ' ') {
                if (line.length() + word.length() > _right) {
                    lines.add(line.toString());
                    line.delete(0, line.length());
                }
                line.append((CharSequence)word);
                word.delete(0, word.length());
            }
            ++i;
        }
        if (word.length() > 0) {
            if (line.length() + word.length() > _right) {
                lines.add(line.toString());
                line.delete(0, line.length());
            }
            line.append((CharSequence)word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        String[] ret = new String[lines.size()];
        int c = 0;
        String leftPadString = "";
        int i2 = 0;
        while (i2 < _left) {
            leftPadString = String.valueOf(leftPadString) + " ";
            ++i2;
        }
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            String newText = (String)e.nextElement();
            ret[c] = newText.startsWith(leftPadString) ? newText : String.valueOf(leftPadString) + newText;
            ++c;
        }
        return ret;
    }

    public static class PacTextLineCommonModel {
        PacTextLineTypeValues lineType;
        String lineText;

        protected PacTextLineCommonModel(String line) {
            this.init(line);
        }

        protected PacTextLineCommonModel(PacTextLine line) {
            this.init(line);
        }

        private void init(PacTextLine line) {
            this.lineType = line.getLineType();
            this.lineText = line.getLineText();
        }

        private void init(String line) {
            line = String.valueOf(line) + PacTextConverter._60Space;
            int l = Math.min(line.length(), 62);
            this.lineType = PacTextLineTypeValues.get("_" + line.substring(0, 1));
            if (this.lineType == null) {
                switch (line.charAt(0)) {
                    case '-': {
                        this.lineType = PacTextLineTypeValues._MINUS_LITERAL;
                        break;
                    }
                    case '=': {
                        this.lineType = PacTextLineTypeValues._EQUAL_LITERAL;
                        break;
                    }
                    case '+': {
                        this.lineType = PacTextLineTypeValues._PLUS_LITERAL;
                        break;
                    }
                    case '*': {
                        this.lineType = PacTextLineTypeValues._STAR_LITERAL;
                        break;
                    }
                    case '_': {
                        this.lineType = PacTextLineTypeValues._UNDER_LITERAL;
                        break;
                    }
                    default: {
                        this.lineType = PacTextLineTypeValues._NONE_LITERAL;
                    }
                }
            }
            this.lineText = line.substring(2, l);
        }

        public PacTextLineTypeValues getLineType() {
            return this.lineType;
        }

        public String getLineText() {
            return this.lineText;
        }
    }
}

