/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.converter;

import com.ibm.pdp.mdl.pacbase.PacTimestampFractionValues;
import com.ibm.pdp.mdl.pacbase.PacTimezoneValues;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationDataElementType;

public class PacPictureParser {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String picture;
    protected boolean isParsed = false;
    protected boolean isDecimalCharacter = false;
    protected Character decimalCharacter;
    protected boolean partieDecimale = false;
    protected boolean searchFor = false;
    protected boolean isSpecialCharacter = false;
    protected int ilen = -1;
    protected char[] c = new char[0];
    protected int i = 0;
    protected int type = -1;
    protected int subtype = -1;
    protected int subtypedate = -1;
    protected int length = 0;
    protected int decimales = 0;
    protected PacTimestampFractionValues nbSec = PacTimestampFractionValues._6_LITERAL;
    protected PacTimezoneValues timezone = PacTimezoneValues._FALSE_LITERAL;
    protected static final int ALPHABETIC = 0;
    protected static final int ALPHANUMERIC = 1;
    protected static final int NUMERIC = 2;
    protected static final int DATE = 3;
    protected static final int DATE_DATE = 4;
    protected static final int DATE_TIME = 5;
    protected static final int DATE_TIMESTAMP = 7;
    protected static final int NATIONAL = 8;
    protected static final int DATE_NUMERIC = 9;
    protected static final int DATE_NON_NUMERIC = 10;

    public PacPictureParser(String pic) {
        this.picture = pic == null ? "" : pic.trim();
    }

    public PacPictureParser(String pic, PacTimestampFractionValues pacTSFraction, PacTimezoneValues timezone) {
        if (pic == null) {
            this.picture = "";
        } else {
            this.picture = pic.trim();
            this.nbSec = pacTSFraction;
            this.timezone = timezone;
        }
    }

    public PacPictureParser(String pic, boolean searchFor) {
        this.picture = pic == null ? "" : pic.trim();
        this.searchFor = searchFor;
    }

    public static boolean IsNativeUsage(char c) {
        return c == 'F' || c == 'W' || c == 'Y' || c == 'J' || c == 'U' || c == '0' || c == '5' || c == '6';
    }

    public static boolean IsBytesPictureUsage(char c) {
        return c == 'B' || c == 'L' || c == '7';
    }

    public int getCapacity() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.length;
    }

    public char getDateFormat() {
        if (!this.isDate()) {
            return ' ';
        }
        if (this.picture.trim().equals("TS")) {
            return 'X';
        }
        return this.picture.charAt(0);
    }

    public int getDecimals() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.decimales;
    }

    public char getDateSeparator() {
        if (!this.isDate()) {
            return ' ';
        }
        if (this.picture.trim().equals("TS") || this.picture.trim().length() < 2) {
            return ' ';
        }
        return this.picture.charAt(1);
    }

    public PacTimestampFractionValues getNbSec() {
        return this.nbSec;
    }

    public void setNbSec(PacTimestampFractionValues nbSec) {
        this.nbSec = nbSec;
    }

    public PacTimezoneValues getTimezone() {
        return this.timezone;
    }

    public void setTimezone(PacTimezoneValues timezone) {
        this.timezone = timezone;
    }

    public boolean hasSign() {
        return this.isNumeric() && (this.picture.trim().startsWith("S") || this.picture.trim().endsWith("S"));
    }

    public boolean isAlphabetic() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.type == 0;
    }

    public boolean isAlphanumeric() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.type == 1;
    }

    public boolean isDate() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.type == 3;
    }

    public boolean isDateSubType() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.subtype == 4;
    }

    public boolean isTimeSubType() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.subtype == 5;
    }

    public boolean isTimestampSubType() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.subtype == 7;
    }

    public boolean isDateNumeric() {
        return this.type == 3 && this.subtypedate == 9;
    }

    public boolean isNumeric() {
        if (!this.isParsed) {
            this.parse();
        }
        return this.type == 2;
    }

    public boolean isPartieDecimale() {
        return this.partieDecimale;
    }

    public void setPartieDecimale(boolean partieDecimale) {
        this.partieDecimale = partieDecimale;
    }

    /*
     * Unable to fully structure code
     */
    private void parse(boolean forceTypeToAlpha) {
        this.isParsed = true;
        if (this.picture.length() == 0) {
            return;
        }
        this.picture = this.picture.toUpperCase();
        if (this.picture.equals("D") || this.picture.equals("I")) {
            this.type = 3;
            this.subtype = 4;
            this.subtypedate = 9;
            this.length = 6;
            return;
        }
        if (this.picture.startsWith("E") || this.picture.equals("C") || this.picture.equals("S")) {
            this.type = 3;
            this.subtype = 4;
            this.subtypedate = 9;
            if (this.picture.startsWith("E")) {
                this.subtypedate = 10;
            }
            this.length = 8;
            return;
        }
        if (this.picture.startsWith("M") || this.picture.startsWith("G")) {
            this.type = 3;
            this.subtype = 4;
            this.subtypedate = 10;
            this.length = 10;
            return;
        }
        if (this.picture.equals("TS")) {
            this.type = 3;
            this.subtype = 7;
            this.subtypedate = 9;
            nbSecI = 0;
            if (this.timezone.equals((Object)PacTimezoneValues._FALSE_LITERAL)) {
                if (this.nbSec == PacTimestampFractionValues._0_LITERAL) {
                    this.length = 19;
                } else {
                    nbSecI = PacTransformationDataElementType.transformFraction(this.nbSec);
                    this.length = 19 + (nbSecI + 1);
                }
            }
            if (this.timezone.equals((Object)PacTimezoneValues._TRUE_LITERAL)) {
                if (this.nbSec == PacTimestampFractionValues._0_LITERAL) {
                    this.length = 26;
                } else {
                    nbSecI = PacTransformationDataElementType.transformFraction(this.nbSec);
                    this.length = 26 + (nbSecI + 1);
                }
            }
            return;
        }
        if (this.picture.startsWith("T")) {
            this.type = 3;
            this.subtype = 5;
            this.subtypedate = 10;
            this.length = 8;
            return;
        }
        this.ilen = this.picture.length();
        this.c = new char[this.ilen];
        this.picture.getChars(0, this.ilen, this.c, 0);
        partieEntiere = true;
        openpar = false;
        if (forceTypeToAlpha) {
            this.type = 0;
        }
        parenthesisLength = 0;
        this.i = 0;
        while (this.i < this.ilen) {
            block29: {
                block31: {
                    block30: {
                        block28: {
                            if (this.c[this.i] != 'V' && (!this.isDecimalCharacter() || this.c[this.i] != this.decimalCharacter.charValue())) break block28;
                            this.type = 2;
                            partieEntiere = false;
                            this.partieDecimale = true;
                            break block29;
                        }
                        if (this.c[this.i] != '(') break block30;
                        openpar = true;
                        parenthesisLength = 0;
                        if (partieEntiere) {
                            --this.length;
                        }
                        if (this.partieDecimale) {
                            this.decimales = Math.max(0, this.decimales - 1);
                        }
                        break block29;
                    }
                    if (this.c[this.i] != ')') break block31;
                    openpar = false;
                    if (partieEntiere) {
                        this.length += parenthesisLength;
                    }
                    if (this.partieDecimale) {
                        this.decimales += parenthesisLength;
                    }
                    break block29;
                }
                if (!openpar) ** GOTO lbl88
                if (Character.isDigit(this.c[this.i])) {
                    inb = Integer.parseInt(String.valueOf(this.c[this.i]));
                    parenthesisLength = parenthesisLength * 10 + inb;
                } else {
                    this.type = -1;
lbl88:
                    // 2 sources

                    if (this.c[this.i] == 'A') {
                        this.type = 0;
                    }
                    if (this.c[this.i] == '9' || this.c[this.i] == 'Z' || this.c[this.i] == '+' || this.c[this.i] == '-') {
                        this.type = 2;
                    }
                    if (this.c[this.i] == '1') {
                        this.type = 2;
                    }
                    if (this.c[this.i] == 'X' || this.c[this.i] == 'N') {
                        this.type = 1;
                    }
                    if (!(this.c[this.i] == 'S' || this.c[this.i] == 'P' || this.searchFor && this.c[this.i] == '*' || this.isSpecialCharacter())) {
                        if (partieEntiere) {
                            ++this.length;
                        }
                        if (this.partieDecimale) {
                            ++this.decimales;
                        }
                    }
                }
            }
            ++this.i;
        }
        this.length += this.decimales;
    }

    public int getType() {
        this.isParsed = false;
        this.parse(false);
        int aType = this.type;
        if (this.type == -1) {
            this.type = 0;
        }
        return aType;
    }

    protected void parse() {
        this.parse(true);
    }

    protected boolean isDecimalCharacter() {
        return this.isDecimalCharacter;
    }

    protected boolean isSpecialCharacter() {
        this.isSpecialCharacter = false;
        return false;
    }
}

