/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.pacbase.converter;

import com.ibm.pdp.mdl.pacbase.PacDataElementInternalUsageValues;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;

public class PacFormatControl {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int INTERNAL = 0;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    private static PacFormatControl _instance = null;
    private static final String validAphaStrings = "ABCDEGIKMNPSTVXZ";
    private static final String validNumStrings = "0123456789";
    private static final String validSpecialStrings = ",.+-*/$()!";
    private static final String[] validSymbolicStrings = new String[]{"E", "G", "M", "T"};
    private static final String validSimpleStrings = "ABCDEGIKMNPSTVXZ0123456789,.+-*/$()!";
    private static final String[] validDoubleStrings = new String[]{"CR", "DB", "TS"};
    private static final String AlphaNumericSign = "X";
    private static final String AlphabeticSign = "A";
    private static final String NumericSign = "9";
    private static final String[] LargeObjectsValidValues = new String[]{"K", "M", "G"};
    private static String SignSign = "S";

    public static PacFormatControl getInstance() {
        if (_instance == null) {
            _instance = new PacFormatControl();
        }
        return _instance;
    }

    public boolean controlFormat(int formatType, String format) {
        if (!this.commonChecks(format.trim().toUpperCase())) {
            return false;
        }
        if (formatType == 1) {
            return this.controlInputFormat(format.trim());
        }
        if (formatType == 0) {
            return this.controlInternalFormat(format.trim());
        }
        if (formatType == 2) {
            return this.controlOutputFormat(format.trim());
        }
        return false;
    }

    public boolean controlFormat(int formatType, String format, PacDataElementTypeValues typeValue, PacDataElementInternalUsageValues usage) {
        if (!(((Object)((Object)typeValue)).equals((Object)PacDataElementTypeValues._L_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._0_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._5_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._6_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._U_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._J_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._Y_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._F_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._W_LITERAL))) {
            return this.controlFormat(formatType, format);
        }
        return this.controlFormatUsageTypeCompatibility(formatType, format, typeValue, usage);
    }

    public boolean controlFormat(int formatType, String format, Boolean validType, PacDataElementInternalUsageValues usage) {
        return this.controlFormat(formatType, format);
    }

    private boolean commonChecks(String format) {
        PacPictureParser parser = new PacPictureParser(format);
        if (!(parser.getType() >= 0 || parser.getCapacity() == 0 || format.endsWith(LargeObjectsValidValues[0]) || format.endsWith(LargeObjectsValidValues[1]) || format.endsWith(LargeObjectsValidValues[2]) || this.isAllNumeric(format))) {
            return false;
        }
        if (format.startsWith(validSymbolicStrings[0]) || format.startsWith(validSymbolicStrings[1]) || format.startsWith(validSymbolicStrings[2]) || format.startsWith(validSymbolicStrings[3])) {
            return format.length() <= 2;
        }
        int i = 0;
        while (i < validDoubleStrings.length) {
            if (format.startsWith(validDoubleStrings[i])) {
                return this.commonChecks(format.substring(2));
            }
            if (format.endsWith(validDoubleStrings[i])) {
                return this.commonChecks(format.substring(format.length()));
            }
            ++i;
        }
        int[] nbParenthesis = new int[2];
        int i2 = 0;
        while (i2 < format.length()) {
            char c = format.charAt(i2);
            if (!validSimpleStrings.contains(format.subSequence(i2, i2 + 1))) {
                return false;
            }
            if (c == '(') {
                nbParenthesis[0] = nbParenthesis[0] + 1;
            }
            if (c == ')') {
                nbParenthesis[1] = nbParenthesis[1] + 1;
            }
            ++i2;
        }
        if (nbParenthesis[0] != nbParenthesis[1]) {
            return false;
        }
        if (nbParenthesis[0] > 0 && !this.checkFormatWithParenthesis(format.trim())) {
            return false;
        }
        if (format.trim().contains(" ")) {
            return false;
        }
        if (parser.isAlphabetic() && format.contains(AlphaNumericSign) || parser.isAlphanumeric() && format.contains(AlphabeticSign)) {
            return false;
        }
        if (parser.hasSign() && (format.contains(AlphabeticSign) || format.contains(AlphaNumericSign))) {
            return false;
        }
        String virtualFormat = this.removeParenthesisValuesFromFormat(format);
        return !virtualFormat.contains(NumericSign) || !parser.isAlphabetic() && !parser.isAlphanumeric();
    }

    private boolean checkFormatWithParenthesis(String format) {
        boolean result = true;
        String value = "";
        while (format.contains("(") && format.contains(")")) {
            try {
                value = format.substring(format.indexOf("(") + 1, format.indexOf(")", format.indexOf("(")));
                Integer.parseInt(value);
                format = format.substring(format.indexOf(41) + 1);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return result;
    }

    private String removeParenthesisValuesFromFormat(String format) {
        char[] result = format.toCharArray();
        char[] chars = format.toCharArray();
        boolean insert = true;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '(') {
                insert = false;
            }
            result[i] = insert ? chars[i] : 32;
            if (chars[i] == ')') {
                insert = true;
            }
            ++i;
        }
        return String.valueOf(result);
    }

    private boolean controlInternalFormat(String internalFormat) {
        boolean result = true;
        if (internalFormat.contains("Z") || internalFormat.contains(",")) {
            result = false;
        }
        return result;
    }

    private boolean controlInputFormat(String inputFormat) {
        boolean result = true;
        if (inputFormat.contains(",")) {
            result = false;
        }
        return result;
    }

    private boolean controlOutputFormat(String outputFormat) {
        boolean result = true;
        return result;
    }

    public boolean controlFormatUsageTypeCompatibility(int formatType, String format, PacDataElementTypeValues typeValue, PacDataElementInternalUsageValues usage) {
        if (formatType == 0 && typeValue == PacDataElementTypeValues._U_LITERAL && (usage != PacDataElementInternalUsageValues._N_LITERAL && usage != PacDataElementInternalUsageValues._X_LITERAL && usage != PacDataElementInternalUsageValues._1_LITERAL || (usage == PacDataElementInternalUsageValues._X_LITERAL || usage == PacDataElementInternalUsageValues._1_LITERAL) && !format.startsWith(SignSign))) {
            return false;
        }
        if (formatType == 0 && (format.endsWith(LargeObjectsValidValues[0]) || format.endsWith(LargeObjectsValidValues[1]) || format.endsWith(LargeObjectsValidValues[2]) || this.isAllNumeric(format)) && format.length() > 1) {
            if (typeValue != PacDataElementTypeValues._L_LITERAL && typeValue != PacDataElementTypeValues._R_LITERAL) {
                return false;
            }
            if (typeValue == PacDataElementTypeValues._R_LITERAL && usage != PacDataElementInternalUsageValues._0_LITERAL && usage != PacDataElementInternalUsageValues._5_LITERAL && usage != PacDataElementInternalUsageValues._6_LITERAL) {
                return false;
            }
            if (typeValue == PacDataElementTypeValues._L_LITERAL && this.isAllNumeric(format) && usage != PacDataElementInternalUsageValues._5_LITERAL && usage != PacDataElementInternalUsageValues._6_LITERAL && usage != PacDataElementInternalUsageValues._7_LITERAL && usage != PacDataElementInternalUsageValues._8_LITERAL && usage != PacDataElementInternalUsageValues._9_LITERAL && usage != PacDataElementInternalUsageValues._4_LITERAL) {
                return false;
            }
        }
        return true;
    }

    public boolean controlUsageFormat(PacDataElementTypeValues typeValue, PacDataElementInternalUsageValues usage, String format) {
        if (format.startsWith(AlphaNumericSign)) {
            if (((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._6_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._F_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._U_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._W_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._J_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._Y_LITERAL)) {
                return true;
            }
            if (!(((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._2_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._D_LITERAL) || ((Object)((Object)usage)).equals((Object)PacDataElementInternalUsageValues._I_LITERAL))) {
                return false;
            }
        }
        return true;
    }

    private boolean isAllNumeric(String format) {
        try {
            int pic = Integer.parseInt(format);
            return pic == 3000;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

