/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.service;

public class MetadataService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String[] getTokens(String documentId) {
        String type = "";
        String metaType = "";
        String name = "";
        String projectName = "";
        StringBuilder packageName = new StringBuilder("");
        if (documentId != null && documentId.length() > 0) {
            String[] segments = documentId.substring(1).split("/");
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i];
                if (i == 0) {
                    projectName = segment;
                } else if (i == segments.length - 1) {
                    int index = segment.lastIndexOf(46);
                    type = segment.substring(index + 1);
                    name = segment.substring(0, index);
                    if (type.equals("userentity")) {
                        index = name.indexOf(46);
                        if (index == 0) {
                            index = name.indexOf(46, 1);
                        }
                        metaType = name.substring(index + 1);
                        name = name.substring(0, index);
                    }
                } else {
                    if (packageName.length() > 0) {
                        packageName.append(".");
                    }
                    packageName.append(segment);
                }
                ++i;
            }
        }
        return new String[]{projectName, packageName.toString(), name, metaType, type};
    }

    public static String getId(String projectName, String packageName, String name, String metaType, String type) {
        StringBuilder buffer = new StringBuilder("/");
        buffer.append(projectName).append("/");
        if (packageName != null && packageName.length() > 0) {
            buffer.append(packageName.replace('.', '/')).append("/");
        }
        buffer.append(name);
        if (metaType != null && metaType.length() > 0) {
            buffer.append(".").append(metaType);
        }
        buffer.append(".").append(type);
        return buffer.toString().intern();
    }

    public static String getProject(String documentId) {
        int index;
        String project = "";
        if (documentId != null && documentId.length() > 0 && (index = documentId.indexOf("/", 1)) > 0) {
            project = documentId.substring(1, index);
        }
        return project;
    }

    public static String getType(String documentId) {
        int index;
        String type = "";
        if (documentId != null && (index = documentId.lastIndexOf(46)) > 0 && index < documentId.length()) {
            type = documentId.substring(index + 1);
        }
        return type;
    }
}

