/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.path;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PTPath {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String _version;
    private String _streamID;
    private String _locationName;
    private String _projectName;
    private String _organization;
    private String _pathMode;
    private String _layerName;
    private int _layerLevel;
    private String _domains;
    private String _projectLabel;
    private List<String> _requires;
    private Set<String> _domainCriterion = null;

    public String getVersion() {
        if (this._version == null) {
            this._version = "";
        }
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getStreamID() {
        if (this._streamID == null) {
            this._streamID = "";
        }
        return this._streamID;
    }

    public void setStreamID(String streamID) {
        this._streamID = streamID;
    }

    public String getLocationName() {
        if (this._locationName == null) {
            this._locationName = "";
        }
        return this._locationName;
    }

    public void setLocationName(String locationName) {
        this._locationName = locationName;
    }

    public String getProjectName() {
        if (this._projectName == null) {
            this._projectName = "";
        }
        return this._projectName;
    }

    public void setProjectName(String projectName) {
        this._projectName = projectName;
    }

    public String getOrganization() {
        if (this._organization == null) {
            this._organization = "tree";
        }
        return this._organization;
    }

    public void setOrganization(String organization) {
        this._organization = organization;
    }

    public String getPathMode() {
        if (this._pathMode == null) {
            this._pathMode = "floating";
        }
        return this._pathMode;
    }

    public void setPathMode(String pathMode) {
        this._pathMode = pathMode;
    }

    public String getLayerName() {
        if (this._layerName == null) {
            this._layerName = "";
        }
        return this._layerName;
    }

    public void setLayerName(String layerName) {
        this._layerName = layerName;
    }

    public int getLayerLevel() {
        String organization = this.getOrganization();
        if (organization.equals("basic")) {
            this._layerLevel = 0;
        } else if (organization.equals("tree")) {
            this._layerLevel = this.getRequires().size();
        }
        return this._layerLevel;
    }

    public void setLayerLevel(int layerLevel) {
        this._layerLevel = layerLevel;
    }

    public String getDomains() {
        if (this._domains == null) {
            this._domains = "";
        }
        return this._domains;
    }

    public void setDomains(String domains) {
        this._domains = domains;
    }

    public String getProjectLabel() {
        if (this._projectLabel == null) {
            this._projectLabel = "";
        }
        return this._projectLabel;
    }

    public void setProjectLabel(String projectLabel) {
        this._projectLabel = projectLabel;
    }

    public List<String> getRequires() {
        if (this._requires == null) {
            this._requires = new ArrayList<String>(1);
        }
        return this._requires;
    }

    public Set<String> getDomainCriterion() {
        if (this._domainCriterion == null) {
            this._domainCriterion = new HashSet<String>();
            String[] stringArray = this.getDomains().trim().split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String domain = stringArray[n2];
                if ((domain = domain.trim()).length() > 0) {
                    this._domainCriterion.add(domain);
                }
                ++n2;
            }
        }
        return this._domainCriterion;
    }

    public int getLevel() {
        int level = 0;
        if (this.getOrganization().equals("tree")) {
            level = this.getRequires().size();
        } else if (this.getOrganization().equals("layer")) {
            level = this.getLayerLevel();
        }
        return level;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getProjectName()).append(" (");
        buffer.append(this.getRequires());
        buffer.append(")");
        return buffer.toString();
    }
}

