/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.impl;

import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import java.util.ArrayList;
import java.util.List;

public class ReferenceImpl
implements Reference {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private int _type;
    private String _sourceId;
    private String _targetId;
    private String _relation;
    private String _stateId;
    private List<Property> _properties;

    protected ReferenceImpl() {
    }

    @Override
    public int getType() {
        return this._type;
    }

    @Override
    public void setType(int type) {
        this._type = 1;
        if (type > 0) {
            this._type = type;
        }
    }

    @Override
    public String getSourceId() {
        return this._sourceId;
    }

    @Override
    public void setSourceId(String sourceId) {
        this._sourceId = sourceId != null ? sourceId.intern() : null;
    }

    @Override
    public String getTargetId() {
        return this._targetId;
    }

    @Override
    public void setTargetId(String targetId) {
        this._targetId = targetId != null ? targetId.intern() : null;
    }

    @Override
    public String getRelation() {
        if (this._relation == null) {
            return "";
        }
        return this._relation;
    }

    @Override
    public void setRelation(String relation) {
        this._relation = relation != null ? relation.intern() : null;
    }

    @Override
    public String getStateId() {
        if (this._stateId == null) {
            return "";
        }
        return this._stateId;
    }

    @Override
    public void setStateId(String stateId) {
        this._stateId = stateId;
    }

    @Override
    public String getId() {
        StringBuilder buffer = new StringBuilder(this.getSourceId());
        buffer.append("->").append(this.getTargetId());
        return buffer.toString();
    }

    @Override
    public boolean hasProperties() {
        int size = 0;
        if (this._properties != null) {
            size = this._properties.size();
        }
        return size > 0;
    }

    @Override
    public List<Property> getProperties() {
        if (this._properties == null) {
            this._properties = new ArrayList<Property>(1);
        }
        return this._properties;
    }

    @Override
    public Property getProperty(String name) {
        if (this._properties != null) {
            for (Property metaProperty : this._properties) {
                if (!metaProperty.getName().equals(name)) continue;
                return metaProperty;
            }
        }
        return null;
    }

    @Override
    public void forgetProperties() {
        this._properties = null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getId());
        switch (this.getType()) {
            case 1: {
                buffer.append(" (Internal)");
                break;
            }
            case 2: {
                buffer.append(" (Solid)");
                break;
            }
            case 4: {
                buffer.append(" (Free)");
                break;
            }
            default: {
                buffer.append(" (Unknown");
            }
        }
        return buffer.toString();
    }
}

