/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.impl;

import com.ibm.pdp.mdl.meta.ArtifactState;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Facet;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.impl.ArtifactStateImpl;
import com.ibm.pdp.mdl.meta.impl.DocumentImpl;
import com.ibm.pdp.mdl.meta.impl.FacetImpl;
import com.ibm.pdp.mdl.meta.impl.PropertyImpl;
import com.ibm.pdp.mdl.meta.impl.ReferenceImpl;
import com.ibm.pdp.mdl.meta.impl.ShallowDocumentImpl;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class MetaFactoryImpl
implements MetaFactory {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<String, WeakReference<Document>> _cache = null;

    public static MetaFactory init() {
        return new MetaFactoryImpl();
    }

    private MetaFactoryImpl() {
    }

    @Override
    public synchronized Document getDocument(String documentId, boolean create) {
        return this.getDocument(documentId, create, false);
    }

    @Override
    public synchronized Document getDocument(String documentId, boolean create, boolean shallowMode) {
        Document document = null;
        if (create) {
            String[] tokens = MetadataService.getTokens(documentId);
            document = shallowMode ? this.createShallowDocument() : this.createDocument();
            document.setProject(tokens[0]);
            document.setPackage(tokens[1]);
            document.setName(tokens[2]);
            document.setMetaType(tokens[3]);
            document.setType(tokens[4]);
            this.getCache().put(documentId, new WeakReference<Document>(document));
        } else {
            WeakReference<Document> weakReference = this.getCache().get(documentId);
            if (weakReference != null) {
                document = (Document)weakReference.get();
            }
        }
        return document;
    }

    @Override
    public synchronized void putDocument(String documentId, Document document) {
        this.getCache().put(documentId, new WeakReference<Document>(document));
    }

    private synchronized Map<String, WeakReference<Document>> getCache() {
        if (this._cache == null) {
            this._cache = new HashMap<String, WeakReference<Document>>();
        }
        return this._cache;
    }

    @Override
    public Document createDocument() {
        DocumentImpl document = new DocumentImpl();
        return document;
    }

    @Override
    public Document createShallowDocument() {
        ShallowDocumentImpl document = new ShallowDocumentImpl();
        return document;
    }

    @Override
    public Reference createReference() {
        ReferenceImpl reference = new ReferenceImpl();
        return reference;
    }

    @Override
    public Facet createFacet() {
        FacetImpl facet = new FacetImpl();
        return facet;
    }

    @Override
    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    @Override
    public ArtifactState createArtifactState() {
        ArtifactStateImpl artifactState = new ArtifactStateImpl();
        return artifactState;
    }
}

