/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.impl;

import com.ibm.pdp.mdl.meta.Artifact;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import java.util.ArrayList;
import java.util.List;

public abstract class ArtifactImpl
implements Artifact {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String _project;
    private String _package;
    private String _name;
    private String _metaType;
    private String _type;
    private List<Property> _properties;

    protected ArtifactImpl() {
    }

    @Override
    public String getProject() {
        if (this._project == null) {
            return "";
        }
        return this._project;
    }

    @Override
    public void setProject(String project) {
        this._project = project != null ? project.intern() : null;
    }

    @Override
    public String getPackage() {
        if (this._package == null) {
            return "";
        }
        return this._package;
    }

    @Override
    public void setPackage(String pkg) {
        this._package = pkg != null ? pkg.intern() : null;
    }

    @Override
    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name != null ? name.intern() : null;
    }

    @Override
    public String getMetaType() {
        if (this._metaType == null) {
            return "";
        }
        return this._metaType;
    }

    @Override
    public void setMetaType(String metaType) {
        this._metaType = metaType != null ? metaType.intern() : null;
    }

    @Override
    public String getType() {
        if (this._type == null) {
            return "";
        }
        return this._type;
    }

    @Override
    public void setType(String type) {
        this._type = type != null ? type.intern() : null;
    }

    @Override
    public String getId() {
        return MetadataService.getId(this.getProject(), this.getPackage(), this.getName(), this.getMetaType(), this.getType());
    }

    @Override
    public boolean hasProperties() {
        int size = 0;
        if (this._properties != null) {
            size = this._properties.size();
        }
        return size > 0;
    }

    @Override
    public List<Property> getProperties() {
        if (this._properties == null) {
            this._properties = new ArrayList<Property>(1);
        }
        return this._properties;
    }

    @Override
    public Property getProperty(String name) {
        if (this._properties != null) {
            for (Property metaProperty : this._properties) {
                if (!metaProperty.getName().equals(name)) continue;
                return metaProperty;
            }
        }
        return null;
    }

    @Override
    public void forgetProperties() {
        this._properties = null;
    }

    public String toString() {
        return this.getId();
    }
}

