/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.io.internal;

import com.ibm.pdp.mdl.meta.ArtifactState;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Facet;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.plugin.MetaPlugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.core.runtime.IPath;

public class LuceneRepository {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static LuceneRepository _instance = null;
    public static final String _DATA_DIRECTORY = ".dat";
    public static final String _XREF_DIRECTORY = ".xref";
    public static final String _STATE_DIRECTORY = ".state";
    private static final int _DEFAULT_HITS_SIZE = 10000;
    private static final char _FIELD_SEPARATOR = ':';
    private Directory _dataDirectory = null;
    private Directory _xRefDirectory = null;
    private Directory _stateDirectory = null;
    private Analyzer _analyzer = null;

    public static LuceneRepository getInstance() {
        if (_instance == null) {
            _instance = new LuceneRepository();
        }
        return _instance;
    }

    public static FieldType translateFieldType(boolean indexed) {
        FieldType ft = new FieldType();
        ft.setStored(true);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        ft.setTokenized(false);
        if (indexed) {
            ft.setStoreTermVectors(true);
        }
        ft.freeze();
        return ft;
    }

    public static void buildLuceneDoc(org.apache.lucene.document.Document luceneDoc, Document document) {
        StringBuilder buffer;
        if (luceneDoc == null || document == null) {
            return;
        }
        luceneDoc.add((IndexableField)new Field("_FIELD_PROJECT", (CharSequence)document.getProject(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        if (document.getPackage().length() > 0) {
            luceneDoc.add((IndexableField)new Field("_FIELD_PACKAGE", (CharSequence)document.getPackage(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        }
        luceneDoc.add((IndexableField)new Field("_FIELD_NAME", (CharSequence)document.getName(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        if (document.getMetaType().length() > 0) {
            luceneDoc.add((IndexableField)new Field("_FIELD_META_TYPE", (CharSequence)document.getMetaType(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        }
        luceneDoc.add((IndexableField)new Field("_FIELD_TYPE", (CharSequence)document.getType(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        if (document.getLabel().length() > 0) {
            luceneDoc.add((IndexableField)new Field("_FIELD_LABEL", (CharSequence)document.getLabel(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
        }
        luceneDoc.add((IndexableField)new Field("_FIELD_STATE_ID", (CharSequence)document.getStateId(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
        if (document.hasKeywords()) {
            for (String keyword : document.getKeywords()) {
                luceneDoc.add((IndexableField)new Field("_FIELD_KEYWORD", (CharSequence)keyword, (IndexableFieldType)LuceneRepository.translateFieldType(false)));
            }
        }
        if (document.hasProperties()) {
            for (Property property : document.getProperties()) {
                buffer = new StringBuilder(property.getName());
                buffer.append(':').append(property.getValue());
                luceneDoc.add((IndexableField)new Field("_FIELD_PROPERTY", (CharSequence)buffer.toString(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
            }
        }
        if (document.hasFacets()) {
            for (Facet facet : document.getFacets()) {
                if (facet.getAlias().length() > 0) {
                    buffer = new StringBuilder(facet.getName());
                    buffer.append(':').append(facet.getAlias());
                    luceneDoc.add((IndexableField)new Field("_FIELD_FACET_ALIAS", (CharSequence)buffer.toString(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
                }
                if (facet.getProperty().length() > 0) {
                    buffer = new StringBuilder(facet.getName());
                    buffer.append(':').append(facet.getProperty());
                    luceneDoc.add((IndexableField)new Field("_FIELD_FACET_PROPERTY", (CharSequence)buffer.toString(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
                }
                if (facet.getKnownId().length() <= 0) continue;
                buffer = new StringBuilder(facet.getName());
                buffer.append(':').append(facet.getKnownId());
                luceneDoc.add((IndexableField)new Field("_FIELD_FACET_KNOWN_ID", (CharSequence)buffer.toString(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
            }
        }
    }

    public static void buildDocument(Document document, org.apache.lucene.document.Document luceneDoc) {
        String value;
        if (document == null || luceneDoc == null) {
            return;
        }
        document.setProject(luceneDoc.get("_FIELD_PROJECT"));
        document.setPackage(luceneDoc.get("_FIELD_PACKAGE"));
        document.setName(luceneDoc.get("_FIELD_NAME"));
        document.setMetaType(luceneDoc.get("_FIELD_META_TYPE"));
        document.setType(luceneDoc.get("_FIELD_TYPE"));
        document.setLabel(luceneDoc.get("_FIELD_LABEL"));
        document.setStateId(luceneDoc.get("_FIELD_STATE_ID"));
        String[] stringArray = luceneDoc.getValues("_FIELD_KEYWORD");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            document.getKeywords().add(value);
            ++n2;
        }
        stringArray = luceneDoc.getValues("_FIELD_PROPERTY");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            value = stringArray[n2];
            Property property = MetaFactory.eINSTANCE.createProperty();
            document.getProperties().add(property);
            int sepIndex = value.indexOf(58);
            property.setName(value.substring(0, sepIndex));
            property.setValue(value.substring(sepIndex + 1));
            ++n2;
        }
        HashMap<String, Facet> facets = new HashMap<String, Facet>();
        LuceneRepository.retrieveFacetField(luceneDoc, "_FIELD_FACET_ALIAS", facets);
        LuceneRepository.retrieveFacetField(luceneDoc, "_FIELD_FACET_PROPERTY", facets);
        LuceneRepository.retrieveFacetField(luceneDoc, "_FIELD_FACET_KNOWN_ID", facets);
        for (Facet facet : facets.values()) {
            document.getFacets().add(facet);
        }
    }

    private static void retrieveFacetField(org.apache.lucene.document.Document luceneDoc, String fieldId, Map<String, Facet> facets) {
        String[] stringArray = luceneDoc.getValues(fieldId);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            int sepIndex = value.indexOf(58);
            String facetName = value.substring(0, sepIndex);
            String fieldValue = value.substring(sepIndex + 1);
            Facet facet = facets.get(facetName);
            if (facet == null) {
                facet = MetaFactory.eINSTANCE.createFacet();
                facets.put(facetName, facet);
            }
            facet.setName(facetName);
            if (fieldId.equals("_FIELD_FACET_ALIAS")) {
                facet.setAlias(fieldValue);
            } else if (fieldId.equals("_FIELD_FACET_PROPERTY")) {
                facet.setProperty(fieldValue);
            } else if (fieldId.equals("_FIELD_FACET_KNOWN_ID")) {
                facet.setKnownId(fieldValue);
            }
            ++n2;
        }
    }

    public static void buildLuceneDoc(org.apache.lucene.document.Document luceneDoc, Reference reference) {
        if (luceneDoc == null || reference == null) {
            return;
        }
        String type = Integer.toString(reference.getType());
        luceneDoc.add((IndexableField)new Field("_FIELD_RELATION_TYPE", (CharSequence)type, (IndexableFieldType)LuceneRepository.translateFieldType(false)));
        luceneDoc.add((IndexableField)new Field("_FIELD_SOURCE_ID", (CharSequence)reference.getSourceId(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        luceneDoc.add((IndexableField)new Field("_FIELD_TARGET_ID", (CharSequence)reference.getTargetId(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        luceneDoc.add((IndexableField)new Field("_FIELD_RELATION", (CharSequence)reference.getRelation(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
        luceneDoc.add((IndexableField)new Field("_FIELD_STATE_ID", (CharSequence)reference.getStateId(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
        if (reference.hasProperties()) {
            for (Property property : reference.getProperties()) {
                StringBuilder buffer = new StringBuilder(property.getName());
                buffer.append(':').append(property.getValue());
                luceneDoc.add((IndexableField)new Field("_FIELD_PROPERTY", (CharSequence)buffer.toString(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
            }
        }
    }

    public static void buildReference(Reference reference, org.apache.lucene.document.Document luceneDoc) {
        if (reference == null || luceneDoc == null) {
            return;
        }
        int type = 1;
        String sType = luceneDoc.get("_FIELD_RELATION_TYPE");
        if (sType != null && sType.length() > 0) {
            try {
                type = Integer.parseInt(sType);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        reference.setType(type);
        reference.setSourceId(luceneDoc.get("_FIELD_SOURCE_ID"));
        reference.setTargetId(luceneDoc.get("_FIELD_TARGET_ID"));
        reference.setRelation(luceneDoc.get("_FIELD_RELATION"));
        reference.setStateId(luceneDoc.get("_FIELD_STATE_ID"));
        String[] stringArray = luceneDoc.getValues("_FIELD_PROPERTY");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            Property property = MetaFactory.eINSTANCE.createProperty();
            reference.getProperties().add(property);
            int leftIndex = 0;
            int rightIndex = value.indexOf(58);
            property.setName(value.substring(leftIndex, rightIndex));
            leftIndex = rightIndex + 1;
            property.setValue(value.substring(leftIndex));
            ++n2;
        }
    }

    public static void buildLuceneDoc(org.apache.lucene.document.Document luceneDoc, ArtifactState artifactState) {
        if (luceneDoc == null || artifactState == null) {
            return;
        }
        luceneDoc.add((IndexableField)new Field("_FIELD_ARTIFACT_ID", (CharSequence)artifactState.getArtifactId(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        luceneDoc.add((IndexableField)new Field("_FIELD_PROJECT", (CharSequence)artifactState.getProject(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        luceneDoc.add((IndexableField)new Field("_FIELD_PATTERN_ID", (CharSequence)artifactState.getPatternId(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        luceneDoc.add((IndexableField)new Field("_FIELD_VERSION_ID", (CharSequence)artifactState.getVersionId(), (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        String sRank = Integer.toString(artifactState.getRank());
        luceneDoc.add((IndexableField)new Field("_FIELD_RANK", (CharSequence)sRank, (IndexableFieldType)LuceneRepository.translateFieldType(true)));
        luceneDoc.add((IndexableField)new Field("_FIELD_STATE_ID", (CharSequence)artifactState.getStateId(), (IndexableFieldType)LuceneRepository.translateFieldType(false)));
    }

    public static void buildArtifactState(ArtifactState artifactState, org.apache.lucene.document.Document luceneDoc) {
        if (artifactState == null || luceneDoc == null) {
            return;
        }
        artifactState.setArtifactId(luceneDoc.get("_FIELD_ARTIFACT_ID"));
        artifactState.setPatternId(luceneDoc.get("_FIELD_PATTERN_ID"));
        artifactState.setVersionId(luceneDoc.get("_FIELD_VERSION_ID"));
        int rank = 0;
        String sRank = luceneDoc.get("_FIELD_RANK");
        if (sRank != null && sRank.length() > 0) {
            try {
                rank = Integer.parseInt(sRank);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        artifactState.setRank(rank);
        artifactState.setStateId(luceneDoc.get("_FIELD_STATE_ID"));
    }

    public static ScoreDoc[] getHits(IndexSearcher searcher, Query query) throws IOException {
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10000, (int)Integer.MAX_VALUE);
        searcher.search(query, (Collector)collector);
        int totalHits = collector.getTotalHits();
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        if (totalHits > 10000) {
            collector = TopScoreDocCollector.create((int)totalHits, (int)Integer.MAX_VALUE);
            searcher.search(query, (Collector)collector);
            hits = collector.topDocs().scoreDocs;
        }
        return hits;
    }

    public Directory getDataDirectory() throws IOException {
        if (this._dataDirectory == null) {
            IPath path = MetaPlugin.getDefault().getStateLocation();
            File metaDirectory = path.toFile();
            File subDirectory = new File(metaDirectory, _DATA_DIRECTORY);
            if (!subDirectory.exists()) {
                subDirectory.mkdir();
            }
            this._dataDirectory = FSDirectory.open((Path)subDirectory.toPath());
        }
        return this._dataDirectory;
    }

    public Directory getXRefDirectory() throws IOException {
        if (this._xRefDirectory == null) {
            IPath path = MetaPlugin.getDefault().getStateLocation();
            File metaDirectory = path.toFile();
            File subDirectory = new File(metaDirectory, _XREF_DIRECTORY);
            if (!subDirectory.exists()) {
                subDirectory.mkdir();
            }
            this._xRefDirectory = FSDirectory.open((Path)subDirectory.toPath());
        }
        return this._xRefDirectory;
    }

    public Directory getStateDirectory() throws IOException {
        if (this._stateDirectory == null) {
            IPath path = MetaPlugin.getDefault().getStateLocation();
            File metaDirectory = path.toFile();
            File subDirectory = new File(metaDirectory, _STATE_DIRECTORY);
            if (!subDirectory.exists()) {
                subDirectory.mkdir();
            }
            this._stateDirectory = FSDirectory.open((Path)subDirectory.toPath());
        }
        return this._stateDirectory;
    }

    public Analyzer getAnalyzer() {
        if (this._analyzer == null) {
            this._analyzer = new StandardAnalyzer();
        }
        return this._analyzer;
    }

    public IndexWriter getDataWriter() throws IOException {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.getAnalyzer());
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        writerConfig.setCommitOnClose(true);
        IndexWriter writer = new IndexWriter(this.getDataDirectory(), writerConfig);
        return writer;
    }

    public IndexWriter getXRefWriter() throws IOException {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.getAnalyzer());
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        writerConfig.setCommitOnClose(true);
        IndexWriter writer = new IndexWriter(this.getXRefDirectory(), writerConfig);
        return writer;
    }

    public IndexWriter getStateWriter() throws IOException {
        IndexWriterConfig writerConfig = new IndexWriterConfig(this.getAnalyzer());
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        writerConfig.setCommitOnClose(true);
        IndexWriter writer = new IndexWriter(this.getStateDirectory(), writerConfig);
        return writer;
    }
}

