/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.io.internal;

import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.plugin.MetaPlugin;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DerbyRepository {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int _SOURCE_IDX = 0;
    public static final int _TARGET_IDX = 1;
    public static final int _NB_MAX_INSERT = 65000;
    private static DerbyRepository _instance = null;
    private Connection _connection = null;
    private PreparedStatement _createTable = null;
    private PreparedStatement _createSourceIdx = null;
    private PreparedStatement _createTargetIdx = null;
    private PreparedStatement _dropTable = null;
    private PreparedStatement _dropSourceIdx = null;
    private PreparedStatement _dropTargetIdx = null;
    private PreparedStatement _insert = null;
    private PreparedStatement _delete = null;
    private PreparedStatement _selectSourceIdx = null;
    private PreparedStatement _selectTargetIdx = null;

    public static DerbyRepository getInstance() {
        if (_instance == null) {
            _instance = new DerbyRepository();
        }
        return _instance;
    }

    private static Connection getEmbeddedConnection() throws Exception {
        if (DerbyRepository.getInstance()._connection == null) {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            StringBuilder buffer = new StringBuilder("jdbc:derby:");
            String metaFolder = MetaPlugin.getDefault().getStateLocation().toString();
            buffer.append(metaFolder).append(";create=true;user=me;password=mine");
            Connection connection = DriverManager.getConnection(buffer.toString());
            DerbyRepository.configureConnection(connection);
            DerbyRepository.getInstance()._connection = connection;
        }
        return DerbyRepository.getInstance()._connection;
    }

    private static void configureConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
        String sql = "CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)";
        CallableStatement statement = connection.prepareCall(sql);
        statement.setString(1, "derby.storage.pageCacheSize");
        statement.setString(2, "10000");
        statement.execute();
        statement.setString(1, "derby.storage.pageSize");
        statement.setString(2, "32768");
        statement.execute();
    }

    public void createTable() throws SQLException {
        if (this._createTable == null) {
            String sql = "CREATE TABLE xrefs(location VARCHAR(32), sourceId VARCHAR(128), targetId VARCHAR(128), relation VARCHAR(64))";
            try {
                this._createTable = DerbyRepository.getEmbeddedConnection().prepareStatement(sql);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return;
            }
        }
        this._createTable.execute();
    }

    public void createIndex() throws SQLException {
        if (this._createSourceIdx == null || this._createTargetIdx == null) {
            String sqlSourceIdx = "CREATE INDEX idx_sourceId ON xrefs (sourceId)";
            String sqlTargetIdx = "CREATE INDEX idx_targetId ON xrefs (targetId)";
            try {
                this._createSourceIdx = DerbyRepository.getEmbeddedConnection().prepareStatement(sqlSourceIdx);
                this._createTargetIdx = DerbyRepository.getEmbeddedConnection().prepareStatement(sqlTargetIdx);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return;
            }
        }
        this._createSourceIdx.execute();
        this._createTargetIdx.execute();
    }

    public void dropTable() throws SQLException {
        if (this._dropTable == null) {
            String sql = "DROP TABLE xrefs";
            try {
                this._dropTable = DerbyRepository.getEmbeddedConnection().prepareStatement(sql);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return;
            }
        }
        this._dropTable.execute();
    }

    public void dropIndex() throws SQLException {
        if (this._dropSourceIdx == null || this._dropTargetIdx == null) {
            String sqlSourceIdx = "DROP INDEX idx_sourceId";
            String sqlTargetIdx = "DROP INDEX idx_targetId";
            try {
                this._dropSourceIdx = DerbyRepository.getEmbeddedConnection().prepareStatement(sqlSourceIdx);
                this._dropTargetIdx = DerbyRepository.getEmbeddedConnection().prepareStatement(sqlTargetIdx);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return;
            }
        }
        this._dropSourceIdx.execute();
        this._dropTargetIdx.execute();
    }

    public void insert(String location, String sourceId, String targetId, String relation) throws SQLException {
        if (this._insert == null) {
            String sql = "INSERT INTO xrefs values (?, ?, ?, ?)";
            try {
                this._insert = DerbyRepository.getEmbeddedConnection().prepareStatement(sql);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return;
            }
        }
        this._insert.setString(1, location);
        this._insert.setString(2, sourceId);
        this._insert.setString(3, targetId);
        this._insert.setString(4, relation);
        this._insert.execute();
    }

    public void prepareInsert(String location, String sourceId, String targetId, String relation) throws SQLException {
        if (this._insert == null) {
            String sql = "INSERT INTO xrefs values (?, ?, ?, ?)";
            try {
                this._insert = DerbyRepository.getEmbeddedConnection().prepareStatement(sql);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return;
            }
        }
        this._insert.setString(1, location);
        this._insert.setString(2, sourceId);
        this._insert.setString(3, targetId);
        this._insert.setString(4, relation);
        this._insert.addBatch();
    }

    public void executeInsert() throws SQLException {
        this._insert.executeBatch();
        this._insert.clearBatch();
    }

    public void delete(String location) throws SQLException {
        if (this._delete == null) {
            String sql = "DELETE FROM xrefs WHERE location = ?";
            try {
                this._delete = DerbyRepository.getEmbeddedConnection().prepareStatement(sql);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return;
            }
        }
        this._delete.execute();
    }

    public List<Reference> select(String documentId, int column) throws SQLException {
        ArrayList<Reference> metaReferences = new ArrayList<Reference>();
        if (this._selectSourceIdx == null || this._selectTargetIdx == null) {
            String sqlSourceIdx = "SELECT * FROM xrefs WHERE sourceId = ?";
            String sqlTargetIdx = "SELECT * FROM xrefs WHERE targetId= ?";
            try {
                this._selectSourceIdx = DerbyRepository.getEmbeddedConnection().prepareStatement(sqlSourceIdx);
                this._selectTargetIdx = DerbyRepository.getEmbeddedConnection().prepareStatement(sqlTargetIdx);
            }
            catch (Exception e) {
                MetaPlugin.logError((Throwable)e);
                return metaReferences;
            }
        }
        ResultSet resultSet = null;
        if (column == 0) {
            resultSet = this._selectSourceIdx.executeQuery();
        } else if (column == 1) {
            resultSet = this._selectTargetIdx.executeQuery();
        }
        if (resultSet != null) {
            while (resultSet.next()) {
                Reference metaReference = MetaFactory.eINSTANCE.createReference();
                metaReference.setSourceId(resultSet.getString("sourceId"));
                metaReference.setTargetId(resultSet.getString("targetId"));
                metaReference.setRelation(resultSet.getString("relation"));
                metaReferences.add(metaReference);
            }
        }
        return metaReferences;
    }

    public List<Reference> select(Set<String> documentIds, int column) {
        ArrayList<Reference> metaReferences = new ArrayList<Reference>();
        return metaReferences;
    }
}

