/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.mdl.meta.io;

import com.ibm.pdp.mdl.meta.ArtifactState;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.io.internal.LuceneRepository;
import com.ibm.pdp.mdl.meta.plugin.MetaPlugin;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;

public class MetadataStateAccess {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static LuceneRepository _luceneRepository = null;
    private static MetadataStateAccess _instance = null;

    public static MetadataStateAccess getMetadataStateAccess() {
        if (_instance == null) {
            _instance = new MetadataStateAccess();
        }
        return _instance;
    }

    private MetadataStateAccess() {
    }

    private LuceneRepository getRepository() {
        if (_luceneRepository == null) {
            _luceneRepository = LuceneRepository.getInstance();
        }
        return _luceneRepository;
    }

    private boolean indexReaderExists(Directory directory) throws IOException {
        boolean exists = false;
        try {
            exists = DirectoryReader.indexExists((Directory)directory);
        }
        catch (Exception exception) {}
        return exists;
    }

    public synchronized List<ArtifactState> queryArtifactStates(Query query) {
        if (query == null) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactState> artifactStates = new ArrayList<ArtifactState>();
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getStateDirectory())) {
                return artifactStates;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getStateDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                Document luceneDoc = storedFields.document(hit.doc);
                ArtifactState artifactState = MetaFactory.eINSTANCE.createArtifactState();
                LuceneRepository.buildArtifactState(artifactState, luceneDoc);
                artifactStates.add(artifactState);
                ++n2;
            }
            reader.close();
        }
        catch (IOException iOException) {}
        return artifactStates;
    }

    public synchronized ArtifactState readArtifactState(String artifactId, String patternId, String versionId, int rank) {
        ArtifactState artifactState = null;
        if (artifactId == null || artifactId.length() == 0 || patternId == null || patternId.length() == 0 || versionId == null || versionId.length() == 0 || rank < 1) {
            return artifactState;
        }
        HashSet<String> artifactIds = new HashSet<String>();
        artifactIds.add(artifactId);
        Query query = this.getArtifactStateQuery(artifactIds, patternId, versionId, rank);
        try {
            if (!this.indexReaderExists(this.getRepository().getStateDirectory())) {
                return artifactState;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getStateDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] hits = LuceneRepository.getHits(searcher, query);
            if (hits.length == 1) {
                ScoreDoc hit = hits[0];
                StoredFields storedFields = searcher.storedFields();
                Document luceneDoc = storedFields.document(hit.doc);
                artifactState = MetaFactory.eINSTANCE.createArtifactState();
                LuceneRepository.buildArtifactState(artifactState, luceneDoc);
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return artifactState;
    }

    public synchronized List<ArtifactState> readArtifactStates(String artifactId) {
        ArrayList<ArtifactState> artifactStates = new ArrayList<ArtifactState>();
        if (artifactId == null || artifactId.length() == 0) {
            return artifactStates;
        }
        HashSet<String> artifactIds = new HashSet<String>();
        artifactIds.add(artifactId);
        Query query = this.getArtifactStateQuery(artifactIds, null, null, 0);
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getStateDirectory())) {
                return artifactStates;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getStateDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                Document luceneDoc = storedFields.document(hit.doc);
                ArtifactState artifactState = MetaFactory.eINSTANCE.createArtifactState();
                LuceneRepository.buildArtifactState(artifactState, luceneDoc);
                artifactStates.add(artifactState);
                ++n2;
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return artifactStates;
    }

    public synchronized List<ArtifactState> readArtifactStates(Set<String> artifactIds) {
        ArrayList<ArtifactState> artifactStates = new ArrayList<ArtifactState>();
        if (artifactIds == null || artifactIds.size() == 0) {
            return artifactStates;
        }
        try {
            if (!this.indexReaderExists(this.getRepository().getStateDirectory())) {
                return artifactStates;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getStateDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            HashSet<String> pageIds = new HashSet<String>(IndexSearcher.getMaxClauseCount());
            Iterator<String> iterator = artifactIds.iterator();
            while (iterator.hasNext()) {
                String artifactId = iterator.next();
                boolean isLast = !iterator.hasNext();
                pageIds.add(artifactId);
                if (!isLast && pageIds.size() != IndexSearcher.getMaxClauseCount()) continue;
                Query query = this.getArtifactStateQuery(pageIds, null, null, 0);
                ScoreDoc[] hits = LuceneRepository.getHits(searcher, query);
                pageIds = new HashSet(IndexSearcher.getMaxClauseCount());
                ScoreDoc[] scoreDocArray = hits;
                int n = hits.length;
                int n2 = 0;
                while (n2 < n) {
                    ScoreDoc hit = scoreDocArray[n2];
                    StoredFields storedFields = searcher.storedFields();
                    Document luceneDoc = storedFields.document(hit.doc);
                    ArtifactState artifactState = MetaFactory.eINSTANCE.createArtifactState();
                    LuceneRepository.buildArtifactState(artifactState, luceneDoc);
                    artifactStates.add(artifactState);
                    ++n2;
                }
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return artifactStates;
    }

    public synchronized List<ArtifactState> readAll(Set<String> projectNames) {
        ArrayList<ArtifactState> artifactStates = new ArrayList<ArtifactState>();
        if (projectNames != null && projectNames.size() == 0) {
            return artifactStates;
        }
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        try {
            ScoreDoc[] hits;
            if (!this.indexReaderExists(this.getRepository().getStateDirectory())) {
                return artifactStates;
            }
            DirectoryReader reader = DirectoryReader.open((Directory)this.getRepository().getStateDirectory());
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] scoreDocArray = hits = LuceneRepository.getHits(searcher, (Query)query);
            int n = hits.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc hit = scoreDocArray[n2];
                StoredFields storedFields = searcher.storedFields();
                Document luceneDoc = storedFields.document(hit.doc);
                ArtifactState artifactState = MetaFactory.eINSTANCE.createArtifactState();
                LuceneRepository.buildArtifactState(artifactState, luceneDoc);
                if (projectNames == null || projectNames.contains(artifactState.getProject())) {
                    artifactStates.add(artifactState);
                }
                ++n2;
            }
            reader.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
        return artifactStates;
    }

    public synchronized void writeArtifactState(ArtifactState artifactState) {
        if (artifactState == null) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getStateWriter();
            Document luceneDoc = new Document();
            LuceneRepository.buildLuceneDoc(luceneDoc, artifactState);
            writer.addDocument((Iterable)luceneDoc);
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void writeArtifactStates(List<ArtifactState> artifactStates) {
        if (artifactStates == null || artifactStates.size() == 0) {
            return;
        }
        try {
            IndexWriter writer = this.getRepository().getStateWriter();
            for (ArtifactState artifactState : artifactStates) {
                Document luceneDoc = new Document();
                LuceneRepository.buildLuceneDoc(luceneDoc, artifactState);
                writer.addDocument((Iterable)luceneDoc);
            }
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
            throw Util.rethrow((Throwable)e);
        }
    }

    public synchronized void deleteArtifactState(ArtifactState artifactState) {
        ArrayList<ArtifactState> artifactStates = new ArrayList<ArtifactState>();
        artifactStates.add(artifactState);
        Query query = this.getArtifactStateQuery(artifactStates);
        try {
            IndexWriter writer = this.getRepository().getStateWriter();
            writer.deleteDocuments(new Query[]{query});
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteArtifactStates(List<ArtifactState> artifactStates) {
        if (artifactStates == null || artifactStates.size() == 0) {
            return;
        }
        try {
            ArrayList<Object> pageArtifactStates = new ArrayList<ArtifactState>(IndexSearcher.getMaxClauseCount());
            Iterator<ArtifactState> iterator = artifactStates.iterator();
            while (iterator.hasNext()) {
                ArtifactState artifactState = iterator.next();
                boolean isLast = !iterator.hasNext();
                pageArtifactStates.add(artifactState);
                if (!isLast && pageArtifactStates.size() != IndexSearcher.getMaxClauseCount()) continue;
                Query query = this.getArtifactStateQuery(pageArtifactStates);
                pageArtifactStates = new ArrayList(IndexSearcher.getMaxClauseCount());
                IndexWriter writer = this.getRepository().getStateWriter();
                writer.deleteDocuments(new Query[]{query});
                writer.close();
            }
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteArtifactStates(String artifactId) {
        if (artifactId == null || artifactId.length() == 0) {
            return;
        }
        HashSet<String> artifactIds = new HashSet<String>();
        artifactIds.add(artifactId);
        Query query = this.getArtifactStateQuery(artifactIds, null, null, 0);
        try {
            IndexWriter writer = this.getRepository().getStateWriter();
            writer.deleteDocuments(new Query[]{query});
            writer.close();
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteArtifactStates(Set<String> artifactIds) {
        if (artifactIds == null || artifactIds.size() == 0) {
            return;
        }
        try {
            HashSet<String> pageIds = new HashSet<String>(IndexSearcher.getMaxClauseCount());
            Iterator<String> iterator = artifactIds.iterator();
            while (iterator.hasNext()) {
                String artifactId = iterator.next();
                boolean isLast = !iterator.hasNext();
                pageIds.add(artifactId);
                if (!isLast && pageIds.size() != IndexSearcher.getMaxClauseCount()) continue;
                Query query = this.getArtifactStateQuery(pageIds, "", "", 0);
                pageIds = new HashSet(IndexSearcher.getMaxClauseCount());
                IndexWriter writer = this.getRepository().getStateWriter();
                writer.deleteDocuments(new Query[]{query});
                writer.close();
            }
        }
        catch (IOException e) {
            MetaPlugin.logError((Throwable)e);
        }
    }

    public synchronized void deleteAll(Set<String> projectNames) {
        try {
            if (projectNames != null) {
                if (projectNames.size() == 0) {
                    return;
                }
                IndexWriter writer = this.getRepository().getStateWriter();
                Query query = this.getArtifactStateQuery(projectNames);
                writer.deleteDocuments(new Query[]{query});
                writer.close();
            } else {
                this.deleteAll(".state");
            }
        }
        catch (IOException ioe) {
            this.deleteAll(".state");
            MetaPlugin.logError((Throwable)ioe);
        }
    }

    private void deleteAll(String directory) {
        File dataDirectory;
        File metaDirectory = MetaPlugin.getDefault().getStateLocation().toFile();
        if (".state".equals(directory) && (dataDirectory = new File(metaDirectory, directory)) != null && dataDirectory.listFiles() != null) {
            File[] fileArray = dataDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dataFile = fileArray[n2];
                dataFile.delete();
                ++n2;
            }
        }
    }

    private Query getArtifactStateQuery(List<ArtifactState> artifactStates) {
        if (artifactStates.size() > IndexSearcher.getMaxClauseCount()) {
            return null;
        }
        BooleanQuery.Builder finalBuilder = new BooleanQuery.Builder();
        for (ArtifactState artifactState : artifactStates) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            Term artifactTerm = new Term("_FIELD_ARTIFACT_ID", artifactState.getArtifactId());
            builder.add((Query)new TermQuery(artifactTerm), BooleanClause.Occur.MUST);
            Term patternTerm = new Term("_FIELD_PATTERN_ID", artifactState.getPatternId());
            builder.add((Query)new TermQuery(patternTerm), BooleanClause.Occur.MUST);
            Term versionTerm = new Term("_FIELD_VERSION_ID", artifactState.getVersionId());
            builder.add((Query)new TermQuery(versionTerm), BooleanClause.Occur.MUST);
            Term rankTerm = new Term("_FIELD_RANK", Integer.toString(artifactState.getRank()));
            builder.add((Query)new TermQuery(rankTerm), BooleanClause.Occur.MUST);
            if (artifactStates.size() > 1) {
                finalBuilder.add((Query)builder.build(), BooleanClause.Occur.SHOULD);
                continue;
            }
            finalBuilder = builder;
        }
        return finalBuilder.build();
    }

    private Query getArtifactStateQuery(Set<String> artifactIds, String patternId, String versionId, int rank) {
        if (artifactIds.size() > IndexSearcher.getMaxClauseCount()) {
            return null;
        }
        BooleanQuery.Builder artifactBuilder = new BooleanQuery.Builder();
        for (String artifactId : artifactIds) {
            Term artifactTerm;
            if (artifactIds.size() > 1) {
                artifactTerm = new Term("_FIELD_ARTIFACT_ID", artifactId);
                artifactBuilder.add((Query)new TermQuery(artifactTerm), BooleanClause.Occur.SHOULD);
                continue;
            }
            artifactTerm = new Term("_FIELD_ARTIFACT_ID", artifactId);
            artifactBuilder.add((Query)new TermQuery(artifactTerm), BooleanClause.Occur.MUST);
        }
        BooleanQuery.Builder paramBuilder = new BooleanQuery.Builder();
        if (patternId != null && patternId.length() > 0) {
            Term patternTerm = new Term("_FIELD_PATTERN_ID", patternId);
            paramBuilder.add((Query)new TermQuery(patternTerm), BooleanClause.Occur.MUST);
        }
        if (versionId != null && versionId.length() > 0) {
            Term versionTerm = new Term("_FIELD_VERSION_ID", versionId);
            paramBuilder.add((Query)new TermQuery(versionTerm), BooleanClause.Occur.MUST);
        }
        if (rank > 0) {
            Term rankTerm = new Term("_FIELD_RANK", Integer.toString(rank));
            paramBuilder.add((Query)new TermQuery(rankTerm), BooleanClause.Occur.MUST);
        }
        BooleanQuery.Builder finalBuilder = null;
        BooleanQuery paramQuery = paramBuilder.build();
        if (paramQuery.clauses().size() > 0) {
            finalBuilder = new BooleanQuery.Builder();
            finalBuilder.add((Query)artifactBuilder.build(), BooleanClause.Occur.MUST);
            finalBuilder.add((Query)paramQuery, BooleanClause.Occur.MUST);
        } else {
            finalBuilder = artifactBuilder;
        }
        return finalBuilder.build();
    }

    private Query getArtifactStateQuery(Set<String> projectNames) {
        BooleanQuery.Builder finalBuilder = new BooleanQuery.Builder();
        for (String projectName : projectNames) {
            Term term = new Term("_FIELD_PROJECT", projectName);
            if (projectNames.size() > 1) {
                finalBuilder.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
                continue;
            }
            finalBuilder.add((Query)new TermQuery(term), BooleanClause.Occur.MUST);
        }
        return finalBuilder.build();
    }
}

